/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.graph.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlTransient;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class GraphNode {
    public Map<String, Object> properties = null;
    public Map<String, Set<Object>> edges = null;

    @JsonIgnore
    @XmlTransient
    public boolean addProperty(String name, Object value) {
        if (name == null || name.isEmpty() || value == null) {
            return false;
        }
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, Object>();
        } else if (this.properties.containsKey(name)) {
            return false;
        }
        this.properties.put(name, value);
        return true;
    }

    private Set<Object> getEdgeSet(String type) {
        Set<Object> nodeIdSet;
        if (type == null || type.isEmpty()) {
            return null;
        }
        if (this.edges == null) {
            this.edges = new LinkedHashMap<String, Set<Object>>();
        }
        if ((nodeIdSet = this.edges.get(type)) != null) {
            return nodeIdSet;
        }
        nodeIdSet = new TreeSet<Object>();
        this.edges.put(type, nodeIdSet);
        return nodeIdSet;
    }

    @JsonIgnore
    @XmlTransient
    public boolean addEdge(String type, Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Collection) {
            return this.addEdges(type, (Collection)value);
        }
        if (value.getClass().isArray()) {
            return this.addEdges(type, (Object[])value);
        }
        Set<Object> nodeIdSet = this.getEdgeSet(type);
        if (nodeIdSet == null) {
            return false;
        }
        nodeIdSet.add(value);
        return true;
    }

    @JsonIgnore
    @XmlTransient
    public boolean addEdges(String type, Collection<Object> values) {
        if (values == null || values.isEmpty()) {
            return false;
        }
        Set<Object> nodeIdSet = this.getEdgeSet(type);
        if (nodeIdSet == null) {
            return false;
        }
        nodeIdSet.addAll(values);
        return true;
    }

    @JsonIgnore
    @XmlTransient
    public boolean addEdges(String type, Object[] values) {
        if (values == null || values.length == 0) {
            return false;
        }
        Set<Object> nodeIdSet = this.getEdgeSet(type);
        if (nodeIdSet == null) {
            return false;
        }
        for (Object value : values) {
            nodeIdSet.add(value);
        }
        return true;
    }

    @JsonIgnore
    @XmlTransient
    public boolean removeEdge(String type, String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        if (this.edges == null) {
            return false;
        }
        if (type == null || type.isEmpty()) {
            return false;
        }
        Set<Object> nodeIdSet = this.edges.get(type);
        if (nodeIdSet == null) {
            return false;
        }
        return nodeIdSet.remove(value);
    }

    @JsonIgnore
    @XmlTransient
    public void add(GraphNode node) {
        if (node == null) {
            return;
        }
        if (node.properties != null) {
            for (Map.Entry<String, Object> entry : node.properties.entrySet()) {
                this.addProperty(entry.getKey(), entry.getValue());
            }
        }
        if (node.edges != null) {
            for (Map.Entry<String, Object> entry : node.edges.entrySet()) {
                this.addEdges(entry.getKey(), (Collection)entry.getValue());
            }
        }
    }
}

