/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.library.ftp;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.qwazr.library.AbstractPasswordLibrary;
import com.qwazr.utils.IOUtils;
import com.qwazr.utils.LoggerUtils;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;

public class FtpConnector
extends AbstractPasswordLibrary {
    public final String hostname;
    public final String username;
    public final Boolean ssl = null;
    public final Boolean passive_mode = null;
    public final Integer connect_time_out = null;
    public final Integer data_timeout = null;
    public final Integer keep_alive_timeout = null;
    public final Integer control_keep_alive_timeout = null;
    private static final Logger LOGGER = LoggerUtils.getLogger(FtpConnector.class);

    public FtpConnector() {
        this.hostname = null;
        this.username = null;
    }

    @JsonIgnore
    public FTPSession getNewSession(IOUtils.CloseableContext context) {
        FTPSession ftpSession = new FTPSession();
        if (context != null) {
            context.add((AutoCloseable)ftpSession);
        }
        return ftpSession;
    }

    public class FTPSession
    implements Closeable {
        private final FTPClient ftp;

        private FTPSession() {
            this.ftp = FtpConnector.this.ssl != null && FtpConnector.this.ssl != false ? new FTPSClient() : new FTPClient();
        }

        public FTPClient connect() throws IOException {
            if (this.ftp.isConnected()) {
                return this.ftp;
            }
            if (FtpConnector.this.keep_alive_timeout != null) {
                this.ftp.setControlKeepAliveTimeout((long)FtpConnector.this.keep_alive_timeout.intValue());
            }
            if (FtpConnector.this.control_keep_alive_timeout != null) {
                this.ftp.setControlKeepAliveReplyTimeout(FtpConnector.this.control_keep_alive_timeout.intValue());
            }
            if (FtpConnector.this.data_timeout != null) {
                this.ftp.setDataTimeout(FtpConnector.this.data_timeout.intValue());
            }
            if (FtpConnector.this.connect_time_out != null) {
                this.ftp.setConnectTimeout(FtpConnector.this.connect_time_out.intValue());
            }
            this.ftp.connect(FtpConnector.this.hostname);
            int reply = this.ftp.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                throw new IOException("FTP server returned an error: " + reply);
            }
            if (!this.ftp.login(FtpConnector.this.username, FtpConnector.this.password)) {
                throw new IOException("FTP login failed: " + this.ftp.getReplyCode());
            }
            return this.ftp;
        }

        private void checkPassiveMode() {
            if (FtpConnector.this.passive_mode != null && FtpConnector.this.passive_mode.booleanValue()) {
                this.ftp.enterLocalPassiveMode();
            } else {
                this.ftp.enterLocalActiveMode();
            }
        }

        public void retrieve(String remote, Path filePath, Boolean binary) throws IOException {
            if (binary != null) {
                if (binary.booleanValue()) {
                    if (!this.ftp.setFileType(2)) {
                        throw new IOException("FTP cannot be set to binary mode");
                    }
                } else if (!this.ftp.setFileType(0)) {
                    throw new IOException("FTP cannot be set to ASCII mode");
                }
            }
            this.checkPassiveMode();
            try (InputStream is = this.ftp.retrieveFileStream(remote);){
                if (is == null) {
                    throw new FileNotFoundException("FTP file not found: " + FtpConnector.this.hostname + "/" + remote);
                }
                IOUtils.copy((InputStream)is, (Path)filePath);
            }
            this.ftp.completePendingCommand();
        }

        public void retrieve(FTPFile remote, Path filePath, Boolean binary) throws IOException {
            this.retrieve(remote.getName(), filePath, binary);
        }

        public void retrieve(FTPFile remote, String local_path, Boolean binary) throws IOException {
            this.retrieve(remote.getName(), Paths.get(local_path, new String[0]), binary);
        }

        public void retrieve(String remote, String local_path, Boolean binary) throws IOException {
            this.retrieve(remote, Paths.get(local_path, new String[0]), binary);
        }

        public void sync_files(ScriptObjectMirror browser, String remote_path, Path localDirectory, Boolean downloadOnlyIfNotExists, Boolean binary) throws IOException {
            boolean dir_method;
            boolean file_method = browser != null && browser.hasMember("file");
            boolean bl = dir_method = browser != null && browser.hasMember("directory");
            if (!this.ftp.changeWorkingDirectory(remote_path)) {
                throw new IOException("Remote working directory change failed: " + FtpConnector.this.hostname + "/" + remote_path);
            }
            if (!Files.exists(localDirectory, new LinkOption[0])) {
                throw new FileNotFoundException("The destination directory does not exist: " + localDirectory);
            }
            if (!Files.isDirectory(localDirectory, new LinkOption[0])) {
                throw new IOException("The destination path is not a directory: " + localDirectory);
            }
            this.checkPassiveMode();
            FTPFile[] remoteFiles = this.ftp.listFiles();
            if (remoteFiles == null) {
                return;
            }
            LinkedHashMap<FTPFile, Path> remoteDirs = new LinkedHashMap<FTPFile, Path>();
            for (FTPFile remoteFile : remoteFiles) {
                String remoteName;
                if (remoteFile == null || ".".equals(remoteName = remoteFile.getName()) || "..".endsWith(remoteName)) continue;
                if (remoteFile.isDirectory()) {
                    if (dir_method && Boolean.FALSE.equals(browser.callMember("directory", new Object[]{remote_path + '/' + remoteName}))) continue;
                    Path localDir = localDirectory.resolve(remoteName);
                    if (!Files.exists(localDir, new LinkOption[0])) {
                        Files.createDirectory(localDir, new FileAttribute[0]);
                    }
                    remoteDirs.put(remoteFile, localDir);
                    continue;
                }
                if (!remoteFile.isFile()) continue;
                Path localFilePath = localDirectory.resolve(remoteName);
                if (file_method && Boolean.FALSE.equals(browser.callMember("file", new Object[]{remote_path + '/' + remoteName, Files.exists(localFilePath, new LinkOption[0])})) || downloadOnlyIfNotExists != null && downloadOnlyIfNotExists.booleanValue() && Files.exists(localFilePath, new LinkOption[0])) continue;
                LOGGER.info(() -> "FTP download: " + FtpConnector.this.hostname + '/' + remote_path + '/' + remoteName);
                this.retrieve(remoteFile, localFilePath, binary);
            }
            for (Map.Entry entry : remoteDirs.entrySet()) {
                this.sync_files(browser, remote_path + '/' + ((FTPFile)entry.getKey()).getName(), (Path)entry.getValue(), downloadOnlyIfNotExists, binary);
            }
        }

        public void sync_files(ScriptObjectMirror browser, String remote_path, String local_path, Boolean downloadOnlyIfNotExists, Boolean binary) throws IOException {
            this.sync_files(browser, remote_path, Paths.get(local_path, new String[0]), downloadOnlyIfNotExists, binary);
        }

        public void logout() throws IOException {
            this.ftp.logout();
        }

        @Override
        public void close() throws IOException {
            if (!this.ftp.isConnected()) {
                return;
            }
            try {
                this.ftp.disconnect();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e, e::getMessage);
            }
        }
    }
}

