/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.library.mybatis;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.qwazr.library.AbstractPasswordLibrary;
import com.qwazr.utils.IOUtils;
import com.qwazr.utils.LoggerUtils;
import com.qwazr.utils.StringUtils;
import com.qwazr.utils.SubstitutedVariables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import javax.ws.rs.InternalServerErrorException;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.session.TransactionIsolationLevel;

public class MybatisConnector
extends AbstractPasswordLibrary {
    private static final Logger LOGGER = LoggerUtils.getLogger(MybatisConnector.class);
    public final String configuration_file;
    public final String configuration_resource;
    public final String environment;
    public final String properties_file;
    public final Map<String, String> properties = null;
    @JsonIgnore
    private volatile SqlSessionFactory sqlSessionFactory = null;
    private static final String default_configuration = "com/qwazr/library/mybatis/default-config.xml";

    public MybatisConnector() {
        this.configuration_file = null;
        this.configuration_resource = null;
        this.environment = null;
        this.properties_file = null;
    }

    public void load() {
        try {
            File configurationFile;
            if (this.configuration_file != null) {
                configurationFile = new File(SubstitutedVariables.propertyAndEnvironmentSubstitute((String)this.configuration_file));
                if (!configurationFile.exists()) {
                    throw new RuntimeException("The configuration file " + configurationFile.getPath() + " does not exist");
                }
            } else {
                configurationFile = null;
            }
            Properties props = null;
            if (!StringUtils.isEmpty((CharSequence)this.properties_file)) {
                File propFile = new File(SubstitutedVariables.propertyAndEnvironmentSubstitute((String)this.properties_file));
                if (propFile.exists() && propFile.isFile()) {
                    props = new Properties();
                    try (FileReader reader = new FileReader(propFile);){
                        props.load(reader);
                    }
                } else {
                    LOGGER.warning(() -> "The property file does not exit: " + this.properties_file);
                }
            }
            if (this.properties != null) {
                if (props == null) {
                    props = new Properties();
                }
                props.putAll(this.properties);
            } else {
                props = null;
            }
            SqlSessionFactoryBuilder builder = new SqlSessionFactoryBuilder();
            try (InputStream inputStream = configurationFile != null ? new FileInputStream(configurationFile) : Resources.getResourceAsStream((String)(this.configuration_resource != null ? this.configuration_resource : default_configuration));){
                this.sqlSessionFactory = this.environment != null ? (props != null ? builder.build(inputStream, this.environment, props) : builder.build(inputStream, this.environment)) : (props != null ? builder.build(inputStream, props) : builder.build(inputStream));
            }
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Initialization error", (Throwable)e);
        }
    }

    @JsonIgnore
    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }

    @JsonIgnore
    public SqlSessionFactory getSqlSessionFactory(IOUtils.CloseableContext closeable) {
        Objects.requireNonNull(closeable, "closeable cannot be null");
        return new CloseableSqlSessionFactory(closeable);
    }

    public class CloseableSqlSessionFactory
    implements SqlSessionFactory {
        private final IOUtils.CloseableContext closeable;

        private CloseableSqlSessionFactory(IOUtils.CloseableContext closeable) {
            this.closeable = closeable;
        }

        public SqlSession openSession() {
            return (SqlSession)this.closeable.add((AutoCloseable)MybatisConnector.this.sqlSessionFactory.openSession());
        }

        public SqlSession openSession(boolean autoCommit) {
            return (SqlSession)this.closeable.add((AutoCloseable)MybatisConnector.this.sqlSessionFactory.openSession(autoCommit));
        }

        public SqlSession openSession(Connection connection) {
            return (SqlSession)this.closeable.add((AutoCloseable)MybatisConnector.this.sqlSessionFactory.openSession(connection));
        }

        public SqlSession openSession(TransactionIsolationLevel level) {
            return (SqlSession)this.closeable.add((AutoCloseable)MybatisConnector.this.sqlSessionFactory.openSession(level));
        }

        public SqlSession openSession(ExecutorType execType) {
            return (SqlSession)this.closeable.add((AutoCloseable)MybatisConnector.this.sqlSessionFactory.openSession(execType));
        }

        public SqlSession openSession(ExecutorType execType, boolean autoCommit) {
            return (SqlSession)this.closeable.add((AutoCloseable)MybatisConnector.this.sqlSessionFactory.openSession(execType, autoCommit));
        }

        public SqlSession openSession(ExecutorType execType, TransactionIsolationLevel level) {
            return (SqlSession)this.closeable.add((AutoCloseable)MybatisConnector.this.sqlSessionFactory.openSession(execType, level));
        }

        public SqlSession openSession(ExecutorType execType, Connection connection) {
            return (SqlSession)this.closeable.add((AutoCloseable)MybatisConnector.this.sqlSessionFactory.openSession(execType, connection));
        }

        public Configuration getConfiguration() {
            return MybatisConnector.this.sqlSessionFactory.getConfiguration();
        }
    }
}

