/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.mavenplugin;

import com.qwazr.Qwazr;
import com.qwazr.QwazrConfiguration;
import com.qwazr.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="start", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class QwazrStartMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="qwazrData")
    private String dataDirectory;
    @Parameter(property="qwazr.listenAddr")
    private String listenAddr;
    @Parameter(property="qwazr.publicAddr")
    private String publicAddr;
    @Parameter(property="qwazr.udpAddress")
    private String udpAddress;
    @Parameter(property="qwazr.webappPort")
    private Integer webappPort;
    @Parameter(property="qwazr.webservicePort")
    private Integer webservicePort;
    @Parameter(property="qwazr.udpPort")
    private Integer udpPort;
    @Parameter(property="qwazr.webappRealm")
    private String webappRealm;
    @Parameter(property="qwazr.webserviceRealm")
    private String webserviceRealm;
    @Parameter(property="qwazr.etcDirs")
    private List<String> etcDirectories;
    @Parameter(property="qwazr.etcFilters")
    private List<String> etcFilters;
    @Parameter(property="qwazr.masters")
    private List<String> masters;
    @Parameter(property="qwazr.services")
    private List<QwazrConfiguration.ServiceEnum> services;
    @Parameter(property="qwazr.schedulerMaxThreads")
    private Integer schedulerMaxThreads;
    @Parameter(property="qwazr.groups")
    private List<String> groups;
    @Parameter(property="qwazr.profilers")
    private List<String> profilers;
    @Parameter(property="qwazr.daemon")
    private Boolean daemon;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        log.info((CharSequence)"Starting QWAZR");
        Launcher launcher = new Launcher();
        try {
            if (this.daemon == null || !this.daemon.booleanValue()) {
                launcher.startEmbedded(log);
            } else {
                launcher.startAsDaemon(log);
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("Cannot start QWAZR", (Throwable)e);
        }
    }

    private class Launcher {
        private final Map<String, String> parameters = new HashMap<String, String>();

        private Launcher() {
            this.setParameter("QWAZR_DATA", QwazrStartMojo.this.dataDirectory);
            this.setParameter("LISTEN_ADDR", QwazrStartMojo.this.listenAddr);
            this.setParameter("PUBLIC_ADDR", QwazrStartMojo.this.publicAddr);
            if (QwazrStartMojo.this.etcDirectories != null && !QwazrStartMojo.this.etcDirectories.isEmpty()) {
                this.setParameter("QWAZR_ETC_DIR", StringUtils.join((Iterable)QwazrStartMojo.this.etcDirectories, (char)File.pathSeparatorChar));
            }
            this.setParameter("WEBAPP_PORT", QwazrStartMojo.this.webappPort);
            this.setParameter("WEBSERVICE_PORT", QwazrStartMojo.this.webservicePort);
            this.setParameter("WEBAPP_REALM", QwazrStartMojo.this.webappRealm);
            this.setParameter("WEBSERVICE_REALM", QwazrStartMojo.this.webserviceRealm);
            this.setParameter("UDP_ADDRESS", QwazrStartMojo.this.udpAddress);
            this.setParameter("UDP_PORT", QwazrStartMojo.this.udpPort);
            if (QwazrStartMojo.this.etcFilters != null && !QwazrStartMojo.this.etcFilters.isEmpty()) {
                this.setParameter("QWAZR_ETC", StringUtils.join((Iterable)QwazrStartMojo.this.etcFilters, (char)','));
            }
            if (QwazrStartMojo.this.groups != null && !QwazrStartMojo.this.groups.isEmpty()) {
                this.setParameter("QWAZR_GROUPS", StringUtils.join((Iterable)QwazrStartMojo.this.groups, (char)','));
            }
            if (QwazrStartMojo.this.profilers != null && !QwazrStartMojo.this.profilers.isEmpty()) {
                this.setParameter("QWAZR_PROFILERS", StringUtils.join((Iterable)QwazrStartMojo.this.profilers, (char)';'));
            }
            if (QwazrStartMojo.this.services != null && !QwazrStartMojo.this.services.isEmpty()) {
                this.setParameter("QWAZR_SERVICES", StringUtils.join((Iterable)QwazrStartMojo.this.services, (char)','));
            }
        }

        private void setParameter(String key, Object value) {
            if (value == null) {
                return;
            }
            String str = value.toString();
            if (StringUtils.isEmpty((CharSequence)str)) {
                return;
            }
            System.setProperty(key, str);
            this.parameters.put(key, str);
        }

        private String buildClassPath() throws DependencyResolutionRequiredException {
            StringBuilder sb = new StringBuilder();
            List classPathList = QwazrStartMojo.this.project.getRuntimeClasspathElements();
            classPathList.forEach(path -> {
                sb.append((String)path);
                sb.append(File.pathSeparatorChar);
            });
            Set artifacts = QwazrStartMojo.this.project.getArtifacts();
            if (artifacts != null) {
                artifacts.forEach(artifact -> {
                    File artifactFile = artifact.getFile();
                    sb.append(artifactFile.getPath());
                    sb.append(File.pathSeparatorChar);
                });
            }
            return sb.toString();
        }

        private void startAsDaemon(Log log) throws MojoFailureException, IOException, InterruptedException, DependencyResolutionRequiredException {
            File javaBinFile = new File(System.getProperty("java.home"), File.separator + "bin" + File.separator + (SystemUtils.IS_OS_WINDOWS ? "java.exe" : "java"));
            if (!javaBinFile.exists()) {
                throw new MojoFailureException("Cannot find JAVA: " + javaBinFile);
            }
            String classpath = this.buildClassPath();
            this.parameters.put("CLASSPATH", classpath);
            String className = Qwazr.class.getCanonicalName();
            ProcessBuilder builder = new ProcessBuilder(javaBinFile.getCanonicalPath(), "-Dfile.encoding=UTF-8", className);
            builder.environment().putAll(this.parameters);
            builder.inheritIO();
            Process process = builder.start();
            log.info((CharSequence)"QWAZR started (Daemon)");
            process.waitFor(5000L, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startEmbedded(Log log) throws Exception {
            String oldClassPath = System.getProperty("java.class.path");
            try {
                String classpath = this.buildClassPath();
                if (classpath != null && !classpath.isEmpty()) {
                    System.setProperty("java.class.path", classpath);
                }
                Qwazr.startWithConf((QwazrConfiguration)new QwazrConfiguration(new Map[]{this.parameters}));
                log.info((CharSequence)"QWAZR started (Embedded)");
                try {
                    while (true) {
                        Thread.sleep(30000L);
                    }
                }
                catch (InterruptedException e) {
                    log.info((CharSequence)"QWAZR interrupted");
                    log.info((CharSequence)"Stopping QWAZR");
                    Qwazr.stop(null);
                    if (oldClassPath != null) {
                        System.setProperty("java.class.path", oldClassPath);
                    }
                }
            }
            catch (Throwable throwable) {
                if (oldClassPath != null) {
                    System.setProperty("java.class.path", oldClassPath);
                }
                throw throwable;
            }
        }
    }
}

