/*
 * Decompiled with CFR 0.152.
 */
package com.qwazr.mavenplugin;

import com.qwazr.utils.IOUtils;
import com.qwazr.utils.http.HttpClients;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="stop")
public class QwazrStopMojo
extends AbstractMojo {
    @Parameter(property="qwazr.publicAddr")
    private String publicAddr;
    @Parameter(property="qwazr.webservicePort")
    private Integer webservicePort;
    @Parameter(property="qwazr.waitMs")
    private Integer waitMs;
    @Parameter(property="qwazr.faultTolerant")
    private Boolean faultTolerant;

    static String getPropertyOrEnv(String currentValue, String env, String defaultValue) {
        if (currentValue != null) {
            return currentValue;
        }
        if (env == null) {
            return defaultValue;
        }
        currentValue = System.getProperty(env);
        if (currentValue != null) {
            return currentValue;
        }
        currentValue = System.getenv().get(env);
        return currentValue == null ? defaultValue : currentValue;
    }

    static Integer getPropertyOrEnv(Integer currentValue, String env, Integer defaultValue) {
        if (currentValue != null) {
            return currentValue;
        }
        if (env == null) {
            return defaultValue;
        }
        String value = System.getProperty(env);
        if (value != null) {
            return Integer.parseInt(value);
        }
        value = System.getenv().get(env);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log;
        block8: {
            log = this.getLog();
            log.info((CharSequence)"Stopping QWAZR");
            this.publicAddr = QwazrStopMojo.getPropertyOrEnv(this.publicAddr, "PUBLIC_ADDR", "localhost");
            this.webservicePort = QwazrStopMojo.getPropertyOrEnv(this.webservicePort, "WEBSERVICE_PORT", 9091);
            this.waitMs = QwazrStopMojo.getPropertyOrEnv(this.waitMs, null, 5000);
            CloseableHttpResponse response = null;
            try {
                URI uri = new URI("http", null, this.publicAddr, this.webservicePort, "/shutdown", null, null);
                log.info((CharSequence)("Post HTTP Delete on: " + uri));
                response = HttpClients.UNSECURE_HTTP_CLIENT.execute((HttpUriRequest)new HttpDelete(uri));
                log.info((CharSequence)("HTTP Status Code: " + response.getStatusLine().getStatusCode()));
                IOUtils.close((AutoCloseable)response);
            }
            catch (IOException | URISyntaxException e) {
                if (this.faultTolerant == null || this.faultTolerant.booleanValue()) {
                    log.warn((Throwable)e);
                    break block8;
                }
                throw new MojoExecutionException(e.getMessage(), e);
            }
            finally {
                IOUtils.close(response);
            }
        }
        try {
            Thread.sleep(this.waitMs.intValue());
        }
        catch (InterruptedException e) {
            log.warn((Throwable)e);
        }
    }
}

