/*
 * Decompiled with CFR 0.152.
 */
package org.scalacheck.ops.time;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.AbstractChronology;
import java.time.chrono.HijrahChronology;
import java.time.chrono.IsoChronology;
import java.time.chrono.JapaneseChronology;
import java.time.chrono.MinguoChronology;
import java.time.chrono.ThaiBuddhistChronology;
import org.scalacheck.Arbitrary;
import org.scalacheck.Arbitrary$;
import org.scalacheck.Gen;
import org.scalacheck.Gen$;
import org.scalacheck.ops.time.ImplicitJavaTimeGenerators;
import org.scalacheck.ops.time.ImplicitJavaTimeGenerators$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public abstract class ImplicitJavaTimeGenerators$class {
    public static Arbitrary arbLocalDateTime(ImplicitJavaTimeGenerators $this) {
        return Arbitrary$.MODULE$.apply((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Gen<LocalDateTime> apply() {
                return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToLong((long)LocalDateTime.MIN.toEpochSecond(ZoneOffset.UTC)), (Object)BoxesRunTime.boxToLong((long)LocalDateTime.MAX.toEpochSecond(ZoneOffset.UTC)), (Seq)Predef$.MODULE$.wrapLongArray(new long[0]), (Numeric)Numeric.LongIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseLong()).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Gen<LocalDateTime> apply(long seconds) {
                        return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)LocalDateTime.MIN.getNano()), (Object)BoxesRunTime.boxToInteger((int)LocalDateTime.MAX.getNano()), (Seq)Predef$.MODULE$.wrapIntArray(new int[0]), (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).map((Function1)new Serializable(this, seconds){
                            public static final long serialVersionUID = 0L;
                            private final long seconds$1;

                            public final LocalDateTime apply(int nanos) {
                                return LocalDateTime.ofEpochSecond(this.seconds$1, nanos, ZoneOffset.UTC);
                            }
                            {
                                this.seconds$1 = seconds$1;
                            }
                        });
                    }
                });
            }
        });
    }

    public static Arbitrary arbZonedDateTime(ImplicitJavaTimeGenerators $this) {
        return Arbitrary$.MODULE$.apply((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ImplicitJavaTimeGenerators $outer;

            public final Gen<ZonedDateTime> apply() {
                return this.$outer.arbZoneId().arbitrary().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ImplicitJavaTimeGenerators$.anonfun.arbZonedDateTime.1 $outer;

                    public final Gen<ZonedDateTime> apply(ZoneId zoneId) {
                        return this.$outer.org$scalacheck$ops$time$ImplicitJavaTimeGenerators$$anonfun$$$outer().arbInstant().arbitrary().map((Function1)new Serializable(this, zoneId){
                            public static final long serialVersionUID = 0L;
                            private final ZoneId zoneId$1;

                            public final ZonedDateTime apply(Instant instant) {
                                return ZonedDateTime.ofInstant(instant, this.zoneId$1);
                            }
                            {
                                this.zoneId$1 = zoneId$1;
                            }
                        });
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ImplicitJavaTimeGenerators org$scalacheck$ops$time$ImplicitJavaTimeGenerators$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static void $init$(ImplicitJavaTimeGenerators $this) {
        $this.org$scalacheck$ops$time$ImplicitJavaTimeGenerators$_setter_$arbChronology_$eq(Arbitrary$.MODULE$.apply((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Gen<AbstractChronology> apply() {
                return Gen$.MODULE$.oneOf((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractChronology[]{HijrahChronology.INSTANCE, IsoChronology.INSTANCE, JapaneseChronology.INSTANCE, MinguoChronology.INSTANCE, ThaiBuddhistChronology.INSTANCE})));
            }
        }));
        $this.org$scalacheck$ops$time$ImplicitJavaTimeGenerators$_setter_$arbZoneId_$eq(Arbitrary$.MODULE$.apply((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Gen<ZoneId> apply() {
                return Gen$.MODULE$.oneOf((Seq)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(ZoneId.getAvailableZoneIds()).asScala()).toSeq().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ZoneId apply(String x$1) {
                        return ZoneId.of(x$1);
                    }
                }, Seq$.MODULE$.canBuildFrom()));
            }
        }));
        $this.org$scalacheck$ops$time$ImplicitJavaTimeGenerators$_setter_$arbInstant_$eq(Arbitrary$.MODULE$.apply((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Gen<Instant> apply() {
                return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToLong((long)Instant.MIN.getEpochSecond()), (Object)BoxesRunTime.boxToLong((long)Instant.MAX.getEpochSecond()), (Seq)Predef$.MODULE$.wrapLongArray(new long[0]), (Numeric)Numeric.LongIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseLong()).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Gen<Instant> apply(long millis) {
                        return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToInteger((int)Instant.MIN.getNano()), (Object)BoxesRunTime.boxToInteger((int)Instant.MAX.getNano()), (Seq)Predef$.MODULE$.wrapIntArray(new int[0]), (Numeric)Numeric.IntIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseInt()).map((Function1)new Serializable(this, millis){
                            public static final long serialVersionUID = 0L;
                            private final long millis$1;

                            public final Instant apply(int nanos) {
                                return Instant.ofEpochMilli(this.millis$1).plusNanos(nanos);
                            }
                            {
                                this.millis$1 = millis$1;
                            }
                        });
                    }
                });
            }
        }));
        $this.org$scalacheck$ops$time$ImplicitJavaTimeGenerators$_setter_$arbLocalDate_$eq(Arbitrary$.MODULE$.apply((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Gen<LocalDate> apply() {
                return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToLong((long)LocalDate.MIN.toEpochDay()), (Object)BoxesRunTime.boxToLong((long)LocalDate.MAX.toEpochDay()), (Seq)Predef$.MODULE$.wrapLongArray(new long[0]), (Numeric)Numeric.LongIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseLong()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LocalDate apply(long epochDay) {
                        return LocalDate.ofEpochDay(epochDay);
                    }
                });
            }
        }));
        $this.org$scalacheck$ops$time$ImplicitJavaTimeGenerators$_setter_$arbLocalTime_$eq(Arbitrary$.MODULE$.apply((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Gen<LocalTime> apply() {
                return Gen$.MODULE$.chooseNum((Object)BoxesRunTime.boxToLong((long)LocalTime.MIN.toNanoOfDay()), (Object)BoxesRunTime.boxToLong((long)LocalTime.MAX.toNanoOfDay()), (Seq)Predef$.MODULE$.wrapLongArray(new long[0]), (Numeric)Numeric.LongIsIntegral$.MODULE$, Gen.Choose$.MODULE$.chooseLong()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LocalTime apply(long nanoOfDay) {
                        return LocalTime.ofNanoOfDay(nanoOfDay);
                    }
                });
            }
        }));
    }
}

