/*
 * Decompiled with CFR 0.152.
 */
package com.rallyhealth.weejson.v1.json4s;

import com.rallyhealth.weejson.v1.AstTransformer;
import com.rallyhealth.weejson.v1.Transformer;
import com.rallyhealth.weepickle.v1.core.ArrVisitor;
import com.rallyhealth.weepickle.v1.core.JsVisitor;
import com.rallyhealth.weepickle.v1.core.ObjVisitor;
import com.rallyhealth.weepickle.v1.core.Util$;
import com.rallyhealth.weepickle.v1.core.Visitor;
import java.io.Serializable;
import java.time.Instant;
import org.json4s.JsonAST;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005%r!\u0002\t\u0012\u0011\u0003ab!\u0002\u0010\u0012\u0011\u0003y\u0002B\u0002\"\u0002\t\u0003\t9C\u0002\u0003\u001f#\u0001\t\u0003\u0002C\u001f\u0004\u0005\u0003\u0005\u000b\u0011\u0002 \t\u0011\u0005\u001b!\u0011!Q\u0001\nyBQAQ\u0002\u0005\u0002\rCQAR\u0002\u0005\u0002\u001dCQ!Z\u0002\u0005\u0002\u0019DQa\\\u0002\u0005\u0002ADQ!^\u0002\u0005\u0002YDQa^\u0002\u0005\u0002YDQ\u0001_\u0002\u0005\u0002YDQ!_\u0002\u0005BiDq!!\u0001\u0004\t\u0003\t\u0019\u0001C\u0004\u0002\"\r!\t!a\t\u0002\u0015)\u001bxN\u001c\u001bt\u0015N|gN\u0003\u0002\u0013'\u00051!n]8oiMT!\u0001F\u000b\u0002\u0005Y\f$B\u0001\f\u0018\u0003\u001d9X-\u001a6t_:T!\u0001G\r\u0002\u0017I\fG\u000e\\=iK\u0006dG\u000f\u001b\u0006\u00025\u0005\u00191m\\7\u0004\u0001A\u0011Q$A\u0007\u0002#\tQ!j]8oiMT5o\u001c8\u0014\u0005\u0005\u0001\u0003CA\u000f\u0004'\r\u0019!\u0005\u000b\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0007%RC&D\u0001\u0014\u0013\tY3C\u0001\bBgR$&/\u00198tM>\u0014X.\u001a:\u0011\u00055RdB\u0001\u00188\u001d\tySG\u0004\u00021g5\t\u0011G\u0003\u000237\u00051AH]8pizJ\u0011\u0001N\u0001\u0004_J<\u0017B\u0001\n7\u0015\u0005!\u0014B\u0001\u001d:\u0003\u001dQ5o\u001c8B'RS!A\u0005\u001c\n\u0005mb$A\u0002&WC2,XM\u0003\u00029s\u00051Ro]3CS\u001e$UmY5nC24uN\u001d#pk\ndW\r\u0005\u0002$\u007f%\u0011\u0001\t\n\u0002\b\u0005>|G.Z1o\u0003A)8/\u001a\"jO&sGOR8s\u0019>tw-\u0001\u0004=S:LGO\u0010\u000b\u0004A\u0011+\u0005\"B\u001f\u0007\u0001\u0004q\u0004\"B!\u0007\u0001\u0004q\u0014!\u0003;sC:\u001chm\u001c:n+\tA5\nF\u0002J)Z\u0003\"AS&\r\u0001\u0011)Aj\u0002b\u0001\u001b\n\tA+\u0005\u0002O#B\u00111eT\u0005\u0003!\u0012\u0012qAT8uQ&tw\r\u0005\u0002$%&\u00111\u000b\n\u0002\u0004\u0003:L\b\"B+\b\u0001\u0004a\u0013!A5\t\u000b];\u0001\u0019\u0001-\u0002\u0005Q|\u0007GA-d!\u0011Q\u0006MY%\u000e\u0003mS!\u0001X/\u0002\t\r|'/\u001a\u0006\u0003)yS!aX\f\u0002\u0013],W\r]5dW2,\u0017BA1\\\u0005\u001d1\u0016n]5u_J\u0004\"AS2\u0005\u0013\u00114\u0016\u0011!A\u0001\u0006\u0003i%aA0%c\u0005Qa/[:ji\u0006\u0013(/Y=\u0015\u0005\u001dT\u0007\u0003\u0002.iY1J!![.\u0003\u0015\u0005\u0013(OV5tSR|'\u000fC\u0003l\u0011\u0001\u0007A.\u0001\u0004mK:<G\u000f\u001b\t\u0003G5L!A\u001c\u0013\u0003\u0007%sG/A\u0006wSNLGo\u00142kK\u000e$HCA9u!\u0011Q&\u000f\f\u0017\n\u0005M\\&AC(cUZK7/\u001b;pe\")1.\u0003a\u0001Y\u0006Ia/[:ji:+H\u000e\u001c\u000b\u0002Y\u0005Qa/[:ji\u001a\u000bGn]3\u0002\u0013YL7/\u001b;UeV,\u0017\u0001\u0004<jg&$h\t\\8biZ\"DC\u0001\u0017|\u0011\u0015aX\u00021\u0001~\u0003\u0005!\u0007CA\u0012\u007f\u0013\tyHE\u0001\u0004E_V\u0014G.Z\u0001\u0018m&\u001c\u0018\u000e\u001e$m_\u0006$h\u0007N*ue&tw\rU1siN$r\u0001LA\u0003\u00033\ti\u0002C\u0004\u0002\b9\u0001\r!!\u0003\u0002\u0005\r\u001c\b\u0003BA\u0006\u0003+i!!!\u0004\u000b\t\u0005=\u0011\u0011C\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0014\u0005!!.\u0019<b\u0013\u0011\t9\"!\u0004\u0003\u0019\rC\u0017M]*fcV,gnY3\t\r\u0005ma\u00021\u0001m\u0003!!WmY%oI\u0016D\bBBA\u0010\u001d\u0001\u0007A.\u0001\u0005fqBLe\u000eZ3y\u0003-1\u0018n]5u'R\u0014\u0018N\\4\u0015\u00071\n)\u0003C\u0004\u0002\b=\u0001\r!!\u0003\u0015\u0003q\u0001")
public class Json4sJson
implements AstTransformer<JsonAST.JValue> {
    private final boolean useBigDecimalForDouble;
    private final boolean useBigIntForLong;

    public Object apply(String s) {
        return AstTransformer.apply$((AstTransformer)this, (String)s);
    }

    public <T> T transformArray(Visitor<?, T> f, Iterable<JsonAST.JValue> items) {
        return (T)AstTransformer.transformArray$((AstTransformer)this, f, items);
    }

    public <T> T transformObject(Visitor<?, T> f, Iterable<Tuple2<String, JsonAST.JValue>> items) {
        return (T)AstTransformer.transformObject$((AstTransformer)this, f, items);
    }

    public Object visitFloat32(float d) {
        return JsVisitor.visitFloat32$((JsVisitor)this, (float)d);
    }

    public Object visitInt32(int i) {
        return JsVisitor.visitInt32$((JsVisitor)this, (int)i);
    }

    public Object visitInt64(long l) {
        return JsVisitor.visitInt64$((JsVisitor)this, (long)l);
    }

    public Object visitUInt64(long ul) {
        return JsVisitor.visitUInt64$((JsVisitor)this, (long)ul);
    }

    public Object visitFloat64String(String s) {
        return JsVisitor.visitFloat64String$((JsVisitor)this, (String)s);
    }

    public Object visitBinary(byte[] bytes, int offset, int len) {
        return JsVisitor.visitBinary$((JsVisitor)this, (byte[])bytes, (int)offset, (int)len);
    }

    public Object visitExt(byte tag, byte[] bytes, int offset, int len) {
        return JsVisitor.visitExt$((JsVisitor)this, (byte)tag, (byte[])bytes, (int)offset, (int)len);
    }

    public Object visitChar(char c) {
        return JsVisitor.visitChar$((JsVisitor)this, (char)c);
    }

    public Object visitTimestamp(Instant instant) {
        return JsVisitor.visitTimestamp$((JsVisitor)this, (Instant)instant);
    }

    public <Z> Visitor<JsonAST.JValue, Z> map(Function1<JsonAST.JValue, Z> f) {
        return Visitor.map$((Visitor)this, f);
    }

    public <Z> Visitor<JsonAST.JValue, Z> mapNulls(Function1<JsonAST.JValue, Z> f) {
        return Visitor.mapNulls$((Visitor)this, f);
    }

    public void close() {
        Visitor.close$((Visitor)this);
    }

    public Try validate(Object i, Visitor to) {
        return Transformer.validate$((Transformer)this, (Object)i, (Visitor)to);
    }

    public <T> T transform(JsonAST.JValue i, Visitor<?, T> to) {
        Object object;
        if (i instanceof JsonAST.JArray) {
            List xs = ((JsonAST.JArray)i).arr();
            object = this.transformArray(to, (Iterable<JsonAST.JValue>)xs);
        } else if (i instanceof JsonAST.JBool) {
            object = ((JsonAST.JBool)i).value() ? to.visitTrue() : to.visitFalse();
        } else if (i instanceof JsonAST.JDecimal) {
            BigDecimal d = ((JsonAST.JDecimal)i).num();
            object = to.visitFloat64String(d.toString());
        } else if (i instanceof JsonAST.JDouble) {
            double d = ((JsonAST.JDouble)i).num();
            object = to.visitFloat64(d);
        } else if (i instanceof JsonAST.JInt) {
            BigInt i2 = ((JsonAST.JInt)i).num();
            object = to.visitFloat64StringParts((CharSequence)i2.toString(), -1, -1);
        } else if (i instanceof JsonAST.JLong) {
            long l = ((JsonAST.JLong)i).num();
            object = to.visitFloat64StringParts((CharSequence)((Object)BoxesRunTime.boxToLong((long)l)).toString(), -1, -1);
        } else if (JsonAST.JNothing$.MODULE$.equals(i)) {
            object = to.visitNull();
        } else if (JsonAST.JNull$.MODULE$.equals(i)) {
            object = to.visitNull();
        } else if (i instanceof JsonAST.JObject) {
            List kvs = ((JsonAST.JObject)i).obj();
            object = this.transformObject(to, (Iterable<Tuple2<String, JsonAST.JValue>>)kvs);
        } else if (i instanceof JsonAST.JSet) {
            Set xs = ((JsonAST.JSet)i).set();
            object = this.transformArray(to, (Iterable<JsonAST.JValue>)xs);
        } else if (i instanceof JsonAST.JString) {
            String s = ((JsonAST.JString)i).s();
            object = to.visitString((CharSequence)s);
        } else {
            throw new MatchError((Object)i);
        }
        return object;
    }

    public ArrVisitor<JsonAST.JValue, JsonAST.JValue> visitArray(int length) {
        return new AstTransformer.AstArrVisitor((AstTransformer)this, (Function1 & Serializable & scala.Serializable)x -> new JsonAST.JArray(x), List$.MODULE$.canBuildFrom());
    }

    public ObjVisitor<JsonAST.JValue, JsonAST.JValue> visitObject(int length) {
        return new AstTransformer.AstObjVisitor((AstTransformer)this, (Function1 & Serializable & scala.Serializable)x$1 -> new JsonAST.JObject(x$1), List$.MODULE$.canBuildFrom());
    }

    public JsonAST.JValue visitNull() {
        return JsonAST.JNull$.MODULE$;
    }

    public JsonAST.JValue visitFalse() {
        return new JsonAST.JBool(false);
    }

    public JsonAST.JValue visitTrue() {
        return new JsonAST.JBool(true);
    }

    public JsonAST.JValue visitFloat64(double d) {
        return new JsonAST.JDouble(d);
    }

    public JsonAST.JValue visitFloat64StringParts(CharSequence cs, int decIndex, int expIndex) {
        if (decIndex == -1 && expIndex == -1) {
            if (this.useBigIntForLong) {
                return new JsonAST.JInt(package$.MODULE$.BigInt().apply(((Object)cs).toString()));
            }
            return new JsonAST.JLong(Util$.MODULE$.parseLong(cs, 0, cs.length()));
        }
        if (this.useBigDecimalForDouble) {
            return new JsonAST.JDecimal(package$.MODULE$.BigDecimal().apply(((Object)cs).toString()));
        }
        return new JsonAST.JDouble(new StringOps(Predef$.MODULE$.augmentString(((Object)cs).toString())).toDouble());
    }

    public JsonAST.JValue visitString(CharSequence cs) {
        return new JsonAST.JString(((Object)cs).toString());
    }

    public Json4sJson(boolean useBigDecimalForDouble, boolean useBigIntForLong) {
        this.useBigDecimalForDouble = useBigDecimalForDouble;
        this.useBigIntForLong = useBigIntForLong;
        Transformer.$init$((Transformer)this);
        Visitor.$init$((Visitor)this);
        JsVisitor.$init$((JsVisitor)this);
        AstTransformer.$init$((AstTransformer)this);
    }
}

