/*
 * Decompiled with CFR 0.152.
 */
package com.raquo.laminar;

import com.raquo.ew.JsString;
import com.raquo.ew.JsString$;
import com.raquo.laminar.api.package$;
import com.raquo.laminar.keys.AriaAttr;
import com.raquo.laminar.keys.EventProcessor$;
import com.raquo.laminar.keys.HtmlAttr;
import com.raquo.laminar.keys.HtmlProp;
import com.raquo.laminar.keys.StyleProp;
import com.raquo.laminar.keys.SvgAttr;
import com.raquo.laminar.keys.SvgAttr$;
import com.raquo.laminar.modifiers.EventListener;
import com.raquo.laminar.nodes.ChildNode;
import com.raquo.laminar.nodes.CommentNode;
import com.raquo.laminar.nodes.ParentNode;
import com.raquo.laminar.nodes.ReactiveElement;
import com.raquo.laminar.nodes.ReactiveHtmlElement;
import com.raquo.laminar.nodes.ReactiveSvgElement;
import com.raquo.laminar.nodes.TextNode;
import com.raquo.laminar.tags.HtmlTag;
import com.raquo.laminar.tags.SvgTag;
import com.raquo.laminar.tags.Tag;
import java.io.Serializable;
import org.scalajs.dom.CSSStyleDeclaration;
import org.scalajs.dom.Comment;
import org.scalajs.dom.DOMException;
import org.scalajs.dom.Element;
import org.scalajs.dom.Event;
import org.scalajs.dom.File;
import org.scalajs.dom.HTMLButtonElement;
import org.scalajs.dom.HTMLElement;
import org.scalajs.dom.HTMLInputElement;
import org.scalajs.dom.HTMLOptionElement;
import org.scalajs.dom.HTMLSelectElement;
import org.scalajs.dom.HTMLTemplateElement;
import org.scalajs.dom.HTMLTextAreaElement;
import org.scalajs.dom.Node;
import org.scalajs.dom.SVGElement;
import org.scalajs.dom.Text;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.scalajs.js.;
import scala.scalajs.js.$bar$;
import scala.scalajs.js.Any;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Array;
import scala.scalajs.js.Array$;
import scala.scalajs.js.Dynamic;
import scala.scalajs.js.Iterable;
import scala.scalajs.js.JavaScriptException;
import scala.scalajs.js.RegExp;
import scala.scalajs.js.UndefOrOps$;

public final class DomApi$ {
    public static DomApi$ MODULE$;
    private final HTMLTemplateElement htmlParserContainer;
    private final SVGElement svgParserContainer;
    private final RegExp classNamesSeparatorRegex;

    static {
        new DomApi$();
    }

    public boolean appendChild(ParentNode<Element> parent, ChildNode<Node> child) {
        boolean bl;
        try {
            parent.ref().appendChild(child.ref());
            bl = true;
        }
        catch (Throwable throwable) {
            JavaScriptException javaScriptException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof JavaScriptException && (javaScriptException = (JavaScriptException)throwable2).exception() instanceof DOMException) {
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    public boolean removeChild(ParentNode<Element> parent, ChildNode<Node> child) {
        boolean bl;
        try {
            parent.ref().removeChild(child.ref());
            bl = true;
        }
        catch (Throwable throwable) {
            JavaScriptException javaScriptException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof JavaScriptException && (javaScriptException = (JavaScriptException)throwable2).exception() instanceof DOMException) {
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    public boolean insertBefore(ParentNode<Element> parent, ChildNode<Node> newChild, ChildNode<Node> referenceChild) {
        boolean bl;
        try {
            parent.ref().insertBefore(newChild.ref(), referenceChild.ref());
            bl = true;
        }
        catch (Throwable throwable) {
            JavaScriptException javaScriptException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof JavaScriptException && (javaScriptException = (JavaScriptException)throwable2).exception() instanceof DOMException) {
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    public boolean replaceChild(ParentNode<Element> parent, ChildNode<Node> newChild, ChildNode<Node> oldChild) {
        boolean bl;
        try {
            parent.ref().replaceChild(newChild.ref(), oldChild.ref());
            bl = true;
        }
        catch (Throwable throwable) {
            JavaScriptException javaScriptException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof JavaScriptException && (javaScriptException = (JavaScriptException)throwable2).exception() instanceof DOMException) {
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    public <Ev extends Event> void addEventListener(ReactiveElement<Element> element, EventListener<Ev, ?> listener) {
        element.ref().addEventListener(EventProcessor$.MODULE$.eventProp(listener.eventProcessor()).name(), listener.domCallback(), EventProcessor$.MODULE$.shouldUseCapture(listener.eventProcessor()));
    }

    public <Ev extends Event> void removeEventListener(ReactiveElement<Element> element, EventListener<Ev, ?> listener) {
        element.ref().removeEventListener(EventProcessor$.MODULE$.eventProp(listener.eventProcessor()).name(), listener.domCallback(), EventProcessor$.MODULE$.shouldUseCapture(listener.eventProcessor()));
    }

    public <Ref extends HTMLElement> Ref createHtmlElement(HtmlTag<Ref> tag) {
        return (Ref)((HTMLElement)org.scalajs.dom.package$.MODULE$.document().createElement(tag.name()));
    }

    public <V> .bar<V, BoxedUnit> getHtmlAttribute(ReactiveHtmlElement<HTMLElement> element, HtmlAttr<V> attr) {
        return UndefOrOps$.MODULE$.map$extension($bar$.MODULE$.undefOr2ops(this.getHtmlAttributeRaw(element, attr)), (Function1 & Serializable & scala.Serializable)domValue -> attr.codec().decode((String)domValue));
    }

    public .bar<String, BoxedUnit> getHtmlAttributeRaw(ReactiveHtmlElement<HTMLElement> element, HtmlAttr<?> attr) {
        String domValue = element.ref().getAttributeNS(null, attr.name());
        if (domValue != null) {
            return $bar$.MODULE$.from((Object)domValue, .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base()));
        }
        return scala.scalajs.js.package$.MODULE$.undefined();
    }

    public <V> void setHtmlAttribute(ReactiveHtmlElement<HTMLElement> element, HtmlAttr<V> attr, V value) {
        String domValue = attr.codec().encode(value);
        this.setHtmlAttributeRaw(element, attr, domValue);
    }

    public void setHtmlAttributeRaw(ReactiveHtmlElement<HTMLElement> element, HtmlAttr<?> attr, String domValue) {
        if (domValue == null) {
            this.removeHtmlAttribute(element, attr);
            return;
        }
        element.ref().setAttribute(attr.name(), domValue);
    }

    public void removeHtmlAttribute(ReactiveHtmlElement<HTMLElement> element, HtmlAttr<?> attr) {
        element.ref().removeAttribute(attr.name());
    }

    public <V, DomV> .bar<V, BoxedUnit> getHtmlProperty(ReactiveHtmlElement<HTMLElement> element, HtmlProp<V, DomV> prop) {
        .bar<DomV, BoxedUnit> domValue2 = this.getHtmlPropertyRaw(element, prop);
        return UndefOrOps$.MODULE$.map$extension($bar$.MODULE$.undefOr2ops(domValue2), (Function1 & Serializable & scala.Serializable)domValue -> prop.codec().decode(domValue));
    }

    public <V, DomV> .bar<DomV, BoxedUnit> getHtmlPropertyRaw(ReactiveHtmlElement<HTMLElement> element, HtmlProp<V, DomV> prop) {
        return (.bar)((Dynamic)element.ref()).selectDynamic(prop.name());
    }

    public <V, DomV> void setHtmlProperty(ReactiveHtmlElement<HTMLElement> element, HtmlProp<V, DomV> prop, V value) {
        DomV domValue = prop.codec().encode(value);
        this.setHtmlPropertyRaw(element, prop, domValue);
    }

    public <V, DomV> void setHtmlPropertyRaw(ReactiveHtmlElement<HTMLElement> element, HtmlProp<V, DomV> prop, DomV value) {
        ((Dynamic)element.ref()).updateDynamic(prop.name(), (Any)value);
    }

    public String getHtmlStyleRaw(ReactiveHtmlElement<HTMLElement> element, StyleProp<?> styleProp) {
        return element.ref().style().getPropertyValue(styleProp.name());
    }

    public <V> void setHtmlStyle(ReactiveHtmlElement<HTMLElement> element, StyleProp<V> styleProp, V value) {
        this.setRefStyle(element.ref(), styleProp.name(), styleProp.prefixes(), this.cssValue(value));
    }

    public void setHtmlStringStyle(ReactiveHtmlElement<HTMLElement> element, StyleProp<?> styleProp, String value) {
        this.setRefStyle(element.ref(), styleProp.name(), styleProp.prefixes(), this.cssValue(value));
    }

    public <V> void setHtmlAnyStyle(ReactiveHtmlElement<HTMLElement> element, StyleProp<V> style, .bar<V, String> value) {
        this.setRefStyle(element.ref(), style.name(), style.prefixes(), this.cssValue(value));
    }

    public String cssValue(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public void setRefStyle(HTMLElement ref, String styleCssName, Seq<String> prefixes, String styleValue) {
        if (styleValue == null) {
            prefixes.foreach((Function1 & Serializable & scala.Serializable)prefix -> ref.style().removeProperty(new StringBuilder(0).append((String)prefix).append(styleCssName).toString()));
            ref.style().removeProperty(styleCssName);
            return;
        }
        prefixes.foreach((Function1 & Serializable & scala.Serializable)prefix -> {
            DomApi$.$anonfun$setRefStyle$2(ref, styleCssName, styleValue, prefix);
            return BoxedUnit.UNIT;
        });
        CSSStyleDeclaration qual$2 = ref.style();
        String x$4 = styleCssName;
        String x$5 = styleValue;
        String x$6 = qual$2.setProperty$default$3();
        qual$2.setProperty(x$4, x$5, x$6);
    }

    public <Ref extends SVGElement> Ref createSvgElement(SvgTag<Ref> tag) {
        return (Ref)((SVGElement)org.scalajs.dom.package$.MODULE$.document().createElementNS(SvgAttr$.MODULE$.svgNamespaceUri(), tag.name()));
    }

    public <V> .bar<V, BoxedUnit> getSvgAttribute(ReactiveSvgElement<SVGElement> element, SvgAttr<V> attr) {
        return UndefOrOps$.MODULE$.map$extension($bar$.MODULE$.undefOr2ops(this.getSvgAttributeRaw(element, attr)), (Function1 & Serializable & scala.Serializable)domValue -> attr.codec().decode((String)domValue));
    }

    public .bar<String, BoxedUnit> getSvgAttributeRaw(ReactiveSvgElement<SVGElement> element, SvgAttr<?> attr) {
        String domValue = element.ref().getAttributeNS((String)attr.namespaceUri().orNull(Predef$.MODULE$.$conforms()), attr.localName());
        if (domValue != null) {
            return $bar$.MODULE$.from((Object)domValue, .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base()));
        }
        return scala.scalajs.js.package$.MODULE$.undefined();
    }

    public <V> void setSvgAttribute(ReactiveSvgElement<SVGElement> element, SvgAttr<V> attr, V value) {
        String domValue = attr.codec().encode(value);
        this.setSvgAttributeRaw(element, attr, domValue);
    }

    public void setSvgAttributeRaw(ReactiveSvgElement<SVGElement> element, SvgAttr<?> attr, String domValue) {
        if (domValue == null) {
            this.removeSvgAttribute(element, attr);
            return;
        }
        element.ref().setAttributeNS((String)attr.namespaceUri().orNull(Predef$.MODULE$.$conforms()), attr.name(), domValue);
    }

    public void removeSvgAttribute(ReactiveSvgElement<SVGElement> element, SvgAttr<?> attr) {
        element.ref().removeAttributeNS((String)attr.namespaceUri().orNull(Predef$.MODULE$.$conforms()), attr.localName());
    }

    public <V> .bar<V, BoxedUnit> getAriaAttribute(ReactiveElement<Element> element, AriaAttr<V> attr) {
        return UndefOrOps$.MODULE$.map$extension($bar$.MODULE$.undefOr2ops(this.getAriaAttributeRaw(element, attr)), (Function1 & Serializable & scala.Serializable)domValue -> attr.codec().decode((String)domValue));
    }

    public .bar<String, BoxedUnit> getAriaAttributeRaw(ReactiveElement<Element> element, AriaAttr<?> attr) {
        String domValue = ((Element)element.ref()).getAttributeNS(null, attr.name());
        if (domValue != null) {
            return $bar$.MODULE$.from((Object)domValue, .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base()));
        }
        return scala.scalajs.js.package$.MODULE$.undefined();
    }

    public <V> void setAriaAttribute(ReactiveElement<Element> element, AriaAttr<V> attr, V value) {
        String domValue = attr.codec().encode(value);
        this.setAriaAttributeRaw(element, attr, domValue);
    }

    public void setAriaAttributeRaw(ReactiveElement<Element> element, AriaAttr<?> attr, String domValue) {
        if (domValue == null) {
            this.removeAriaAttribute(element, attr);
            return;
        }
        ((Element)element.ref()).setAttribute(attr.name(), domValue);
    }

    public void removeAriaAttribute(ReactiveElement<Element> element, AriaAttr<?> attr) {
        ((Element)element.ref()).removeAttribute(attr.name());
    }

    public Comment createCommentNode(String text) {
        return org.scalajs.dom.package$.MODULE$.document().createComment(text);
    }

    public void setCommentNodeText(CommentNode node, String text) {
        node.ref().textContent_$eq(text);
    }

    public Text createTextNode(String text) {
        return org.scalajs.dom.package$.MODULE$.document().createTextNode(text);
    }

    public void setTextNodeText(TextNode node, String text) {
        node.ref().textContent_$eq(text);
    }

    public boolean isCustomElement(Element element) {
        return new StringOps(Predef$.MODULE$.augmentString(element.tagName())).contains((Object)BoxesRunTime.boxToCharacter((char)'-'));
    }

    public .bar<Object, BoxedUnit> getChecked(Element element) {
        Element element2;
        block4: {
            HTMLInputElement hTMLInputElement;
            block5: {
                element2 = element;
                if (!(element2 instanceof HTMLInputElement)) break block4;
                hTMLInputElement = (HTMLInputElement)element2;
                String string = hTMLInputElement.type();
                String string2 = "checkbox";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block5;
                String string3 = hTMLInputElement.type();
                String string4 = "radio";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block4;
            }
            return $bar$.MODULE$.from((Object)BoxesRunTime.boxToBoolean((boolean)hTMLInputElement.checked()), .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base()));
        }
        if (this.isCustomElement(element2)) {
            return UndefOrOps$.MODULE$.collect$extension($bar$.MODULE$.undefOr2ops((.bar)((Dynamic)element2).selectDynamic("checked")), (PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof Boolean) {
                        boolean bl = BoxesRunTime.unboxToBoolean(A1);
                        return (B1)BoxesRunTime.boxToBoolean((boolean)bl);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    return object instanceof Boolean;
                }
            });
        }
        return scala.scalajs.js.package$.MODULE$.undefined();
    }

    public boolean setChecked(Element element, boolean checked) {
        Element element2;
        block4: {
            HTMLInputElement hTMLInputElement;
            block5: {
                element2 = element;
                if (!(element2 instanceof HTMLInputElement)) break block4;
                hTMLInputElement = (HTMLInputElement)element2;
                String string = hTMLInputElement.type();
                String string2 = "checkbox";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block5;
                String string3 = hTMLInputElement.type();
                String string4 = "radio";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block4;
            }
            hTMLInputElement.checked_$eq(checked);
            return true;
        }
        if (this.isCustomElement(element2)) {
            ((Dynamic)element2).updateDynamic("checked", Any$.MODULE$.fromBoolean(checked));
            return true;
        }
        return false;
    }

    public .bar<String, BoxedUnit> getValue(Element element) {
        Element element2 = element;
        if (element2 instanceof HTMLInputElement) {
            HTMLInputElement hTMLInputElement = (HTMLInputElement)element2;
            return $bar$.MODULE$.from((Object)hTMLInputElement.value(), .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base()));
        }
        if (element2 instanceof HTMLTextAreaElement) {
            HTMLTextAreaElement hTMLTextAreaElement = (HTMLTextAreaElement)element2;
            return $bar$.MODULE$.from((Object)hTMLTextAreaElement.value(), .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base()));
        }
        if (element2 instanceof HTMLSelectElement) {
            HTMLSelectElement hTMLSelectElement = (HTMLSelectElement)element2;
            return $bar$.MODULE$.from((Object)hTMLSelectElement.value(), .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base()));
        }
        if (element2 instanceof HTMLButtonElement) {
            HTMLButtonElement hTMLButtonElement = (HTMLButtonElement)element2;
            return $bar$.MODULE$.from((Object)hTMLButtonElement.value(), .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base()));
        }
        if (element2 instanceof HTMLOptionElement) {
            HTMLOptionElement hTMLOptionElement = (HTMLOptionElement)element2;
            return $bar$.MODULE$.from((Object)hTMLOptionElement.value(), .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base()));
        }
        if (this.isCustomElement(element2)) {
            return UndefOrOps$.MODULE$.collect$extension($bar$.MODULE$.undefOr2ops((.bar)((Dynamic)element2).selectDynamic("value")), (PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof String) {
                        String string = (String)A1;
                        return (B1)string;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    return object instanceof String;
                }
            });
        }
        return scala.scalajs.js.package$.MODULE$.undefined();
    }

    public boolean setValue(Element element, String value) {
        Element element2 = element;
        if (element2 instanceof HTMLInputElement) {
            HTMLInputElement hTMLInputElement = (HTMLInputElement)element2;
            hTMLInputElement.value_$eq(value);
            return true;
        }
        if (element2 instanceof HTMLTextAreaElement) {
            HTMLTextAreaElement hTMLTextAreaElement = (HTMLTextAreaElement)element2;
            hTMLTextAreaElement.value_$eq(value);
            return true;
        }
        if (element2 instanceof HTMLSelectElement) {
            HTMLSelectElement hTMLSelectElement = (HTMLSelectElement)element2;
            hTMLSelectElement.value_$eq(value);
            return true;
        }
        if (element2 instanceof HTMLButtonElement) {
            HTMLButtonElement hTMLButtonElement = (HTMLButtonElement)element2;
            hTMLButtonElement.value_$eq(value);
            return true;
        }
        if (element2 instanceof HTMLOptionElement) {
            HTMLOptionElement hTMLOptionElement = (HTMLOptionElement)element2;
            hTMLOptionElement.value_$eq(value);
            return true;
        }
        if (this.isCustomElement(element2)) {
            ((Dynamic)element2).updateDynamic("value", Any$.MODULE$.fromString(value));
            return true;
        }
        return false;
    }

    public .bar<List<File>, BoxedUnit> getFiles(Element element) {
        Element element2 = element;
        if (element2 instanceof HTMLInputElement) {
            HTMLInputElement hTMLInputElement = (HTMLInputElement)element2;
            String string = hTMLInputElement.type();
            String string2 = "file";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Nil$ result = Nil$.MODULE$;
                for (int ix = hTMLInputElement.files().length() - 1; ix >= 0; --ix) {
                    File file = (File)hTMLInputElement.files().apply(ix);
                    result = result.$colon$colon((Object)file);
                }
                return $bar$.MODULE$.from((Object)result, .bar.Evidence$.MODULE$.left(.bar.Evidence$.MODULE$.base()));
            }
        }
        return scala.scalajs.js.package$.MODULE$.undefined();
    }

    private HTMLTemplateElement htmlParserContainer() {
        return this.htmlParserContainer;
    }

    private SVGElement svgParserContainer() {
        return this.svgParserContainer;
    }

    public HTMLElement unsafeParseHtmlString(String dangerousHtmlString) {
        Array<Node> nodes = this.unsafeParseHtmlStringIntoNodeArray(dangerousHtmlString);
        String clue = "Error parsing HTML string";
        Node node = this.assertSingleNode(nodes, clue);
        return this.assertHtmlElement(node, clue);
    }

    public <Ref extends HTMLElement> Ref unsafeParseHtmlString(HtmlTag<Ref> tag, String dangerousHtmlString) {
        Array<Node> nodes = this.unsafeParseHtmlStringIntoNodeArray(dangerousHtmlString);
        String clue = "Error parsing HTML string";
        Node node = this.assertSingleNode(nodes, clue);
        return (Ref)((HTMLElement)this.assertTagMatches(tag, node, clue));
    }

    public SVGElement unsafeParseSvgString(String dangerousSvgString) {
        Array<Node> nodes = this.unsafeParseSvgStringIntoNodeArray(dangerousSvgString);
        String clue = "Error parsing SVG string";
        Node node = this.assertSingleNode(nodes, clue);
        return this.assertSvgElement(node, clue);
    }

    public <Ref extends SVGElement> Ref unsafeParseSvgString(SvgTag<Ref> tag, String dangerousSvgString) {
        Array<Node> nodes = this.unsafeParseSvgStringIntoNodeArray(dangerousSvgString);
        String clue = "Error parsing SVG string";
        Node node = this.assertSingleNode(nodes, clue);
        return (Ref)((SVGElement)this.assertTagMatches(tag, node, clue));
    }

    public Array<Node> unsafeParseHtmlStringIntoNodeArray(String dangerousHtmlString) {
        this.htmlParserContainer().innerHTML_$eq(dangerousHtmlString);
        Array arr = Array$.MODULE$.from((Iterable)this.htmlParserContainer().content().childNodes());
        this.htmlParserContainer().innerHTML_$eq("");
        return arr;
    }

    public Array<Node> unsafeParseSvgStringIntoNodeArray(String dangerousSvgString) {
        this.svgParserContainer().innerHTML_$eq(dangerousSvgString);
        Array arr = Array$.MODULE$.from((Iterable)this.svgParserContainer().childNodes());
        this.svgParserContainer().innerHTML_$eq("");
        return arr;
    }

    public Node assertSingleNode(Array<Node> nodes, String clue) {
        if (nodes.length() != 1) {
            throw new Exception(new StringBuilder(34).append(clue).append(": expected exactly 1 element, got ").append(nodes.length()).toString());
        }
        return (Node)nodes.apply(0);
    }

    public HTMLElement assertHtmlElement(Node node, String clue) {
        Node node2 = node;
        if (node2 instanceof HTMLElement) {
            HTMLElement hTMLElement = (HTMLElement)node2;
            return hTMLElement;
        }
        throw new Exception(new StringBuilder(47).append(clue).append(": expected HTML element, got non-element node: ").append(node.nodeName()).toString());
    }

    public String assertHtmlElement$default$2() {
        return "Error";
    }

    public SVGElement assertSvgElement(Node node, String clue) {
        Node node2 = node;
        if (node2 instanceof SVGElement) {
            SVGElement sVGElement = (SVGElement)node2;
            return sVGElement;
        }
        throw new Exception(new StringBuilder(46).append(clue).append(": expected SVG element, got non-element node: ").append(node.nodeName()).toString());
    }

    public String assertSvgElement$default$2() {
        return "Error";
    }

    public <Ref extends Element> Ref assertTagMatches(Tag<ReactiveElement<Ref>> tag, Node node, String clue) {
        Node node2 = node;
        if (node2 instanceof Element) {
            Element element = (Element)node2;
            JsString jsString = JsString.RichString$.MODULE$.ew$extension(com.raquo.ew.package$.MODULE$.ewString(tag.name())).toLowerCase();
            JsString jsString2 = JsString.RichString$.MODULE$.ew$extension(com.raquo.ew.package$.MODULE$.ewString(element.tagName())).toLowerCase();
            if (jsString == null ? jsString2 != null : !jsString.equals(jsString2)) {
                throw new Exception(new StringBuilder(30).append(clue).append(": expected tag name `").append(tag.name()).append("`, got `").append(element.tagName()).append("`").toString());
            }
            return (Ref)((Element)node);
        }
        throw new Exception(new StringBuilder(42).append(clue).append(": expected element, got non-element node: ").append(node.nodeName()).toString());
    }

    public <Ref extends Element> String assertTagMatches$default$3() {
        return "Error";
    }

    private RegExp classNamesSeparatorRegex() {
        return this.classNamesSeparatorRegex;
    }

    public List<String> debugPath(Node element, List<String> initial) {
        Node node;
        while ((node = element) != null) {
            String string = this.debugNodeDescription(element);
            initial = initial.$colon$colon((Object)string);
            element = element.parentNode();
        }
        return initial;
    }

    public List<String> debugPath$default$2() {
        return Nil$.MODULE$;
    }

    public String debugNodeDescription(Node node) {
        Node node2 = node;
        if (node2 instanceof HTMLElement) {
            String classes;
            HTMLElement hTMLElement = (HTMLElement)node2;
            String id = hTMLElement.id();
            String suffixStr = new StringOps(Predef$.MODULE$.augmentString(id)).nonEmpty() ? new StringBuilder(1).append("#").append(id).toString() : (new StringOps(Predef$.MODULE$.augmentString(classes = hTMLElement.className())).nonEmpty() ? new StringBuilder(1).append(".").append(JsString.RichJsString$.MODULE$.str$extension(JsString$.MODULE$.RichJsString(JsString.RichString$.MODULE$.ew$extension(com.raquo.ew.package$.MODULE$.ewString(classes)).replace($bar$.MODULE$.from((Object)this.classNamesSeparatorRegex(), .bar.Evidence$.MODULE$.right(.bar.Evidence$.MODULE$.base())), ".")))).toString() : "");
            return new StringBuilder(0).append(JsString.RichJsString$.MODULE$.str$extension(JsString$.MODULE$.RichJsString(JsString.RichString$.MODULE$.ew$extension(com.raquo.ew.package$.MODULE$.ewString(hTMLElement.tagName())).toLowerCase()))).append(suffixStr).toString();
        }
        return node.nodeName();
    }

    public String debugNodeOuterHtml(Node node) {
        Node node2 = node;
        if (node2 instanceof Element) {
            Element element = (Element)node2;
            return element.outerHTML();
        }
        if (node2 instanceof Text) {
            Text text = (Text)node2;
            return new StringBuilder(6).append("Text(").append(text.textContent()).append(")").toString();
        }
        if (node2 instanceof Comment) {
            Comment comment = (Comment)node2;
            return new StringBuilder(9).append("Comment(").append(comment.textContent()).append(")").toString();
        }
        if (node2 == null) {
            return "<null>";
        }
        return new StringBuilder(11).append("OtherNode(").append(node2.toString()).append(")").toString();
    }

    public String debugNodeInnerHtml(Node node) {
        Node node2 = node;
        if (node2 instanceof Element) {
            Element element = (Element)node2;
            return element.innerHTML();
        }
        if (node2 instanceof Text) {
            Text text = (Text)node2;
            return new StringBuilder(6).append("Text(").append(text.textContent()).append(")").toString();
        }
        if (node2 instanceof Comment) {
            Comment comment = (Comment)node2;
            return new StringBuilder(9).append("Comment(").append(comment.textContent()).append(")").toString();
        }
        if (node2 == null) {
            return "<null>";
        }
        return new StringBuilder(11).append("OtherNode(").append(node2.toString()).append(")").toString();
    }

    public static final /* synthetic */ void $anonfun$setRefStyle$2(HTMLElement ref$1, String styleCssName$1, String styleValue$1, String prefix) {
        CSSStyleDeclaration qual$1 = ref$1.style();
        String x$1 = new StringBuilder(0).append(prefix).append(styleCssName$1).toString();
        String x$2 = styleValue$1;
        String x$3 = qual$1.setProperty$default$3();
        qual$1.setProperty(x$1, x$2, x$3);
    }

    private DomApi$() {
        MODULE$ = this;
        this.htmlParserContainer = (HTMLTemplateElement)org.scalajs.dom.package$.MODULE$.document().createElement("template");
        this.svgParserContainer = this.createSvgElement(package$.MODULE$.L().svg().svg());
        this.classNamesSeparatorRegex = new RegExp(" ", "g");
    }
}

