/*
 * Decompiled with CFR 0.152.
 */
package com.rivigo.zoom.billing.dto;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.rivigo.zoom.billing.dto.zoomtech.ConsignmentRemark;
import com.rivigo.zoom.billing.enums.ChangeLog.ChangeLogStatus;
import com.rivigo.zoom.billing.enums.ChangeLog.FieldCategory;
import com.rivigo.zoom.billing.enums.ConsignmentChargeAtrribute;
import com.rivigo.zoom.billing.exceptions.ZoomBillingException;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class ChangeLogDTO {
    private Long id;
    private Long consignmentBookId;
    private List<PropertyChangeLog> propertyChangeLogs;
    private List<BillingComponentChangeLog> billingComponentChangeLogs;
    private BigDecimal totalChange;
    private String consumerId;
    private ChangeLogStatus status;
    private Long createdAt;
    private String createdBy;
    private Long updatedAt;
    private String updatedBy;
    private String cnote;

    private static BigDecimal convertStringToBigDecimal(String s) {
        if (s == null || StringUtils.isEmpty((Object)s)) {
            return null;
        }
        return new BigDecimal(s);
    }

    public void setBillingComponentChangeLogs(List<BillingComponentChangeLog> billingComponentChangeLogs) {
        this.billingComponentChangeLogs = billingComponentChangeLogs;
    }

    public void setPropertyChangeLogs(List<PropertyChangeLog> propertyChangeLogs) {
        this.propertyChangeLogs = propertyChangeLogs;
    }

    public void setBillingComponentChangeLogs(String changeLogs) {
        List<BillingComponentChangeLog> logs = new ArrayList<BillingComponentChangeLog>();
        if (!StringUtils.isEmpty((Object)changeLogs)) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                logs = (List)mapper.readValue(changeLogs, (TypeReference)new TypeReference<List<BillingComponentChangeLog>>(){});
            }
            catch (Exception e) {
                throw new ZoomBillingException("Unable to parse billing component change log");
            }
        }
        this.billingComponentChangeLogs = logs;
    }

    public void setPropertyChangeLogs(String propertyChangeLogs) {
        List<PropertyChangeLog> logs = new ArrayList<PropertyChangeLog>();
        if (!StringUtils.isEmpty((Object)propertyChangeLogs)) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                logs = (List)mapper.readValue(propertyChangeLogs, (TypeReference)new TypeReference<List<PropertyChangeLog>>(){});
            }
            catch (Exception e) {
                throw new ZoomBillingException("Unable to parse property component change log");
            }
        }
        this.propertyChangeLogs = logs;
    }

    public static ChangeLogDTOBuilder builder() {
        return new ChangeLogDTOBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getConsignmentBookId() {
        return this.consignmentBookId;
    }

    public List<PropertyChangeLog> getPropertyChangeLogs() {
        return this.propertyChangeLogs;
    }

    public List<BillingComponentChangeLog> getBillingComponentChangeLogs() {
        return this.billingComponentChangeLogs;
    }

    public BigDecimal getTotalChange() {
        return this.totalChange;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public ChangeLogStatus getStatus() {
        return this.status;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public String getCnote() {
        return this.cnote;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setConsignmentBookId(Long consignmentBookId) {
        this.consignmentBookId = consignmentBookId;
    }

    public void setTotalChange(BigDecimal totalChange) {
        this.totalChange = totalChange;
    }

    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    public void setStatus(ChangeLogStatus status) {
        this.status = status;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public void setCnote(String cnote) {
        this.cnote = cnote;
    }

    public ChangeLogDTO() {
    }

    @ConstructorProperties(value={"id", "consignmentBookId", "propertyChangeLogs", "billingComponentChangeLogs", "totalChange", "consumerId", "status", "createdAt", "createdBy", "updatedAt", "updatedBy", "cnote"})
    public ChangeLogDTO(Long id, Long consignmentBookId, List<PropertyChangeLog> propertyChangeLogs, List<BillingComponentChangeLog> billingComponentChangeLogs, BigDecimal totalChange, String consumerId, ChangeLogStatus status, Long createdAt, String createdBy, Long updatedAt, String updatedBy, String cnote) {
        this.id = id;
        this.consignmentBookId = consignmentBookId;
        this.propertyChangeLogs = propertyChangeLogs;
        this.billingComponentChangeLogs = billingComponentChangeLogs;
        this.totalChange = totalChange;
        this.consumerId = consumerId;
        this.status = status;
        this.createdAt = createdAt;
        this.createdBy = createdBy;
        this.updatedAt = updatedAt;
        this.updatedBy = updatedBy;
        this.cnote = cnote;
    }

    public String toString() {
        return "ChangeLogDTO(id=" + this.getId() + ", consignmentBookId=" + this.getConsignmentBookId() + ", propertyChangeLogs=" + this.getPropertyChangeLogs() + ", billingComponentChangeLogs=" + this.getBillingComponentChangeLogs() + ", totalChange=" + this.getTotalChange() + ", consumerId=" + this.getConsumerId() + ", status=" + (Object)((Object)this.getStatus()) + ", createdAt=" + this.getCreatedAt() + ", createdBy=" + this.getCreatedBy() + ", updatedAt=" + this.getUpdatedAt() + ", updatedBy=" + this.getUpdatedBy() + ", cnote=" + this.getCnote() + ")";
    }

    public static class ChangeLogDTOBuilder {
        private Long id;
        private Long consignmentBookId;
        private List<PropertyChangeLog> propertyChangeLogs;
        private List<BillingComponentChangeLog> billingComponentChangeLogs;
        private BigDecimal totalChange;
        private String consumerId;
        private ChangeLogStatus status;
        private Long createdAt;
        private String createdBy;
        private Long updatedAt;
        private String updatedBy;
        private String cnote;

        ChangeLogDTOBuilder() {
        }

        public ChangeLogDTOBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public ChangeLogDTOBuilder consignmentBookId(Long consignmentBookId) {
            this.consignmentBookId = consignmentBookId;
            return this;
        }

        public ChangeLogDTOBuilder propertyChangeLogs(List<PropertyChangeLog> propertyChangeLogs) {
            this.propertyChangeLogs = propertyChangeLogs;
            return this;
        }

        public ChangeLogDTOBuilder billingComponentChangeLogs(List<BillingComponentChangeLog> billingComponentChangeLogs) {
            this.billingComponentChangeLogs = billingComponentChangeLogs;
            return this;
        }

        public ChangeLogDTOBuilder totalChange(BigDecimal totalChange) {
            this.totalChange = totalChange;
            return this;
        }

        public ChangeLogDTOBuilder consumerId(String consumerId) {
            this.consumerId = consumerId;
            return this;
        }

        public ChangeLogDTOBuilder status(ChangeLogStatus status) {
            this.status = status;
            return this;
        }

        public ChangeLogDTOBuilder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public ChangeLogDTOBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public ChangeLogDTOBuilder updatedAt(Long updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public ChangeLogDTOBuilder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public ChangeLogDTOBuilder cnote(String cnote) {
            this.cnote = cnote;
            return this;
        }

        public ChangeLogDTO build() {
            return new ChangeLogDTO(this.id, this.consignmentBookId, this.propertyChangeLogs, this.billingComponentChangeLogs, this.totalChange, this.consumerId, this.status, this.createdAt, this.createdBy, this.updatedAt, this.updatedBy, this.cnote);
        }

        public String toString() {
            return "ChangeLogDTO.ChangeLogDTOBuilder(id=" + this.id + ", consignmentBookId=" + this.consignmentBookId + ", propertyChangeLogs=" + this.propertyChangeLogs + ", billingComponentChangeLogs=" + this.billingComponentChangeLogs + ", totalChange=" + this.totalChange + ", consumerId=" + this.consumerId + ", status=" + (Object)((Object)this.status) + ", createdAt=" + this.createdAt + ", createdBy=" + this.createdBy + ", updatedAt=" + this.updatedAt + ", updatedBy=" + this.updatedBy + ", cnote=" + this.cnote + ")";
        }
    }

    public static class PropertyChangeLogMapper
    extends JsonDeserializer<PropertyChangeLog> {
        public PropertyChangeLog deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            PropertyChangeLog propertyChangeLog = new PropertyChangeLog();
            propertyChangeLog.setFieldCategory(FieldCategory.valueOf(node.get("fieldCategory").asText()));
            propertyChangeLog.setOldValue(node.get("oldValue").asText());
            propertyChangeLog.setNewValue(node.get("newValue").asText());
            return propertyChangeLog;
        }
    }

    public static class BillingComponentChangeLogMapper
    extends JsonDeserializer<BillingComponentChangeLog> {
        public BillingComponentChangeLog deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode additionalParamMap;
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            BillingComponentChangeLog billingComponentChangeLog = new BillingComponentChangeLog();
            billingComponentChangeLog.setFieldName(node.get("fieldName").asText());
            billingComponentChangeLog.setOldValue(ChangeLogDTO.convertStringToBigDecimal(node.get("oldValue").asText()));
            billingComponentChangeLog.setNewValue(ChangeLogDTO.convertStringToBigDecimal(node.get("newValue").asText()));
            JsonNode jsonNode = additionalParamMap = node.get("additional") == null ? null : node.get("additional");
            if (additionalParamMap != null) {
                ObjectMapper objectMapper = new ObjectMapper();
                billingComponentChangeLog.setAdditional((Map)objectMapper.convertValue((Object)additionalParamMap, Map.class));
            }
            return billingComponentChangeLog;
        }
    }

    @JsonDeserialize(using=BillingComponentChangeLogMapper.class)
    public static class BillingComponentChangeLog {
        private String fieldName;
        private BigDecimal oldValue;
        private BigDecimal newValue;
        private Map<String, Object> additional = new HashMap<String, Object>();
        public static final String OTHER_ADJUSTMENT_REASON_KEY = "OTHER_ADJUSTMENT_REASON";
        public static final String OTHER_ADJUSTMENT_COMMENT_KEY = "OTHER_ADJUSTMENT_COMMENT";
        public static final String DIESEL_RATE_CHANGES_KEY = "DIESEL_RATE_CHANGES";

        public ConsignmentRemark interpret() {
            ConsignmentChargeAtrribute consignmentChargeAtrribute = ConsignmentChargeAtrribute.getByFieldName(this.fieldName);
            return ConsignmentRemark.builder().code(consignmentChargeAtrribute.getFieldName()).title(consignmentChargeAtrribute.getStr()).oldValue(String.valueOf(this.oldValue)).newValue(String.valueOf(this.newValue)).build();
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public BigDecimal getOldValue() {
            return this.oldValue;
        }

        public void setOldValue(BigDecimal oldValue) {
            this.oldValue = oldValue == null ? BigDecimal.ZERO : oldValue;
        }

        public BigDecimal getNewValue() {
            return this.newValue;
        }

        public void setNewValue(BigDecimal newValue) {
            this.newValue = newValue == null ? BigDecimal.ZERO : newValue;
        }

        public Map<String, Object> getAdditional() {
            return this.additional;
        }

        public void setAdditional(Map<String, Object> additional) {
            this.additional = additional;
        }

        public String toString() {
            return "ChangeLogDTO.BillingComponentChangeLog(fieldName=" + this.getFieldName() + ", oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ", additional=" + this.getAdditional() + ")";
        }
    }

    @JsonDeserialize(using=PropertyChangeLogMapper.class)
    public static class PropertyChangeLog {
        private FieldCategory fieldCategory;
        private String oldValue;
        private String newValue;

        public static PropertyChangeLogBuilder builder() {
            return new PropertyChangeLogBuilder();
        }

        public void setFieldCategory(FieldCategory fieldCategory) {
            this.fieldCategory = fieldCategory;
        }

        public void setOldValue(String oldValue) {
            this.oldValue = oldValue;
        }

        public void setNewValue(String newValue) {
            this.newValue = newValue;
        }

        public FieldCategory getFieldCategory() {
            return this.fieldCategory;
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public String getNewValue() {
            return this.newValue;
        }

        public String toString() {
            return "ChangeLogDTO.PropertyChangeLog(fieldCategory=" + (Object)((Object)this.getFieldCategory()) + ", oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ")";
        }

        public PropertyChangeLog() {
        }

        @ConstructorProperties(value={"fieldCategory", "oldValue", "newValue"})
        public PropertyChangeLog(FieldCategory fieldCategory, String oldValue, String newValue) {
            this.fieldCategory = fieldCategory;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public static class PropertyChangeLogBuilder {
            private FieldCategory fieldCategory;
            private String oldValue;
            private String newValue;

            PropertyChangeLogBuilder() {
            }

            public PropertyChangeLogBuilder fieldCategory(FieldCategory fieldCategory) {
                this.fieldCategory = fieldCategory;
                return this;
            }

            public PropertyChangeLogBuilder oldValue(String oldValue) {
                this.oldValue = oldValue;
                return this;
            }

            public PropertyChangeLogBuilder newValue(String newValue) {
                this.newValue = newValue;
                return this;
            }

            public PropertyChangeLog build() {
                return new PropertyChangeLog(this.fieldCategory, this.oldValue, this.newValue);
            }

            public String toString() {
                return "ChangeLogDTO.PropertyChangeLog.PropertyChangeLogBuilder(fieldCategory=" + (Object)((Object)this.fieldCategory) + ", oldValue=" + this.oldValue + ", newValue=" + this.newValue + ")";
            }
        }
    }
}

