/*
 * Decompiled with CFR 0.152.
 */
package com.rivigo.zoom.billing.dto;

import com.rivigo.zoom.billing.enums.CnBookStatus;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;

public class ConsignmentBookSummaryDTO {
    private String status;
    private Long count;
    private BigDecimal revenue;

    public void setStatus(CnBookStatus cnBookStatus) {
        this.status = cnBookStatus.getStr();
    }

    public void add(ConsignmentBookSummaryDTO consignmentBookSummaryDTO) {
        this.count = this.count + consignmentBookSummaryDTO.getCount();
        this.revenue = this.revenue.add(consignmentBookSummaryDTO.getRevenue());
    }

    public static ConsignmentBookSummaryDTOBuilder builder() {
        return new ConsignmentBookSummaryDTOBuilder();
    }

    public String getStatus() {
        return this.status;
    }

    public Long getCount() {
        return this.count;
    }

    public BigDecimal getRevenue() {
        return this.revenue;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public void setRevenue(BigDecimal revenue) {
        this.revenue = revenue;
    }

    public ConsignmentBookSummaryDTO() {
    }

    @ConstructorProperties(value={"status", "count", "revenue"})
    public ConsignmentBookSummaryDTO(String status, Long count, BigDecimal revenue) {
        this.status = status;
        this.count = count;
        this.revenue = revenue;
    }

    public static class ConsignmentBookSummaryDTOBuilder {
        private String status;
        private Long count;
        private BigDecimal revenue;

        ConsignmentBookSummaryDTOBuilder() {
        }

        public ConsignmentBookSummaryDTOBuilder status(String status) {
            this.status = status;
            return this;
        }

        public ConsignmentBookSummaryDTOBuilder count(Long count) {
            this.count = count;
            return this;
        }

        public ConsignmentBookSummaryDTOBuilder revenue(BigDecimal revenue) {
            this.revenue = revenue;
            return this;
        }

        public ConsignmentBookSummaryDTO build() {
            return new ConsignmentBookSummaryDTO(this.status, this.count, this.revenue);
        }

        public String toString() {
            return "ConsignmentBookSummaryDTO.ConsignmentBookSummaryDTOBuilder(status=" + this.status + ", count=" + this.count + ", revenue=" + this.revenue + ")";
        }
    }
}

