/*
 * Decompiled with CFR 0.152.
 */
package com.rivigo.zoom.billing.dto;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rivigo.cms.constants.BillingCycle;
import com.rivigo.cms.constants.ContractType;
import com.rivigo.cms.constants.ServiceType;
import com.rivigo.cms.dtos.ClientContractAttributeDTO;
import com.rivigo.cms.dtos.ClientContractDTO;
import com.rivigo.cms.dtos.ClientDTO;
import com.rivigo.meta.constants.DieselSource;
import com.rivigo.zoom.billing.constants.ContractAttributeConstants;
import com.rivigo.zoom.billing.dto.CustomField;
import com.rivigo.zoom.billing.dto.SlabDTO;
import com.rivigo.zoom.billing.enums.BasicFreight.ChargeWeightBasis;
import com.rivigo.zoom.billing.enums.BasicFreight.ContractObligation;
import com.rivigo.zoom.billing.enums.BasicFreight.ContractObligationLocationType;
import com.rivigo.zoom.billing.enums.BillingAnnexureTemplate;
import com.rivigo.zoom.billing.enums.ChargeBasis;
import com.rivigo.zoom.billing.enums.CodDodOnlinePaymentMode;
import com.rivigo.zoom.billing.enums.ConsignmentLiability;
import com.rivigo.zoom.billing.enums.FOV.FragilityValue;
import com.rivigo.zoom.billing.enums.FSC.BaseDieselRateDerivation;
import com.rivigo.zoom.billing.enums.FSC.BaseDieselRateType;
import com.rivigo.zoom.billing.enums.FSC.BasicFreightChangeCriteria;
import com.rivigo.zoom.billing.enums.FSC.BillingDieselRateCalculationType;
import com.rivigo.zoom.billing.enums.FSC.DieselBillingPeriod;
import com.rivigo.zoom.billing.enums.FSC.FuelLinkageCriteria;
import com.rivigo.zoom.billing.enums.FSC.NegativeFscBenefit;
import com.rivigo.zoom.billing.enums.FSC.ToleranceBand;
import com.rivigo.zoom.billing.enums.FSC.ToleranceType;
import com.rivigo.zoom.billing.enums.GreenTaxApplicableCity;
import com.rivigo.zoom.billing.enums.LatePaymentInterest;
import com.rivigo.zoom.billing.enums.ModeOfPayment;
import com.rivigo.zoom.billing.enums.ODAType;
import com.rivigo.zoom.billing.enums.PODRequirement;
import com.rivigo.zoom.billing.enums.PickupDeliveryActivityBasis;
import com.rivigo.zoom.billing.enums.RoundingFactor;
import com.rivigo.zoom.billing.enums.WeightType;
import com.rivigo.zoom.billing.exceptions.ZoomBillingException;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class ContractDetailsDTO {
    private static final Logger log = LoggerFactory.getLogger(ContractDetailsDTO.class);
    private String code;
    private ContractType type;
    private ServiceType serviceType;
    private BillingCycle billingCycle;
    private Integer creditPeriod;
    private Long expiryTimestamp;
    private Long createdTimestamp;
    private Long updatedTimestamp;
    private String clientCode;
    private ClientDTO clientDTO;
    private ModeOfPayment modeOfPayment;
    private LatePaymentInterest latePaymentInterest;
    private BigDecimal interestOnLatePayment;
    private PODRequirement podRequirement;
    private BillingAnnexureTemplate billingAnnexureTemplate;
    private ContractObligation contractObligation;
    private BigDecimal minimumWeightPerCn;
    private BigDecimal minimumFreightPerCn;
    private ChargeWeightBasis chargeWeightBasis;
    private BigDecimal minimumWeightPerBox;
    private BigDecimal cft;
    private BigDecimal lightCft;
    private BigDecimal denseCft;
    private RoundingFactor roundingFactor;
    private ContractObligationLocationType contractObligationLocationType;
    private Map<String, BigDecimal> locationToMinWeightMap;
    private Map<String, BigDecimal> locationToMinFreightMap;
    private ChargeBasis processingChargesChargeBasis;
    private BigDecimal processingChargesPerCn;
    private ConsignmentLiability consignmentLiability;
    private BigDecimal maximumLiability;
    private ChargeBasis fovChargeBasis;
    private FragilityValue fovValue;
    private BigDecimal clientFovPerCn;
    private BigDecimal clientFovPerCnFragile;
    private BigDecimal clientFovPerCnNonFragile;
    private BigDecimal clientFovPercentage;
    private BigDecimal clientFovPercentageFragile;
    private BigDecimal clientFovPercentageNonFragile;
    private BigDecimal clientFovMaxCharge;
    private BigDecimal clientFovMaxChargeFragile;
    private BigDecimal clientFovMaxChargeNonFragile;
    private BigDecimal clientFovMinCharge;
    private BigDecimal clientFovMinChargeFragile;
    private BigDecimal clientFovMinChargeNonFragile;
    private BigDecimal rcsPercentageFragile;
    private BigDecimal rcsPercentageNonFragile;
    private BigDecimal rcsMaxCharge;
    private BigDecimal rcsMaxChargeFragile;
    private BigDecimal rcsMaxChargeNonFragile;
    private BigDecimal rcsMinCharge;
    private BigDecimal rcsMinChargeFragile;
    private BigDecimal rcsMinChargeNonFragile;
    private BigDecimal fscPercentage;
    private ChargeBasis fuelLinkageChargeBasis;
    private FuelLinkageCriteria fuelLinkageCriteria;
    private BigDecimal fscDieselPercentChange;
    private BigDecimal fscPercentChange;
    private BaseDieselRateType baseDieselRateType;
    private BaseDieselRateDerivation baseDieselRateDerivation;
    private DieselSource dieselSource;
    private BigDecimal dieselPrice;
    private String dieselRateCities;
    private Long dieselRateAsOnDate;
    private BillingDieselRateCalculationType billingDieselRateCalculationType;
    private String specificPeriodDays;
    private DieselBillingPeriod dieselBillingPeriod;
    private ToleranceBand toleranceBand;
    private ToleranceType toleranceType;
    private BigDecimal toleranceAmount;
    private Boolean negativeFscBenefit;
    private BasicFreightChangeCriteria basicFreightChangeCriteria;
    private List<SlabDTO> fscBasicFreightChangeSlabs;
    private String componentsForFscCharge;
    private ChargeBasis greenTaxChargeBasis;
    private BigDecimal greenTaxRatePerCn;
    private BigDecimal greenTaxRatePerKg;
    private BigDecimal greenTaxRatePerBox;
    private BigDecimal greenTaxMinimumCharge;
    private BigDecimal greenTaxMaximumCharge;
    private GreenTaxApplicableCity greenTaxApplicableCity;
    private PickupDeliveryActivityBasis greenTaxApplicabilityType;
    private ChargeBasis appointmentDeliveryChargeBasis;
    private BigDecimal appointmentDeliveryRatePerCn;
    private BigDecimal appointmentDeliveryRatePerKg;
    private BigDecimal appointmentDeliveryMinimumCharge;
    private BigDecimal appointmentDeliveryMaximumCharge;
    private ChargeBasis sundayDeliveryChargeBasis;
    private BigDecimal sundayDeliveryRatePerCn;
    private BigDecimal sundayDeliveryRatePerKg;
    private BigDecimal sundayDeliveryRatePerBox;
    private BigDecimal sundayDeliveryMinimumCharge;
    private BigDecimal sundayDeliveryMaximumCharge;
    private PickupDeliveryActivityBasis sundayDeliveryApplicabilityType;
    private ChargeBasis mallDeliveryChargeBasis;
    private BigDecimal mallDeliveryRatePerCn;
    private BigDecimal mallDeliveryRatePerKg;
    private BigDecimal mallDeliveryMinimumCharge;
    private BigDecimal mallDeliveryMaximumCharge;
    private ChargeBasis canteenDeliveryChargeBasis;
    private BigDecimal canteenDeliveryRatePerCn;
    private BigDecimal canteenDeliveryRatePerKg;
    private BigDecimal canteenDeliveryMinimumCharge;
    private BigDecimal canteenDeliveryMaximumCharge;
    private ChargeBasis sezDeliveryChargeBasis;
    private BigDecimal sezDeliveryRatePerCn;
    private BigDecimal sezDeliveryRatePerKg;
    private BigDecimal sezDeliveryMinimumCharge;
    private BigDecimal sezDeliveryMaximumCharge;
    private ChargeBasis railwayDeliveryChargeBasis;
    private BigDecimal railwayDeliveryRatePerCn;
    private BigDecimal railwayDeliveryRatePerKg;
    private BigDecimal railwayDeliveryMinimumCharge;
    private BigDecimal railwayDeliveryMaximumCharge;
    private ChargeBasis governmentCompoundDeliveryChargeBasis;
    private BigDecimal governmentCompoundDeliveryRatePerCn;
    private BigDecimal governmentCompoundDeliveryRatePerKg;
    private BigDecimal governmentCompoundDeliveryMinimumCharge;
    private BigDecimal governmentCompoundDeliveryMaximumCharge;
    private ChargeBasis liquidHandlingChargeBasis;
    private BigDecimal liquidHandlingRatePerCn;
    private BigDecimal liquidHandlingRatePerKg;
    private BigDecimal liquidHandlingMinimumCharge;
    private BigDecimal liquidHandlingMaximumCharge;
    private ChargeBasis hazardousHandlingChargeBasis;
    private BigDecimal hazardousHandlingRatePerCn;
    private BigDecimal hazardousHandlingRatePerKg;
    private BigDecimal hazardousHandlingMinimumCharge;
    private BigDecimal hazardousHandlingMaximumCharge;
    private ChargeBasis deliveryReattemptChargeBasis;
    private Boolean deliveryReattemptIsPerAttempt;
    private BigDecimal deliveryReattemptRatePerCn;
    private BigDecimal deliveryReattemptRatePerKg;
    private BigDecimal deliveryReattemptMinimumCharge;
    private BigDecimal deliveryReattemptMaximumCharge;
    private ChargeBasis handlingChargesChargeBasis;
    private WeightType handlingChargeWeightType;
    private BigDecimal handlingChargesRatePerCn;
    private BigDecimal handlingChargesRatePerKg;
    private BigDecimal handlingChargesRatePerBox;
    private BigDecimal handlingChargesMinimumCharge;
    private BigDecimal handlingChargesMaximumCharge;
    private List<SlabDTO> handlingChargesRatePerKgPerBoxSlabs;
    private List<SlabDTO> handlingChargesRatePerBoxSlabs;
    private List<SlabDTO> handlingChargesRatePerKgSlabs;
    private ChargeBasis odcHandlingChargesChargeBasis;
    private BigDecimal odcHandlingChargesRatePerKg;
    private BigDecimal odcHandlingChargesRatePerBox;
    private BigDecimal odcHandlingChargesMinimumCharge;
    private BigDecimal odcHandlingChargesMaximumCharge;
    private ChargeBasis valueHandlingChargesChargeBasis;
    private BigDecimal valueHandlingChargesRatePerKgCutoff;
    private BigDecimal valueHandlingChargesCustomerInvoicePercentage;
    private BigDecimal valueHandlingChargesMinimumCharge;
    private BigDecimal valueHandlingChargesMaximumCharge;
    private Boolean higherFloorChargesIsPerFloor;
    private PickupDeliveryActivityBasis higherFloorActivityBasis;
    private ChargeBasis higherFloorDeliveryChargeBasis;
    private BigDecimal higherFloorDeliveryRatePerCn;
    private BigDecimal higherFloorDeliveryRatePerKg;
    private BigDecimal higherFloorDeliveryRatePerBox;
    private BigDecimal higherFloorDeliveryMinimumCharge;
    private BigDecimal higherFloorDeliveryMaximumCharge;
    private List<SlabDTO> higherFloorDeliveryRatePerKgSlabs;
    private List<SlabDTO> higherFloorDeliveryRatePerBoxSlabs;
    private Integer higherFloorExclusionFloors;
    private ChargeBasis odaChargeBasis;
    private ODAType odaType;
    private BigDecimal oda1RatePerCn;
    private BigDecimal oda2RatePerCn;
    private BigDecimal oda3RatePerCn;
    private BigDecimal oda4RatePerCn;
    private BigDecimal oda5RatePerCn;
    private BigDecimal oda6RatePerCn;
    private BigDecimal oda7RatePerCn;
    private List<SlabDTO> oda1RatePerKgSlabs;
    private List<SlabDTO> oda2RatePerKgSlabs;
    private List<SlabDTO> oda3RatePerKgSlabs;
    private List<SlabDTO> oda4RatePerKgSlabs;
    private List<SlabDTO> oda5RatePerKgSlabs;
    private List<SlabDTO> oda6RatePerKgSlabs;
    private List<SlabDTO> oda7RatePerKgSlabs;
    private boolean odaExemptionApplicability;
    private String odaExemptedPincodes;
    private ChargeBasis opaChargeBasis;
    private Map<String, OPAField> categoryVsOpaField;
    private Map<String, BigDecimal> exceptionalPincodes;
    private boolean opaExceptionApplicability;
    private ChargeBasis fodChargeBasis;
    private BigDecimal fodPerCn;
    private BigDecimal fodPerKg;
    private BigDecimal fodMinimumCharge;
    private BigDecimal fodMaximumCharge;
    private BigDecimal fodPerBox;
    private ChargeBasis metroCongestionChargeBasis;
    private BigDecimal metroCongestionPerCn;
    private BigDecimal metroCongestionPerKg;
    private BigDecimal metroCongestionMinimumCharge;
    private BigDecimal metroCongestionMaximumCharge;
    private BigDecimal metroCongestionPerBox;
    private ChargeBasis hardRegionChargeBasis;
    private BigDecimal hardRegionPerCn;
    private BigDecimal hardRegionPerKg;
    private BigDecimal hardRegionMinimumCharge;
    private BigDecimal hardRegionMaximumCharge;
    private BigDecimal hardRegionPerBox;
    private ChargeBasis specialZoneChargeBasis;
    private BigDecimal specialZonePerCn;
    private BigDecimal specialZonePerKg;
    private BigDecimal specialZoneMinimumCharge;
    private BigDecimal specialZoneMaximumCharge;
    private BigDecimal specialZonePerBox;
    private ChargeBasis infrastructureDevelopmentChargeBasis;
    private BigDecimal infrastructureDevelopmentRatePerChargeBasis;
    private String infrastructureDevelopmentChargeComponent;
    private ChargeBasis bdSurchargeChargeBasis;
    private BigDecimal bdSurchargePercentageFreight;
    private ChargeBasis codDodChargeBasis;
    private BigDecimal codDodPerCn;
    private BigDecimal codDodPercentageFreight;
    private BigDecimal codDodMin;
    private BigDecimal codDodMax;
    private String clientAccountNumber;
    private BigDecimal codDodCreditCardChargeMin;
    private BigDecimal codDodDebitCardChargeMin;
    private BigDecimal codDodNetbankingChargeMin;
    private BigDecimal codDodNeftChargeMin;
    private BigDecimal codDodRtgsChargeMin;
    private BigDecimal codDodImpsChargeMin;
    private BigDecimal codDodUpiChargeMin;
    private BigDecimal codDodCreditCardPercentage;
    private BigDecimal codDodDebitCardPercentage;
    private BigDecimal codDodNetbankingPercentage;
    private BigDecimal codDodNeftPercentage;
    private BigDecimal codDodRtgsPercentage;
    private BigDecimal codDodImpsPercentage;
    private BigDecimal codDodUpiPercentage;
    private BigDecimal codDodCreditCardChargeMax;
    private BigDecimal codDodDebitCardChargeMax;
    private BigDecimal codDodNetbankingChargeMax;
    private BigDecimal codDodNeftChargeMax;
    private BigDecimal codDodRtgsChargeMax;
    private BigDecimal codDodImpsChargeMax;
    private BigDecimal codDodUpiChargeMax;
    private Map<CodDodOnlinePaymentMode, List<CodDodExceptionalCharge>> codDodModeVsExceptionalCharge;
    private ChargeBasis daccChargeBasis;
    private BigDecimal daccRatePerCn;
    private BigDecimal daccRatePerKg;
    private BigDecimal daccMinimumCharge;
    private BigDecimal daccMaximumCharge;
    private ChargeBasis demurrageChargeBasis;
    private BigDecimal demurrageExclusionHours;
    private BigDecimal demurrageRatePerCn;
    private BigDecimal demurrageRatePerKg;
    private BigDecimal demurragePercentageFreight;
    private List<SlabDTO> demurrageRatePerCnSlab;
    private List<SlabDTO> demurragePercentageFreightSlab;
    private List<SlabDTO> demurrageRatePerKgSlab;
    private ChargeBasis hardCopyPodChargeBasis;
    private BigDecimal hardCopyPodPerCn;
    private ChargeBasis unionWaraiMathadiChargeBasis;
    private BigDecimal unionWaraiMathadiChargePerUnit;
    private BigDecimal unionWaraiMathadiMinCharge;
    private BigDecimal unionWaraiMathadiMaxCharge;
    private PickupDeliveryActivityBasis unionWaraiMathadiActivityBasis;
    private ChargeBasis dedicatedVehicleChargeBasis;
    private BigDecimal dedicatedVehicleChargePerUnit;
    private BigDecimal dedicatedVehicleMinCharge;
    private BigDecimal dedicatedVehicleMaxCharge;
    private PickupDeliveryActivityBasis dedicatedVehicleActivityBasis;
    private ChargeBasis materialHandlingEquipmentChargeBasis;
    private BigDecimal materialHandlingEquipmentChargePerUnit;
    private BigDecimal materialHandlingEquipmentMinCharge;
    private BigDecimal materialHandlingEquipmentMaxCharge;
    private PickupDeliveryActivityBasis materialHandlingEquipmentActivityBasis;
    private List<CustomField> clientFields;
    private List<SlabDTO> weightBasedDiscount;
    private List<SlabDTO> chargedWeightSlabs;
    private List<SlabDTO> ccSlabs;

    public ContractDetailsDTO(ClientContractDTO clientContractDTO) {
        this.billingCycle = clientContractDTO.getBillingCycle();
        this.clientCode = clientContractDTO.getClientCode();
        this.clientDTO = clientContractDTO.getClientDTO();
        this.code = clientContractDTO.getCode();
        this.creditPeriod = clientContractDTO.getCreditPeriod();
        this.serviceType = clientContractDTO.getServiceType();
        this.expiryTimestamp = clientContractDTO.getExpiryTimestamp().getMillis();
        this.createdTimestamp = clientContractDTO.getCreatedTimestamp().getMillis();
        this.updatedTimestamp = clientContractDTO.getUpdatedTimestamp().getMillis();
        this.type = clientContractDTO.getType();
        LinkedMultiValueMap attributeNameToAttributeDtoMap = new LinkedMultiValueMap();
        for (ClientContractAttributeDTO clientContractAttributeDTO : clientContractDTO.getAttributes()) {
            attributeNameToAttributeDtoMap.add((Object)clientContractAttributeDTO.getName(), (Object)clientContractAttributeDTO);
        }
        this.setContractFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setBasicFreightDetails((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap, clientContractDTO.getServiceType());
        this.setAppointmentDeliveryFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setCodDodFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setFodFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setMetroCongestionFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setHardRegionFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setSpecialZoneFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setInfrastructureDevelopmentFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setBDSurchargeFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setLiabilityFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setFscFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setGreenTaxFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setDeliveryReattemptChargesFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setDaccChargesFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setHandlingChargesFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setOdcHandlingCharges((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setValueHandlingCharges((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setHardCopyPodFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setMallDeliveryFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setCanteenDeliveryFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setGovernmentCompoundDeliveryFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setSezDeliveryFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setRailwayDeliveryFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setHazardousHandlingFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setLiquidHandlingFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setSundayDeliveryFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setOdaFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setOpaFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setProcessingChargesFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setHigherFloorDeliveryFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setClientCustomFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setWeightBasedDiscount((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setChargedWeightSlabs((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setCcSlabs((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setDemurrageChargesFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setUWMChargeFields((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setDedicatedVehicle((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
        this.setMHECharge((MultiValueMap<String, ClientContractAttributeDTO>)attributeNameToAttributeDtoMap);
    }

    private void setCcSlabs(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.ccSlabs = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|CC|FROM", "SLAB|CC|TO", "SLAB|CC|VALUE", "SLAB|CC|MIN", "SLAB|CC|MAX");
    }

    private void setChargedWeightSlabs(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.chargedWeightSlabs = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|BOX_WEIGHT|FROM", "SLAB|BOX_WEIGHT|TO", "SLAB|BOX_WEIGHT|VALUE", "SLAB|BOX_WEIGHT|MIN", "SLAB|BOX_WEIGHT|MAX");
    }

    private void setContractFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.modeOfPayment = (ModeOfPayment)this.getEnumValue(attributeNameToAttributeDtoMap, "MODE_OF_PAYMENT", ModeOfPayment.class);
        this.latePaymentInterest = (LatePaymentInterest)this.getEnumValue(attributeNameToAttributeDtoMap, "LATE_PAYMENT_INTEREST", LatePaymentInterest.class);
        this.interestOnLatePayment = this.getNumberFromMap(attributeNameToAttributeDtoMap, "PERCENTAGE_INTEREST");
        this.podRequirement = (PODRequirement)this.getEnumValue(attributeNameToAttributeDtoMap, "POD_REQUIREMENT", PODRequirement.class);
        this.billingAnnexureTemplate = (BillingAnnexureTemplate)this.getEnumValue(attributeNameToAttributeDtoMap, "BILLING_ANNEXURE_TEMPLATE", BillingAnnexureTemplate.class);
    }

    private void setBasicFreightDetails(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap, ServiceType serviceType) {
        switch (((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"CONTRACT_OBLIGATION")).get(0)).getValue()) {
            case "CONTRACT_OBLIGATION_MIN_WEIGHT": {
                this.contractObligation = ContractObligation.MINIMUM_WEIGHT_PER_CN;
                this.minimumWeightPerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CONTRACT_OBLIGATION_MIN_WEIGHT");
                break;
            }
            case "CONTRACT_OBLIGATION_MIN_FREIGHT": {
                this.contractObligation = ContractObligation.MINIMUM_FREIGHT_PER_CN;
                this.minimumFreightPerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CONTRACT_OBLIGATION_MIN_FREIGHT");
                break;
            }
            case "BOTH": {
                this.contractObligation = ContractObligation.BOTH;
                this.minimumWeightPerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CONTRACT_OBLIGATION_MIN_WEIGHT");
                this.minimumFreightPerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CONTRACT_OBLIGATION_MIN_FREIGHT");
                break;
            }
            case "NOT_APPLICABLE": {
                this.contractObligation = ContractObligation.NOT_APPLICABLE;
            }
        }
        if (attributeNameToAttributeDtoMap.containsKey((Object)"CONTRACT_OBLIGATION_LOCATION_TYPE")) {
            String locationType = ((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"CONTRACT_OBLIGATION_LOCATION_TYPE")).get(0)).getValue();
            this.contractObligationLocationType = ContractObligationLocationType.valueOf(locationType);
            switch (locationType) {
                case "OU": 
                case "CITY": {
                    this.locationToMinWeightMap = this.getMap(attributeNameToAttributeDtoMap, "ARRAY_FIELD|CONTRACT_OBLIGATION_SLAB|LOCATION_CODE", "ARRAY_FIELD|CONTRACT_OBLIGATION_SLAB|LOCATION_MIN_WEIGHT");
                    this.locationToMinFreightMap = this.getMap(attributeNameToAttributeDtoMap, "ARRAY_FIELD|CONTRACT_OBLIGATION_SLAB|LOCATION_CODE", "ARRAY_FIELD|CONTRACT_OBLIGATION_SLAB|LOCATION_MIN_FREIGHT");
                }
            }
        }
        this.chargeWeightBasis = (ChargeWeightBasis)this.getEnumValue(attributeNameToAttributeDtoMap, "CHARGE_WEIGHT", ChargeWeightBasis.class);
        switch (this.chargeWeightBasis) {
            case VOLUMETRIC: {
                if (ServiceType.ZOOM_FRANCHISE.equals((Object)serviceType)) {
                    this.lightCft = this.getNumberFromMap(attributeNameToAttributeDtoMap, "LIGHT_CFT");
                    this.denseCft = this.getNumberFromMap(attributeNameToAttributeDtoMap, "DENSE_CFT");
                    break;
                }
                if (ServiceType.ZOOM_RETAIL.equals((Object)serviceType) || ServiceType.ZOOM_ECOMMERCE.equals((Object)serviceType)) {
                    this.lightCft = this.getNumberFromMap(attributeNameToAttributeDtoMap, "LIGHT_CFT");
                    this.denseCft = this.getNumberFromMap(attributeNameToAttributeDtoMap, "DENSE_CFT");
                    this.cft = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CFT");
                    break;
                }
                this.cft = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CFT");
                break;
            }
            case BOX: {
                if (ServiceType.ZOOM_RETAIL.equals((Object)serviceType)) {
                    this.cft = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CFT");
                }
                this.minimumWeightPerBox = this.getNumberFromMap(attributeNameToAttributeDtoMap, "MINIMUM_WEIGHT_PER_BOX");
                break;
            }
            case BIKE: {
                this.cft = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CFT");
            }
        }
        this.roundingFactor = (RoundingFactor)this.getEnumValue(attributeNameToAttributeDtoMap, "ROUNDING_FACTOR", RoundingFactor.class);
    }

    private void setProcessingChargesFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        BigDecimal proccessingCharges = this.getNumberFromMap(attributeNameToAttributeDtoMap, "PROCESSING_CHARGE");
        this.processingChargesChargeBasis = BigDecimal.ZERO.equals(proccessingCharges) ? ChargeBasis.NOT_APPLICABLE : ChargeBasis.FLAT_RATE_PER_CN;
        this.processingChargesPerCn = proccessingCharges;
    }

    private void setLiabilityFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.consignmentLiability = (ConsignmentLiability)this.getEnumValue(attributeNameToAttributeDtoMap, "CONSIGNMENT_LIABILITY", ConsignmentLiability.class);
        if (this.consignmentLiability != null) {
            if (ConsignmentLiability.NOT_APPLICABLE.equals((Object)this.consignmentLiability)) {
                return;
            }
            switch (this.consignmentLiability) {
                case CLIENT_LIABILITY: {
                    this.maximumLiability = this.getNumberFromMap(attributeNameToAttributeDtoMap, "MAX_LIABILITY");
                    this.fovValue = (FragilityValue)this.getEnumValue(attributeNameToAttributeDtoMap, "FOV_VALUE", FragilityValue.class);
                    this.setFovFields(attributeNameToAttributeDtoMap, this.fovValue);
                    break;
                }
                case RIVIGO_LIABILITY: {
                    this.setRcsFields(attributeNameToAttributeDtoMap);
                    break;
                }
                case BOTH: {
                    this.fovValue = (FragilityValue)this.getEnumValue(attributeNameToAttributeDtoMap, "FOV_VALUE", FragilityValue.class);
                    this.setFovFields(attributeNameToAttributeDtoMap, this.fovValue);
                    this.setRcsFields(attributeNameToAttributeDtoMap);
                }
            }
        }
    }

    private void setFovFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap, FragilityValue fovValue) {
        switch (((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"FOV_CRITERIA")).get(0)).getValue()) {
            case "FOV_PERCENT": {
                this.fovChargeBasis = ChargeBasis.PERCENTAGE;
                if (FragilityValue.SAME_FOR_ALL_ITEMS.equals((Object)fovValue)) {
                    this.clientFovPercentage = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CLIENT_FOV_PERCENTAGE");
                    this.clientFovMinCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CLIENT_FOV_MINIMUM_CHARGE");
                    this.clientFovMaxCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CLIENT_FOV_MAXIMUM_CHARGE");
                }
                if (!FragilityValue.DIFFERENT_FOR_FRAGILE.equals((Object)fovValue)) break;
                this.clientFovPercentageFragile = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CLIENT_FOV_PERCENTAGE_FRAGILE");
                this.clientFovMinChargeFragile = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CLIENT_FOV_MINIMUM_CHARGE_FRAGILE");
                this.clientFovMaxChargeFragile = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CLIENT_FOV_MAXIMUM_CHARGE_FRAGILE");
                this.clientFovPercentageNonFragile = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CLIENT_FOV_PERCENTAGE_NON_FRAGILE");
                this.clientFovMinChargeNonFragile = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CLIENT_FOV_MINIMUM_CHARGE_NON_FRAGILE");
                this.clientFovMaxChargeNonFragile = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CLIENT_FOV_MAXIMUM_CHARGE_NON_FRAGILE");
                break;
            }
            case "FOV_RS_PER_CN": {
                this.fovChargeBasis = ChargeBasis.FLAT_RATE_PER_CN;
                if (FragilityValue.SAME_FOR_ALL_ITEMS.equals((Object)fovValue)) {
                    this.clientFovPerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CLIENT_FOV_RS_PER_CN");
                }
                if (!FragilityValue.DIFFERENT_FOR_FRAGILE.equals((Object)fovValue)) break;
                this.clientFovPerCnFragile = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CLIENT_FOV_RS_PER_CN_FRAGILE");
                this.clientFovPerCnNonFragile = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CLIENT_FOV_RS_PER_CN_NON_FRAGILE");
            }
        }
    }

    private void setRcsFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.rcsPercentageFragile = this.getNumberFromMap(attributeNameToAttributeDtoMap, "RCS_PERCENTAGE_FRAGILE");
        this.rcsMinChargeFragile = this.getNumberFromMap(attributeNameToAttributeDtoMap, "RCS_MINIMUM_CHARGE_FRAGILE");
        this.rcsMaxChargeFragile = this.getNumberFromMap(attributeNameToAttributeDtoMap, "RCS_MAXIMUM_CHARGE_FRAGILE");
        this.rcsPercentageNonFragile = this.getNumberFromMap(attributeNameToAttributeDtoMap, "RCS_PERCENTAGE_NON_FRAGILE");
        this.rcsMinChargeNonFragile = this.getNumberFromMap(attributeNameToAttributeDtoMap, "RCS_MINIMUM_CHARGE_NON_FRAGILE");
        this.rcsMaxChargeNonFragile = this.getNumberFromMap(attributeNameToAttributeDtoMap, "RCS_MAXIMUM_CHARGE_NON_FRAGILE");
        this.updateFromRivigoFOVAttribute(this.rcsPercentageFragile, attributeNameToAttributeDtoMap, "RIVIGO_FOV_PERCENTAGE_FRAGILE", "RIVIGO_FOV_PERCENTAGE");
        this.updateFromRivigoFOVAttribute(this.rcsMinChargeFragile, attributeNameToAttributeDtoMap, "RIVIGO_FOV_PERCENTAGE_NON_FRAGILE", "RIVIGO_FOV_PERCENTAGE");
        this.updateFromRivigoFOVAttribute(this.rcsMaxChargeFragile, attributeNameToAttributeDtoMap, "RIVIGO_FOV_MAXIMUM_CHARGE_FRAGILE", "RIVIGO_FOV_MAXIMUM_CHARGE");
        this.updateFromRivigoFOVAttribute(this.rcsPercentageNonFragile, attributeNameToAttributeDtoMap, "RIVIGO_FOV_MAXIMUM_CHARGE_NON_FRAGILE", "RIVIGO_FOV_MAXIMUM_CHARGE");
        this.updateFromRivigoFOVAttribute(this.rcsMinChargeNonFragile, attributeNameToAttributeDtoMap, "RIVIGO_FOV_MINIMUM_CHARGE_FRAGILE", "RIVIGO_FOV_MINIMUM_CHARGE");
        this.updateFromRivigoFOVAttribute(this.rcsMaxChargeNonFragile, attributeNameToAttributeDtoMap, "RIVIGO_FOV_MINIMUM_CHARGE_NON_FRAGILE", "RIVIGO_FOV_MINIMUM_CHARGE");
    }

    private void updateFromRivigoFOVAttribute(BigDecimal attributeValue, MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap, String attributeKeyFragility, String attributeKeyGeneral) {
        if (attributeValue == null && (attributeValue = this.getNumberFromMap(attributeNameToAttributeDtoMap, attributeKeyFragility)) == null) {
            attributeValue = this.getNumberFromMap(attributeNameToAttributeDtoMap, attributeKeyGeneral);
        }
    }

    private void setFscFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.fscPercentage = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FUEL_SURCHARGE_PERCENTAGE");
        switch (((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"FUEL_LINKAGE_APPLICABILITY")).get(0)).getValue()) {
            case "YES": {
                this.fuelLinkageChargeBasis = ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"FUEL_LINKAGE_CHARGE_BASIS")).get(0)).getValue());
                this.fuelLinkageCriteria = FuelLinkageCriteria.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"FUEL_LINKAGE_CRITERIA")).get(0)).getValue());
                this.fscDieselPercentChange = this.getNumberFromMap(attributeNameToAttributeDtoMap, "DIESEL_RATE_CHANGE");
                this.baseDieselRateType = BaseDieselRateType.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"BASE_DIESEL_RATE_TYPE")).get(0)).getValue());
                if (this.baseDieselRateType == BaseDieselRateType.SAME) {
                    switch (((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"DIESEL_RATE_DERIVATION")).get(0)).getValue()) {
                        case "ENTER_MANUALLY": {
                            this.baseDieselRateDerivation = BaseDieselRateDerivation.MANUAL;
                            this.dieselPrice = this.getNumberFromMap(attributeNameToAttributeDtoMap, "DIESEL_PRICE");
                            break;
                        }
                        case "SYSTEM_CALCULATED": {
                            this.baseDieselRateDerivation = BaseDieselRateDerivation.AUTOMATED;
                            this.dieselRateAsOnDate = Long.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"DIESEL_RATE_AS_ON_DATE")).get(0)).getValue());
                        }
                    }
                    this.dieselRateCities = ((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"CITIES_FOR_DIESEL_RATE")).get(0)).getValue();
                    this.dieselSource = (DieselSource)this.getEnumValue(attributeNameToAttributeDtoMap, "DIESEL_RATE_SOURCE", DieselSource.class);
                }
                this.billingDieselRateCalculationType = (BillingDieselRateCalculationType)this.getEnumValue(attributeNameToAttributeDtoMap, "BILLING_DIESEL_RATE", BillingDieselRateCalculationType.class);
                if (BillingDieselRateCalculationType.SPECIFIC_DAYS.equals((Object)this.billingDieselRateCalculationType)) {
                    this.specificPeriodDays = ((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"DAY_OF_DIESEL_BILLING_PERIOD")).get(0)).getValue();
                }
                this.dieselBillingPeriod = (DieselBillingPeriod)this.getEnumValue(attributeNameToAttributeDtoMap, "DIESEL_BILLING_PERIOD", DieselBillingPeriod.class);
                break;
            }
            case "NO": {
                this.fuelLinkageChargeBasis = ChargeBasis.NOT_APPLICABLE;
            }
        }
        this.setFscToleranceDetails(attributeNameToAttributeDtoMap);
        this.negativeFscBenefit = attributeNameToAttributeDtoMap.containsKey((Object)"FSC_BENIFIT") ? Boolean.valueOf(NegativeFscBenefit.POS_NEG.name().equals(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"FSC_BENIFIT")).get(0)).getValue())) : Boolean.valueOf(false);
        if (attributeNameToAttributeDtoMap.containsKey((Object)"BFC_CRITERIA")) {
            this.basicFreightChangeCriteria = BasicFreightChangeCriteria.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"BFC_CRITERIA")).get(0)).getValue());
            switch (this.basicFreightChangeCriteria) {
                case FLAT_RATE_PERCENT: {
                    this.fscPercentChange = this.getNumberFromMap(attributeNameToAttributeDtoMap, "BASIC_FREIGHT_CHANGE");
                    break;
                }
                case FLAT_RATE_PER_KG: {
                    this.fscPercentChange = this.getNumberFromMap(attributeNameToAttributeDtoMap, "BASIC_FREIGHT_CHANGE_RATE");
                    break;
                }
                case RATE_PERCENT_SLABS: {
                    this.fscBasicFreightChangeSlabs = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|basicFreightChangePercentSlab|FROM", "SLAB|basicFreightChangePercentSlab|TO", "SLAB|basicFreightChangePercentSlab|PERCENTAGE", null, null);
                    break;
                }
                case RATE_PER_KG_SLABS: {
                    this.fscBasicFreightChangeSlabs = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|basicFreightChangeRateSlab|FROM", "SLAB|basicFreightChangeRateSlab|TO", "SLAB|basicFreightChangeRateSlab|RATE", null, null);
                }
            }
        } else {
            this.basicFreightChangeCriteria = BasicFreightChangeCriteria.FLAT_RATE_PERCENT;
            this.fscPercentChange = this.getNumberFromMap(attributeNameToAttributeDtoMap, "BASIC_FREIGHT_CHANGE");
        }
        this.componentsForFscCharge = attributeNameToAttributeDtoMap.containsKey((Object)"FUEL_SURCHARGE_COMPONENT") ? ((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"FUEL_SURCHARGE_COMPONENT")).get(0)).getValue() : "BASIC_FREIGHT";
    }

    private void setFscToleranceDetails(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        if (attributeNameToAttributeDtoMap.containsKey((Object)"TOLERANCE_BAND")) {
            this.toleranceBand = ToleranceBand.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"TOLERANCE_BAND")).get(0)).getValue());
            if (this.toleranceBand == ToleranceBand.APPLICABLE) {
                this.toleranceType = ToleranceType.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"TOLERANCE_TYPE")).get(0)).getValue());
                this.toleranceAmount = this.getNumberFromMap(attributeNameToAttributeDtoMap, "TOLERANCE_AMOUNT");
            }
        }
    }

    private void setGreenTaxFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.greenTaxChargeBasis = ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"GREEN_TAX")).get(0)).getValue());
        switch (this.greenTaxChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.greenTaxRatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_GREEN_TAX");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.greenTaxRatePerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_GREEN_TAX");
                this.greenTaxMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "GREEN_TAX_MINIMUM_CHARGE");
                this.greenTaxMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "GREEN_TAX_MAXIMUM_CHARGE");
                break;
            }
            case RATE_PER_BOX: {
                this.greenTaxRatePerBox = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_BOX_GREEN_TAX");
                this.greenTaxMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "GREEN_TAX_MINIMUM_CHARGE_BOX");
                this.greenTaxMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "GREEN_TAX_MAXIMUM_CHARGE_BOX");
                break;
            }
            case FLAT_RATE_PER_CN_AND_KG: {
                this.greenTaxRatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_GREEN_TAX");
                this.greenTaxRatePerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_GREEN_TAX");
                this.greenTaxMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "GREEN_TAX_MINIMUM_CHARGE");
                this.greenTaxMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "GREEN_TAX_MAXIMUM_CHARGE");
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
        this.greenTaxApplicableCity = (GreenTaxApplicableCity)this.getEnumValue(attributeNameToAttributeDtoMap, "GREEN_TAX_CITY_BASIS", GreenTaxApplicableCity.class);
        this.greenTaxApplicabilityType = (PickupDeliveryActivityBasis)this.getEnumValue(attributeNameToAttributeDtoMap, "GREEN_TAX_ACTIVITY_BASIS", PickupDeliveryActivityBasis.class);
    }

    private void setAppointmentDeliveryFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.appointmentDeliveryChargeBasis = ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"APPOINTMENT_DELIVERY")).get(0)).getValue());
        switch (this.appointmentDeliveryChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.appointmentDeliveryRatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_APPOINTMENT_DELIVERY");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.appointmentDeliveryRatePerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_APPOINTMENT_DELIVERY");
                this.appointmentDeliveryMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "APPOINTMENT_DELIVERY_MINIMUM_CHARGE");
                this.appointmentDeliveryMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "APPOINTMENT_DELIVERY_MAXIMUM_CHARGE");
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
    }

    private void setSundayDeliveryFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.sundayDeliveryChargeBasis = ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"SUNDAY_DELIVERY")).get(0)).getValue());
        switch (this.sundayDeliveryChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.sundayDeliveryRatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_SUNDAY_DELIVERY");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.sundayDeliveryRatePerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_SUNDAY_DELIVERY");
                this.sundayDeliveryMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "SUNDAY_DELIVERY_MINIMUM_CHARGE");
                this.sundayDeliveryMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "SUNDAY_DELIVERY_MAXIMUM_CHARGE");
                break;
            }
            case RATE_PER_BOX: {
                this.sundayDeliveryRatePerBox = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_BOX_SUNDAY_DELIVERY");
                this.sundayDeliveryMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "SUNDAY_DELIVERY_MINIMUM_CHARGE_BOX");
                this.sundayDeliveryMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "SUNDAY_DELIVERY_MAXIMUM_CHARGE_BOX");
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
        this.sundayDeliveryApplicabilityType = (PickupDeliveryActivityBasis)this.getEnumValue(attributeNameToAttributeDtoMap, "SUNDAY_DELIVERY_ACTIVITY_BASIS", PickupDeliveryActivityBasis.class);
    }

    private void setMallDeliveryFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.mallDeliveryChargeBasis = ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"MALL_DELIVERY")).get(0)).getValue());
        switch (this.mallDeliveryChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.mallDeliveryRatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_MALL_DELIVERY");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.mallDeliveryRatePerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_MALL_DELIVERY");
                this.mallDeliveryMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "MALL_DELIVERY_MINIMUM_CHARGE");
                this.mallDeliveryMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "MALL_DELIVERY_MAXIMUM_CHARGE");
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
    }

    private void setCanteenDeliveryFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        if (!attributeNameToAttributeDtoMap.containsKey((Object)"CANTEEN_DELIVERY")) {
            return;
        }
        this.canteenDeliveryChargeBasis = ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"CANTEEN_DELIVERY")).get(0)).getValue());
        switch (this.canteenDeliveryChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.canteenDeliveryRatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_CANTEEN_DELIVERY");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.canteenDeliveryRatePerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_CANTEEN_DELIVERY");
                this.canteenDeliveryMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CANTEEN_DELIVERY_MINIMUM_CHARGE");
                this.canteenDeliveryMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "CANTEEN_DELIVERY_MAXIMUM_CHARGE");
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
    }

    private void setDedicatedVehicle(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        if (!attributeNameToAttributeDtoMap.containsKey((Object)"DEDICATED_VEHICLE")) {
            this.dedicatedVehicleChargeBasis = ChargeBasis.NOT_APPLICABLE;
            return;
        }
        this.dedicatedVehicleChargeBasis = (ChargeBasis)this.getEnumValue(attributeNameToAttributeDtoMap, "DEDICATED_VEHICLE", ChargeBasis.class);
        this.dedicatedVehicleActivityBasis = (PickupDeliveryActivityBasis)this.getEnumValue(attributeNameToAttributeDtoMap, "DEDICATED_VEHICLE_ACTIVITY_BASIS", PickupDeliveryActivityBasis.class);
        switch (this.dedicatedVehicleChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.dedicatedVehicleChargePerUnit = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_DEDICATED_VEHICLE");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.dedicatedVehicleChargePerUnit = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_DEDICATED_VEHICLE");
                this.dedicatedVehicleMinCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "DEDICATED_VEHICLE_MINIMUM_CHARGE");
                this.dedicatedVehicleMaxCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "DEDICATED_VEHICLE_MAXIMUM_CHARGE");
                break;
            }
            case RATE_PER_BOX: {
                this.dedicatedVehicleChargePerUnit = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_BOX_DEDICATED_VEHICLE");
                this.dedicatedVehicleMinCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "DEDICATED_VEHICLE_MINIMUM_CHARGE");
                this.dedicatedVehicleMaxCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "DEDICATED_VEHICLE_MAXIMUM_CHARGE");
                break;
            }
            case NOT_APPLICABLE: 
            case ACTUAL: {
                break;
            }
            default: {
                throw new ZoomBillingException(String.format("Invalid Dedicated Vehivle Applicability Found: %s", this.dedicatedVehicleChargeBasis.getStr()));
            }
        }
    }

    private void setMHECharge(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        if (!attributeNameToAttributeDtoMap.containsKey((Object)"MATERIAL_HANDLING_EQUIPMENT")) {
            this.materialHandlingEquipmentChargeBasis = ChargeBasis.NOT_APPLICABLE;
            return;
        }
        this.materialHandlingEquipmentChargeBasis = (ChargeBasis)this.getEnumValue(attributeNameToAttributeDtoMap, "MATERIAL_HANDLING_EQUIPMENT", ChargeBasis.class);
        this.materialHandlingEquipmentActivityBasis = (PickupDeliveryActivityBasis)this.getEnumValue(attributeNameToAttributeDtoMap, "MATERIAL_HANDLING_EQUIPMENT_ACTIVITY_BASIS", PickupDeliveryActivityBasis.class);
        switch (this.materialHandlingEquipmentChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.materialHandlingEquipmentChargePerUnit = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_MATERIAL_HANDLING_EQUIPMENT");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.materialHandlingEquipmentChargePerUnit = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_MATERIAL_HANDLING_EQUIPMENT");
                this.materialHandlingEquipmentMinCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "MATERIAL_HANDLING_EQUIPMENT_MINIMUM_CHARGE");
                this.materialHandlingEquipmentMaxCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "MATERIAL_HANDLING_EQUIPMENT_MAXIMUM_CHARGE");
                break;
            }
            case RATE_PER_BOX: {
                this.materialHandlingEquipmentChargePerUnit = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_BOX_MATERIAL_HANDLING_EQUIPMENT");
                this.materialHandlingEquipmentMinCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "MATERIAL_HANDLING_EQUIPMENT_MINIMUM_CHARGE");
                this.materialHandlingEquipmentMaxCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "MATERIAL_HANDLING_EQUIPMENT_MAXIMUM_CHARGE");
                break;
            }
            case NOT_APPLICABLE: 
            case ACTUAL: {
                break;
            }
            default: {
                throw new ZoomBillingException(String.format("Invalid Material Handling Equipment Applicability Found: %s", this.materialHandlingEquipmentChargeBasis.getStr()));
            }
        }
    }

    private void setUWMChargeFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        if (!attributeNameToAttributeDtoMap.containsKey((Object)"UNION_WARAI_MATHADI")) {
            this.unionWaraiMathadiChargeBasis = ChargeBasis.NOT_APPLICABLE;
            return;
        }
        this.unionWaraiMathadiChargeBasis = (ChargeBasis)this.getEnumValue(attributeNameToAttributeDtoMap, "UNION_WARAI_MATHADI", ChargeBasis.class);
        this.unionWaraiMathadiActivityBasis = (PickupDeliveryActivityBasis)this.getEnumValue(attributeNameToAttributeDtoMap, "UNION_WARAI_MATHADI_ACTIVITY_BASIS", PickupDeliveryActivityBasis.class);
        switch (this.unionWaraiMathadiChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.unionWaraiMathadiChargePerUnit = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_UNION_WARAI_MATHADI");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.unionWaraiMathadiChargePerUnit = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_UNION_WARAI_MATHADI");
                this.unionWaraiMathadiMinCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "UNION_WARAI_MATHADI_MINIMUM_CHARGE");
                this.unionWaraiMathadiMaxCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "UNION_WARAI_MATHADI_MAXIMUM_CHARGE");
                break;
            }
            case RATE_PER_BOX: {
                this.unionWaraiMathadiChargePerUnit = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_BOX_UNION_WARAI_MATHADI");
                this.unionWaraiMathadiMinCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "UNION_WARAI_MATHADI_MINIMUM_CHARGE");
                this.unionWaraiMathadiMaxCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "UNION_WARAI_MATHADI_MAXIMUM_CHARGE");
                break;
            }
            case NOT_APPLICABLE: 
            case ACTUAL: {
                break;
            }
            default: {
                throw new ZoomBillingException(String.format("Invalid Union Warai Mathadi Applicability Found: %s", this.unionWaraiMathadiChargeBasis.getStr()));
            }
        }
    }

    private void setRailwayDeliveryFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        if (!attributeNameToAttributeDtoMap.containsKey((Object)"RAILWAY_DELIVERY")) {
            return;
        }
        this.railwayDeliveryChargeBasis = ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"RAILWAY_DELIVERY")).get(0)).getValue());
        switch (this.railwayDeliveryChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.railwayDeliveryRatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_RAILWAY_DELIVERY");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.railwayDeliveryRatePerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_RAILWAY_DELIVERY");
                this.railwayDeliveryMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "RAILWAY_DELIVERY_MINIMUM_CHARGE");
                this.railwayDeliveryMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "RAILWAY_DELIVERY_MAXIMUM_CHARGE");
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
    }

    private void setSezDeliveryFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        if (!attributeNameToAttributeDtoMap.containsKey((Object)"SEZ_DELIVERY")) {
            return;
        }
        this.sezDeliveryChargeBasis = ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"SEZ_DELIVERY")).get(0)).getValue());
        switch (this.sezDeliveryChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.sezDeliveryRatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_SEZ_DELIVERY");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.sezDeliveryRatePerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_SEZ_DELIVERY");
                this.sezDeliveryMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "SEZ_DELIVERY_MINIMUM_CHARGE");
                this.sezDeliveryMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "SEZ_DELIVERY_MAXIMUM_CHARGE");
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
    }

    private void setGovernmentCompoundDeliveryFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        if (!attributeNameToAttributeDtoMap.containsKey((Object)"GOVERNMENT_COMPOUND_DELIVERY")) {
            return;
        }
        this.governmentCompoundDeliveryChargeBasis = ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"GOVERNMENT_COMPOUND_DELIVERY")).get(0)).getValue());
        switch (this.governmentCompoundDeliveryChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.governmentCompoundDeliveryRatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_GOVERNMENT_COMPOUND_DELIVERY");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.governmentCompoundDeliveryRatePerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_GOVERNMENT_COMPOUND_DELIVERY");
                this.governmentCompoundDeliveryMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "GOVERNMENT_COMPOUND_DELIVERY_MINIMUM_CHARGE");
                this.governmentCompoundDeliveryMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "GOVERNMENT_COMPOUND_DELIVERY_MAXIMUM_CHARGE");
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
    }

    private void setDeliveryReattemptChargesFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.deliveryReattemptChargeBasis = ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"DELIVERY_REATTEMPT")).get(0)).getValue());
        switch (this.deliveryReattemptChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.deliveryReattemptRatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_DELIVERY_REATTEMPT");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.deliveryReattemptRatePerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_DELIVERY_REATTEMPT");
                this.deliveryReattemptMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "DELIVERY_REATTEMPT_MINIMUM_CHARGE");
                this.deliveryReattemptMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "DELIVERY_REATTEMPT_MAXIMUM_CHARGE");
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
        this.deliveryReattemptIsPerAttempt = Optional.ofNullable(attributeNameToAttributeDtoMap.getFirst((Object)"DELIVERY_REATTEMPT_IS_PER_ATTEMPT")).map(ClientContractAttributeDTO::getValue).orElse(null);
    }

    private void setDaccChargesFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.daccChargeBasis = ChargeBasis.valueOf(this.getFieldFromMap(attributeNameToAttributeDtoMap, "DACC").orElse("NOT_APPLICABLE"));
        switch (this.daccChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.daccRatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_DACC");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.daccRatePerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_DACC");
                this.daccMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "DACC_MINIMUM_CHARGE");
                this.daccMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "DACC_MAXIMUM_CHARGE");
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
    }

    private void setLiquidHandlingFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        if (!attributeNameToAttributeDtoMap.containsKey((Object)"LIQUID_HANDLING")) {
            return;
        }
        this.liquidHandlingChargeBasis = ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"LIQUID_HANDLING")).get(0)).getValue());
        switch (this.liquidHandlingChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.liquidHandlingRatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_LIQUID_HANDLING");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.liquidHandlingRatePerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_LIQUID_HANDLING");
                this.liquidHandlingMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "LIQUID_HANDLING_MINIMUM_CHARGE");
                this.liquidHandlingMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "LIQUID_HANDLING_MAXIMUM_CHARGE");
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
    }

    private void setHazardousHandlingFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        if (!attributeNameToAttributeDtoMap.containsKey((Object)"HAZARDOUS_MATERIAL_HANDLING")) {
            return;
        }
        this.hazardousHandlingChargeBasis = ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"HAZARDOUS_MATERIAL_HANDLING")).get(0)).getValue());
        switch (this.hazardousHandlingChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.hazardousHandlingRatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_HAZARDOUS_MATERIAL_HANDLING");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.hazardousHandlingRatePerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_HAZARDOUS_MATERIAL_HANDLING");
                this.hazardousHandlingMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "HAZARDOUS_MATERIAL_HANDLING_MINIMUM_CHARGE");
                this.hazardousHandlingMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "HAZARDOUS_MATERIAL_HANDLING_MAXIMUM_CHARGE");
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
    }

    private void setHandlingChargesFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.handlingChargesChargeBasis = ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"HANDLING_CHARGES")).get(0)).getValue());
        switch (this.handlingChargesChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.handlingChargesRatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_HANDLING_CHARGES");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.handlingChargesRatePerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_HANDLING_CHARGES");
                this.handlingChargesMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "HANDLING_CHARGES_MINIMUM_CHARGE");
                this.handlingChargesMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "HANDLING_CHARGES_MAXIMUM_CHARGE");
                this.handlingChargeWeightType = WeightType.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"HANDLING_CHARGE_WEIGHT_TYPE")).get(0)).getValue());
                break;
            }
            case RATE_PER_BOX: {
                this.handlingChargesRatePerBox = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_BOX_HANDLING_CHARGES");
                this.handlingChargesMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "HANDLING_CHARGES_MINIMUM_CHARGE_BOX");
                this.handlingChargesMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "HANDLING_CHARGES_MAXIMUM_CHARGE_BOX");
                break;
            }
            case RATE_PER_KG_PER_BOX_SLABS: {
                this.handlingChargesRatePerKgPerBoxSlabs = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|RATE_PER_KG_PER_BOX_SLAB_HANDLING_CHARGES|FROM", "SLAB|RATE_PER_KG_PER_BOX_SLAB_HANDLING_CHARGES|TO", "SLAB|RATE_PER_KG_PER_BOX_SLAB_HANDLING_CHARGES|RATE", "SLAB|RATE_PER_KG_PER_BOX_SLAB_HANDLING_CHARGES|MIN", "SLAB|RATE_PER_KG_PER_BOX_SLAB_HANDLING_CHARGES|MAX");
                this.handlingChargeWeightType = WeightType.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"HANDLING_CHARGE_WEIGHT_TYPE")).get(0)).getValue());
                break;
            }
            case RATE_PER_BOX_SLABS: {
                this.handlingChargesRatePerBoxSlabs = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|RATE_PER_BOX_HANDLING_CHARGES|FROM", "SLAB|RATE_PER_BOX_HANDLING_CHARGES|TO", "SLAB|RATE_PER_BOX_HANDLING_CHARGES|RATE", "SLAB|RATE_PER_BOX_HANDLING_CHARGES|MIN", "SLAB|RATE_PER_BOX_HANDLING_CHARGES|MAX");
                break;
            }
            case RATE_PER_KG_SLABS: {
                this.handlingChargesRatePerKgSlabs = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|RATE_PER_KG_SLAB_HANDLING_CHARGES|FROM", "SLAB|RATE_PER_KG_SLAB_HANDLING_CHARGES|TO", "SLAB|RATE_PER_KG_SLAB_HANDLING_CHARGES|RATE", "SLAB|RATE_PER_KG_SLAB_HANDLING_CHARGES|MIN", "SLAB|RATE_PER_KG_SLAB_HANDLING_CHARGES|MAX");
                this.handlingChargeWeightType = WeightType.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"HANDLING_CHARGE_WEIGHT_TYPE")).get(0)).getValue());
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
    }

    private ClientContractAttributeDTO buildAttributeByValue(String value) {
        return ClientContractAttributeDTO.builder().value("NOT_APPLICABLE").build();
    }

    private void setOdcHandlingCharges(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.odcHandlingChargesChargeBasis = ChargeBasis.valueOf(Optional.ofNullable(attributeNameToAttributeDtoMap.getFirst((Object)"ODC_HANDLING_CHARGES")).orElseGet(() -> this.buildAttributeByValue("NOT_APPLICABLE")).getValue());
        switch (this.odcHandlingChargesChargeBasis) {
            case FLAT_RATE_PER_KG: {
                this.odcHandlingChargesRatePerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_ODC_HANDLING_CHARGES");
                break;
            }
            case RATE_PER_BOX: {
                this.odcHandlingChargesRatePerBox = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_BOX_ODC_HANDLING_CHARGES");
                break;
            }
            default: {
                return;
            }
        }
        this.odcHandlingChargesMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "ODC_HANDLING_CHARGES_MINIMUM_CHARGE");
        this.odcHandlingChargesMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "ODC_HANDLING_CHARGES_MAXIMUM_CHARGE");
    }

    private void setValueHandlingCharges(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.valueHandlingChargesChargeBasis = ChargeBasis.valueOf(Optional.ofNullable(attributeNameToAttributeDtoMap.getFirst((Object)"VALUE_HANDLING_CHARGES")).orElseGet(() -> this.buildAttributeByValue("NOT_APPLICABLE")).getValue());
        switch (this.valueHandlingChargesChargeBasis) {
            case PERCENTAGE: {
                this.valueHandlingChargesCustomerInvoicePercentage = this.getNumberFromMap(attributeNameToAttributeDtoMap, "VALUE_HANDLING_CHARGES_PERCENTAGE_INVOICE_VALUE");
                this.valueHandlingChargesRatePerKgCutoff = this.getNumberFromMap(attributeNameToAttributeDtoMap, "VALUE_HANDLING_CHARGES_CUT_OFF_VALUE_PER_KG");
                break;
            }
            default: {
                return;
            }
        }
        this.valueHandlingChargesMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "VALUE_HANDLING_CHARGES_MAXIMUM_CHARGE");
        this.valueHandlingChargesMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "VALUE_HANDLING_CHARGES_MINIMUM_CHARGE");
    }

    private void setHigherFloorDeliveryFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.higherFloorDeliveryChargeBasis = ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"HIGHER_FLOOR_DELIVERY")).get(0)).getValue());
        switch (this.higherFloorDeliveryChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.higherFloorDeliveryRatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_HIGHER_FLOOR_DELIVERY");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.higherFloorDeliveryRatePerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_HIGHER_FLOOR_DELIVERY");
                this.higherFloorDeliveryMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "HIGHER_FLOOR_DELIVERY_MINIMUM_CHARGE");
                this.higherFloorDeliveryMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "HIGHER_FLOOR_DELIVERY_MAXIMUM_CHARGE");
                break;
            }
            case RATE_PER_BOX: {
                this.higherFloorDeliveryRatePerBox = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_BOX_HIGHER_FLOOR_DELIVERY");
                this.higherFloorDeliveryMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "HIGHER_FLOOR_DELIVERY_MINIMUM_CHARGE_BOX");
                this.higherFloorDeliveryMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "HIGHER_FLOOR_DELIVERY_MAXIMUM_CHARGE_BOX");
                break;
            }
            case RATE_PER_KG_SLABS: {
                this.higherFloorDeliveryRatePerKgSlabs = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|RATE_PER_KG_SLAB_HIGHER_FLOOR_DELIVERY|FROM", "SLAB|RATE_PER_KG_SLAB_HIGHER_FLOOR_DELIVERY|TO", "SLAB|RATE_PER_KG_SLAB_HIGHER_FLOOR_DELIVERY|RATE", "SLAB|RATE_PER_KG_SLAB_HIGHER_FLOOR_DELIVERY|MIN", "SLAB|RATE_PER_KG_SLAB_HIGHER_FLOOR_DELIVERY|MAX");
                break;
            }
            case RATE_PER_BOX_SLABS: {
                this.higherFloorDeliveryRatePerBoxSlabs = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|RATE_PER_BOX_HIGHER_FLOOR_DELIVERY|FROM", "SLAB|RATE_PER_BOX_HIGHER_FLOOR_DELIVERY|TO", "SLAB|RATE_PER_BOX_HIGHER_FLOOR_DELIVERY|RATE", "SLAB|RATE_PER_BOX_HIGHER_FLOOR_DELIVERY|MIN", "SLAB|RATE_PER_BOX_HIGHER_FLOOR_DELIVERY|MAX");
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
        this.higherFloorChargesIsPerFloor = Optional.ofNullable(attributeNameToAttributeDtoMap.getFirst((Object)"HIGHER_FLOOR_DELIVERY_IS_PER_FLOOR")).map(ClientContractAttributeDTO::getValue).orElse(null);
        this.higherFloorActivityBasis = PickupDeliveryActivityBasis.valueOf(Optional.ofNullable(attributeNameToAttributeDtoMap.getFirst((Object)"HIGHER_FLOOR_DELIVERY_ACTIVITY_BASIS")).map(ClientContractAttributeDTO::getValue).orElse(PickupDeliveryActivityBasis.ONLY_DELIVERY.name()));
        this.higherFloorExclusionFloors = Optional.ofNullable(attributeNameToAttributeDtoMap.getFirst((Object)"HIGHER_FLOOR_DELIVERY_EXCLUSION_FLOORS")).map(att -> Integer.parseInt(att.getValue())).orElse(0);
    }

    private void setFodFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.fodChargeBasis = ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"FOD")).get(0)).getValue());
        switch (this.fodChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.fodPerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_FOD");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.fodPerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_FOD");
                this.fodMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FOD_MINIMUM_CHARGE");
                this.fodMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FOD_MAXIMUM_CHARGE");
                break;
            }
            case FLAT_RATE_PER_CN_AND_KG: {
                this.fodPerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_FOD");
                this.fodPerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_FOD");
                this.fodMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FOD_MINIMUM_CHARGE");
                this.fodMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FOD_MAXIMUM_CHARGE");
                break;
            }
            case RATE_PER_BOX: {
                this.fodPerBox = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_BOX_FOD");
                this.fodMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FOD_MINIMUM_CHARGE_BOX");
                this.fodMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FOD_MAXIMUM_CHARGE_BOX");
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
    }

    private void setMetroCongestionFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.metroCongestionChargeBasis = attributeNameToAttributeDtoMap.getFirst((Object)"METRO_CONGESTION") != null ? ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"METRO_CONGESTION")).get(0)).getValue()) : ChargeBasis.NOT_APPLICABLE;
        switch (this.metroCongestionChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.metroCongestionPerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_METRO_CONGESTION");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.metroCongestionPerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_METRO_CONGESTION");
                this.metroCongestionMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "METRO_CONGESTION_MINIMUM_CHARGE");
                this.metroCongestionMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "METRO_CONGESTION_MAXIMUM_CHARGE");
                break;
            }
            case FLAT_RATE_PER_CN_AND_KG: {
                this.metroCongestionPerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_METRO_CONGESTION");
                this.metroCongestionPerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_METRO_CONGESTION");
                this.metroCongestionMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "METRO_CONGESTION_MINIMUM_CHARGE");
                this.metroCongestionMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "METRO_CONGESTION_MAXIMUM_CHARGE");
                break;
            }
            case RATE_PER_BOX: {
                this.metroCongestionPerBox = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_BOX_METRO_CONGESTION");
                this.metroCongestionMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "METRO_CONGESTION_MINIMUM_CHARGE_BOX");
                this.metroCongestionMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "METRO_CONGESTION_MAXIMUM_CHARGE_BOX");
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
    }

    private void setHardRegionFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.hardRegionChargeBasis = attributeNameToAttributeDtoMap.containsKey((Object)"HARD_REGION_VAYU_CHARGE") ? ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"HARD_REGION_VAYU_CHARGE")).get(0)).getValue()) : ChargeBasis.NOT_APPLICABLE;
        switch (this.hardRegionChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.hardRegionPerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_HARD_REGION_VAYU");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.hardRegionPerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_HARD_REGION_VAYU");
                this.hardRegionMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "HARD_REGION_VAYU_MINIMUM_CHARGE");
                this.hardRegionMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "HARD_REGION_VAYU_MAXIMUM_CHARGE");
                break;
            }
            case FLAT_RATE_PER_CN_AND_KG: {
                this.hardRegionPerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_HARD_REGION_VAYU");
                this.hardRegionPerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_HARD_REGION_VAYU");
                this.hardRegionMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "HARD_REGION_VAYU_MINIMUM_CHARGE");
                this.hardRegionMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "HARD_REGION_VAYU_MAXIMUM_CHARGE");
                break;
            }
            case RATE_PER_BOX: {
                this.hardRegionPerBox = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_BOX_HARD_REGION_VAYU");
                this.hardRegionMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_BOX_MIN_HARD_REGION_VAYU");
                this.hardRegionMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_BOX_MAX_HARD_REGION_VAYU");
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
    }

    private void setSpecialZoneFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.specialZoneChargeBasis = attributeNameToAttributeDtoMap.getFirst((Object)"SPECIAL_ZONE_CHARGE") != null ? ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"SPECIAL_ZONE_CHARGE")).get(0)).getValue()) : ChargeBasis.NOT_APPLICABLE;
        switch (this.specialZoneChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.specialZonePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_SPECIAL_ZONE");
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.specialZonePerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_SPECIAL_ZONE");
                this.specialZoneMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "SPECIAL_ZONE_MINIMUM_CHARGE");
                this.specialZoneMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "SPECIAL_ZONE_MAXIMUM_CHARGE");
                break;
            }
            case FLAT_RATE_PER_CN_AND_KG: {
                this.specialZonePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_SPECIAL_ZONE");
                this.specialZonePerKg = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_KG_SPECIAL_ZONE");
                this.specialZoneMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "SPECIAL_ZONE_MINIMUM_CHARGE");
                this.specialZoneMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "SPECIAL_ZONE_MAXIMUM_CHARGE");
                break;
            }
            case RATE_PER_BOX: {
                this.specialZonePerBox = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_BOX_SPECIAL_ZONE");
                this.specialZoneMinimumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "SPECIAL_ZONE_MINIMUM_CHARGE_BOX");
                this.specialZoneMaximumCharge = this.getNumberFromMap(attributeNameToAttributeDtoMap, "SPECIAL_ZONE_MAXIMUM_CHARGE_BOX");
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
    }

    private void setInfrastructureDevelopmentFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.infrastructureDevelopmentChargeBasis = attributeNameToAttributeDtoMap.getFirst((Object)"INFRASTRUCTURE_DEVELOPMENT_CHARGE") != null ? ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"INFRASTRUCTURE_DEVELOPMENT_CHARGE")).get(0)).getValue()) : ChargeBasis.NOT_APPLICABLE;
        switch (this.infrastructureDevelopmentChargeBasis) {
            case PERCENTAGE: {
                this.infrastructureDevelopmentRatePerChargeBasis = this.getNumberFromMap(attributeNameToAttributeDtoMap, "INFRASTRUCTURE_DEVELOPMENT_RATE_PER_CHARGE_BASIS");
                this.infrastructureDevelopmentChargeComponent = ((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"INFRASTRUCTURE_CHARGE_COMPONENT")).get(0)).getValue();
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
    }

    private void setBDSurchargeFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.bdSurchargeChargeBasis = Optional.ofNullable(attributeNameToAttributeDtoMap.getFirst((Object)"BUSINESS_DEVELOPMENT_SURCHARGE")).map(ClientContractAttributeDTO::getValue).map(ChargeBasis::valueOf).orElse(ChargeBasis.NOT_APPLICABLE);
        switch (this.bdSurchargeChargeBasis) {
            case PERCENTAGE: {
                this.bdSurchargePercentageFreight = this.getNumberFromMap(attributeNameToAttributeDtoMap, "BUSINESS_DEVELOPMENT_RATE_PER_CHARGE_BASIS");
                break;
            }
        }
    }

    private void setCodDodFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        switch (((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"COD_DOD")).get(0)).getValue()) {
            case "FLAT_RATE_PER_CN": {
                this.codDodChargeBasis = ChargeBasis.FLAT_RATE_PER_CN;
                this.codDodPerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_COD_DOD");
                break;
            }
            case "PERCENTAGE_FREIGHT": {
                this.codDodChargeBasis = ChargeBasis.PERCENTAGE;
                this.codDodPercentageFreight = this.getNumberFromMap(attributeNameToAttributeDtoMap, "PERCENTAGE_FREIGHT_COD_DOD");
                break;
            }
            case "HIGHER_OF_TWO": {
                this.codDodChargeBasis = ChargeBasis.HIGHER_OF_TWO;
                this.codDodPerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_COD_DOD");
                this.codDodPercentageFreight = this.getNumberFromMap(attributeNameToAttributeDtoMap, "PERCENTAGE_FREIGHT_COD_DOD");
                break;
            }
            case "NOT_APPLICABLE": {
                this.codDodChargeBasis = ChargeBasis.NOT_APPLICABLE;
                return;
            }
        }
        this.codDodMin = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_MIN");
        this.codDodMax = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_MAX");
        this.clientAccountNumber = attributeNameToAttributeDtoMap.containsKey((Object)"COD_DOD_CLIENT_ACCOUNT_NUMBER") ? ((ClientContractAttributeDTO)attributeNameToAttributeDtoMap.getFirst((Object)"COD_DOD_CLIENT_ACCOUNT_NUMBER")).getValue() : null;
        this.codDodCreditCardChargeMin = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_CREDIT_CARD_PERCENTAGE_MIN");
        this.codDodDebitCardChargeMin = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_DEBIT_CARD_PERCENTAGE_MIN");
        this.codDodNetbankingChargeMin = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_NETBANKING_PERCENTAGE_MIN");
        this.codDodNeftChargeMin = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_NEFT_PERCENTAGE_MIN");
        this.codDodRtgsChargeMin = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_RTGS_PERCENTAGE_MIN");
        this.codDodImpsChargeMin = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_IMPS_PERCENTAGE_MIN");
        this.codDodUpiChargeMin = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_UPI_PERCENTAGE_MIN");
        this.codDodCreditCardPercentage = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_CREDIT_CARD_PERCENTAGE");
        this.codDodDebitCardPercentage = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_DEBIT_CARD_PERCENTAGE");
        this.codDodNetbankingPercentage = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_NETBANKING_PERCENTAGE");
        this.codDodNeftPercentage = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_NEFT_PERCENTAGE");
        this.codDodRtgsPercentage = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_RTGS_PERCENTAGE");
        this.codDodImpsPercentage = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_IMPS_PERCENTAGE");
        this.codDodUpiPercentage = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_UPI_PERCENTAGE");
        this.codDodCreditCardChargeMax = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_CREDIT_CARD_PERCENTAGE_MAX");
        this.codDodDebitCardChargeMax = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_DEBIT_CARD_PERCENTAGE_MAX");
        this.codDodNetbankingChargeMax = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_NETBANKING_PERCENTAGE_MAX");
        this.codDodNeftChargeMax = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_NEFT_PERCENTAGE_MAX");
        this.codDodRtgsChargeMax = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_RTGS_PERCENTAGE_MAX");
        this.codDodImpsChargeMax = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_IMPS_PERCENTAGE_MAX");
        this.codDodUpiChargeMax = this.getNumberFromMap(attributeNameToAttributeDtoMap, "COD_DOD_UPI_PERCENTAGE_MAX");
        this.setCodDodExceptionalCharge(attributeNameToAttributeDtoMap);
    }

    private void setCodDodExceptionalCharge(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.codDodModeVsExceptionalCharge = new HashMap<CodDodOnlinePaymentMode, List<CodDodExceptionalCharge>>();
        List<ClientContractAttributeDTO> paymentModes = this.getAttributeList(attributeNameToAttributeDtoMap, ContractAttributeConstants.ONLINE_COD_EXCEPTION_FIELDS);
        if (CollectionUtils.isEmpty(paymentModes)) {
            return;
        }
        for (ClientContractAttributeDTO attributeDTO : paymentModes) {
            if (!Boolean.TRUE.equals(Boolean.valueOf(attributeDTO.getValue()))) continue;
            this.createOnlineCodExceptionTypeFields(attributeDTO, this.getAttributeList(attributeNameToAttributeDtoMap, this.getAllKeysForException(attributeDTO.getName())));
        }
    }

    private void createOnlineCodExceptionTypeFields(ClientContractAttributeDTO paymentMode, List<ClientContractAttributeDTO> attributeDTOS) {
        ArrayList<CodDodExceptionalCharge> charges = new ArrayList<CodDodExceptionalCharge>();
        HashMap sequenceVsAttributes = new HashMap();
        attributeDTOS.forEach(dto -> sequenceVsAttributes.computeIfAbsent(this.normalizedSequence((ClientContractAttributeDTO)dto), key -> new ArrayList()).add(dto));
        for (Map.Entry entry : sequenceVsAttributes.entrySet()) {
            CodDodExceptionalCharge charge = new CodDodExceptionalCharge();
            HashMap<Integer, SlabDTO> sequenceVsSlab = new HashMap<Integer, SlabDTO>();
            for (ClientContractAttributeDTO dto2 : (List)entry.getValue()) {
                switch (this.normalize(dto2.getName())) {
                    case "BANK_NAME": {
                        charge.setBankNames(Arrays.asList(dto2.getValue().split(",")));
                        break;
                    }
                    case "CHARGE": {
                        charge.setChargePercent(this.convertStringToBigDecimal(dto2.getValue()));
                        break;
                    }
                    case "MINIMUM_CHARGE": {
                        charge.setMinCharge(this.convertStringToBigDecimal(dto2.getValue()));
                        break;
                    }
                    case "MAXIMUM_CHARGE": {
                        charge.setMaxCharge(this.convertStringToBigDecimal(dto2.getValue()));
                        break;
                    }
                    case "exceptionType": {
                        charge.setExceptionType(CodDodExceptionalType.valueOf(dto2.getValue()));
                        break;
                    }
                    case "FROM": {
                        sequenceVsSlab.computeIfAbsent(dto2.getSequence(), key -> new SlabDTO()).setFrom(this.convertStringToBigDecimal(dto2.getValue()));
                        break;
                    }
                    case "TO": {
                        sequenceVsSlab.computeIfAbsent(dto2.getSequence(), key -> new SlabDTO()).setTo(this.convertStringToBigDecimal(dto2.getValue()));
                        break;
                    }
                    case "PERCENT": {
                        sequenceVsSlab.computeIfAbsent(dto2.getSequence(), key -> new SlabDTO()).setValue(this.convertStringToBigDecimal(dto2.getValue()));
                        break;
                    }
                    case "MIN": {
                        sequenceVsSlab.computeIfAbsent(dto2.getSequence(), key -> new SlabDTO()).setMinimum(this.convertStringToBigDecimal(dto2.getValue()));
                        break;
                    }
                    case "MAX": {
                        sequenceVsSlab.computeIfAbsent(dto2.getSequence(), key -> new SlabDTO()).setMaximum(this.convertStringToBigDecimal(dto2.getValue()));
                    }
                }
            }
            charge.setSlabDTOS(new ArrayList<SlabDTO>(sequenceVsSlab.values()));
            charges.add(charge);
        }
        this.codDodModeVsExceptionalCharge.put(CodDodOnlinePaymentMode.getModeByExceptionKey(paymentMode.getName()), charges);
    }

    private Integer normalizedSequence(ClientContractAttributeDTO dto) {
        Integer sequence = dto.getSequence();
        if (ContractAttributeConstants.ONLINE_COD_SLAB_FIELDS.contains(dto.getName().substring(dto.getName().lastIndexOf("|") + 1))) {
            sequence = dto.getSequence() / 1000;
        }
        return sequence;
    }

    private String normalize(String name) {
        return name.substring(name.lastIndexOf("|") + 1);
    }

    private List<String> getAllKeysForException(String key) {
        ArrayList<String> keys = new ArrayList<String>();
        for (String field : ContractAttributeConstants.ONLINE_COD_ARRAY_FIELDS) {
            keys.add(String.format("DOUBLE_SLAB|%s_SLAB|%s", key, field));
        }
        for (String field : ContractAttributeConstants.ONLINE_COD_SLAB_FIELDS) {
            keys.add(String.format("DOUBLE_SLAB|%s_SLAB|SLAB|COD_EXC_AMOUNT_SLAB|%s", key, field));
        }
        return keys;
    }

    private void setHardCopyPodFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.hardCopyPodChargeBasis = ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"HARD_COPY_OF_POD")).get(0)).getValue());
        switch (this.hardCopyPodChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.hardCopyPodPerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_HARD_COPY_OF_POD");
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
    }

    private void setOdaFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.odaChargeBasis = ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"ODA")).get(0)).getValue());
        ODAType oDAType = this.odaType = attributeNameToAttributeDtoMap.get((Object)"ODA_TYPE") != null ? ODAType.valueOf((String)((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"ODA_TYPE")).get(0)).getValue()) : null;
        if (ChargeBasis.NOT_APPLICABLE.equals((Object)this.odaChargeBasis)) {
            return;
        }
        switch (((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"ODA_EXEMPTION")).get(0)).getValue()) {
            case "APPLICABLE": {
                this.odaExemptionApplicability = true;
                this.odaExemptedPincodes = ((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"ODA_EXEMPTED_PINCODES")).get(0)).getValue();
                break;
            }
            case "NOT_APPLICABLE": {
                this.odaExemptionApplicability = false;
            }
        }
        switch (this.odaChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.oda1RatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_ODA_1");
                this.oda2RatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_ODA_2");
                this.oda3RatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_ODA_3");
                this.oda4RatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_ODA_4");
                this.oda5RatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_ODA_5");
                this.oda6RatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_ODA_6");
                this.oda7RatePerCn = this.getNumberFromMap(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_ODA_7");
                break;
            }
            case RATE_PER_KG_SLABS: {
                this.oda1RatePerKgSlabs = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|RATE_PER_KG_SLAB_ODA_1|FROM", "SLAB|RATE_PER_KG_SLAB_ODA_1|TO", "SLAB|RATE_PER_KG_SLAB_ODA_1|RATE", "SLAB|RATE_PER_KG_SLAB_ODA_1|MIN", "SLAB|RATE_PER_KG_SLAB_ODA_1|MAX");
                this.oda2RatePerKgSlabs = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|RATE_PER_KG_SLAB_ODA_2|FROM", "SLAB|RATE_PER_KG_SLAB_ODA_2|TO", "SLAB|RATE_PER_KG_SLAB_ODA_2|RATE", "SLAB|RATE_PER_KG_SLAB_ODA_2|MIN", "SLAB|RATE_PER_KG_SLAB_ODA_2|MAX");
                this.oda3RatePerKgSlabs = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|RATE_PER_KG_SLAB_ODA_3|FROM", "SLAB|RATE_PER_KG_SLAB_ODA_3|TO", "SLAB|RATE_PER_KG_SLAB_ODA_3|RATE", "SLAB|RATE_PER_KG_SLAB_ODA_3|MIN", "SLAB|RATE_PER_KG_SLAB_ODA_3|MAX");
                this.oda4RatePerKgSlabs = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|RATE_PER_KG_SLAB_ODA_4|FROM", "SLAB|RATE_PER_KG_SLAB_ODA_4|TO", "SLAB|RATE_PER_KG_SLAB_ODA_4|RATE", "SLAB|RATE_PER_KG_SLAB_ODA_4|MIN", "SLAB|RATE_PER_KG_SLAB_ODA_4|MAX");
                this.oda5RatePerKgSlabs = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|RATE_PER_KG_SLAB_ODA_5|FROM", "SLAB|RATE_PER_KG_SLAB_ODA_5|TO", "SLAB|RATE_PER_KG_SLAB_ODA_5|RATE", "SLAB|RATE_PER_KG_SLAB_ODA_5|MIN", "SLAB|RATE_PER_KG_SLAB_ODA_5|MAX");
                this.oda6RatePerKgSlabs = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|RATE_PER_KG_SLAB_ODA_6|FROM", "SLAB|RATE_PER_KG_SLAB_ODA_6|TO", "SLAB|RATE_PER_KG_SLAB_ODA_6|RATE", "SLAB|RATE_PER_KG_SLAB_ODA_6|MIN", "SLAB|RATE_PER_KG_SLAB_ODA_6|MAX");
                this.oda7RatePerKgSlabs = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|RATE_PER_KG_SLAB_ODA_7|FROM", "SLAB|RATE_PER_KG_SLAB_ODA_7|TO", "SLAB|RATE_PER_KG_SLAB_ODA_7|RATE", "SLAB|RATE_PER_KG_SLAB_ODA_7|MIN", "SLAB|RATE_PER_KG_SLAB_ODA_7|MAX");
                break;
            }
            case NOT_APPLICABLE: {
                return;
            }
        }
    }

    private void setOpaFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        ChargeBasis chargeBasis = this.opaChargeBasis = CollectionUtils.isNotEmpty((Collection)((Collection)attributeNameToAttributeDtoMap.get((Object)"OPA_CHARGE_BASIS"))) ? ChargeBasis.valueOf(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"OPA_CHARGE_BASIS")).get(0)).getValue()) : ChargeBasis.NOT_APPLICABLE;
        if (ChargeBasis.NOT_APPLICABLE.equals((Object)this.opaChargeBasis)) {
            return;
        }
        switch (CollectionUtils.isNotEmpty((Collection)((Collection)attributeNameToAttributeDtoMap.get((Object)"OPA_EXCEPTION"))) ? ((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)"OPA_EXCEPTION")).get(0)).getValue() : "NOT_APPLICABLE") {
            case "APPLICABLE": {
                this.opaExceptionApplicability = true;
                this.setOPAExceptionalPincode(attributeNameToAttributeDtoMap);
                break;
            }
            case "NOT_APPLICABLE": {
                this.exceptionalPincodes = new HashMap<String, BigDecimal>();
                this.opaExceptionApplicability = false;
            }
        }
        this.categoryVsOpaField = new HashMap<String, OPAField>();
        this.setOPASlabs(attributeNameToAttributeDtoMap);
    }

    private void setOPAExceptionalPincode(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.exceptionalPincodes = new HashMap<String, BigDecimal>();
        List pincodes = (List)attributeNameToAttributeDtoMap.get((Object)"OPA_EXCEPTIONAL_PINCODE");
        List charges = (List)attributeNameToAttributeDtoMap.get((Object)"OPA_EXCEPTIONAL_CHARGE");
        if (CollectionUtils.isEmpty((Collection)pincodes) || CollectionUtils.isEmpty((Collection)charges) || pincodes.size() != charges.size()) {
            return;
        }
        Map<Integer, ClientContractAttributeDTO> sequenceVsCharge = charges.stream().collect(Collectors.toMap(ClientContractAttributeDTO::getSequence, c -> c));
        Map<Integer, ClientContractAttributeDTO> sequenceVsPincodes = pincodes.stream().collect(Collectors.toMap(ClientContractAttributeDTO::getSequence, p -> p));
        for (Map.Entry<Integer, ClientContractAttributeDTO> entry : sequenceVsCharge.entrySet()) {
            String[] pincodeSplit;
            ClientContractAttributeDTO pincode = sequenceVsPincodes.get(entry.getKey());
            if (pincode == null || !StringUtils.isNotEmpty((String)pincode.getValue())) continue;
            for (String p2 : pincodeSplit = pincode.getValue().split(",")) {
                this.exceptionalPincodes.put(p2, new BigDecimal(entry.getValue().getValue()));
            }
        }
    }

    private void setOPASlabs(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        List<ClientContractAttributeDTO> opaAttributes = this.getAttributeList(attributeNameToAttributeDtoMap, "OPA_CATEGORY");
        opaAttributes.addAll(this.getAttributeList(attributeNameToAttributeDtoMap, "FLAT_RATE_PER_CN_OPA"));
        opaAttributes.addAll(this.getAttributeList(attributeNameToAttributeDtoMap, "SLAB|RATE_PER_KG_SLAB_OPA|FROM"));
        opaAttributes.addAll(this.getAttributeList(attributeNameToAttributeDtoMap, "SLAB|RATE_PER_KG_SLAB_OPA|TO"));
        opaAttributes.addAll(this.getAttributeList(attributeNameToAttributeDtoMap, "SLAB|RATE_PER_KG_SLAB_OPA|RATE"));
        opaAttributes.addAll(this.getAttributeList(attributeNameToAttributeDtoMap, "SLAB|RATE_PER_KG_SLAB_OPA|MIN"));
        opaAttributes.addAll(this.getAttributeList(attributeNameToAttributeDtoMap, "SLAB|RATE_PER_KG_SLAB_OPA|MAX"));
        HashMap<Integer, List> opaCategoryVsAttribute = new HashMap<Integer, List>();
        for (ClientContractAttributeDTO clientContractAttributeDTO : opaAttributes) {
            Integer opaCategoryIdentifier = this.shiftBits(clientContractAttributeDTO.getSequence(), ContractAttributeConstants.OPA_SLAB_BITS);
            opaCategoryVsAttribute.computeIfAbsent(opaCategoryIdentifier, value -> new ArrayList()).add(clientContractAttributeDTO);
        }
        for (Map.Entry entry : opaCategoryVsAttribute.entrySet()) {
            OPAField opaField = new OPAField();
            HashMap<Integer, SlabDTO> sequenceVsSlab = new HashMap<Integer, SlabDTO>();
            for (ClientContractAttributeDTO clientContractAttributeDTO : (List)entry.getValue()) {
                switch (clientContractAttributeDTO.getName()) {
                    case "OPA_CATEGORY": {
                        opaField.setOpaCategory(clientContractAttributeDTO.getValue());
                        break;
                    }
                    case "FLAT_RATE_PER_CN_OPA": {
                        opaField.setFlatRatePerCN(new BigDecimal(clientContractAttributeDTO.getValue()));
                        break;
                    }
                    case "SLAB|RATE_PER_KG_SLAB_OPA|FROM": {
                        sequenceVsSlab.computeIfAbsent(clientContractAttributeDTO.getSequence(), v -> new SlabDTO()).setFrom(new BigDecimal(clientContractAttributeDTO.getValue()));
                        break;
                    }
                    case "SLAB|RATE_PER_KG_SLAB_OPA|TO": {
                        sequenceVsSlab.computeIfAbsent(clientContractAttributeDTO.getSequence(), v -> new SlabDTO()).setTo(new BigDecimal(clientContractAttributeDTO.getValue()));
                        break;
                    }
                    case "SLAB|RATE_PER_KG_SLAB_OPA|RATE": {
                        sequenceVsSlab.computeIfAbsent(clientContractAttributeDTO.getSequence(), v -> new SlabDTO()).setValue(new BigDecimal(clientContractAttributeDTO.getValue()));
                        break;
                    }
                    case "SLAB|RATE_PER_KG_SLAB_OPA|MIN": {
                        sequenceVsSlab.computeIfAbsent(clientContractAttributeDTO.getSequence(), v -> new SlabDTO()).setMinimum(new BigDecimal(clientContractAttributeDTO.getValue()));
                        break;
                    }
                    case "SLAB|RATE_PER_KG_SLAB_OPA|MAX": {
                        sequenceVsSlab.computeIfAbsent(clientContractAttributeDTO.getSequence(), v -> new SlabDTO()).setMaximum(new BigDecimal(clientContractAttributeDTO.getValue()));
                    }
                }
            }
            opaField.setSlabs(new ArrayList<SlabDTO>());
            if (CollectionUtils.isNotEmpty(sequenceVsSlab.values())) {
                opaField.getSlabs().addAll(sequenceVsSlab.values());
            }
            this.categoryVsOpaField.put(opaField.getOpaCategory(), opaField);
        }
    }

    private Integer shiftBits(Integer sequence, int bits) {
        return sequence >> bits;
    }

    private void setClientCustomFields(MultiValueMap<String, ClientContractAttributeDTO> attributeMultimap) {
        this.clientFields = Lists.newArrayList();
        if (attributeMultimap.containsKey((Object)"ARRAY_FIELD|ZOOM_CLIENT_CUSTOM_FIELDS|FIELD_NAME")) {
            List fieldNames = (List)attributeMultimap.get((Object)"ARRAY_FIELD|ZOOM_CLIENT_CUSTOM_FIELDS|FIELD_NAME");
            Map<Integer, ClientContractAttributeDTO> inputTypes = this.attributesBySequence((List)attributeMultimap.get((Object)"ARRAY_FIELD|ZOOM_CLIENT_CUSTOM_FIELDS|FIELD_TYPE"));
            Map<Integer, ClientContractAttributeDTO> values = this.attributesBySequence((List)attributeMultimap.get((Object)"ARRAY_FIELD|ZOOM_CLIENT_CUSTOM_FIELDS|FIELD_VALUE"));
            Map<Integer, ClientContractAttributeDTO> dropdownValues = this.attributesBySequence((List)attributeMultimap.get((Object)"ARRAY_FIELD|ZOOM_CLIENT_CUSTOM_FIELDS|USER_CREATED_OPTIONS"));
            this.clientFields = this.buildCustomFields(fieldNames, inputTypes, values, dropdownValues);
        }
    }

    private void setDemurrageChargesFields(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.demurrageChargeBasis = this.computeDemurrageChargeBasis(this.getFieldFromMap(attributeNameToAttributeDtoMap, "DEMURRAGE").orElse(null), this.getFieldFromMap(attributeNameToAttributeDtoMap, "DEMURRAGE_CHARGE_BASIS").orElse(null));
        switch (this.demurrageChargeBasis) {
            case FLAT_RATE_PER_CN: {
                this.demurrageRatePerCn = Optional.ofNullable(this.getNumberFromMap(attributeNameToAttributeDtoMap, "DEMURRAGE_RATE_PER_CN")).orElse(BigDecimal.ZERO);
                this.demurrageExclusionHours = Optional.ofNullable(this.getNumberFromMap(attributeNameToAttributeDtoMap, "DEMURRAGE_EXCLUSION_HOURS")).orElse(BigDecimal.ZERO).multiply(BigDecimal.valueOf(24L));
                break;
            }
            case FLAT_RATE_PER_KG: {
                this.demurrageRatePerKg = Optional.ofNullable(this.getNumberFromMap(attributeNameToAttributeDtoMap, "DEMURRAGE_FLAT_RATE_PER_KG")).orElse(BigDecimal.ZERO);
                this.demurrageExclusionHours = Optional.ofNullable(this.getNumberFromMap(attributeNameToAttributeDtoMap, "DEMURRAGE_EXCLUSION_HOURS")).orElse(BigDecimal.ZERO).multiply(BigDecimal.valueOf(24L));
                break;
            }
            case PERCENTAGE: {
                this.demurragePercentageFreight = Optional.ofNullable(this.getNumberFromMap(attributeNameToAttributeDtoMap, "DEMURRAGE_PERCENTAGE_FREIGHT")).orElse(BigDecimal.ZERO);
                this.demurrageExclusionHours = Optional.ofNullable(this.getNumberFromMap(attributeNameToAttributeDtoMap, "DEMURRAGE_EXCLUSION_HOURS")).orElse(BigDecimal.ZERO).multiply(BigDecimal.valueOf(24L));
                break;
            }
            case RATE_PER_CN_SLAB: {
                this.demurrageRatePerCnSlab = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|RATE_PER_CN_SLAB_DEMURRAGE|FROM", "SLAB|RATE_PER_CN_SLAB_DEMURRAGE|TO", "SLAB|RATE_PER_CN_SLAB_DEMURRAGE|RATE", "SLAB|RATE_PER_CN_SLAB_DEMURRAGE|MIN", "SLAB|RATE_PER_CN_SLAB_DEMURRAGE|MAX");
                this.demurrageExclusionHours = this.demurrageRatePerCnSlab.stream().map(SlabDTO::getFrom).min(BigDecimal::compareTo).orElse(BigDecimal.ZERO).multiply(BigDecimal.valueOf(24L));
                break;
            }
            case RATE_PER_KG_SLABS: {
                this.demurrageRatePerKgSlab = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|RATE_PER_KG_SLAB_DEMURRAGE|FROM", "SLAB|RATE_PER_KG_SLAB_DEMURRAGE|TO", "SLAB|RATE_PER_KG_SLAB_DEMURRAGE|RATE", "SLAB|RATE_PER_KG_SLAB_DEMURRAGE|MIN", "SLAB|RATE_PER_KG_SLAB_DEMURRAGE|MAX");
                this.demurrageExclusionHours = this.demurrageRatePerKgSlab.stream().map(SlabDTO::getFrom).min(BigDecimal::compareTo).orElse(BigDecimal.ZERO).multiply(BigDecimal.valueOf(24L));
                break;
            }
            case PERCENTAGE_SLAB: {
                this.demurragePercentageFreightSlab = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|PERCENTAGE_FREIGHT_SLAB_DEMURRAGE|FROM", "SLAB|PERCENTAGE_FREIGHT_SLAB_DEMURRAGE|TO", "SLAB|PERCENTAGE_FREIGHT_SLAB_DEMURRAGE|PERCENT", "SLAB|PERCENTAGE_FREIGHT_SLAB_DEMURRAGE|MIN", "SLAB|PERCENTAGE_FREIGHT_SLAB_DEMURRAGE|MAX");
                this.demurrageExclusionHours = this.demurragePercentageFreightSlab.stream().map(SlabDTO::getFrom).min(BigDecimal::compareTo).orElse(BigDecimal.ZERO).multiply(BigDecimal.valueOf(24L));
            }
        }
    }

    private ChargeBasis computeDemurrageChargeBasis(String chargeType, String chargeCriteria) {
        if (StringUtils.isEmpty((String)chargeType) || StringUtils.isEmpty((String)chargeCriteria)) {
            return ChargeBasis.NOT_APPLICABLE;
        }
        switch (chargeType) {
            case "RATE_PER_CN": {
                return chargeCriteria.equals("SLAB_PER_DAY") ? ChargeBasis.RATE_PER_CN_SLAB : ChargeBasis.FLAT_RATE_PER_CN;
            }
            case "PERCENTAGE_FREIGHT": {
                return chargeCriteria.equals("SLAB_PER_DAY") ? ChargeBasis.PERCENTAGE_SLAB : ChargeBasis.PERCENTAGE;
            }
            case "FLAT_RATE_PER_KG": {
                return chargeCriteria.equals("SLAB_PER_DAY") ? ChargeBasis.RATE_PER_KG_SLABS : ChargeBasis.FLAT_RATE_PER_KG;
            }
        }
        return ChargeBasis.NOT_APPLICABLE;
    }

    private List<CustomField> buildCustomFields(List<ClientContractAttributeDTO> fieldNames, Map<Integer, ClientContractAttributeDTO> inputTypes, Map<Integer, ClientContractAttributeDTO> values, Map<Integer, ClientContractAttributeDTO> dropdownValues) {
        ArrayList customFields = Lists.newArrayList();
        fieldNames.forEach(fieldName -> {
            Integer sequence = fieldName.getSequence();
            CustomField customField = new CustomField();
            customField.setFieldName(fieldName.getValue());
            if (inputTypes.containsKey(sequence)) {
                customField.setInputType(((ClientContractAttributeDTO)inputTypes.get(sequence)).getValue());
            }
            if (values.containsKey(sequence)) {
                customField.setValues((List)Lists.newArrayList((Object[])new String[]{((ClientContractAttributeDTO)values.get(sequence)).getValue()}));
            }
            if (dropdownValues.containsKey(sequence)) {
                customField.setValues((List)Lists.newArrayList((Object[])((ClientContractAttributeDTO)dropdownValues.get(sequence)).getValue().split(",")));
            }
            customFields.add(customField);
        });
        return customFields;
    }

    private Map<Integer, ClientContractAttributeDTO> attributesBySequence(List<ClientContractAttributeDTO> attributes) {
        return CollectionUtils.isEmpty(attributes) ? Maps.newHashMap() : attributes.stream().collect(Collectors.toMap(ClientContractAttributeDTO::getSequence, Function.identity()));
    }

    private void setWeightBasedDiscount(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap) {
        this.weightBasedDiscount = this.getSlabs(attributeNameToAttributeDtoMap, "SLAB|DISCOUNT_SLAB|FROM", "SLAB|DISCOUNT_SLAB|TO", "SLAB|DISCOUNT_SLAB|DISCOUNT", "SLAB|DISCOUNT_SLAB|MIN", "SLAB|DISCOUNT_SLAB|MAX");
    }

    private List<SlabDTO> getSlabs(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap, String fromKey, String toKey, String valueKey, String minimumKey, String maximumKey) {
        SlabDTO slabDTO;
        List<ClientContractAttributeDTO> fromAttributes = this.getAttributeList(attributeNameToAttributeDtoMap, fromKey);
        List<ClientContractAttributeDTO> toAttributes = this.getAttributeList(attributeNameToAttributeDtoMap, toKey);
        List<ClientContractAttributeDTO> valueAttributes = this.getAttributeList(attributeNameToAttributeDtoMap, valueKey);
        List<Object> minimumAttributes = minimumKey != null ? this.getAttributeList(attributeNameToAttributeDtoMap, minimumKey) : new ArrayList(0);
        List<Object> maximumAttributes = maximumKey != null ? this.getAttributeList(attributeNameToAttributeDtoMap, maximumKey) : new ArrayList(0);
        HashMap<Integer, SlabDTO> sequenceToSlabMap = new HashMap<Integer, SlabDTO>();
        for (ClientContractAttributeDTO clientContractAttributeDTO : fromAttributes) {
            slabDTO = SlabDTO.builder().from(this.convertStringToBigDecimal(clientContractAttributeDTO.getValue())).build();
            sequenceToSlabMap.put(clientContractAttributeDTO.getSequence(), slabDTO);
        }
        for (ClientContractAttributeDTO clientContractAttributeDTO : toAttributes) {
            slabDTO = (SlabDTO)sequenceToSlabMap.get(clientContractAttributeDTO.getSequence());
            slabDTO.setTo(this.convertStringToBigDecimal(clientContractAttributeDTO.getValue()));
            slabDTO.setSequence(clientContractAttributeDTO.getSequence());
        }
        for (ClientContractAttributeDTO clientContractAttributeDTO : valueAttributes) {
            slabDTO = (SlabDTO)sequenceToSlabMap.get(clientContractAttributeDTO.getSequence());
            slabDTO.setValue(this.convertStringToBigDecimal(clientContractAttributeDTO.getValue()));
        }
        for (ClientContractAttributeDTO clientContractAttributeDTO : minimumAttributes) {
            slabDTO = (SlabDTO)sequenceToSlabMap.get(clientContractAttributeDTO.getSequence());
            slabDTO.setMinimum(this.convertStringToBigDecimal(clientContractAttributeDTO.getValue()));
        }
        for (ClientContractAttributeDTO clientContractAttributeDTO : maximumAttributes) {
            slabDTO = (SlabDTO)sequenceToSlabMap.get(clientContractAttributeDTO.getSequence());
            slabDTO.setMaximum(this.convertStringToBigDecimal(clientContractAttributeDTO.getValue()));
        }
        return new ArrayList<SlabDTO>(sequenceToSlabMap.values());
    }

    private Map<String, BigDecimal> getMap(MultiValueMap<String, ClientContractAttributeDTO> attributeMap, String keyAttributeName, String valueAttributeName) {
        HashMap map = Maps.newHashMap();
        if (attributeMap.containsKey((Object)keyAttributeName) && attributeMap.containsKey((Object)valueAttributeName)) {
            List keyAttributes = (List)attributeMap.get((Object)keyAttributeName);
            Map<Integer, String> valueAttributeMap = ((List)attributeMap.get((Object)valueAttributeName)).stream().collect(Collectors.toMap(ClientContractAttributeDTO::getSequence, ClientContractAttributeDTO::getValue));
            keyAttributes.forEach(attribute -> map.put(attribute.getValue(), this.convertStringToBigDecimal((String)valueAttributeMap.get(attribute.getSequence()))));
        }
        return map;
    }

    private List<ClientContractAttributeDTO> getAttributeList(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap, String key) {
        List clientContractAttributeDTOs = (List)attributeNameToAttributeDtoMap.get((Object)key);
        if (clientContractAttributeDTOs == null) {
            return new ArrayList<ClientContractAttributeDTO>();
        }
        return clientContractAttributeDTOs;
    }

    private List<ClientContractAttributeDTO> getAttributeList(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap, List<String> keys) {
        ArrayList<ClientContractAttributeDTO> clientContractAttributeDTOs = new ArrayList<ClientContractAttributeDTO>();
        for (String key : keys) {
            clientContractAttributeDTOs.addAll(this.getAttributeList(attributeNameToAttributeDtoMap, key));
        }
        return clientContractAttributeDTOs;
    }

    private BigDecimal getNumberFromMap(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap, String s) {
        if (s == null) {
            return null;
        }
        if (attributeNameToAttributeDtoMap.containsKey((Object)s)) {
            return this.convertStringToBigDecimal(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)s)).get(0)).getValue());
        }
        return null;
    }

    private BigDecimal convertStringToBigDecimal(String s) {
        if (s == null || StringUtils.isEmpty((String)s)) {
            return null;
        }
        return new BigDecimal(s);
    }

    private Enum<?> getEnumValue(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap, String keyString, Class<? extends Enum> enumClass) {
        ClientContractAttributeDTO clientContractAttributeDTO = (ClientContractAttributeDTO)attributeNameToAttributeDtoMap.getFirst((Object)keyString);
        if (clientContractAttributeDTO == null) {
            return null;
        }
        return Enum.valueOf(enumClass, clientContractAttributeDTO.getValue());
    }

    private Optional<String> getFieldFromMap(MultiValueMap<String, ClientContractAttributeDTO> attributeNameToAttributeDtoMap, String s) {
        if (StringUtils.isEmpty((String)s)) {
            return Optional.empty();
        }
        if (attributeNameToAttributeDtoMap.containsKey((Object)s)) {
            return CollectionUtils.isEmpty((Collection)((Collection)attributeNameToAttributeDtoMap.get((Object)s))) ? Optional.empty() : Optional.ofNullable(((ClientContractAttributeDTO)((List)attributeNameToAttributeDtoMap.get((Object)s)).get(0)).getValue());
        }
        return Optional.empty();
    }

    public String getCode() {
        return this.code;
    }

    public ContractType getType() {
        return this.type;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public BillingCycle getBillingCycle() {
        return this.billingCycle;
    }

    public Integer getCreditPeriod() {
        return this.creditPeriod;
    }

    public Long getExpiryTimestamp() {
        return this.expiryTimestamp;
    }

    public Long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public Long getUpdatedTimestamp() {
        return this.updatedTimestamp;
    }

    public String getClientCode() {
        return this.clientCode;
    }

    public ClientDTO getClientDTO() {
        return this.clientDTO;
    }

    public ModeOfPayment getModeOfPayment() {
        return this.modeOfPayment;
    }

    public LatePaymentInterest getLatePaymentInterest() {
        return this.latePaymentInterest;
    }

    public BigDecimal getInterestOnLatePayment() {
        return this.interestOnLatePayment;
    }

    public PODRequirement getPodRequirement() {
        return this.podRequirement;
    }

    public BillingAnnexureTemplate getBillingAnnexureTemplate() {
        return this.billingAnnexureTemplate;
    }

    public ContractObligation getContractObligation() {
        return this.contractObligation;
    }

    public BigDecimal getMinimumWeightPerCn() {
        return this.minimumWeightPerCn;
    }

    public BigDecimal getMinimumFreightPerCn() {
        return this.minimumFreightPerCn;
    }

    public ChargeWeightBasis getChargeWeightBasis() {
        return this.chargeWeightBasis;
    }

    public BigDecimal getMinimumWeightPerBox() {
        return this.minimumWeightPerBox;
    }

    public BigDecimal getCft() {
        return this.cft;
    }

    public BigDecimal getLightCft() {
        return this.lightCft;
    }

    public BigDecimal getDenseCft() {
        return this.denseCft;
    }

    public RoundingFactor getRoundingFactor() {
        return this.roundingFactor;
    }

    public ContractObligationLocationType getContractObligationLocationType() {
        return this.contractObligationLocationType;
    }

    public Map<String, BigDecimal> getLocationToMinWeightMap() {
        return this.locationToMinWeightMap;
    }

    public Map<String, BigDecimal> getLocationToMinFreightMap() {
        return this.locationToMinFreightMap;
    }

    public ChargeBasis getProcessingChargesChargeBasis() {
        return this.processingChargesChargeBasis;
    }

    public BigDecimal getProcessingChargesPerCn() {
        return this.processingChargesPerCn;
    }

    public ConsignmentLiability getConsignmentLiability() {
        return this.consignmentLiability;
    }

    public BigDecimal getMaximumLiability() {
        return this.maximumLiability;
    }

    public ChargeBasis getFovChargeBasis() {
        return this.fovChargeBasis;
    }

    public FragilityValue getFovValue() {
        return this.fovValue;
    }

    public BigDecimal getClientFovPerCn() {
        return this.clientFovPerCn;
    }

    public BigDecimal getClientFovPerCnFragile() {
        return this.clientFovPerCnFragile;
    }

    public BigDecimal getClientFovPerCnNonFragile() {
        return this.clientFovPerCnNonFragile;
    }

    public BigDecimal getClientFovPercentage() {
        return this.clientFovPercentage;
    }

    public BigDecimal getClientFovPercentageFragile() {
        return this.clientFovPercentageFragile;
    }

    public BigDecimal getClientFovPercentageNonFragile() {
        return this.clientFovPercentageNonFragile;
    }

    public BigDecimal getClientFovMaxCharge() {
        return this.clientFovMaxCharge;
    }

    public BigDecimal getClientFovMaxChargeFragile() {
        return this.clientFovMaxChargeFragile;
    }

    public BigDecimal getClientFovMaxChargeNonFragile() {
        return this.clientFovMaxChargeNonFragile;
    }

    public BigDecimal getClientFovMinCharge() {
        return this.clientFovMinCharge;
    }

    public BigDecimal getClientFovMinChargeFragile() {
        return this.clientFovMinChargeFragile;
    }

    public BigDecimal getClientFovMinChargeNonFragile() {
        return this.clientFovMinChargeNonFragile;
    }

    public BigDecimal getRcsPercentageFragile() {
        return this.rcsPercentageFragile;
    }

    public BigDecimal getRcsPercentageNonFragile() {
        return this.rcsPercentageNonFragile;
    }

    public BigDecimal getRcsMaxCharge() {
        return this.rcsMaxCharge;
    }

    public BigDecimal getRcsMaxChargeFragile() {
        return this.rcsMaxChargeFragile;
    }

    public BigDecimal getRcsMaxChargeNonFragile() {
        return this.rcsMaxChargeNonFragile;
    }

    public BigDecimal getRcsMinCharge() {
        return this.rcsMinCharge;
    }

    public BigDecimal getRcsMinChargeFragile() {
        return this.rcsMinChargeFragile;
    }

    public BigDecimal getRcsMinChargeNonFragile() {
        return this.rcsMinChargeNonFragile;
    }

    public BigDecimal getFscPercentage() {
        return this.fscPercentage;
    }

    public ChargeBasis getFuelLinkageChargeBasis() {
        return this.fuelLinkageChargeBasis;
    }

    public FuelLinkageCriteria getFuelLinkageCriteria() {
        return this.fuelLinkageCriteria;
    }

    public BigDecimal getFscDieselPercentChange() {
        return this.fscDieselPercentChange;
    }

    public BigDecimal getFscPercentChange() {
        return this.fscPercentChange;
    }

    public BaseDieselRateType getBaseDieselRateType() {
        return this.baseDieselRateType;
    }

    public BaseDieselRateDerivation getBaseDieselRateDerivation() {
        return this.baseDieselRateDerivation;
    }

    public DieselSource getDieselSource() {
        return this.dieselSource;
    }

    public BigDecimal getDieselPrice() {
        return this.dieselPrice;
    }

    public String getDieselRateCities() {
        return this.dieselRateCities;
    }

    public Long getDieselRateAsOnDate() {
        return this.dieselRateAsOnDate;
    }

    public BillingDieselRateCalculationType getBillingDieselRateCalculationType() {
        return this.billingDieselRateCalculationType;
    }

    public String getSpecificPeriodDays() {
        return this.specificPeriodDays;
    }

    public DieselBillingPeriod getDieselBillingPeriod() {
        return this.dieselBillingPeriod;
    }

    public ToleranceBand getToleranceBand() {
        return this.toleranceBand;
    }

    public ToleranceType getToleranceType() {
        return this.toleranceType;
    }

    public BigDecimal getToleranceAmount() {
        return this.toleranceAmount;
    }

    public Boolean getNegativeFscBenefit() {
        return this.negativeFscBenefit;
    }

    public BasicFreightChangeCriteria getBasicFreightChangeCriteria() {
        return this.basicFreightChangeCriteria;
    }

    public List<SlabDTO> getFscBasicFreightChangeSlabs() {
        return this.fscBasicFreightChangeSlabs;
    }

    public String getComponentsForFscCharge() {
        return this.componentsForFscCharge;
    }

    public ChargeBasis getGreenTaxChargeBasis() {
        return this.greenTaxChargeBasis;
    }

    public BigDecimal getGreenTaxRatePerCn() {
        return this.greenTaxRatePerCn;
    }

    public BigDecimal getGreenTaxRatePerKg() {
        return this.greenTaxRatePerKg;
    }

    public BigDecimal getGreenTaxRatePerBox() {
        return this.greenTaxRatePerBox;
    }

    public BigDecimal getGreenTaxMinimumCharge() {
        return this.greenTaxMinimumCharge;
    }

    public BigDecimal getGreenTaxMaximumCharge() {
        return this.greenTaxMaximumCharge;
    }

    public GreenTaxApplicableCity getGreenTaxApplicableCity() {
        return this.greenTaxApplicableCity;
    }

    public PickupDeliveryActivityBasis getGreenTaxApplicabilityType() {
        return this.greenTaxApplicabilityType;
    }

    public ChargeBasis getAppointmentDeliveryChargeBasis() {
        return this.appointmentDeliveryChargeBasis;
    }

    public BigDecimal getAppointmentDeliveryRatePerCn() {
        return this.appointmentDeliveryRatePerCn;
    }

    public BigDecimal getAppointmentDeliveryRatePerKg() {
        return this.appointmentDeliveryRatePerKg;
    }

    public BigDecimal getAppointmentDeliveryMinimumCharge() {
        return this.appointmentDeliveryMinimumCharge;
    }

    public BigDecimal getAppointmentDeliveryMaximumCharge() {
        return this.appointmentDeliveryMaximumCharge;
    }

    public ChargeBasis getSundayDeliveryChargeBasis() {
        return this.sundayDeliveryChargeBasis;
    }

    public BigDecimal getSundayDeliveryRatePerCn() {
        return this.sundayDeliveryRatePerCn;
    }

    public BigDecimal getSundayDeliveryRatePerKg() {
        return this.sundayDeliveryRatePerKg;
    }

    public BigDecimal getSundayDeliveryRatePerBox() {
        return this.sundayDeliveryRatePerBox;
    }

    public BigDecimal getSundayDeliveryMinimumCharge() {
        return this.sundayDeliveryMinimumCharge;
    }

    public BigDecimal getSundayDeliveryMaximumCharge() {
        return this.sundayDeliveryMaximumCharge;
    }

    public PickupDeliveryActivityBasis getSundayDeliveryApplicabilityType() {
        return this.sundayDeliveryApplicabilityType;
    }

    public ChargeBasis getMallDeliveryChargeBasis() {
        return this.mallDeliveryChargeBasis;
    }

    public BigDecimal getMallDeliveryRatePerCn() {
        return this.mallDeliveryRatePerCn;
    }

    public BigDecimal getMallDeliveryRatePerKg() {
        return this.mallDeliveryRatePerKg;
    }

    public BigDecimal getMallDeliveryMinimumCharge() {
        return this.mallDeliveryMinimumCharge;
    }

    public BigDecimal getMallDeliveryMaximumCharge() {
        return this.mallDeliveryMaximumCharge;
    }

    public ChargeBasis getCanteenDeliveryChargeBasis() {
        return this.canteenDeliveryChargeBasis;
    }

    public BigDecimal getCanteenDeliveryRatePerCn() {
        return this.canteenDeliveryRatePerCn;
    }

    public BigDecimal getCanteenDeliveryRatePerKg() {
        return this.canteenDeliveryRatePerKg;
    }

    public BigDecimal getCanteenDeliveryMinimumCharge() {
        return this.canteenDeliveryMinimumCharge;
    }

    public BigDecimal getCanteenDeliveryMaximumCharge() {
        return this.canteenDeliveryMaximumCharge;
    }

    public ChargeBasis getSezDeliveryChargeBasis() {
        return this.sezDeliveryChargeBasis;
    }

    public BigDecimal getSezDeliveryRatePerCn() {
        return this.sezDeliveryRatePerCn;
    }

    public BigDecimal getSezDeliveryRatePerKg() {
        return this.sezDeliveryRatePerKg;
    }

    public BigDecimal getSezDeliveryMinimumCharge() {
        return this.sezDeliveryMinimumCharge;
    }

    public BigDecimal getSezDeliveryMaximumCharge() {
        return this.sezDeliveryMaximumCharge;
    }

    public ChargeBasis getRailwayDeliveryChargeBasis() {
        return this.railwayDeliveryChargeBasis;
    }

    public BigDecimal getRailwayDeliveryRatePerCn() {
        return this.railwayDeliveryRatePerCn;
    }

    public BigDecimal getRailwayDeliveryRatePerKg() {
        return this.railwayDeliveryRatePerKg;
    }

    public BigDecimal getRailwayDeliveryMinimumCharge() {
        return this.railwayDeliveryMinimumCharge;
    }

    public BigDecimal getRailwayDeliveryMaximumCharge() {
        return this.railwayDeliveryMaximumCharge;
    }

    public ChargeBasis getGovernmentCompoundDeliveryChargeBasis() {
        return this.governmentCompoundDeliveryChargeBasis;
    }

    public BigDecimal getGovernmentCompoundDeliveryRatePerCn() {
        return this.governmentCompoundDeliveryRatePerCn;
    }

    public BigDecimal getGovernmentCompoundDeliveryRatePerKg() {
        return this.governmentCompoundDeliveryRatePerKg;
    }

    public BigDecimal getGovernmentCompoundDeliveryMinimumCharge() {
        return this.governmentCompoundDeliveryMinimumCharge;
    }

    public BigDecimal getGovernmentCompoundDeliveryMaximumCharge() {
        return this.governmentCompoundDeliveryMaximumCharge;
    }

    public ChargeBasis getLiquidHandlingChargeBasis() {
        return this.liquidHandlingChargeBasis;
    }

    public BigDecimal getLiquidHandlingRatePerCn() {
        return this.liquidHandlingRatePerCn;
    }

    public BigDecimal getLiquidHandlingRatePerKg() {
        return this.liquidHandlingRatePerKg;
    }

    public BigDecimal getLiquidHandlingMinimumCharge() {
        return this.liquidHandlingMinimumCharge;
    }

    public BigDecimal getLiquidHandlingMaximumCharge() {
        return this.liquidHandlingMaximumCharge;
    }

    public ChargeBasis getHazardousHandlingChargeBasis() {
        return this.hazardousHandlingChargeBasis;
    }

    public BigDecimal getHazardousHandlingRatePerCn() {
        return this.hazardousHandlingRatePerCn;
    }

    public BigDecimal getHazardousHandlingRatePerKg() {
        return this.hazardousHandlingRatePerKg;
    }

    public BigDecimal getHazardousHandlingMinimumCharge() {
        return this.hazardousHandlingMinimumCharge;
    }

    public BigDecimal getHazardousHandlingMaximumCharge() {
        return this.hazardousHandlingMaximumCharge;
    }

    public ChargeBasis getDeliveryReattemptChargeBasis() {
        return this.deliveryReattemptChargeBasis;
    }

    public Boolean getDeliveryReattemptIsPerAttempt() {
        return this.deliveryReattemptIsPerAttempt;
    }

    public BigDecimal getDeliveryReattemptRatePerCn() {
        return this.deliveryReattemptRatePerCn;
    }

    public BigDecimal getDeliveryReattemptRatePerKg() {
        return this.deliveryReattemptRatePerKg;
    }

    public BigDecimal getDeliveryReattemptMinimumCharge() {
        return this.deliveryReattemptMinimumCharge;
    }

    public BigDecimal getDeliveryReattemptMaximumCharge() {
        return this.deliveryReattemptMaximumCharge;
    }

    public ChargeBasis getHandlingChargesChargeBasis() {
        return this.handlingChargesChargeBasis;
    }

    public WeightType getHandlingChargeWeightType() {
        return this.handlingChargeWeightType;
    }

    public BigDecimal getHandlingChargesRatePerCn() {
        return this.handlingChargesRatePerCn;
    }

    public BigDecimal getHandlingChargesRatePerKg() {
        return this.handlingChargesRatePerKg;
    }

    public BigDecimal getHandlingChargesRatePerBox() {
        return this.handlingChargesRatePerBox;
    }

    public BigDecimal getHandlingChargesMinimumCharge() {
        return this.handlingChargesMinimumCharge;
    }

    public BigDecimal getHandlingChargesMaximumCharge() {
        return this.handlingChargesMaximumCharge;
    }

    public List<SlabDTO> getHandlingChargesRatePerKgPerBoxSlabs() {
        return this.handlingChargesRatePerKgPerBoxSlabs;
    }

    public List<SlabDTO> getHandlingChargesRatePerBoxSlabs() {
        return this.handlingChargesRatePerBoxSlabs;
    }

    public List<SlabDTO> getHandlingChargesRatePerKgSlabs() {
        return this.handlingChargesRatePerKgSlabs;
    }

    public ChargeBasis getOdcHandlingChargesChargeBasis() {
        return this.odcHandlingChargesChargeBasis;
    }

    public BigDecimal getOdcHandlingChargesRatePerKg() {
        return this.odcHandlingChargesRatePerKg;
    }

    public BigDecimal getOdcHandlingChargesRatePerBox() {
        return this.odcHandlingChargesRatePerBox;
    }

    public BigDecimal getOdcHandlingChargesMinimumCharge() {
        return this.odcHandlingChargesMinimumCharge;
    }

    public BigDecimal getOdcHandlingChargesMaximumCharge() {
        return this.odcHandlingChargesMaximumCharge;
    }

    public ChargeBasis getValueHandlingChargesChargeBasis() {
        return this.valueHandlingChargesChargeBasis;
    }

    public BigDecimal getValueHandlingChargesRatePerKgCutoff() {
        return this.valueHandlingChargesRatePerKgCutoff;
    }

    public BigDecimal getValueHandlingChargesCustomerInvoicePercentage() {
        return this.valueHandlingChargesCustomerInvoicePercentage;
    }

    public BigDecimal getValueHandlingChargesMinimumCharge() {
        return this.valueHandlingChargesMinimumCharge;
    }

    public BigDecimal getValueHandlingChargesMaximumCharge() {
        return this.valueHandlingChargesMaximumCharge;
    }

    public Boolean getHigherFloorChargesIsPerFloor() {
        return this.higherFloorChargesIsPerFloor;
    }

    public PickupDeliveryActivityBasis getHigherFloorActivityBasis() {
        return this.higherFloorActivityBasis;
    }

    public ChargeBasis getHigherFloorDeliveryChargeBasis() {
        return this.higherFloorDeliveryChargeBasis;
    }

    public BigDecimal getHigherFloorDeliveryRatePerCn() {
        return this.higherFloorDeliveryRatePerCn;
    }

    public BigDecimal getHigherFloorDeliveryRatePerKg() {
        return this.higherFloorDeliveryRatePerKg;
    }

    public BigDecimal getHigherFloorDeliveryRatePerBox() {
        return this.higherFloorDeliveryRatePerBox;
    }

    public BigDecimal getHigherFloorDeliveryMinimumCharge() {
        return this.higherFloorDeliveryMinimumCharge;
    }

    public BigDecimal getHigherFloorDeliveryMaximumCharge() {
        return this.higherFloorDeliveryMaximumCharge;
    }

    public List<SlabDTO> getHigherFloorDeliveryRatePerKgSlabs() {
        return this.higherFloorDeliveryRatePerKgSlabs;
    }

    public List<SlabDTO> getHigherFloorDeliveryRatePerBoxSlabs() {
        return this.higherFloorDeliveryRatePerBoxSlabs;
    }

    public Integer getHigherFloorExclusionFloors() {
        return this.higherFloorExclusionFloors;
    }

    public ChargeBasis getOdaChargeBasis() {
        return this.odaChargeBasis;
    }

    public ODAType getOdaType() {
        return this.odaType;
    }

    public BigDecimal getOda1RatePerCn() {
        return this.oda1RatePerCn;
    }

    public BigDecimal getOda2RatePerCn() {
        return this.oda2RatePerCn;
    }

    public BigDecimal getOda3RatePerCn() {
        return this.oda3RatePerCn;
    }

    public BigDecimal getOda4RatePerCn() {
        return this.oda4RatePerCn;
    }

    public BigDecimal getOda5RatePerCn() {
        return this.oda5RatePerCn;
    }

    public BigDecimal getOda6RatePerCn() {
        return this.oda6RatePerCn;
    }

    public BigDecimal getOda7RatePerCn() {
        return this.oda7RatePerCn;
    }

    public List<SlabDTO> getOda1RatePerKgSlabs() {
        return this.oda1RatePerKgSlabs;
    }

    public List<SlabDTO> getOda2RatePerKgSlabs() {
        return this.oda2RatePerKgSlabs;
    }

    public List<SlabDTO> getOda3RatePerKgSlabs() {
        return this.oda3RatePerKgSlabs;
    }

    public List<SlabDTO> getOda4RatePerKgSlabs() {
        return this.oda4RatePerKgSlabs;
    }

    public List<SlabDTO> getOda5RatePerKgSlabs() {
        return this.oda5RatePerKgSlabs;
    }

    public List<SlabDTO> getOda6RatePerKgSlabs() {
        return this.oda6RatePerKgSlabs;
    }

    public List<SlabDTO> getOda7RatePerKgSlabs() {
        return this.oda7RatePerKgSlabs;
    }

    public boolean isOdaExemptionApplicability() {
        return this.odaExemptionApplicability;
    }

    public String getOdaExemptedPincodes() {
        return this.odaExemptedPincodes;
    }

    public ChargeBasis getOpaChargeBasis() {
        return this.opaChargeBasis;
    }

    public Map<String, OPAField> getCategoryVsOpaField() {
        return this.categoryVsOpaField;
    }

    public Map<String, BigDecimal> getExceptionalPincodes() {
        return this.exceptionalPincodes;
    }

    public boolean isOpaExceptionApplicability() {
        return this.opaExceptionApplicability;
    }

    public ChargeBasis getFodChargeBasis() {
        return this.fodChargeBasis;
    }

    public BigDecimal getFodPerCn() {
        return this.fodPerCn;
    }

    public BigDecimal getFodPerKg() {
        return this.fodPerKg;
    }

    public BigDecimal getFodMinimumCharge() {
        return this.fodMinimumCharge;
    }

    public BigDecimal getFodMaximumCharge() {
        return this.fodMaximumCharge;
    }

    public BigDecimal getFodPerBox() {
        return this.fodPerBox;
    }

    public ChargeBasis getMetroCongestionChargeBasis() {
        return this.metroCongestionChargeBasis;
    }

    public BigDecimal getMetroCongestionPerCn() {
        return this.metroCongestionPerCn;
    }

    public BigDecimal getMetroCongestionPerKg() {
        return this.metroCongestionPerKg;
    }

    public BigDecimal getMetroCongestionMinimumCharge() {
        return this.metroCongestionMinimumCharge;
    }

    public BigDecimal getMetroCongestionMaximumCharge() {
        return this.metroCongestionMaximumCharge;
    }

    public BigDecimal getMetroCongestionPerBox() {
        return this.metroCongestionPerBox;
    }

    public ChargeBasis getHardRegionChargeBasis() {
        return this.hardRegionChargeBasis;
    }

    public BigDecimal getHardRegionPerCn() {
        return this.hardRegionPerCn;
    }

    public BigDecimal getHardRegionPerKg() {
        return this.hardRegionPerKg;
    }

    public BigDecimal getHardRegionMinimumCharge() {
        return this.hardRegionMinimumCharge;
    }

    public BigDecimal getHardRegionMaximumCharge() {
        return this.hardRegionMaximumCharge;
    }

    public BigDecimal getHardRegionPerBox() {
        return this.hardRegionPerBox;
    }

    public ChargeBasis getSpecialZoneChargeBasis() {
        return this.specialZoneChargeBasis;
    }

    public BigDecimal getSpecialZonePerCn() {
        return this.specialZonePerCn;
    }

    public BigDecimal getSpecialZonePerKg() {
        return this.specialZonePerKg;
    }

    public BigDecimal getSpecialZoneMinimumCharge() {
        return this.specialZoneMinimumCharge;
    }

    public BigDecimal getSpecialZoneMaximumCharge() {
        return this.specialZoneMaximumCharge;
    }

    public BigDecimal getSpecialZonePerBox() {
        return this.specialZonePerBox;
    }

    public ChargeBasis getInfrastructureDevelopmentChargeBasis() {
        return this.infrastructureDevelopmentChargeBasis;
    }

    public BigDecimal getInfrastructureDevelopmentRatePerChargeBasis() {
        return this.infrastructureDevelopmentRatePerChargeBasis;
    }

    public String getInfrastructureDevelopmentChargeComponent() {
        return this.infrastructureDevelopmentChargeComponent;
    }

    public ChargeBasis getBdSurchargeChargeBasis() {
        return this.bdSurchargeChargeBasis;
    }

    public BigDecimal getBdSurchargePercentageFreight() {
        return this.bdSurchargePercentageFreight;
    }

    public ChargeBasis getCodDodChargeBasis() {
        return this.codDodChargeBasis;
    }

    public BigDecimal getCodDodPerCn() {
        return this.codDodPerCn;
    }

    public BigDecimal getCodDodPercentageFreight() {
        return this.codDodPercentageFreight;
    }

    public BigDecimal getCodDodMin() {
        return this.codDodMin;
    }

    public BigDecimal getCodDodMax() {
        return this.codDodMax;
    }

    public String getClientAccountNumber() {
        return this.clientAccountNumber;
    }

    public BigDecimal getCodDodCreditCardChargeMin() {
        return this.codDodCreditCardChargeMin;
    }

    public BigDecimal getCodDodDebitCardChargeMin() {
        return this.codDodDebitCardChargeMin;
    }

    public BigDecimal getCodDodNetbankingChargeMin() {
        return this.codDodNetbankingChargeMin;
    }

    public BigDecimal getCodDodNeftChargeMin() {
        return this.codDodNeftChargeMin;
    }

    public BigDecimal getCodDodRtgsChargeMin() {
        return this.codDodRtgsChargeMin;
    }

    public BigDecimal getCodDodImpsChargeMin() {
        return this.codDodImpsChargeMin;
    }

    public BigDecimal getCodDodUpiChargeMin() {
        return this.codDodUpiChargeMin;
    }

    public BigDecimal getCodDodCreditCardPercentage() {
        return this.codDodCreditCardPercentage;
    }

    public BigDecimal getCodDodDebitCardPercentage() {
        return this.codDodDebitCardPercentage;
    }

    public BigDecimal getCodDodNetbankingPercentage() {
        return this.codDodNetbankingPercentage;
    }

    public BigDecimal getCodDodNeftPercentage() {
        return this.codDodNeftPercentage;
    }

    public BigDecimal getCodDodRtgsPercentage() {
        return this.codDodRtgsPercentage;
    }

    public BigDecimal getCodDodImpsPercentage() {
        return this.codDodImpsPercentage;
    }

    public BigDecimal getCodDodUpiPercentage() {
        return this.codDodUpiPercentage;
    }

    public BigDecimal getCodDodCreditCardChargeMax() {
        return this.codDodCreditCardChargeMax;
    }

    public BigDecimal getCodDodDebitCardChargeMax() {
        return this.codDodDebitCardChargeMax;
    }

    public BigDecimal getCodDodNetbankingChargeMax() {
        return this.codDodNetbankingChargeMax;
    }

    public BigDecimal getCodDodNeftChargeMax() {
        return this.codDodNeftChargeMax;
    }

    public BigDecimal getCodDodRtgsChargeMax() {
        return this.codDodRtgsChargeMax;
    }

    public BigDecimal getCodDodImpsChargeMax() {
        return this.codDodImpsChargeMax;
    }

    public BigDecimal getCodDodUpiChargeMax() {
        return this.codDodUpiChargeMax;
    }

    public Map<CodDodOnlinePaymentMode, List<CodDodExceptionalCharge>> getCodDodModeVsExceptionalCharge() {
        return this.codDodModeVsExceptionalCharge;
    }

    public ChargeBasis getDaccChargeBasis() {
        return this.daccChargeBasis;
    }

    public BigDecimal getDaccRatePerCn() {
        return this.daccRatePerCn;
    }

    public BigDecimal getDaccRatePerKg() {
        return this.daccRatePerKg;
    }

    public BigDecimal getDaccMinimumCharge() {
        return this.daccMinimumCharge;
    }

    public BigDecimal getDaccMaximumCharge() {
        return this.daccMaximumCharge;
    }

    public ChargeBasis getDemurrageChargeBasis() {
        return this.demurrageChargeBasis;
    }

    public BigDecimal getDemurrageExclusionHours() {
        return this.demurrageExclusionHours;
    }

    public BigDecimal getDemurrageRatePerCn() {
        return this.demurrageRatePerCn;
    }

    public BigDecimal getDemurrageRatePerKg() {
        return this.demurrageRatePerKg;
    }

    public BigDecimal getDemurragePercentageFreight() {
        return this.demurragePercentageFreight;
    }

    public List<SlabDTO> getDemurrageRatePerCnSlab() {
        return this.demurrageRatePerCnSlab;
    }

    public List<SlabDTO> getDemurragePercentageFreightSlab() {
        return this.demurragePercentageFreightSlab;
    }

    public List<SlabDTO> getDemurrageRatePerKgSlab() {
        return this.demurrageRatePerKgSlab;
    }

    public ChargeBasis getHardCopyPodChargeBasis() {
        return this.hardCopyPodChargeBasis;
    }

    public BigDecimal getHardCopyPodPerCn() {
        return this.hardCopyPodPerCn;
    }

    public ChargeBasis getUnionWaraiMathadiChargeBasis() {
        return this.unionWaraiMathadiChargeBasis;
    }

    public BigDecimal getUnionWaraiMathadiChargePerUnit() {
        return this.unionWaraiMathadiChargePerUnit;
    }

    public BigDecimal getUnionWaraiMathadiMinCharge() {
        return this.unionWaraiMathadiMinCharge;
    }

    public BigDecimal getUnionWaraiMathadiMaxCharge() {
        return this.unionWaraiMathadiMaxCharge;
    }

    public PickupDeliveryActivityBasis getUnionWaraiMathadiActivityBasis() {
        return this.unionWaraiMathadiActivityBasis;
    }

    public ChargeBasis getDedicatedVehicleChargeBasis() {
        return this.dedicatedVehicleChargeBasis;
    }

    public BigDecimal getDedicatedVehicleChargePerUnit() {
        return this.dedicatedVehicleChargePerUnit;
    }

    public BigDecimal getDedicatedVehicleMinCharge() {
        return this.dedicatedVehicleMinCharge;
    }

    public BigDecimal getDedicatedVehicleMaxCharge() {
        return this.dedicatedVehicleMaxCharge;
    }

    public PickupDeliveryActivityBasis getDedicatedVehicleActivityBasis() {
        return this.dedicatedVehicleActivityBasis;
    }

    public ChargeBasis getMaterialHandlingEquipmentChargeBasis() {
        return this.materialHandlingEquipmentChargeBasis;
    }

    public BigDecimal getMaterialHandlingEquipmentChargePerUnit() {
        return this.materialHandlingEquipmentChargePerUnit;
    }

    public BigDecimal getMaterialHandlingEquipmentMinCharge() {
        return this.materialHandlingEquipmentMinCharge;
    }

    public BigDecimal getMaterialHandlingEquipmentMaxCharge() {
        return this.materialHandlingEquipmentMaxCharge;
    }

    public PickupDeliveryActivityBasis getMaterialHandlingEquipmentActivityBasis() {
        return this.materialHandlingEquipmentActivityBasis;
    }

    public List<CustomField> getClientFields() {
        return this.clientFields;
    }

    public List<SlabDTO> getWeightBasedDiscount() {
        return this.weightBasedDiscount;
    }

    public List<SlabDTO> getChargedWeightSlabs() {
        return this.chargedWeightSlabs;
    }

    public List<SlabDTO> getCcSlabs() {
        return this.ccSlabs;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setType(ContractType type) {
        this.type = type;
    }

    public void setServiceType(ServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public void setBillingCycle(BillingCycle billingCycle) {
        this.billingCycle = billingCycle;
    }

    public void setCreditPeriod(Integer creditPeriod) {
        this.creditPeriod = creditPeriod;
    }

    public void setExpiryTimestamp(Long expiryTimestamp) {
        this.expiryTimestamp = expiryTimestamp;
    }

    public void setCreatedTimestamp(Long createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
    }

    public void setUpdatedTimestamp(Long updatedTimestamp) {
        this.updatedTimestamp = updatedTimestamp;
    }

    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    public void setClientDTO(ClientDTO clientDTO) {
        this.clientDTO = clientDTO;
    }

    public void setModeOfPayment(ModeOfPayment modeOfPayment) {
        this.modeOfPayment = modeOfPayment;
    }

    public void setLatePaymentInterest(LatePaymentInterest latePaymentInterest) {
        this.latePaymentInterest = latePaymentInterest;
    }

    public void setInterestOnLatePayment(BigDecimal interestOnLatePayment) {
        this.interestOnLatePayment = interestOnLatePayment;
    }

    public void setPodRequirement(PODRequirement podRequirement) {
        this.podRequirement = podRequirement;
    }

    public void setBillingAnnexureTemplate(BillingAnnexureTemplate billingAnnexureTemplate) {
        this.billingAnnexureTemplate = billingAnnexureTemplate;
    }

    public void setContractObligation(ContractObligation contractObligation) {
        this.contractObligation = contractObligation;
    }

    public void setMinimumWeightPerCn(BigDecimal minimumWeightPerCn) {
        this.minimumWeightPerCn = minimumWeightPerCn;
    }

    public void setMinimumFreightPerCn(BigDecimal minimumFreightPerCn) {
        this.minimumFreightPerCn = minimumFreightPerCn;
    }

    public void setChargeWeightBasis(ChargeWeightBasis chargeWeightBasis) {
        this.chargeWeightBasis = chargeWeightBasis;
    }

    public void setMinimumWeightPerBox(BigDecimal minimumWeightPerBox) {
        this.minimumWeightPerBox = minimumWeightPerBox;
    }

    public void setCft(BigDecimal cft) {
        this.cft = cft;
    }

    public void setLightCft(BigDecimal lightCft) {
        this.lightCft = lightCft;
    }

    public void setDenseCft(BigDecimal denseCft) {
        this.denseCft = denseCft;
    }

    public void setRoundingFactor(RoundingFactor roundingFactor) {
        this.roundingFactor = roundingFactor;
    }

    public void setContractObligationLocationType(ContractObligationLocationType contractObligationLocationType) {
        this.contractObligationLocationType = contractObligationLocationType;
    }

    public void setLocationToMinWeightMap(Map<String, BigDecimal> locationToMinWeightMap) {
        this.locationToMinWeightMap = locationToMinWeightMap;
    }

    public void setLocationToMinFreightMap(Map<String, BigDecimal> locationToMinFreightMap) {
        this.locationToMinFreightMap = locationToMinFreightMap;
    }

    public void setProcessingChargesChargeBasis(ChargeBasis processingChargesChargeBasis) {
        this.processingChargesChargeBasis = processingChargesChargeBasis;
    }

    public void setProcessingChargesPerCn(BigDecimal processingChargesPerCn) {
        this.processingChargesPerCn = processingChargesPerCn;
    }

    public void setConsignmentLiability(ConsignmentLiability consignmentLiability) {
        this.consignmentLiability = consignmentLiability;
    }

    public void setMaximumLiability(BigDecimal maximumLiability) {
        this.maximumLiability = maximumLiability;
    }

    public void setFovChargeBasis(ChargeBasis fovChargeBasis) {
        this.fovChargeBasis = fovChargeBasis;
    }

    public void setFovValue(FragilityValue fovValue) {
        this.fovValue = fovValue;
    }

    public void setClientFovPerCn(BigDecimal clientFovPerCn) {
        this.clientFovPerCn = clientFovPerCn;
    }

    public void setClientFovPerCnFragile(BigDecimal clientFovPerCnFragile) {
        this.clientFovPerCnFragile = clientFovPerCnFragile;
    }

    public void setClientFovPerCnNonFragile(BigDecimal clientFovPerCnNonFragile) {
        this.clientFovPerCnNonFragile = clientFovPerCnNonFragile;
    }

    public void setClientFovPercentage(BigDecimal clientFovPercentage) {
        this.clientFovPercentage = clientFovPercentage;
    }

    public void setClientFovPercentageFragile(BigDecimal clientFovPercentageFragile) {
        this.clientFovPercentageFragile = clientFovPercentageFragile;
    }

    public void setClientFovPercentageNonFragile(BigDecimal clientFovPercentageNonFragile) {
        this.clientFovPercentageNonFragile = clientFovPercentageNonFragile;
    }

    public void setClientFovMaxCharge(BigDecimal clientFovMaxCharge) {
        this.clientFovMaxCharge = clientFovMaxCharge;
    }

    public void setClientFovMaxChargeFragile(BigDecimal clientFovMaxChargeFragile) {
        this.clientFovMaxChargeFragile = clientFovMaxChargeFragile;
    }

    public void setClientFovMaxChargeNonFragile(BigDecimal clientFovMaxChargeNonFragile) {
        this.clientFovMaxChargeNonFragile = clientFovMaxChargeNonFragile;
    }

    public void setClientFovMinCharge(BigDecimal clientFovMinCharge) {
        this.clientFovMinCharge = clientFovMinCharge;
    }

    public void setClientFovMinChargeFragile(BigDecimal clientFovMinChargeFragile) {
        this.clientFovMinChargeFragile = clientFovMinChargeFragile;
    }

    public void setClientFovMinChargeNonFragile(BigDecimal clientFovMinChargeNonFragile) {
        this.clientFovMinChargeNonFragile = clientFovMinChargeNonFragile;
    }

    public void setRcsPercentageFragile(BigDecimal rcsPercentageFragile) {
        this.rcsPercentageFragile = rcsPercentageFragile;
    }

    public void setRcsPercentageNonFragile(BigDecimal rcsPercentageNonFragile) {
        this.rcsPercentageNonFragile = rcsPercentageNonFragile;
    }

    public void setRcsMaxCharge(BigDecimal rcsMaxCharge) {
        this.rcsMaxCharge = rcsMaxCharge;
    }

    public void setRcsMaxChargeFragile(BigDecimal rcsMaxChargeFragile) {
        this.rcsMaxChargeFragile = rcsMaxChargeFragile;
    }

    public void setRcsMaxChargeNonFragile(BigDecimal rcsMaxChargeNonFragile) {
        this.rcsMaxChargeNonFragile = rcsMaxChargeNonFragile;
    }

    public void setRcsMinCharge(BigDecimal rcsMinCharge) {
        this.rcsMinCharge = rcsMinCharge;
    }

    public void setRcsMinChargeFragile(BigDecimal rcsMinChargeFragile) {
        this.rcsMinChargeFragile = rcsMinChargeFragile;
    }

    public void setRcsMinChargeNonFragile(BigDecimal rcsMinChargeNonFragile) {
        this.rcsMinChargeNonFragile = rcsMinChargeNonFragile;
    }

    public void setFscPercentage(BigDecimal fscPercentage) {
        this.fscPercentage = fscPercentage;
    }

    public void setFuelLinkageChargeBasis(ChargeBasis fuelLinkageChargeBasis) {
        this.fuelLinkageChargeBasis = fuelLinkageChargeBasis;
    }

    public void setFuelLinkageCriteria(FuelLinkageCriteria fuelLinkageCriteria) {
        this.fuelLinkageCriteria = fuelLinkageCriteria;
    }

    public void setFscDieselPercentChange(BigDecimal fscDieselPercentChange) {
        this.fscDieselPercentChange = fscDieselPercentChange;
    }

    public void setFscPercentChange(BigDecimal fscPercentChange) {
        this.fscPercentChange = fscPercentChange;
    }

    public void setBaseDieselRateType(BaseDieselRateType baseDieselRateType) {
        this.baseDieselRateType = baseDieselRateType;
    }

    public void setBaseDieselRateDerivation(BaseDieselRateDerivation baseDieselRateDerivation) {
        this.baseDieselRateDerivation = baseDieselRateDerivation;
    }

    public void setDieselSource(DieselSource dieselSource) {
        this.dieselSource = dieselSource;
    }

    public void setDieselPrice(BigDecimal dieselPrice) {
        this.dieselPrice = dieselPrice;
    }

    public void setDieselRateCities(String dieselRateCities) {
        this.dieselRateCities = dieselRateCities;
    }

    public void setDieselRateAsOnDate(Long dieselRateAsOnDate) {
        this.dieselRateAsOnDate = dieselRateAsOnDate;
    }

    public void setBillingDieselRateCalculationType(BillingDieselRateCalculationType billingDieselRateCalculationType) {
        this.billingDieselRateCalculationType = billingDieselRateCalculationType;
    }

    public void setSpecificPeriodDays(String specificPeriodDays) {
        this.specificPeriodDays = specificPeriodDays;
    }

    public void setDieselBillingPeriod(DieselBillingPeriod dieselBillingPeriod) {
        this.dieselBillingPeriod = dieselBillingPeriod;
    }

    public void setToleranceBand(ToleranceBand toleranceBand) {
        this.toleranceBand = toleranceBand;
    }

    public void setToleranceType(ToleranceType toleranceType) {
        this.toleranceType = toleranceType;
    }

    public void setToleranceAmount(BigDecimal toleranceAmount) {
        this.toleranceAmount = toleranceAmount;
    }

    public void setNegativeFscBenefit(Boolean negativeFscBenefit) {
        this.negativeFscBenefit = negativeFscBenefit;
    }

    public void setBasicFreightChangeCriteria(BasicFreightChangeCriteria basicFreightChangeCriteria) {
        this.basicFreightChangeCriteria = basicFreightChangeCriteria;
    }

    public void setFscBasicFreightChangeSlabs(List<SlabDTO> fscBasicFreightChangeSlabs) {
        this.fscBasicFreightChangeSlabs = fscBasicFreightChangeSlabs;
    }

    public void setComponentsForFscCharge(String componentsForFscCharge) {
        this.componentsForFscCharge = componentsForFscCharge;
    }

    public void setGreenTaxChargeBasis(ChargeBasis greenTaxChargeBasis) {
        this.greenTaxChargeBasis = greenTaxChargeBasis;
    }

    public void setGreenTaxRatePerCn(BigDecimal greenTaxRatePerCn) {
        this.greenTaxRatePerCn = greenTaxRatePerCn;
    }

    public void setGreenTaxRatePerKg(BigDecimal greenTaxRatePerKg) {
        this.greenTaxRatePerKg = greenTaxRatePerKg;
    }

    public void setGreenTaxRatePerBox(BigDecimal greenTaxRatePerBox) {
        this.greenTaxRatePerBox = greenTaxRatePerBox;
    }

    public void setGreenTaxMinimumCharge(BigDecimal greenTaxMinimumCharge) {
        this.greenTaxMinimumCharge = greenTaxMinimumCharge;
    }

    public void setGreenTaxMaximumCharge(BigDecimal greenTaxMaximumCharge) {
        this.greenTaxMaximumCharge = greenTaxMaximumCharge;
    }

    public void setGreenTaxApplicableCity(GreenTaxApplicableCity greenTaxApplicableCity) {
        this.greenTaxApplicableCity = greenTaxApplicableCity;
    }

    public void setGreenTaxApplicabilityType(PickupDeliveryActivityBasis greenTaxApplicabilityType) {
        this.greenTaxApplicabilityType = greenTaxApplicabilityType;
    }

    public void setAppointmentDeliveryChargeBasis(ChargeBasis appointmentDeliveryChargeBasis) {
        this.appointmentDeliveryChargeBasis = appointmentDeliveryChargeBasis;
    }

    public void setAppointmentDeliveryRatePerCn(BigDecimal appointmentDeliveryRatePerCn) {
        this.appointmentDeliveryRatePerCn = appointmentDeliveryRatePerCn;
    }

    public void setAppointmentDeliveryRatePerKg(BigDecimal appointmentDeliveryRatePerKg) {
        this.appointmentDeliveryRatePerKg = appointmentDeliveryRatePerKg;
    }

    public void setAppointmentDeliveryMinimumCharge(BigDecimal appointmentDeliveryMinimumCharge) {
        this.appointmentDeliveryMinimumCharge = appointmentDeliveryMinimumCharge;
    }

    public void setAppointmentDeliveryMaximumCharge(BigDecimal appointmentDeliveryMaximumCharge) {
        this.appointmentDeliveryMaximumCharge = appointmentDeliveryMaximumCharge;
    }

    public void setSundayDeliveryChargeBasis(ChargeBasis sundayDeliveryChargeBasis) {
        this.sundayDeliveryChargeBasis = sundayDeliveryChargeBasis;
    }

    public void setSundayDeliveryRatePerCn(BigDecimal sundayDeliveryRatePerCn) {
        this.sundayDeliveryRatePerCn = sundayDeliveryRatePerCn;
    }

    public void setSundayDeliveryRatePerKg(BigDecimal sundayDeliveryRatePerKg) {
        this.sundayDeliveryRatePerKg = sundayDeliveryRatePerKg;
    }

    public void setSundayDeliveryRatePerBox(BigDecimal sundayDeliveryRatePerBox) {
        this.sundayDeliveryRatePerBox = sundayDeliveryRatePerBox;
    }

    public void setSundayDeliveryMinimumCharge(BigDecimal sundayDeliveryMinimumCharge) {
        this.sundayDeliveryMinimumCharge = sundayDeliveryMinimumCharge;
    }

    public void setSundayDeliveryMaximumCharge(BigDecimal sundayDeliveryMaximumCharge) {
        this.sundayDeliveryMaximumCharge = sundayDeliveryMaximumCharge;
    }

    public void setSundayDeliveryApplicabilityType(PickupDeliveryActivityBasis sundayDeliveryApplicabilityType) {
        this.sundayDeliveryApplicabilityType = sundayDeliveryApplicabilityType;
    }

    public void setMallDeliveryChargeBasis(ChargeBasis mallDeliveryChargeBasis) {
        this.mallDeliveryChargeBasis = mallDeliveryChargeBasis;
    }

    public void setMallDeliveryRatePerCn(BigDecimal mallDeliveryRatePerCn) {
        this.mallDeliveryRatePerCn = mallDeliveryRatePerCn;
    }

    public void setMallDeliveryRatePerKg(BigDecimal mallDeliveryRatePerKg) {
        this.mallDeliveryRatePerKg = mallDeliveryRatePerKg;
    }

    public void setMallDeliveryMinimumCharge(BigDecimal mallDeliveryMinimumCharge) {
        this.mallDeliveryMinimumCharge = mallDeliveryMinimumCharge;
    }

    public void setMallDeliveryMaximumCharge(BigDecimal mallDeliveryMaximumCharge) {
        this.mallDeliveryMaximumCharge = mallDeliveryMaximumCharge;
    }

    public void setCanteenDeliveryChargeBasis(ChargeBasis canteenDeliveryChargeBasis) {
        this.canteenDeliveryChargeBasis = canteenDeliveryChargeBasis;
    }

    public void setCanteenDeliveryRatePerCn(BigDecimal canteenDeliveryRatePerCn) {
        this.canteenDeliveryRatePerCn = canteenDeliveryRatePerCn;
    }

    public void setCanteenDeliveryRatePerKg(BigDecimal canteenDeliveryRatePerKg) {
        this.canteenDeliveryRatePerKg = canteenDeliveryRatePerKg;
    }

    public void setCanteenDeliveryMinimumCharge(BigDecimal canteenDeliveryMinimumCharge) {
        this.canteenDeliveryMinimumCharge = canteenDeliveryMinimumCharge;
    }

    public void setCanteenDeliveryMaximumCharge(BigDecimal canteenDeliveryMaximumCharge) {
        this.canteenDeliveryMaximumCharge = canteenDeliveryMaximumCharge;
    }

    public void setSezDeliveryChargeBasis(ChargeBasis sezDeliveryChargeBasis) {
        this.sezDeliveryChargeBasis = sezDeliveryChargeBasis;
    }

    public void setSezDeliveryRatePerCn(BigDecimal sezDeliveryRatePerCn) {
        this.sezDeliveryRatePerCn = sezDeliveryRatePerCn;
    }

    public void setSezDeliveryRatePerKg(BigDecimal sezDeliveryRatePerKg) {
        this.sezDeliveryRatePerKg = sezDeliveryRatePerKg;
    }

    public void setSezDeliveryMinimumCharge(BigDecimal sezDeliveryMinimumCharge) {
        this.sezDeliveryMinimumCharge = sezDeliveryMinimumCharge;
    }

    public void setSezDeliveryMaximumCharge(BigDecimal sezDeliveryMaximumCharge) {
        this.sezDeliveryMaximumCharge = sezDeliveryMaximumCharge;
    }

    public void setRailwayDeliveryChargeBasis(ChargeBasis railwayDeliveryChargeBasis) {
        this.railwayDeliveryChargeBasis = railwayDeliveryChargeBasis;
    }

    public void setRailwayDeliveryRatePerCn(BigDecimal railwayDeliveryRatePerCn) {
        this.railwayDeliveryRatePerCn = railwayDeliveryRatePerCn;
    }

    public void setRailwayDeliveryRatePerKg(BigDecimal railwayDeliveryRatePerKg) {
        this.railwayDeliveryRatePerKg = railwayDeliveryRatePerKg;
    }

    public void setRailwayDeliveryMinimumCharge(BigDecimal railwayDeliveryMinimumCharge) {
        this.railwayDeliveryMinimumCharge = railwayDeliveryMinimumCharge;
    }

    public void setRailwayDeliveryMaximumCharge(BigDecimal railwayDeliveryMaximumCharge) {
        this.railwayDeliveryMaximumCharge = railwayDeliveryMaximumCharge;
    }

    public void setGovernmentCompoundDeliveryChargeBasis(ChargeBasis governmentCompoundDeliveryChargeBasis) {
        this.governmentCompoundDeliveryChargeBasis = governmentCompoundDeliveryChargeBasis;
    }

    public void setGovernmentCompoundDeliveryRatePerCn(BigDecimal governmentCompoundDeliveryRatePerCn) {
        this.governmentCompoundDeliveryRatePerCn = governmentCompoundDeliveryRatePerCn;
    }

    public void setGovernmentCompoundDeliveryRatePerKg(BigDecimal governmentCompoundDeliveryRatePerKg) {
        this.governmentCompoundDeliveryRatePerKg = governmentCompoundDeliveryRatePerKg;
    }

    public void setGovernmentCompoundDeliveryMinimumCharge(BigDecimal governmentCompoundDeliveryMinimumCharge) {
        this.governmentCompoundDeliveryMinimumCharge = governmentCompoundDeliveryMinimumCharge;
    }

    public void setGovernmentCompoundDeliveryMaximumCharge(BigDecimal governmentCompoundDeliveryMaximumCharge) {
        this.governmentCompoundDeliveryMaximumCharge = governmentCompoundDeliveryMaximumCharge;
    }

    public void setLiquidHandlingChargeBasis(ChargeBasis liquidHandlingChargeBasis) {
        this.liquidHandlingChargeBasis = liquidHandlingChargeBasis;
    }

    public void setLiquidHandlingRatePerCn(BigDecimal liquidHandlingRatePerCn) {
        this.liquidHandlingRatePerCn = liquidHandlingRatePerCn;
    }

    public void setLiquidHandlingRatePerKg(BigDecimal liquidHandlingRatePerKg) {
        this.liquidHandlingRatePerKg = liquidHandlingRatePerKg;
    }

    public void setLiquidHandlingMinimumCharge(BigDecimal liquidHandlingMinimumCharge) {
        this.liquidHandlingMinimumCharge = liquidHandlingMinimumCharge;
    }

    public void setLiquidHandlingMaximumCharge(BigDecimal liquidHandlingMaximumCharge) {
        this.liquidHandlingMaximumCharge = liquidHandlingMaximumCharge;
    }

    public void setHazardousHandlingChargeBasis(ChargeBasis hazardousHandlingChargeBasis) {
        this.hazardousHandlingChargeBasis = hazardousHandlingChargeBasis;
    }

    public void setHazardousHandlingRatePerCn(BigDecimal hazardousHandlingRatePerCn) {
        this.hazardousHandlingRatePerCn = hazardousHandlingRatePerCn;
    }

    public void setHazardousHandlingRatePerKg(BigDecimal hazardousHandlingRatePerKg) {
        this.hazardousHandlingRatePerKg = hazardousHandlingRatePerKg;
    }

    public void setHazardousHandlingMinimumCharge(BigDecimal hazardousHandlingMinimumCharge) {
        this.hazardousHandlingMinimumCharge = hazardousHandlingMinimumCharge;
    }

    public void setHazardousHandlingMaximumCharge(BigDecimal hazardousHandlingMaximumCharge) {
        this.hazardousHandlingMaximumCharge = hazardousHandlingMaximumCharge;
    }

    public void setDeliveryReattemptChargeBasis(ChargeBasis deliveryReattemptChargeBasis) {
        this.deliveryReattemptChargeBasis = deliveryReattemptChargeBasis;
    }

    public void setDeliveryReattemptIsPerAttempt(Boolean deliveryReattemptIsPerAttempt) {
        this.deliveryReattemptIsPerAttempt = deliveryReattemptIsPerAttempt;
    }

    public void setDeliveryReattemptRatePerCn(BigDecimal deliveryReattemptRatePerCn) {
        this.deliveryReattemptRatePerCn = deliveryReattemptRatePerCn;
    }

    public void setDeliveryReattemptRatePerKg(BigDecimal deliveryReattemptRatePerKg) {
        this.deliveryReattemptRatePerKg = deliveryReattemptRatePerKg;
    }

    public void setDeliveryReattemptMinimumCharge(BigDecimal deliveryReattemptMinimumCharge) {
        this.deliveryReattemptMinimumCharge = deliveryReattemptMinimumCharge;
    }

    public void setDeliveryReattemptMaximumCharge(BigDecimal deliveryReattemptMaximumCharge) {
        this.deliveryReattemptMaximumCharge = deliveryReattemptMaximumCharge;
    }

    public void setHandlingChargesChargeBasis(ChargeBasis handlingChargesChargeBasis) {
        this.handlingChargesChargeBasis = handlingChargesChargeBasis;
    }

    public void setHandlingChargeWeightType(WeightType handlingChargeWeightType) {
        this.handlingChargeWeightType = handlingChargeWeightType;
    }

    public void setHandlingChargesRatePerCn(BigDecimal handlingChargesRatePerCn) {
        this.handlingChargesRatePerCn = handlingChargesRatePerCn;
    }

    public void setHandlingChargesRatePerKg(BigDecimal handlingChargesRatePerKg) {
        this.handlingChargesRatePerKg = handlingChargesRatePerKg;
    }

    public void setHandlingChargesRatePerBox(BigDecimal handlingChargesRatePerBox) {
        this.handlingChargesRatePerBox = handlingChargesRatePerBox;
    }

    public void setHandlingChargesMinimumCharge(BigDecimal handlingChargesMinimumCharge) {
        this.handlingChargesMinimumCharge = handlingChargesMinimumCharge;
    }

    public void setHandlingChargesMaximumCharge(BigDecimal handlingChargesMaximumCharge) {
        this.handlingChargesMaximumCharge = handlingChargesMaximumCharge;
    }

    public void setHandlingChargesRatePerKgPerBoxSlabs(List<SlabDTO> handlingChargesRatePerKgPerBoxSlabs) {
        this.handlingChargesRatePerKgPerBoxSlabs = handlingChargesRatePerKgPerBoxSlabs;
    }

    public void setHandlingChargesRatePerBoxSlabs(List<SlabDTO> handlingChargesRatePerBoxSlabs) {
        this.handlingChargesRatePerBoxSlabs = handlingChargesRatePerBoxSlabs;
    }

    public void setHandlingChargesRatePerKgSlabs(List<SlabDTO> handlingChargesRatePerKgSlabs) {
        this.handlingChargesRatePerKgSlabs = handlingChargesRatePerKgSlabs;
    }

    public void setOdcHandlingChargesChargeBasis(ChargeBasis odcHandlingChargesChargeBasis) {
        this.odcHandlingChargesChargeBasis = odcHandlingChargesChargeBasis;
    }

    public void setOdcHandlingChargesRatePerKg(BigDecimal odcHandlingChargesRatePerKg) {
        this.odcHandlingChargesRatePerKg = odcHandlingChargesRatePerKg;
    }

    public void setOdcHandlingChargesRatePerBox(BigDecimal odcHandlingChargesRatePerBox) {
        this.odcHandlingChargesRatePerBox = odcHandlingChargesRatePerBox;
    }

    public void setOdcHandlingChargesMinimumCharge(BigDecimal odcHandlingChargesMinimumCharge) {
        this.odcHandlingChargesMinimumCharge = odcHandlingChargesMinimumCharge;
    }

    public void setOdcHandlingChargesMaximumCharge(BigDecimal odcHandlingChargesMaximumCharge) {
        this.odcHandlingChargesMaximumCharge = odcHandlingChargesMaximumCharge;
    }

    public void setValueHandlingChargesChargeBasis(ChargeBasis valueHandlingChargesChargeBasis) {
        this.valueHandlingChargesChargeBasis = valueHandlingChargesChargeBasis;
    }

    public void setValueHandlingChargesRatePerKgCutoff(BigDecimal valueHandlingChargesRatePerKgCutoff) {
        this.valueHandlingChargesRatePerKgCutoff = valueHandlingChargesRatePerKgCutoff;
    }

    public void setValueHandlingChargesCustomerInvoicePercentage(BigDecimal valueHandlingChargesCustomerInvoicePercentage) {
        this.valueHandlingChargesCustomerInvoicePercentage = valueHandlingChargesCustomerInvoicePercentage;
    }

    public void setValueHandlingChargesMinimumCharge(BigDecimal valueHandlingChargesMinimumCharge) {
        this.valueHandlingChargesMinimumCharge = valueHandlingChargesMinimumCharge;
    }

    public void setValueHandlingChargesMaximumCharge(BigDecimal valueHandlingChargesMaximumCharge) {
        this.valueHandlingChargesMaximumCharge = valueHandlingChargesMaximumCharge;
    }

    public void setHigherFloorChargesIsPerFloor(Boolean higherFloorChargesIsPerFloor) {
        this.higherFloorChargesIsPerFloor = higherFloorChargesIsPerFloor;
    }

    public void setHigherFloorActivityBasis(PickupDeliveryActivityBasis higherFloorActivityBasis) {
        this.higherFloorActivityBasis = higherFloorActivityBasis;
    }

    public void setHigherFloorDeliveryChargeBasis(ChargeBasis higherFloorDeliveryChargeBasis) {
        this.higherFloorDeliveryChargeBasis = higherFloorDeliveryChargeBasis;
    }

    public void setHigherFloorDeliveryRatePerCn(BigDecimal higherFloorDeliveryRatePerCn) {
        this.higherFloorDeliveryRatePerCn = higherFloorDeliveryRatePerCn;
    }

    public void setHigherFloorDeliveryRatePerKg(BigDecimal higherFloorDeliveryRatePerKg) {
        this.higherFloorDeliveryRatePerKg = higherFloorDeliveryRatePerKg;
    }

    public void setHigherFloorDeliveryRatePerBox(BigDecimal higherFloorDeliveryRatePerBox) {
        this.higherFloorDeliveryRatePerBox = higherFloorDeliveryRatePerBox;
    }

    public void setHigherFloorDeliveryMinimumCharge(BigDecimal higherFloorDeliveryMinimumCharge) {
        this.higherFloorDeliveryMinimumCharge = higherFloorDeliveryMinimumCharge;
    }

    public void setHigherFloorDeliveryMaximumCharge(BigDecimal higherFloorDeliveryMaximumCharge) {
        this.higherFloorDeliveryMaximumCharge = higherFloorDeliveryMaximumCharge;
    }

    public void setHigherFloorDeliveryRatePerKgSlabs(List<SlabDTO> higherFloorDeliveryRatePerKgSlabs) {
        this.higherFloorDeliveryRatePerKgSlabs = higherFloorDeliveryRatePerKgSlabs;
    }

    public void setHigherFloorDeliveryRatePerBoxSlabs(List<SlabDTO> higherFloorDeliveryRatePerBoxSlabs) {
        this.higherFloorDeliveryRatePerBoxSlabs = higherFloorDeliveryRatePerBoxSlabs;
    }

    public void setHigherFloorExclusionFloors(Integer higherFloorExclusionFloors) {
        this.higherFloorExclusionFloors = higherFloorExclusionFloors;
    }

    public void setOdaChargeBasis(ChargeBasis odaChargeBasis) {
        this.odaChargeBasis = odaChargeBasis;
    }

    public void setOdaType(ODAType odaType) {
        this.odaType = odaType;
    }

    public void setOda1RatePerCn(BigDecimal oda1RatePerCn) {
        this.oda1RatePerCn = oda1RatePerCn;
    }

    public void setOda2RatePerCn(BigDecimal oda2RatePerCn) {
        this.oda2RatePerCn = oda2RatePerCn;
    }

    public void setOda3RatePerCn(BigDecimal oda3RatePerCn) {
        this.oda3RatePerCn = oda3RatePerCn;
    }

    public void setOda4RatePerCn(BigDecimal oda4RatePerCn) {
        this.oda4RatePerCn = oda4RatePerCn;
    }

    public void setOda5RatePerCn(BigDecimal oda5RatePerCn) {
        this.oda5RatePerCn = oda5RatePerCn;
    }

    public void setOda6RatePerCn(BigDecimal oda6RatePerCn) {
        this.oda6RatePerCn = oda6RatePerCn;
    }

    public void setOda7RatePerCn(BigDecimal oda7RatePerCn) {
        this.oda7RatePerCn = oda7RatePerCn;
    }

    public void setOda1RatePerKgSlabs(List<SlabDTO> oda1RatePerKgSlabs) {
        this.oda1RatePerKgSlabs = oda1RatePerKgSlabs;
    }

    public void setOda2RatePerKgSlabs(List<SlabDTO> oda2RatePerKgSlabs) {
        this.oda2RatePerKgSlabs = oda2RatePerKgSlabs;
    }

    public void setOda3RatePerKgSlabs(List<SlabDTO> oda3RatePerKgSlabs) {
        this.oda3RatePerKgSlabs = oda3RatePerKgSlabs;
    }

    public void setOda4RatePerKgSlabs(List<SlabDTO> oda4RatePerKgSlabs) {
        this.oda4RatePerKgSlabs = oda4RatePerKgSlabs;
    }

    public void setOda5RatePerKgSlabs(List<SlabDTO> oda5RatePerKgSlabs) {
        this.oda5RatePerKgSlabs = oda5RatePerKgSlabs;
    }

    public void setOda6RatePerKgSlabs(List<SlabDTO> oda6RatePerKgSlabs) {
        this.oda6RatePerKgSlabs = oda6RatePerKgSlabs;
    }

    public void setOda7RatePerKgSlabs(List<SlabDTO> oda7RatePerKgSlabs) {
        this.oda7RatePerKgSlabs = oda7RatePerKgSlabs;
    }

    public void setOdaExemptionApplicability(boolean odaExemptionApplicability) {
        this.odaExemptionApplicability = odaExemptionApplicability;
    }

    public void setOdaExemptedPincodes(String odaExemptedPincodes) {
        this.odaExemptedPincodes = odaExemptedPincodes;
    }

    public void setOpaChargeBasis(ChargeBasis opaChargeBasis) {
        this.opaChargeBasis = opaChargeBasis;
    }

    public void setCategoryVsOpaField(Map<String, OPAField> categoryVsOpaField) {
        this.categoryVsOpaField = categoryVsOpaField;
    }

    public void setExceptionalPincodes(Map<String, BigDecimal> exceptionalPincodes) {
        this.exceptionalPincodes = exceptionalPincodes;
    }

    public void setOpaExceptionApplicability(boolean opaExceptionApplicability) {
        this.opaExceptionApplicability = opaExceptionApplicability;
    }

    public void setFodChargeBasis(ChargeBasis fodChargeBasis) {
        this.fodChargeBasis = fodChargeBasis;
    }

    public void setFodPerCn(BigDecimal fodPerCn) {
        this.fodPerCn = fodPerCn;
    }

    public void setFodPerKg(BigDecimal fodPerKg) {
        this.fodPerKg = fodPerKg;
    }

    public void setFodMinimumCharge(BigDecimal fodMinimumCharge) {
        this.fodMinimumCharge = fodMinimumCharge;
    }

    public void setFodMaximumCharge(BigDecimal fodMaximumCharge) {
        this.fodMaximumCharge = fodMaximumCharge;
    }

    public void setFodPerBox(BigDecimal fodPerBox) {
        this.fodPerBox = fodPerBox;
    }

    public void setMetroCongestionChargeBasis(ChargeBasis metroCongestionChargeBasis) {
        this.metroCongestionChargeBasis = metroCongestionChargeBasis;
    }

    public void setMetroCongestionPerCn(BigDecimal metroCongestionPerCn) {
        this.metroCongestionPerCn = metroCongestionPerCn;
    }

    public void setMetroCongestionPerKg(BigDecimal metroCongestionPerKg) {
        this.metroCongestionPerKg = metroCongestionPerKg;
    }

    public void setMetroCongestionMinimumCharge(BigDecimal metroCongestionMinimumCharge) {
        this.metroCongestionMinimumCharge = metroCongestionMinimumCharge;
    }

    public void setMetroCongestionMaximumCharge(BigDecimal metroCongestionMaximumCharge) {
        this.metroCongestionMaximumCharge = metroCongestionMaximumCharge;
    }

    public void setMetroCongestionPerBox(BigDecimal metroCongestionPerBox) {
        this.metroCongestionPerBox = metroCongestionPerBox;
    }

    public void setHardRegionChargeBasis(ChargeBasis hardRegionChargeBasis) {
        this.hardRegionChargeBasis = hardRegionChargeBasis;
    }

    public void setHardRegionPerCn(BigDecimal hardRegionPerCn) {
        this.hardRegionPerCn = hardRegionPerCn;
    }

    public void setHardRegionPerKg(BigDecimal hardRegionPerKg) {
        this.hardRegionPerKg = hardRegionPerKg;
    }

    public void setHardRegionMinimumCharge(BigDecimal hardRegionMinimumCharge) {
        this.hardRegionMinimumCharge = hardRegionMinimumCharge;
    }

    public void setHardRegionMaximumCharge(BigDecimal hardRegionMaximumCharge) {
        this.hardRegionMaximumCharge = hardRegionMaximumCharge;
    }

    public void setHardRegionPerBox(BigDecimal hardRegionPerBox) {
        this.hardRegionPerBox = hardRegionPerBox;
    }

    public void setSpecialZoneChargeBasis(ChargeBasis specialZoneChargeBasis) {
        this.specialZoneChargeBasis = specialZoneChargeBasis;
    }

    public void setSpecialZonePerCn(BigDecimal specialZonePerCn) {
        this.specialZonePerCn = specialZonePerCn;
    }

    public void setSpecialZonePerKg(BigDecimal specialZonePerKg) {
        this.specialZonePerKg = specialZonePerKg;
    }

    public void setSpecialZoneMinimumCharge(BigDecimal specialZoneMinimumCharge) {
        this.specialZoneMinimumCharge = specialZoneMinimumCharge;
    }

    public void setSpecialZoneMaximumCharge(BigDecimal specialZoneMaximumCharge) {
        this.specialZoneMaximumCharge = specialZoneMaximumCharge;
    }

    public void setSpecialZonePerBox(BigDecimal specialZonePerBox) {
        this.specialZonePerBox = specialZonePerBox;
    }

    public void setInfrastructureDevelopmentChargeBasis(ChargeBasis infrastructureDevelopmentChargeBasis) {
        this.infrastructureDevelopmentChargeBasis = infrastructureDevelopmentChargeBasis;
    }

    public void setInfrastructureDevelopmentRatePerChargeBasis(BigDecimal infrastructureDevelopmentRatePerChargeBasis) {
        this.infrastructureDevelopmentRatePerChargeBasis = infrastructureDevelopmentRatePerChargeBasis;
    }

    public void setInfrastructureDevelopmentChargeComponent(String infrastructureDevelopmentChargeComponent) {
        this.infrastructureDevelopmentChargeComponent = infrastructureDevelopmentChargeComponent;
    }

    public void setBdSurchargeChargeBasis(ChargeBasis bdSurchargeChargeBasis) {
        this.bdSurchargeChargeBasis = bdSurchargeChargeBasis;
    }

    public void setBdSurchargePercentageFreight(BigDecimal bdSurchargePercentageFreight) {
        this.bdSurchargePercentageFreight = bdSurchargePercentageFreight;
    }

    public void setCodDodChargeBasis(ChargeBasis codDodChargeBasis) {
        this.codDodChargeBasis = codDodChargeBasis;
    }

    public void setCodDodPerCn(BigDecimal codDodPerCn) {
        this.codDodPerCn = codDodPerCn;
    }

    public void setCodDodPercentageFreight(BigDecimal codDodPercentageFreight) {
        this.codDodPercentageFreight = codDodPercentageFreight;
    }

    public void setCodDodMin(BigDecimal codDodMin) {
        this.codDodMin = codDodMin;
    }

    public void setCodDodMax(BigDecimal codDodMax) {
        this.codDodMax = codDodMax;
    }

    public void setClientAccountNumber(String clientAccountNumber) {
        this.clientAccountNumber = clientAccountNumber;
    }

    public void setCodDodCreditCardChargeMin(BigDecimal codDodCreditCardChargeMin) {
        this.codDodCreditCardChargeMin = codDodCreditCardChargeMin;
    }

    public void setCodDodDebitCardChargeMin(BigDecimal codDodDebitCardChargeMin) {
        this.codDodDebitCardChargeMin = codDodDebitCardChargeMin;
    }

    public void setCodDodNetbankingChargeMin(BigDecimal codDodNetbankingChargeMin) {
        this.codDodNetbankingChargeMin = codDodNetbankingChargeMin;
    }

    public void setCodDodNeftChargeMin(BigDecimal codDodNeftChargeMin) {
        this.codDodNeftChargeMin = codDodNeftChargeMin;
    }

    public void setCodDodRtgsChargeMin(BigDecimal codDodRtgsChargeMin) {
        this.codDodRtgsChargeMin = codDodRtgsChargeMin;
    }

    public void setCodDodImpsChargeMin(BigDecimal codDodImpsChargeMin) {
        this.codDodImpsChargeMin = codDodImpsChargeMin;
    }

    public void setCodDodUpiChargeMin(BigDecimal codDodUpiChargeMin) {
        this.codDodUpiChargeMin = codDodUpiChargeMin;
    }

    public void setCodDodCreditCardPercentage(BigDecimal codDodCreditCardPercentage) {
        this.codDodCreditCardPercentage = codDodCreditCardPercentage;
    }

    public void setCodDodDebitCardPercentage(BigDecimal codDodDebitCardPercentage) {
        this.codDodDebitCardPercentage = codDodDebitCardPercentage;
    }

    public void setCodDodNetbankingPercentage(BigDecimal codDodNetbankingPercentage) {
        this.codDodNetbankingPercentage = codDodNetbankingPercentage;
    }

    public void setCodDodNeftPercentage(BigDecimal codDodNeftPercentage) {
        this.codDodNeftPercentage = codDodNeftPercentage;
    }

    public void setCodDodRtgsPercentage(BigDecimal codDodRtgsPercentage) {
        this.codDodRtgsPercentage = codDodRtgsPercentage;
    }

    public void setCodDodImpsPercentage(BigDecimal codDodImpsPercentage) {
        this.codDodImpsPercentage = codDodImpsPercentage;
    }

    public void setCodDodUpiPercentage(BigDecimal codDodUpiPercentage) {
        this.codDodUpiPercentage = codDodUpiPercentage;
    }

    public void setCodDodCreditCardChargeMax(BigDecimal codDodCreditCardChargeMax) {
        this.codDodCreditCardChargeMax = codDodCreditCardChargeMax;
    }

    public void setCodDodDebitCardChargeMax(BigDecimal codDodDebitCardChargeMax) {
        this.codDodDebitCardChargeMax = codDodDebitCardChargeMax;
    }

    public void setCodDodNetbankingChargeMax(BigDecimal codDodNetbankingChargeMax) {
        this.codDodNetbankingChargeMax = codDodNetbankingChargeMax;
    }

    public void setCodDodNeftChargeMax(BigDecimal codDodNeftChargeMax) {
        this.codDodNeftChargeMax = codDodNeftChargeMax;
    }

    public void setCodDodRtgsChargeMax(BigDecimal codDodRtgsChargeMax) {
        this.codDodRtgsChargeMax = codDodRtgsChargeMax;
    }

    public void setCodDodImpsChargeMax(BigDecimal codDodImpsChargeMax) {
        this.codDodImpsChargeMax = codDodImpsChargeMax;
    }

    public void setCodDodUpiChargeMax(BigDecimal codDodUpiChargeMax) {
        this.codDodUpiChargeMax = codDodUpiChargeMax;
    }

    public void setCodDodModeVsExceptionalCharge(Map<CodDodOnlinePaymentMode, List<CodDodExceptionalCharge>> codDodModeVsExceptionalCharge) {
        this.codDodModeVsExceptionalCharge = codDodModeVsExceptionalCharge;
    }

    public void setDaccChargeBasis(ChargeBasis daccChargeBasis) {
        this.daccChargeBasis = daccChargeBasis;
    }

    public void setDaccRatePerCn(BigDecimal daccRatePerCn) {
        this.daccRatePerCn = daccRatePerCn;
    }

    public void setDaccRatePerKg(BigDecimal daccRatePerKg) {
        this.daccRatePerKg = daccRatePerKg;
    }

    public void setDaccMinimumCharge(BigDecimal daccMinimumCharge) {
        this.daccMinimumCharge = daccMinimumCharge;
    }

    public void setDaccMaximumCharge(BigDecimal daccMaximumCharge) {
        this.daccMaximumCharge = daccMaximumCharge;
    }

    public void setDemurrageChargeBasis(ChargeBasis demurrageChargeBasis) {
        this.demurrageChargeBasis = demurrageChargeBasis;
    }

    public void setDemurrageExclusionHours(BigDecimal demurrageExclusionHours) {
        this.demurrageExclusionHours = demurrageExclusionHours;
    }

    public void setDemurrageRatePerCn(BigDecimal demurrageRatePerCn) {
        this.demurrageRatePerCn = demurrageRatePerCn;
    }

    public void setDemurrageRatePerKg(BigDecimal demurrageRatePerKg) {
        this.demurrageRatePerKg = demurrageRatePerKg;
    }

    public void setDemurragePercentageFreight(BigDecimal demurragePercentageFreight) {
        this.demurragePercentageFreight = demurragePercentageFreight;
    }

    public void setDemurrageRatePerCnSlab(List<SlabDTO> demurrageRatePerCnSlab) {
        this.demurrageRatePerCnSlab = demurrageRatePerCnSlab;
    }

    public void setDemurragePercentageFreightSlab(List<SlabDTO> demurragePercentageFreightSlab) {
        this.demurragePercentageFreightSlab = demurragePercentageFreightSlab;
    }

    public void setDemurrageRatePerKgSlab(List<SlabDTO> demurrageRatePerKgSlab) {
        this.demurrageRatePerKgSlab = demurrageRatePerKgSlab;
    }

    public void setHardCopyPodChargeBasis(ChargeBasis hardCopyPodChargeBasis) {
        this.hardCopyPodChargeBasis = hardCopyPodChargeBasis;
    }

    public void setHardCopyPodPerCn(BigDecimal hardCopyPodPerCn) {
        this.hardCopyPodPerCn = hardCopyPodPerCn;
    }

    public void setUnionWaraiMathadiChargeBasis(ChargeBasis unionWaraiMathadiChargeBasis) {
        this.unionWaraiMathadiChargeBasis = unionWaraiMathadiChargeBasis;
    }

    public void setUnionWaraiMathadiChargePerUnit(BigDecimal unionWaraiMathadiChargePerUnit) {
        this.unionWaraiMathadiChargePerUnit = unionWaraiMathadiChargePerUnit;
    }

    public void setUnionWaraiMathadiMinCharge(BigDecimal unionWaraiMathadiMinCharge) {
        this.unionWaraiMathadiMinCharge = unionWaraiMathadiMinCharge;
    }

    public void setUnionWaraiMathadiMaxCharge(BigDecimal unionWaraiMathadiMaxCharge) {
        this.unionWaraiMathadiMaxCharge = unionWaraiMathadiMaxCharge;
    }

    public void setUnionWaraiMathadiActivityBasis(PickupDeliveryActivityBasis unionWaraiMathadiActivityBasis) {
        this.unionWaraiMathadiActivityBasis = unionWaraiMathadiActivityBasis;
    }

    public void setDedicatedVehicleChargeBasis(ChargeBasis dedicatedVehicleChargeBasis) {
        this.dedicatedVehicleChargeBasis = dedicatedVehicleChargeBasis;
    }

    public void setDedicatedVehicleChargePerUnit(BigDecimal dedicatedVehicleChargePerUnit) {
        this.dedicatedVehicleChargePerUnit = dedicatedVehicleChargePerUnit;
    }

    public void setDedicatedVehicleMinCharge(BigDecimal dedicatedVehicleMinCharge) {
        this.dedicatedVehicleMinCharge = dedicatedVehicleMinCharge;
    }

    public void setDedicatedVehicleMaxCharge(BigDecimal dedicatedVehicleMaxCharge) {
        this.dedicatedVehicleMaxCharge = dedicatedVehicleMaxCharge;
    }

    public void setDedicatedVehicleActivityBasis(PickupDeliveryActivityBasis dedicatedVehicleActivityBasis) {
        this.dedicatedVehicleActivityBasis = dedicatedVehicleActivityBasis;
    }

    public void setMaterialHandlingEquipmentChargeBasis(ChargeBasis materialHandlingEquipmentChargeBasis) {
        this.materialHandlingEquipmentChargeBasis = materialHandlingEquipmentChargeBasis;
    }

    public void setMaterialHandlingEquipmentChargePerUnit(BigDecimal materialHandlingEquipmentChargePerUnit) {
        this.materialHandlingEquipmentChargePerUnit = materialHandlingEquipmentChargePerUnit;
    }

    public void setMaterialHandlingEquipmentMinCharge(BigDecimal materialHandlingEquipmentMinCharge) {
        this.materialHandlingEquipmentMinCharge = materialHandlingEquipmentMinCharge;
    }

    public void setMaterialHandlingEquipmentMaxCharge(BigDecimal materialHandlingEquipmentMaxCharge) {
        this.materialHandlingEquipmentMaxCharge = materialHandlingEquipmentMaxCharge;
    }

    public void setMaterialHandlingEquipmentActivityBasis(PickupDeliveryActivityBasis materialHandlingEquipmentActivityBasis) {
        this.materialHandlingEquipmentActivityBasis = materialHandlingEquipmentActivityBasis;
    }

    public void setClientFields(List<CustomField> clientFields) {
        this.clientFields = clientFields;
    }

    public ContractDetailsDTO() {
    }

    public String toString() {
        return "ContractDetailsDTO(code=" + this.getCode() + ", type=" + this.getType() + ", serviceType=" + this.getServiceType() + ", billingCycle=" + this.getBillingCycle() + ", creditPeriod=" + this.getCreditPeriod() + ", expiryTimestamp=" + this.getExpiryTimestamp() + ", createdTimestamp=" + this.getCreatedTimestamp() + ", updatedTimestamp=" + this.getUpdatedTimestamp() + ", clientCode=" + this.getClientCode() + ", clientDTO=" + this.getClientDTO() + ", modeOfPayment=" + (Object)((Object)this.getModeOfPayment()) + ", latePaymentInterest=" + (Object)((Object)this.getLatePaymentInterest()) + ", interestOnLatePayment=" + this.getInterestOnLatePayment() + ", podRequirement=" + (Object)((Object)this.getPodRequirement()) + ", billingAnnexureTemplate=" + (Object)((Object)this.getBillingAnnexureTemplate()) + ", contractObligation=" + (Object)((Object)this.getContractObligation()) + ", minimumWeightPerCn=" + this.getMinimumWeightPerCn() + ", minimumFreightPerCn=" + this.getMinimumFreightPerCn() + ", chargeWeightBasis=" + (Object)((Object)this.getChargeWeightBasis()) + ", minimumWeightPerBox=" + this.getMinimumWeightPerBox() + ", cft=" + this.getCft() + ", lightCft=" + this.getLightCft() + ", denseCft=" + this.getDenseCft() + ", roundingFactor=" + (Object)((Object)this.getRoundingFactor()) + ", contractObligationLocationType=" + (Object)((Object)this.getContractObligationLocationType()) + ", locationToMinWeightMap=" + this.getLocationToMinWeightMap() + ", locationToMinFreightMap=" + this.getLocationToMinFreightMap() + ", processingChargesChargeBasis=" + (Object)((Object)this.getProcessingChargesChargeBasis()) + ", processingChargesPerCn=" + this.getProcessingChargesPerCn() + ", consignmentLiability=" + this.getConsignmentLiability() + ", maximumLiability=" + this.getMaximumLiability() + ", fovChargeBasis=" + (Object)((Object)this.getFovChargeBasis()) + ", fovValue=" + (Object)((Object)this.getFovValue()) + ", clientFovPerCn=" + this.getClientFovPerCn() + ", clientFovPerCnFragile=" + this.getClientFovPerCnFragile() + ", clientFovPerCnNonFragile=" + this.getClientFovPerCnNonFragile() + ", clientFovPercentage=" + this.getClientFovPercentage() + ", clientFovPercentageFragile=" + this.getClientFovPercentageFragile() + ", clientFovPercentageNonFragile=" + this.getClientFovPercentageNonFragile() + ", clientFovMaxCharge=" + this.getClientFovMaxCharge() + ", clientFovMaxChargeFragile=" + this.getClientFovMaxChargeFragile() + ", clientFovMaxChargeNonFragile=" + this.getClientFovMaxChargeNonFragile() + ", clientFovMinCharge=" + this.getClientFovMinCharge() + ", clientFovMinChargeFragile=" + this.getClientFovMinChargeFragile() + ", clientFovMinChargeNonFragile=" + this.getClientFovMinChargeNonFragile() + ", rcsPercentageFragile=" + this.getRcsPercentageFragile() + ", rcsPercentageNonFragile=" + this.getRcsPercentageNonFragile() + ", rcsMaxCharge=" + this.getRcsMaxCharge() + ", rcsMaxChargeFragile=" + this.getRcsMaxChargeFragile() + ", rcsMaxChargeNonFragile=" + this.getRcsMaxChargeNonFragile() + ", rcsMinCharge=" + this.getRcsMinCharge() + ", rcsMinChargeFragile=" + this.getRcsMinChargeFragile() + ", rcsMinChargeNonFragile=" + this.getRcsMinChargeNonFragile() + ", fscPercentage=" + this.getFscPercentage() + ", fuelLinkageChargeBasis=" + (Object)((Object)this.getFuelLinkageChargeBasis()) + ", fuelLinkageCriteria=" + (Object)((Object)this.getFuelLinkageCriteria()) + ", fscDieselPercentChange=" + this.getFscDieselPercentChange() + ", fscPercentChange=" + this.getFscPercentChange() + ", baseDieselRateType=" + (Object)((Object)this.getBaseDieselRateType()) + ", baseDieselRateDerivation=" + (Object)((Object)this.getBaseDieselRateDerivation()) + ", dieselSource=" + this.getDieselSource() + ", dieselPrice=" + this.getDieselPrice() + ", dieselRateCities=" + this.getDieselRateCities() + ", dieselRateAsOnDate=" + this.getDieselRateAsOnDate() + ", billingDieselRateCalculationType=" + (Object)((Object)this.getBillingDieselRateCalculationType()) + ", specificPeriodDays=" + this.getSpecificPeriodDays() + ", dieselBillingPeriod=" + (Object)((Object)this.getDieselBillingPeriod()) + ", toleranceBand=" + (Object)((Object)this.getToleranceBand()) + ", toleranceType=" + (Object)((Object)this.getToleranceType()) + ", toleranceAmount=" + this.getToleranceAmount() + ", negativeFscBenefit=" + this.getNegativeFscBenefit() + ", basicFreightChangeCriteria=" + (Object)((Object)this.getBasicFreightChangeCriteria()) + ", fscBasicFreightChangeSlabs=" + this.getFscBasicFreightChangeSlabs() + ", componentsForFscCharge=" + this.getComponentsForFscCharge() + ", greenTaxChargeBasis=" + (Object)((Object)this.getGreenTaxChargeBasis()) + ", greenTaxRatePerCn=" + this.getGreenTaxRatePerCn() + ", greenTaxRatePerKg=" + this.getGreenTaxRatePerKg() + ", greenTaxRatePerBox=" + this.getGreenTaxRatePerBox() + ", greenTaxMinimumCharge=" + this.getGreenTaxMinimumCharge() + ", greenTaxMaximumCharge=" + this.getGreenTaxMaximumCharge() + ", greenTaxApplicableCity=" + this.getGreenTaxApplicableCity() + ", greenTaxApplicabilityType=" + (Object)((Object)this.getGreenTaxApplicabilityType()) + ", appointmentDeliveryChargeBasis=" + (Object)((Object)this.getAppointmentDeliveryChargeBasis()) + ", appointmentDeliveryRatePerCn=" + this.getAppointmentDeliveryRatePerCn() + ", appointmentDeliveryRatePerKg=" + this.getAppointmentDeliveryRatePerKg() + ", appointmentDeliveryMinimumCharge=" + this.getAppointmentDeliveryMinimumCharge() + ", appointmentDeliveryMaximumCharge=" + this.getAppointmentDeliveryMaximumCharge() + ", sundayDeliveryChargeBasis=" + (Object)((Object)this.getSundayDeliveryChargeBasis()) + ", sundayDeliveryRatePerCn=" + this.getSundayDeliveryRatePerCn() + ", sundayDeliveryRatePerKg=" + this.getSundayDeliveryRatePerKg() + ", sundayDeliveryRatePerBox=" + this.getSundayDeliveryRatePerBox() + ", sundayDeliveryMinimumCharge=" + this.getSundayDeliveryMinimumCharge() + ", sundayDeliveryMaximumCharge=" + this.getSundayDeliveryMaximumCharge() + ", sundayDeliveryApplicabilityType=" + (Object)((Object)this.getSundayDeliveryApplicabilityType()) + ", mallDeliveryChargeBasis=" + (Object)((Object)this.getMallDeliveryChargeBasis()) + ", mallDeliveryRatePerCn=" + this.getMallDeliveryRatePerCn() + ", mallDeliveryRatePerKg=" + this.getMallDeliveryRatePerKg() + ", mallDeliveryMinimumCharge=" + this.getMallDeliveryMinimumCharge() + ", mallDeliveryMaximumCharge=" + this.getMallDeliveryMaximumCharge() + ", canteenDeliveryChargeBasis=" + (Object)((Object)this.getCanteenDeliveryChargeBasis()) + ", canteenDeliveryRatePerCn=" + this.getCanteenDeliveryRatePerCn() + ", canteenDeliveryRatePerKg=" + this.getCanteenDeliveryRatePerKg() + ", canteenDeliveryMinimumCharge=" + this.getCanteenDeliveryMinimumCharge() + ", canteenDeliveryMaximumCharge=" + this.getCanteenDeliveryMaximumCharge() + ", sezDeliveryChargeBasis=" + (Object)((Object)this.getSezDeliveryChargeBasis()) + ", sezDeliveryRatePerCn=" + this.getSezDeliveryRatePerCn() + ", sezDeliveryRatePerKg=" + this.getSezDeliveryRatePerKg() + ", sezDeliveryMinimumCharge=" + this.getSezDeliveryMinimumCharge() + ", sezDeliveryMaximumCharge=" + this.getSezDeliveryMaximumCharge() + ", railwayDeliveryChargeBasis=" + (Object)((Object)this.getRailwayDeliveryChargeBasis()) + ", railwayDeliveryRatePerCn=" + this.getRailwayDeliveryRatePerCn() + ", railwayDeliveryRatePerKg=" + this.getRailwayDeliveryRatePerKg() + ", railwayDeliveryMinimumCharge=" + this.getRailwayDeliveryMinimumCharge() + ", railwayDeliveryMaximumCharge=" + this.getRailwayDeliveryMaximumCharge() + ", governmentCompoundDeliveryChargeBasis=" + (Object)((Object)this.getGovernmentCompoundDeliveryChargeBasis()) + ", governmentCompoundDeliveryRatePerCn=" + this.getGovernmentCompoundDeliveryRatePerCn() + ", governmentCompoundDeliveryRatePerKg=" + this.getGovernmentCompoundDeliveryRatePerKg() + ", governmentCompoundDeliveryMinimumCharge=" + this.getGovernmentCompoundDeliveryMinimumCharge() + ", governmentCompoundDeliveryMaximumCharge=" + this.getGovernmentCompoundDeliveryMaximumCharge() + ", liquidHandlingChargeBasis=" + (Object)((Object)this.getLiquidHandlingChargeBasis()) + ", liquidHandlingRatePerCn=" + this.getLiquidHandlingRatePerCn() + ", liquidHandlingRatePerKg=" + this.getLiquidHandlingRatePerKg() + ", liquidHandlingMinimumCharge=" + this.getLiquidHandlingMinimumCharge() + ", liquidHandlingMaximumCharge=" + this.getLiquidHandlingMaximumCharge() + ", hazardousHandlingChargeBasis=" + (Object)((Object)this.getHazardousHandlingChargeBasis()) + ", hazardousHandlingRatePerCn=" + this.getHazardousHandlingRatePerCn() + ", hazardousHandlingRatePerKg=" + this.getHazardousHandlingRatePerKg() + ", hazardousHandlingMinimumCharge=" + this.getHazardousHandlingMinimumCharge() + ", hazardousHandlingMaximumCharge=" + this.getHazardousHandlingMaximumCharge() + ", deliveryReattemptChargeBasis=" + (Object)((Object)this.getDeliveryReattemptChargeBasis()) + ", deliveryReattemptIsPerAttempt=" + this.getDeliveryReattemptIsPerAttempt() + ", deliveryReattemptRatePerCn=" + this.getDeliveryReattemptRatePerCn() + ", deliveryReattemptRatePerKg=" + this.getDeliveryReattemptRatePerKg() + ", deliveryReattemptMinimumCharge=" + this.getDeliveryReattemptMinimumCharge() + ", deliveryReattemptMaximumCharge=" + this.getDeliveryReattemptMaximumCharge() + ", handlingChargesChargeBasis=" + (Object)((Object)this.getHandlingChargesChargeBasis()) + ", handlingChargeWeightType=" + (Object)((Object)this.getHandlingChargeWeightType()) + ", handlingChargesRatePerCn=" + this.getHandlingChargesRatePerCn() + ", handlingChargesRatePerKg=" + this.getHandlingChargesRatePerKg() + ", handlingChargesRatePerBox=" + this.getHandlingChargesRatePerBox() + ", handlingChargesMinimumCharge=" + this.getHandlingChargesMinimumCharge() + ", handlingChargesMaximumCharge=" + this.getHandlingChargesMaximumCharge() + ", handlingChargesRatePerKgPerBoxSlabs=" + this.getHandlingChargesRatePerKgPerBoxSlabs() + ", handlingChargesRatePerBoxSlabs=" + this.getHandlingChargesRatePerBoxSlabs() + ", handlingChargesRatePerKgSlabs=" + this.getHandlingChargesRatePerKgSlabs() + ", odcHandlingChargesChargeBasis=" + (Object)((Object)this.getOdcHandlingChargesChargeBasis()) + ", odcHandlingChargesRatePerKg=" + this.getOdcHandlingChargesRatePerKg() + ", odcHandlingChargesRatePerBox=" + this.getOdcHandlingChargesRatePerBox() + ", odcHandlingChargesMinimumCharge=" + this.getOdcHandlingChargesMinimumCharge() + ", odcHandlingChargesMaximumCharge=" + this.getOdcHandlingChargesMaximumCharge() + ", valueHandlingChargesChargeBasis=" + (Object)((Object)this.getValueHandlingChargesChargeBasis()) + ", valueHandlingChargesRatePerKgCutoff=" + this.getValueHandlingChargesRatePerKgCutoff() + ", valueHandlingChargesCustomerInvoicePercentage=" + this.getValueHandlingChargesCustomerInvoicePercentage() + ", valueHandlingChargesMinimumCharge=" + this.getValueHandlingChargesMinimumCharge() + ", valueHandlingChargesMaximumCharge=" + this.getValueHandlingChargesMaximumCharge() + ", higherFloorChargesIsPerFloor=" + this.getHigherFloorChargesIsPerFloor() + ", higherFloorActivityBasis=" + (Object)((Object)this.getHigherFloorActivityBasis()) + ", higherFloorDeliveryChargeBasis=" + (Object)((Object)this.getHigherFloorDeliveryChargeBasis()) + ", higherFloorDeliveryRatePerCn=" + this.getHigherFloorDeliveryRatePerCn() + ", higherFloorDeliveryRatePerKg=" + this.getHigherFloorDeliveryRatePerKg() + ", higherFloorDeliveryRatePerBox=" + this.getHigherFloorDeliveryRatePerBox() + ", higherFloorDeliveryMinimumCharge=" + this.getHigherFloorDeliveryMinimumCharge() + ", higherFloorDeliveryMaximumCharge=" + this.getHigherFloorDeliveryMaximumCharge() + ", higherFloorDeliveryRatePerKgSlabs=" + this.getHigherFloorDeliveryRatePerKgSlabs() + ", higherFloorDeliveryRatePerBoxSlabs=" + this.getHigherFloorDeliveryRatePerBoxSlabs() + ", higherFloorExclusionFloors=" + this.getHigherFloorExclusionFloors() + ", odaChargeBasis=" + (Object)((Object)this.getOdaChargeBasis()) + ", odaType=" + this.getOdaType() + ", oda1RatePerCn=" + this.getOda1RatePerCn() + ", oda2RatePerCn=" + this.getOda2RatePerCn() + ", oda3RatePerCn=" + this.getOda3RatePerCn() + ", oda4RatePerCn=" + this.getOda4RatePerCn() + ", oda5RatePerCn=" + this.getOda5RatePerCn() + ", oda6RatePerCn=" + this.getOda6RatePerCn() + ", oda7RatePerCn=" + this.getOda7RatePerCn() + ", oda1RatePerKgSlabs=" + this.getOda1RatePerKgSlabs() + ", oda2RatePerKgSlabs=" + this.getOda2RatePerKgSlabs() + ", oda3RatePerKgSlabs=" + this.getOda3RatePerKgSlabs() + ", oda4RatePerKgSlabs=" + this.getOda4RatePerKgSlabs() + ", oda5RatePerKgSlabs=" + this.getOda5RatePerKgSlabs() + ", oda6RatePerKgSlabs=" + this.getOda6RatePerKgSlabs() + ", oda7RatePerKgSlabs=" + this.getOda7RatePerKgSlabs() + ", odaExemptionApplicability=" + this.isOdaExemptionApplicability() + ", odaExemptedPincodes=" + this.getOdaExemptedPincodes() + ", opaChargeBasis=" + (Object)((Object)this.getOpaChargeBasis()) + ", categoryVsOpaField=" + this.getCategoryVsOpaField() + ", exceptionalPincodes=" + this.getExceptionalPincodes() + ", opaExceptionApplicability=" + this.isOpaExceptionApplicability() + ", fodChargeBasis=" + (Object)((Object)this.getFodChargeBasis()) + ", fodPerCn=" + this.getFodPerCn() + ", fodPerKg=" + this.getFodPerKg() + ", fodMinimumCharge=" + this.getFodMinimumCharge() + ", fodMaximumCharge=" + this.getFodMaximumCharge() + ", fodPerBox=" + this.getFodPerBox() + ", metroCongestionChargeBasis=" + (Object)((Object)this.getMetroCongestionChargeBasis()) + ", metroCongestionPerCn=" + this.getMetroCongestionPerCn() + ", metroCongestionPerKg=" + this.getMetroCongestionPerKg() + ", metroCongestionMinimumCharge=" + this.getMetroCongestionMinimumCharge() + ", metroCongestionMaximumCharge=" + this.getMetroCongestionMaximumCharge() + ", metroCongestionPerBox=" + this.getMetroCongestionPerBox() + ", hardRegionChargeBasis=" + (Object)((Object)this.getHardRegionChargeBasis()) + ", hardRegionPerCn=" + this.getHardRegionPerCn() + ", hardRegionPerKg=" + this.getHardRegionPerKg() + ", hardRegionMinimumCharge=" + this.getHardRegionMinimumCharge() + ", hardRegionMaximumCharge=" + this.getHardRegionMaximumCharge() + ", hardRegionPerBox=" + this.getHardRegionPerBox() + ", specialZoneChargeBasis=" + (Object)((Object)this.getSpecialZoneChargeBasis()) + ", specialZonePerCn=" + this.getSpecialZonePerCn() + ", specialZonePerKg=" + this.getSpecialZonePerKg() + ", specialZoneMinimumCharge=" + this.getSpecialZoneMinimumCharge() + ", specialZoneMaximumCharge=" + this.getSpecialZoneMaximumCharge() + ", specialZonePerBox=" + this.getSpecialZonePerBox() + ", infrastructureDevelopmentChargeBasis=" + (Object)((Object)this.getInfrastructureDevelopmentChargeBasis()) + ", infrastructureDevelopmentRatePerChargeBasis=" + this.getInfrastructureDevelopmentRatePerChargeBasis() + ", infrastructureDevelopmentChargeComponent=" + this.getInfrastructureDevelopmentChargeComponent() + ", bdSurchargeChargeBasis=" + (Object)((Object)this.getBdSurchargeChargeBasis()) + ", bdSurchargePercentageFreight=" + this.getBdSurchargePercentageFreight() + ", codDodChargeBasis=" + (Object)((Object)this.getCodDodChargeBasis()) + ", codDodPerCn=" + this.getCodDodPerCn() + ", codDodPercentageFreight=" + this.getCodDodPercentageFreight() + ", codDodMin=" + this.getCodDodMin() + ", codDodMax=" + this.getCodDodMax() + ", clientAccountNumber=" + this.getClientAccountNumber() + ", codDodCreditCardChargeMin=" + this.getCodDodCreditCardChargeMin() + ", codDodDebitCardChargeMin=" + this.getCodDodDebitCardChargeMin() + ", codDodNetbankingChargeMin=" + this.getCodDodNetbankingChargeMin() + ", codDodNeftChargeMin=" + this.getCodDodNeftChargeMin() + ", codDodRtgsChargeMin=" + this.getCodDodRtgsChargeMin() + ", codDodImpsChargeMin=" + this.getCodDodImpsChargeMin() + ", codDodUpiChargeMin=" + this.getCodDodUpiChargeMin() + ", codDodCreditCardPercentage=" + this.getCodDodCreditCardPercentage() + ", codDodDebitCardPercentage=" + this.getCodDodDebitCardPercentage() + ", codDodNetbankingPercentage=" + this.getCodDodNetbankingPercentage() + ", codDodNeftPercentage=" + this.getCodDodNeftPercentage() + ", codDodRtgsPercentage=" + this.getCodDodRtgsPercentage() + ", codDodImpsPercentage=" + this.getCodDodImpsPercentage() + ", codDodUpiPercentage=" + this.getCodDodUpiPercentage() + ", codDodCreditCardChargeMax=" + this.getCodDodCreditCardChargeMax() + ", codDodDebitCardChargeMax=" + this.getCodDodDebitCardChargeMax() + ", codDodNetbankingChargeMax=" + this.getCodDodNetbankingChargeMax() + ", codDodNeftChargeMax=" + this.getCodDodNeftChargeMax() + ", codDodRtgsChargeMax=" + this.getCodDodRtgsChargeMax() + ", codDodImpsChargeMax=" + this.getCodDodImpsChargeMax() + ", codDodUpiChargeMax=" + this.getCodDodUpiChargeMax() + ", codDodModeVsExceptionalCharge=" + this.getCodDodModeVsExceptionalCharge() + ", daccChargeBasis=" + (Object)((Object)this.getDaccChargeBasis()) + ", daccRatePerCn=" + this.getDaccRatePerCn() + ", daccRatePerKg=" + this.getDaccRatePerKg() + ", daccMinimumCharge=" + this.getDaccMinimumCharge() + ", daccMaximumCharge=" + this.getDaccMaximumCharge() + ", demurrageChargeBasis=" + (Object)((Object)this.getDemurrageChargeBasis()) + ", demurrageExclusionHours=" + this.getDemurrageExclusionHours() + ", demurrageRatePerCn=" + this.getDemurrageRatePerCn() + ", demurrageRatePerKg=" + this.getDemurrageRatePerKg() + ", demurragePercentageFreight=" + this.getDemurragePercentageFreight() + ", demurrageRatePerCnSlab=" + this.getDemurrageRatePerCnSlab() + ", demurragePercentageFreightSlab=" + this.getDemurragePercentageFreightSlab() + ", demurrageRatePerKgSlab=" + this.getDemurrageRatePerKgSlab() + ", hardCopyPodChargeBasis=" + (Object)((Object)this.getHardCopyPodChargeBasis()) + ", hardCopyPodPerCn=" + this.getHardCopyPodPerCn() + ", unionWaraiMathadiChargeBasis=" + (Object)((Object)this.getUnionWaraiMathadiChargeBasis()) + ", unionWaraiMathadiChargePerUnit=" + this.getUnionWaraiMathadiChargePerUnit() + ", unionWaraiMathadiMinCharge=" + this.getUnionWaraiMathadiMinCharge() + ", unionWaraiMathadiMaxCharge=" + this.getUnionWaraiMathadiMaxCharge() + ", unionWaraiMathadiActivityBasis=" + (Object)((Object)this.getUnionWaraiMathadiActivityBasis()) + ", dedicatedVehicleChargeBasis=" + (Object)((Object)this.getDedicatedVehicleChargeBasis()) + ", dedicatedVehicleChargePerUnit=" + this.getDedicatedVehicleChargePerUnit() + ", dedicatedVehicleMinCharge=" + this.getDedicatedVehicleMinCharge() + ", dedicatedVehicleMaxCharge=" + this.getDedicatedVehicleMaxCharge() + ", dedicatedVehicleActivityBasis=" + (Object)((Object)this.getDedicatedVehicleActivityBasis()) + ", materialHandlingEquipmentChargeBasis=" + (Object)((Object)this.getMaterialHandlingEquipmentChargeBasis()) + ", materialHandlingEquipmentChargePerUnit=" + this.getMaterialHandlingEquipmentChargePerUnit() + ", materialHandlingEquipmentMinCharge=" + this.getMaterialHandlingEquipmentMinCharge() + ", materialHandlingEquipmentMaxCharge=" + this.getMaterialHandlingEquipmentMaxCharge() + ", materialHandlingEquipmentActivityBasis=" + (Object)((Object)this.getMaterialHandlingEquipmentActivityBasis()) + ", clientFields=" + this.getClientFields() + ", weightBasedDiscount=" + this.getWeightBasedDiscount() + ", chargedWeightSlabs=" + this.getChargedWeightSlabs() + ", ccSlabs=" + this.getCcSlabs() + ")";
    }

    public static class CodDodExceptionalCharge {
        private CodDodExceptionalType exceptionType;
        private List<String> bankNames;
        private BigDecimal chargePercent;
        private BigDecimal minCharge;
        private BigDecimal maxCharge;
        private List<SlabDTO> slabDTOS;

        public CodDodExceptionalType getExceptionType() {
            return this.exceptionType;
        }

        public List<String> getBankNames() {
            return this.bankNames;
        }

        public BigDecimal getChargePercent() {
            return this.chargePercent;
        }

        public BigDecimal getMinCharge() {
            return this.minCharge;
        }

        public BigDecimal getMaxCharge() {
            return this.maxCharge;
        }

        public List<SlabDTO> getSlabDTOS() {
            return this.slabDTOS;
        }

        public void setExceptionType(CodDodExceptionalType exceptionType) {
            this.exceptionType = exceptionType;
        }

        public void setBankNames(List<String> bankNames) {
            this.bankNames = bankNames;
        }

        public void setChargePercent(BigDecimal chargePercent) {
            this.chargePercent = chargePercent;
        }

        public void setMinCharge(BigDecimal minCharge) {
            this.minCharge = minCharge;
        }

        public void setMaxCharge(BigDecimal maxCharge) {
            this.maxCharge = maxCharge;
        }

        public void setSlabDTOS(List<SlabDTO> slabDTOS) {
            this.slabDTOS = slabDTOS;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CodDodExceptionalCharge)) {
                return false;
            }
            CodDodExceptionalCharge other = (CodDodExceptionalCharge)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CodDodExceptionalType this$exceptionType = this.getExceptionType();
            CodDodExceptionalType other$exceptionType = other.getExceptionType();
            if (this$exceptionType == null ? other$exceptionType != null : !((Object)((Object)this$exceptionType)).equals((Object)other$exceptionType)) {
                return false;
            }
            List<String> this$bankNames = this.getBankNames();
            List<String> other$bankNames = other.getBankNames();
            if (this$bankNames == null ? other$bankNames != null : !((Object)this$bankNames).equals(other$bankNames)) {
                return false;
            }
            BigDecimal this$chargePercent = this.getChargePercent();
            BigDecimal other$chargePercent = other.getChargePercent();
            if (this$chargePercent == null ? other$chargePercent != null : !((Object)this$chargePercent).equals(other$chargePercent)) {
                return false;
            }
            BigDecimal this$minCharge = this.getMinCharge();
            BigDecimal other$minCharge = other.getMinCharge();
            if (this$minCharge == null ? other$minCharge != null : !((Object)this$minCharge).equals(other$minCharge)) {
                return false;
            }
            BigDecimal this$maxCharge = this.getMaxCharge();
            BigDecimal other$maxCharge = other.getMaxCharge();
            if (this$maxCharge == null ? other$maxCharge != null : !((Object)this$maxCharge).equals(other$maxCharge)) {
                return false;
            }
            List<SlabDTO> this$slabDTOS = this.getSlabDTOS();
            List<SlabDTO> other$slabDTOS = other.getSlabDTOS();
            return !(this$slabDTOS == null ? other$slabDTOS != null : !((Object)this$slabDTOS).equals(other$slabDTOS));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CodDodExceptionalCharge;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CodDodExceptionalType $exceptionType = this.getExceptionType();
            result = result * 59 + ($exceptionType == null ? 43 : ((Object)((Object)$exceptionType)).hashCode());
            List<String> $bankNames = this.getBankNames();
            result = result * 59 + ($bankNames == null ? 43 : ((Object)$bankNames).hashCode());
            BigDecimal $chargePercent = this.getChargePercent();
            result = result * 59 + ($chargePercent == null ? 43 : ((Object)$chargePercent).hashCode());
            BigDecimal $minCharge = this.getMinCharge();
            result = result * 59 + ($minCharge == null ? 43 : ((Object)$minCharge).hashCode());
            BigDecimal $maxCharge = this.getMaxCharge();
            result = result * 59 + ($maxCharge == null ? 43 : ((Object)$maxCharge).hashCode());
            List<SlabDTO> $slabDTOS = this.getSlabDTOS();
            result = result * 59 + ($slabDTOS == null ? 43 : ((Object)$slabDTOS).hashCode());
            return result;
        }

        public String toString() {
            return "ContractDetailsDTO.CodDodExceptionalCharge(exceptionType=" + (Object)((Object)this.getExceptionType()) + ", bankNames=" + this.getBankNames() + ", chargePercent=" + this.getChargePercent() + ", minCharge=" + this.getMinCharge() + ", maxCharge=" + this.getMaxCharge() + ", slabDTOS=" + this.getSlabDTOS() + ")";
        }

        @ConstructorProperties(value={"exceptionType", "bankNames", "chargePercent", "minCharge", "maxCharge", "slabDTOS"})
        public CodDodExceptionalCharge(CodDodExceptionalType exceptionType, List<String> bankNames, BigDecimal chargePercent, BigDecimal minCharge, BigDecimal maxCharge, List<SlabDTO> slabDTOS) {
            this.exceptionType = exceptionType;
            this.bankNames = bankNames;
            this.chargePercent = chargePercent;
            this.minCharge = minCharge;
            this.maxCharge = maxCharge;
            this.slabDTOS = slabDTOS;
        }

        public CodDodExceptionalCharge() {
        }
    }

    public static class OPAField {
        private String opaCategory;
        private List<SlabDTO> slabs;
        private BigDecimal flatRatePerCN;

        public String getOpaCategory() {
            return this.opaCategory;
        }

        public List<SlabDTO> getSlabs() {
            return this.slabs;
        }

        public BigDecimal getFlatRatePerCN() {
            return this.flatRatePerCN;
        }

        public void setOpaCategory(String opaCategory) {
            this.opaCategory = opaCategory;
        }

        public void setSlabs(List<SlabDTO> slabs) {
            this.slabs = slabs;
        }

        public void setFlatRatePerCN(BigDecimal flatRatePerCN) {
            this.flatRatePerCN = flatRatePerCN;
        }

        public String toString() {
            return "ContractDetailsDTO.OPAField(opaCategory=" + this.getOpaCategory() + ", slabs=" + this.getSlabs() + ", flatRatePerCN=" + this.getFlatRatePerCN() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OPAField)) {
                return false;
            }
            OPAField other = (OPAField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$opaCategory = this.getOpaCategory();
            String other$opaCategory = other.getOpaCategory();
            return !(this$opaCategory == null ? other$opaCategory != null : !this$opaCategory.equals(other$opaCategory));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OPAField;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $opaCategory = this.getOpaCategory();
            result = result * 59 + ($opaCategory == null ? 43 : $opaCategory.hashCode());
            return result;
        }
    }

    public static enum CodDodExceptionalType {
        TRANSACTION_AMOUNT(1),
        BANK_NAME(2),
        BOTH(3);

        private final Integer priority;

        private CodDodExceptionalType(Integer priority) {
            this.priority = priority;
        }

        public Integer getPriority() {
            return this.priority;
        }
    }
}

