/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.archive.file;

import com.salesforce.cantor.common.CommonPreconditions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;

public abstract class AbstractBaseArchiverOnFile {
    protected final String baseDirectory;
    protected String subDirectory = "";

    protected AbstractBaseArchiverOnFile(String baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    protected Path getFile(String fileNameFormat, Object ... args) {
        return Paths.get(this.baseDirectory, this.subDirectory, String.format(fileNameFormat, args));
    }

    protected Path getArchiveLocation() {
        return Paths.get(this.baseDirectory, this.subDirectory);
    }

    protected void setSubDirectory(String subDirectory) {
        this.subDirectory = subDirectory != null ? subDirectory : "";
        Path createDirectory = this.getArchiveLocation();
        if (!createDirectory.toFile().exists() && !createDirectory.toFile().mkdirs()) {
            throw new IllegalStateException("Failed to create sub directory for file archive: " + createDirectory);
        }
    }

    protected void writeArchiveEntry(ArchiveOutputStream archive, String name, byte[] bytes) throws IOException {
        if (bytes.length == 0) {
            return;
        }
        TarArchiveEntry entry = new TarArchiveEntry(name);
        entry.setSize((long)bytes.length);
        archive.putArchiveEntry((ArchiveEntry)entry);
        archive.write(bytes);
        archive.closeArchiveEntry();
    }

    protected ArchiveOutputStream getArchiveOutputStream(Path destination) throws IOException {
        return new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)new BufferedOutputStream(Files.newOutputStream(destination, new OpenOption[0]))));
    }

    protected ArchiveInputStream getArchiveInputStream(Path archiveFile) throws IOException {
        return new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(archiveFile, new OpenOption[0]))));
    }

    protected boolean checkArchiveArguments(Object instance, String namespace, Path destination) {
        CommonPreconditions.checkArgument((instance != null ? 1 : 0) != 0, (String)"null cantor instance, can't archive");
        CommonPreconditions.checkArgument((destination != null ? 1 : 0) != 0, (String)"null destination, can't archive");
        return Files.notExists(destination, new LinkOption[0]) || destination.toFile().length() == 0L;
    }

    protected void checkRestoreArguments(Object instance, String namespace, Path archiveFile) {
        CommonPreconditions.checkArgument((instance != null ? 1 : 0) != 0, (String)"null objects, can't restore");
        CommonPreconditions.checkArgument((boolean)Files.exists(archiveFile, new LinkOption[0]), (String)("can't locate archive file, can't restore: " + archiveFile));
    }
}

