/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.archive.file;

import com.salesforce.cantor.archive.file.EventsArchiverOnFile;
import com.salesforce.cantor.archive.file.ObjectsArchiverOnFile;
import com.salesforce.cantor.archive.file.SetsArchiverOnFile;
import com.salesforce.cantor.common.CommonPreconditions;
import com.salesforce.cantor.misc.archivable.CantorArchiver;
import com.salesforce.cantor.misc.archivable.EventsArchiver;
import com.salesforce.cantor.misc.archivable.ObjectsArchiver;
import com.salesforce.cantor.misc.archivable.SetsArchiver;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiverOnFile
implements CantorArchiver {
    private static final Logger logger = LoggerFactory.getLogger(ArchiverOnFile.class);
    protected static final String defaultArchivePathBase = "cantor-archive-data";
    protected static final long defaultChunkMillis = TimeUnit.HOURS.toMillis(1L);
    private final SetsArchiverOnFile setsArchive;
    private final ObjectsArchiverOnFile objectsArchive;
    private final EventsArchiverOnFile eventsArchive;

    public ArchiverOnFile() {
        this(defaultArchivePathBase);
    }

    public ArchiverOnFile(String baseDirectory) {
        this(baseDirectory, defaultChunkMillis);
    }

    public ArchiverOnFile(String baseDirectory, long eventsChunkMillis) {
        CommonPreconditions.checkArgument((baseDirectory != null && !baseDirectory.isEmpty() ? 1 : 0) != 0, (String)"null/empty baseDirectory");
        CommonPreconditions.checkArgument((eventsChunkMillis > 0L ? 1 : 0) != 0, (String)"eventsChunkMillis must be greater than zero");
        logger.info("initializing file archiver with directory '{}' in {}ms chunks", (Object)baseDirectory, (Object)eventsChunkMillis);
        File createDirectory = new File(baseDirectory);
        if (!createDirectory.mkdirs() && !createDirectory.exists()) {
            throw new IllegalStateException("Failed to create base directory for file archive: " + baseDirectory);
        }
        this.setsArchive = new SetsArchiverOnFile(baseDirectory);
        this.objectsArchive = new ObjectsArchiverOnFile(baseDirectory);
        this.eventsArchive = new EventsArchiverOnFile(baseDirectory);
    }

    public SetsArchiver sets() {
        return this.setsArchive;
    }

    public ObjectsArchiver objects() {
        return this.objectsArchive;
    }

    public EventsArchiver events() {
        return this.eventsArchive;
    }
}

