/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.archive.file;

import com.google.protobuf.ByteString;
import com.salesforce.cantor.Events;
import com.salesforce.cantor.archive.EventsChunk;
import com.salesforce.cantor.archive.file.AbstractBaseArchiverOnFile;
import com.salesforce.cantor.common.CommonPreconditions;
import com.salesforce.cantor.misc.archivable.EventsArchiver;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsArchiverOnFile
extends AbstractBaseArchiverOnFile
implements EventsArchiver {
    private static final Logger logger = LoggerFactory.getLogger(EventsArchiverOnFile.class);
    private static final String archivePathFormat = "/archive-events-%s-%d-%d";
    private static final Pattern archiveRegexPattern = Pattern.compile(".*archive-events-(?<namespace>.*)-(?<start>\\d+)-(?<end>\\d+)");
    private static final String isRestoredFlag = ".cantor-archive-restored";
    private static final long chunkMillis = TimeUnit.HOURS.toMillis(1L);
    private static final long minChunkMillis = TimeUnit.MINUTES.toMillis(1L);
    private static final long maxChunkMillis = TimeUnit.DAYS.toMillis(1L);

    public EventsArchiverOnFile(String baseDirectory) {
        super(baseDirectory);
        this.setSubDirectory("events");
    }

    public Collection<String> namespaces() throws IOException {
        return Files.list(this.getArchiveLocation()).map(EventsArchiverOnFile::getNamespace).collect(Collectors.toList());
    }

    public void create(String namespace) throws IOException {
    }

    public void drop(String namespace) throws IOException {
        List<Path> fileArchiveList = this.getFileArchiveList(namespace, Long.MIN_VALUE, Long.MAX_VALUE);
        for (Path path : fileArchiveList) {
            if (path.toFile().delete()) continue;
            logger.warn("failed to delete file: {}", (Object)path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void archive(Events events, String namespace, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery) throws IOException {
        long totalEventsArchived;
        long startNanos;
        block6: {
            startNanos = System.nanoTime();
            totalEventsArchived = 0L;
            try {
                long start = this.getFloorForChunk(endTimestampMillis);
                for (long end = endTimestampMillis; end > startTimestampMillis; end -= chunkMillis, start -= chunkMillis) {
                    long archivedEvents = this.doArchive(events, namespace, Math.max(start, startTimestampMillis), end, metadataQuery, dimensionsQuery, this.getFileArchive(namespace, start));
                    totalEventsArchived += archivedEvents;
                    long floorForStart = this.getFloorForChunk(startTimestampMillis);
                    if (archivedEvents == 0L && start > floorForStart + chunkMillis && events.first(namespace, floorForStart + chunkMillis, start) == null) {
                        if (events.first(namespace, floorForStart, floorForStart + chunkMillis - 1L) != null) {
                            start = floorForStart + chunkMillis;
                            end = floorForStart + chunkMillis * 2L - 1L;
                            continue;
                        }
                        break block6;
                    }
                    if (end != endTimestampMillis) continue;
                    end = this.getCeilingForChunk(end);
                }
            }
            catch (Throwable throwable) {
                logger.info("archiving {} events for namespace '{}' took {}s", new Object[]{totalEventsArchived, namespace, TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startNanos)});
                throw throwable;
            }
            logger.info("archiving {} events for namespace '{}' took {}s", new Object[]{totalEventsArchived, namespace, TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startNanos)});
            return;
        }
        logger.info("archiving {} events for namespace '{}' took {}s", new Object[]{totalEventsArchived, namespace, TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startNanos)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(Events events, String namespace, long startTimestampMillis, long endTimestampMillis) throws IOException {
        CommonPreconditions.checkNamespace((String)namespace);
        CommonPreconditions.checkArgument((startTimestampMillis >= 0L ? 1 : 0) != 0, (String)"invalid start timestamp");
        CommonPreconditions.checkArgument((endTimestampMillis >= startTimestampMillis ? 1 : 0) != 0, (String)"end timestamp cannot be before start timestamp");
        List<Path> archives = this.getFileArchiveList(namespace, startTimestampMillis, endTimestampMillis);
        long startNanos = System.nanoTime();
        long totalEventsRestored = 0L;
        try {
            for (Path archive : archives) {
                totalEventsRestored += this.doRestore(events, namespace, archive);
            }
        }
        catch (Throwable throwable) {
            logger.info("restoring {} chunks, {} events for namespace '{}' took {}s", new Object[]{archives.size(), totalEventsRestored, namespace, TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startNanos)});
            throw throwable;
        }
        logger.info("restoring {} chunks, {} events for namespace '{}' took {}s", new Object[]{archives.size(), totalEventsRestored, namespace, TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startNanos)});
    }

    /*
     * Exception decompiling
     */
    protected long doArchive(Events events, String namespace, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery, Path destination) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected long doRestore(Events events, String namespace, Path archiveFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected List<Events.Event> toEvents(List<EventsChunk.Event> eventsList) {
        ArrayList<Events.Event> events = new ArrayList<Events.Event>();
        for (EventsChunk.Event event : eventsList) {
            events.add(new Events.Event(event.getTimestampMillis(), event.getMetadataMap(), event.toBuilder().putDimensions(isRestoredFlag, 1.0).getDimensionsMap(), !ByteString.EMPTY.equals((Object)event.getPayload()) ? event.getPayload().toByteArray() : null));
        }
        return events;
    }

    protected void cleanRestoredEvents(Events events, String namespace, Path archiveFile) throws IOException {
        String filename = archiveFile.getFileName().toString();
        Matcher matcher = archiveRegexPattern.matcher(filename);
        if (matcher.matches()) {
            long start = Long.parseLong(matcher.group("start"));
            long end = Long.parseLong(matcher.group("end"));
            HashMap<String, String> dimensionMap = new HashMap<String, String>();
            dimensionMap.put(isRestoredFlag, "1");
            events.delete(namespace, start, end, null, dimensionMap);
        }
    }

    protected List<Path> getFileArchiveList(String namespace, long startTimestampMillis, long endTimestampMillis) throws IOException {
        return this.getMatchingArchives(namespace, Files.list(this.getArchiveLocation()).collect(Collectors.toList()), startTimestampMillis, endTimestampMillis);
    }

    public <R> List<R> getMatchingArchives(String namespace, Collection<R> archiveFilenames, long startTimestampMillis, long endTimestampMillis) {
        long windowStart = this.getFloorForChunk(startTimestampMillis);
        long windowEnd = endTimestampMillis <= Long.MAX_VALUE - chunkMillis ? this.getCeilingForChunk(endTimestampMillis) : endTimestampMillis;
        return archiveFilenames.stream().filter(filename -> {
            Matcher matcher = archiveRegexPattern.matcher(filename.toString());
            if (matcher.matches() && matcher.group("namespace").equals(namespace)) {
                long fileStart = Long.parseLong(matcher.group("start"));
                long fileEnd = Long.parseLong(matcher.group("end"));
                return fileStart <= windowEnd && fileEnd >= windowStart;
            }
            return false;
        }).collect(Collectors.toList());
    }

    protected Path getFileArchive(String namespace, long chunkStartMillis) {
        CommonPreconditions.checkString((String)namespace, (String)"null/empty namespace");
        return this.getFile(archivePathFormat, namespace, chunkStartMillis, chunkStartMillis + chunkMillis - 1L);
    }

    protected static String getNamespace(Path path) {
        String fileName = path.getFileName().toString();
        Matcher matcher = archiveRegexPattern.matcher(fileName);
        return matcher.matches() ? matcher.group("namespace") : null;
    }

    protected long getFloorForChunk(long timestampMillis) {
        return timestampMillis / chunkMillis * chunkMillis;
    }

    protected long getCeilingForChunk(long timestampMillis) {
        if (timestampMillis >= Long.MAX_VALUE - chunkMillis) {
            return Long.MAX_VALUE;
        }
        return this.getFloorForChunk(timestampMillis) + chunkMillis - 1L;
    }

    private static /* synthetic */ boolean lambda$doArchive$0(Events.Event event) {
        return event.getDimensions().getOrDefault(isRestoredFlag, 0.0) == 0.0;
    }
}

