/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.archive.file;

import com.google.protobuf.ByteString;
import com.salesforce.cantor.Objects;
import com.salesforce.cantor.archive.ObjectsChunk;
import com.salesforce.cantor.archive.file.AbstractBaseArchiverOnFile;
import com.salesforce.cantor.common.CommonPreconditions;
import com.salesforce.cantor.misc.archivable.ObjectsArchiver;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectsArchiverOnFile
extends AbstractBaseArchiverOnFile
implements ObjectsArchiver {
    private static final Logger logger = LoggerFactory.getLogger(ObjectsArchiverOnFile.class);
    protected static final String archivePathFormat = "/archive-objects-%s";
    private static final Pattern archiveRegexPattern = Pattern.compile("archive-objects-(?<namespace>.*)");
    public static final int chunkSize = 1000;

    public ObjectsArchiverOnFile(String baseDirectory) {
        super(baseDirectory);
        this.setSubDirectory("objects");
    }

    public Collection<String> namespaces() throws IOException {
        return Files.list(this.getArchiveLocation()).map(ObjectsArchiverOnFile::getNamespace).collect(Collectors.toList());
    }

    public void create(String namespace) throws IOException {
    }

    public void drop(String namespace) throws IOException {
        Path archiveFile = this.getFileArchive(namespace);
        CommonPreconditions.checkArgument((boolean)archiveFile.toFile().exists(), (String)("file archive does not exist: " + archiveFile));
        if (!archiveFile.toFile().delete()) {
            throw new IOException("failed to delete namespace archive: " + archiveFile.toString());
        }
    }

    public void archive(Objects objects, String namespace) throws IOException {
        Path destination = this.getFileArchive(namespace);
        this.checkArchiveArguments(objects, namespace, destination);
        this.doArchive(objects, namespace, destination);
    }

    public void restore(Objects objects, String namespace) throws IOException {
        Path archiveFile = this.getFileArchive(namespace);
        this.checkRestoreArguments(objects, namespace, archiveFile);
        this.doRestore(objects, namespace, archiveFile);
    }

    protected void doArchive(Objects objects, String namespace, Path destination) throws IOException {
        try (ArchiveOutputStream archive = this.getArchiveOutputStream(destination);){
            int start = 0;
            Collection keys = objects.keys(namespace, start, 1000);
            while (!keys.isEmpty()) {
                Map chunk = objects.get(namespace, keys);
                int end = start + chunk.size();
                String name = String.format("objects-%s-%s-%s", namespace, start, end);
                this.writeArchiveEntry(archive, name, this.getBytes(chunk));
                logger.info("archived {} objects ({}-{}) into chunk '{}'", new Object[]{chunk.size(), start, end, name});
                start = end;
                keys = objects.keys(namespace, start, 1000);
            }
        }
    }

    protected void doRestore(Objects objects, String namespace, Path archiveFile) throws IOException {
        objects.create(namespace);
        try (ArchiveInputStream archive = this.getArchiveInputStream(archiveFile);){
            ArchiveEntry entry;
            int total = 0;
            while ((entry = archive.getNextEntry()) != null) {
                ObjectsChunk chunk = ObjectsChunk.parseFrom((InputStream)archive);
                for (Map.Entry<String, ByteString> chunkEntry : chunk.getObjectsMap().entrySet()) {
                    objects.store(namespace, chunkEntry.getKey(), chunkEntry.getValue().toByteArray());
                }
                logger.info("read {} objects from chunk {} ({} bytes) into {}", new Object[]{chunk.getObjectsCount(), entry.getName(), entry.getSize(), objects});
                total += chunk.getObjectsCount();
            }
            logger.info("restored {} objects into namespace '{}' from archive file {}", new Object[]{total, namespace, archiveFile});
        }
    }

    protected byte[] getBytes(Map<String, byte[]> chunk) {
        ObjectsChunk.Builder builder = ObjectsChunk.newBuilder();
        for (Map.Entry<String, byte[]> entry : chunk.entrySet()) {
            builder.putObjects(entry.getKey(), ByteString.copyFrom((byte[])entry.getValue()));
        }
        return builder.build().toByteArray();
    }

    protected Path getFileArchive(String namespace) {
        CommonPreconditions.checkString((String)namespace, (String)"null/empty namespace");
        return this.getFile(archivePathFormat, namespace);
    }

    protected static String getNamespace(Path path) {
        String fileName = path.getFileName().toString();
        Matcher matcher = archiveRegexPattern.matcher(fileName);
        return matcher.matches() ? matcher.group("namespace") : null;
    }
}

