/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.archive.file;

import com.salesforce.cantor.Sets;
import com.salesforce.cantor.archive.SetsChunk;
import com.salesforce.cantor.archive.file.AbstractBaseArchiverOnFile;
import com.salesforce.cantor.common.CommonPreconditions;
import com.salesforce.cantor.misc.archivable.SetsArchiver;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetsArchiverOnFile
extends AbstractBaseArchiverOnFile
implements SetsArchiver {
    private static final Logger logger = LoggerFactory.getLogger(SetsArchiverOnFile.class);
    private static final String archivePathFormat = "/archive-sets-%s";
    private static final Pattern archiveRegexPattern = Pattern.compile("archive-sets-(?<namespace>.*)");
    public static final int chunkSize = 1000;

    public SetsArchiverOnFile(String baseDirectory) {
        super(baseDirectory);
        this.setSubDirectory("sets");
    }

    public Collection<String> namespaces() throws IOException {
        return Files.list(this.getArchiveLocation()).map(SetsArchiverOnFile::getNamespace).collect(Collectors.toList());
    }

    public void create(String namespace) throws IOException {
    }

    public void drop(String namespace) throws IOException {
        Path archiveFile = this.getFileArchive(namespace);
        CommonPreconditions.checkArgument((boolean)archiveFile.toFile().exists(), (String)("file archive does not exist: " + archiveFile));
        if (!archiveFile.toFile().delete()) {
            throw new IOException("failed to delete namespace archive: " + archiveFile.toString());
        }
    }

    public void archive(Sets sets, String namespace) throws IOException {
        Path destination = this.getFileArchive(namespace);
        this.checkArchiveArguments(sets, namespace, destination);
        this.doArchive(sets, namespace, destination);
    }

    public void restore(Sets sets, String namespace) throws IOException {
        Path archiveFile = this.getFileArchive(namespace);
        this.checkRestoreArguments(sets, namespace, archiveFile);
        this.doRestore(sets, namespace, archiveFile);
    }

    protected void doArchive(Sets sets, String namespace, Path destination) throws IOException {
        Collection setNames = sets.sets(namespace);
        try (ArchiveOutputStream archive = this.getArchiveOutputStream(destination);){
            for (String set : setNames) {
                logger.info("archiving set {}.{}", (Object)namespace, (Object)set);
                int start = 0;
                Map entries = sets.get(namespace, set, start, 1000);
                while (!entries.isEmpty()) {
                    int end = start + entries.size();
                    String name = String.format("sets-%s-%s-%s-%s", namespace, set, start, end);
                    SetsChunk chunk = SetsChunk.newBuilder().setSet(set).putAllEntries(entries).build();
                    this.writeArchiveEntry(archive, name, chunk.toByteArray());
                    logger.info("archived {} entries ({}-{}) into chunk '{}' for set {}.{}", new Object[]{entries.size(), start, end, name, namespace, set});
                    start = end;
                    entries = sets.get(namespace, set, start, 1000);
                }
            }
        }
    }

    protected void doRestore(Sets sets, String namespace, Path archiveFile) throws IOException {
        sets.create(namespace);
        try (ArchiveInputStream archive = this.getArchiveInputStream(archiveFile);){
            ArchiveEntry entry;
            int total = 0;
            while ((entry = archive.getNextEntry()) != null) {
                SetsChunk chunk = SetsChunk.parseFrom((InputStream)archive);
                sets.add(namespace, chunk.getSet(), chunk.getEntriesMap());
                logger.info("read {} entries from chunk {} ({} bytes) into {}.{}", new Object[]{chunk.getEntriesCount(), entry.getName(), entry.getSize(), namespace, chunk.getSet()});
                total += chunk.getEntriesCount();
            }
            logger.info("restored {} entries int namespace '{}' from archive file {}", new Object[]{total, namespace, archiveFile});
        }
    }

    protected Path getFileArchive(String namespace) {
        CommonPreconditions.checkString((String)namespace, (String)"null/empty namespace");
        return this.getFile(archivePathFormat, namespace);
    }

    protected static String getNamespace(Path path) {
        String fileName = path.getFileName().toString();
        Matcher matcher = archiveRegexPattern.matcher(fileName);
        return matcher.matches() ? matcher.group("namespace") : null;
    }
}

