/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.archive.s3;

import com.salesforce.cantor.Cantor;
import com.salesforce.cantor.archive.s3.EventsArchiverOnS3;
import com.salesforce.cantor.archive.s3.ObjectsArchiverOnS3;
import com.salesforce.cantor.archive.s3.SetsArchiverOnS3;
import com.salesforce.cantor.common.CommonPreconditions;
import com.salesforce.cantor.misc.archivable.CantorArchiver;
import com.salesforce.cantor.misc.archivable.EventsArchiver;
import com.salesforce.cantor.misc.archivable.ObjectsArchiver;
import com.salesforce.cantor.misc.archivable.SetsArchiver;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiverOnS3
implements CantorArchiver {
    private static final Logger logger = LoggerFactory.getLogger(ArchiverOnS3.class);
    private static final String archivePath = "cantor-s3-archive-data";
    private static final long defaultChunkMillis = TimeUnit.HOURS.toMillis(1L);
    private final SetsArchiverOnS3 setsArchive;
    private final ObjectsArchiverOnS3 objectsArchive;
    private final EventsArchiverOnS3 eventsArchive;

    public ArchiverOnS3(Cantor cantor) throws IOException {
        CommonPreconditions.checkArgument((cantor != null ? 1 : 0) != 0, (String)"null/empty cantor");
        logger.info("initializing s3 archiver with file archive '{}'", (Object)archivePath);
        File createDirectory = new File(archivePath);
        if (!createDirectory.mkdirs() && !createDirectory.exists()) {
            throw new IllegalStateException("Failed to create base directory for file archive: cantor-s3-archive-data");
        }
        this.setsArchive = new SetsArchiverOnS3(cantor, archivePath);
        this.objectsArchive = new ObjectsArchiverOnS3(cantor, archivePath);
        this.eventsArchive = new EventsArchiverOnS3(cantor, archivePath);
    }

    public SetsArchiver sets() {
        return this.setsArchive;
    }

    public ObjectsArchiver objects() {
        return this.objectsArchive;
    }

    public EventsArchiver events() {
        return this.eventsArchive;
    }
}

