/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.archive.s3;

import com.salesforce.cantor.Cantor;
import com.salesforce.cantor.Events;
import com.salesforce.cantor.archive.file.EventsArchiverOnFile;
import com.salesforce.cantor.common.CommonPreconditions;
import com.salesforce.cantor.misc.archivable.EventsArchiver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsArchiverOnS3
extends EventsArchiverOnFile
implements EventsArchiver {
    private static final Logger logger = LoggerFactory.getLogger(EventsArchiverOnS3.class);
    private static final String archiveNamespace = "events-archive";
    private final Cantor cantorOnS3;

    public EventsArchiverOnS3(Cantor cantorOnS3, String baseDirectory) throws IOException {
        super(baseDirectory);
        logger.info("initializing s3 events archiver");
        this.cantorOnS3 = cantorOnS3;
        this.cantorOnS3.objects().create(archiveNamespace);
        Path archiveLocation = super.getArchiveLocation();
        List archiveFiles = Files.list(archiveLocation).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
        for (Path file : archiveFiles) {
            this.uploadToS3(file.getFileName().toString(), file);
            if (file.toFile().delete()) continue;
            logger.warn("failed to delete temp archive file during startup {}", (Object)file);
        }
    }

    @Override
    public void archive(Events events, String namespace, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery) throws IOException {
        HashMap<String, Long> fileToModifiedTime = new HashMap<String, Long>();
        Collection archiveFilenames = this.cantorOnS3.objects().keys(archiveNamespace, 0, -1);
        List archives = this.getMatchingArchives(namespace, archiveFilenames, startTimestampMillis, endTimestampMillis);
        Path archiveLocation = super.getArchiveLocation();
        for (String objectKey : archives) {
            logger.debug("objectKey already exists, pulling to merge: {}", (Object)objectKey);
            Path fileLocation = archiveLocation.resolve(objectKey);
            this.pullFile(objectKey, fileLocation);
            fileToModifiedTime.put(objectKey, fileLocation.toFile().lastModified());
        }
        super.archive(events, namespace, startTimestampMillis, endTimestampMillis, metadataQuery, dimensionsQuery);
        for (Path archiveFile : super.getFileArchiveList(namespace, startTimestampMillis, endTimestampMillis)) {
            Long timeModified = (Long)fileToModifiedTime.get(archiveFile.getFileName().toString());
            if (timeModified == null || timeModified.longValue() != archiveFile.toFile().lastModified()) {
                this.uploadToS3(archiveFile.getFileName().toString(), archiveFile);
            }
            if (archiveFile.toFile().delete()) continue;
            logger.warn("failed to delete temp archive file {}", (Object)archiveFile);
        }
    }

    @Override
    public void restore(Events events, String namespace, long startTimestampMillis, long endTimestampMillis) throws IOException {
        Collection archiveFilenames = this.cantorOnS3.objects().keys(archiveNamespace, 0, -1);
        List archives = this.getMatchingArchives(namespace, archiveFilenames, startTimestampMillis, endTimestampMillis);
        Path archiveLocation = super.getArchiveLocation();
        for (String archiveObjectName : archives) {
            Path archiveFile;
            if (!this.pullFile(archiveObjectName, archiveFile = archiveLocation.resolve(archiveObjectName))) continue;
            super.doRestore(events, namespace, archiveFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadToS3(String objectKey, Path archiveFile) throws IOException {
        CommonPreconditions.checkArgument((Files.exists(archiveFile, new LinkOption[0]) && archiveFile.toFile().length() != 0L ? 1 : 0) != 0, (String)("file doesn't exist or is empty: " + archiveFile));
        int byteSize = 0;
        long startNanos = System.nanoTime();
        try (InputStream uploadStream = Files.newInputStream(archiveFile, new OpenOption[0]);){
            byteSize = uploadStream.available();
            byte[] fileBytes = new byte[byteSize];
            int read = uploadStream.read(fileBytes);
            if (read != byteSize) {
                throw new IOException(String.format("failed to read all bytes into memory %d/%d read", read, byteSize));
            }
            this.cantorOnS3.objects().store(archiveNamespace, objectKey, fileBytes);
        }
        catch (Throwable throwable) {
            logger.info("uploading file '{}' ({} bytes) took {}s", new Object[]{archiveFile, byteSize, TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startNanos)});
            throw throwable;
        }
        logger.info("uploading file '{}' ({} bytes) took {}s", new Object[]{archiveFile, byteSize, TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - startNanos)});
    }

    public boolean pullFile(String objectKey, Path archiveLocation) throws IOException {
        if (archiveLocation.toFile().exists()) {
            return false;
        }
        logger.debug("local file not found, pulling file from s3: {}", (Object)objectKey);
        byte[] fileBytes = this.cantorOnS3.objects().get(archiveNamespace, objectKey);
        try (OutputStream temporaryStorage = Files.newOutputStream(archiveLocation, new OpenOption[0]);){
            temporaryStorage.write(fileBytes);
            temporaryStorage.flush();
        }
        return true;
    }
}

