/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor;

import com.salesforce.cantor.Namespaceable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface Events
extends Namespaceable {
    default public void store(String namespace, long timestampMillis, Map<String, String> metadata, Map<String, Double> dimensions) throws IOException {
        this.store(namespace, timestampMillis, metadata, dimensions, null);
    }

    default public void store(String namespace, Event event) throws IOException {
        this.store(namespace, event.getTimestampMillis(), event.getMetadata(), event.getDimensions(), event.getPayload());
    }

    default public void store(String namespace, long timestampMillis, Map<String, String> metadata, Map<String, Double> dimensions, byte[] payload) throws IOException {
        this.store(namespace, Collections.singleton(new Event(timestampMillis, metadata, dimensions, payload)));
    }

    public void store(String var1, Collection<Event> var2) throws IOException;

    default public List<Event> get(String namespace, long startTimestampMillis, long endTimestampMillis) throws IOException {
        return this.get(namespace, startTimestampMillis, endTimestampMillis, false);
    }

    default public List<Event> get(String namespace, long startTimestampMillis, long endTimestampMillis, boolean includePayloads) throws IOException {
        return this.get(namespace, startTimestampMillis, endTimestampMillis, null, null, includePayloads, true, 0);
    }

    default public List<Event> get(String namespace, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery) throws IOException {
        return this.get(namespace, startTimestampMillis, endTimestampMillis, metadataQuery, dimensionsQuery, false, true, 0);
    }

    default public List<Event> get(String namespace, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery, boolean includePayloads) throws IOException {
        return this.get(namespace, startTimestampMillis, endTimestampMillis, metadataQuery, dimensionsQuery, includePayloads, true, 0);
    }

    public List<Event> get(String var1, long var2, long var4, Map<String, String> var6, Map<String, String> var7, boolean var8, boolean var9, int var10) throws IOException;

    public Set<String> metadata(String var1, String var2, long var3, long var5, Map<String, String> var7, Map<String, String> var8) throws IOException;

    public void expire(String var1, long var2) throws IOException;

    public static class Event {
        private final long timestampMillis;
        private final Map<String, String> metadata;
        private final Map<String, Double> dimensions;
        private final byte[] payload;

        public Event(long timestampMillis, Map<String, String> metadata, Map<String, Double> dimensions) {
            this(timestampMillis, metadata, dimensions, null);
        }

        public Event(long timestampMillis, Map<String, String> metadata, Map<String, Double> dimensions, byte[] payload) {
            this.timestampMillis = timestampMillis;
            this.metadata = metadata != null ? metadata : Collections.emptyMap();
            this.dimensions = dimensions != null ? dimensions : Collections.emptyMap();
            this.payload = payload;
        }

        public long getTimestampMillis() {
            return this.timestampMillis;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        public Map<String, Double> getDimensions() {
            return this.dimensions;
        }

        public byte[] getPayload() {
            return this.payload;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Event)) {
                return false;
            }
            Event other = (Event)obj;
            return this.getTimestampMillis() == other.getTimestampMillis() && this.getMetadata().equals(other.getMetadata()) && this.getDimensions().equals(other.getDimensions()) && Arrays.equals(this.getPayload(), other.getPayload());
        }

        public String toString() {
            return "timestampMillis=" + this.getTimestampMillis() + ",dimensions=" + this.getDimensions() + ",metadata=" + this.getMetadata() + ",payload=" + Arrays.toString(this.getPayload());
        }
    }
}

