/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.functions;

import com.salesforce.cantor.Cantor;
import com.salesforce.cantor.common.CommonPreconditions;
import com.salesforce.cantor.functions.Context;
import com.salesforce.cantor.functions.Executor;
import com.salesforce.cantor.functions.Functions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsOnCantor
implements Functions {
    private static final Logger logger = LoggerFactory.getLogger(FunctionsOnCantor.class);
    private final Cantor cantor;
    private final List<Executor> executors = new ArrayList<Executor>();

    public FunctionsOnCantor(Cantor cantor) {
        this.cantor = cantor;
        this.initExecutors();
    }

    @Override
    public void create(String namespace) throws IOException {
        CommonPreconditions.checkNamespace((String)namespace);
        this.doCreate(namespace);
    }

    @Override
    public void drop(String namespace) throws IOException {
        CommonPreconditions.checkNamespace((String)namespace);
        this.doDrop(namespace);
    }

    @Override
    public void store(String namespace, String function, String body) throws IOException {
        CommonPreconditions.checkString((String)body, (String)"missing function body");
        this.store(namespace, function, body.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void store(String namespace, String function, byte[] body) throws IOException {
        CommonPreconditions.checkNamespace((String)namespace);
        CommonPreconditions.checkString((String)function, (String)"missing function name");
        CommonPreconditions.checkArgument((boolean)function.contains("."), (String)"missing extension in function name");
        CommonPreconditions.checkArgument((body != null ? 1 : 0) != 0, (String)"missing function body");
        this.doStore(namespace, function, body);
    }

    @Override
    public byte[] get(String namespace, String function) throws IOException {
        CommonPreconditions.checkNamespace((String)namespace);
        CommonPreconditions.checkString((String)function, (String)"missing function name");
        return this.doGet(namespace, function);
    }

    @Override
    public void delete(String namespace, String function) throws IOException {
        CommonPreconditions.checkNamespace((String)namespace);
        CommonPreconditions.checkString((String)function, (String)"missing function name");
        this.doDelete(namespace, function);
    }

    @Override
    public Collection<String> list(String namespace) throws IOException {
        CommonPreconditions.checkNamespace((String)namespace);
        return this.doList(namespace);
    }

    @Override
    public void run(String namespace, String function, Context context, Map<String, String> params) throws IOException {
        CommonPreconditions.checkNamespace((String)namespace);
        CommonPreconditions.checkString((String)function, (String)"missing function name");
        CommonPreconditions.checkArgument((context != null ? 1 : 0) != 0, (String)"missing context");
        CommonPreconditions.checkArgument((params != null ? 1 : 0) != 0, (String)"missing parameters");
        this.doRun(namespace, function, context, params);
    }

    private void doRun(String namespace, String function, Context context, Map<String, String> params) throws IOException {
        byte[] body = this.get(namespace, function);
        if (body == null) {
            throw new IllegalArgumentException("function not found: " + function);
        }
        this.getExecutor(function).run(function, body, context, params);
    }

    private void initExecutors() {
        logger.info("loading all executors available in class path");
        ServiceLoader<Executor> loader = ServiceLoader.load(Executor.class);
        for (Executor executor : loader) {
            logger.info("loading executor: {} for extensions: {}", (Object)executor.getClass().getSimpleName(), executor.getExtensions());
            this.executors.add(executor);
        }
    }

    private void doCreate(String namespace) throws IOException {
        String functionNamespace = this.getFunctionNamespace(namespace);
        logger.info("creating objects namespace for functions: '{}'", (Object)functionNamespace);
        this.cantor.objects().create(functionNamespace);
    }

    private void doDrop(String namespace) throws IOException {
        String functionNamespace = this.getFunctionNamespace(namespace);
        logger.info("dropping objects namespace for functions: '{}'", (Object)functionNamespace);
        this.cantor.objects().drop(functionNamespace);
    }

    private void doStore(String namespace, String function, byte[] body) throws IOException {
        String functionNamespace = this.getFunctionNamespace(namespace);
        logger.info("storing function: '{}' in objects namespace: '{}'", (Object)function, (Object)functionNamespace);
        this.cantor.objects().store(functionNamespace, function, body);
    }

    private byte[] doGet(String namespace, String function) throws IOException {
        String functionNamespace = this.getFunctionNamespace(namespace);
        logger.info("retrieving function: '{}' from objects namespace: '{}'", (Object)function, (Object)functionNamespace);
        return this.cantor.objects().get(functionNamespace, function);
    }

    private void doDelete(String namespace, String function) throws IOException {
        String functionNamespace = this.getFunctionNamespace(namespace);
        logger.info("deleting function: name '{}' from objects namespace: '{}'", (Object)function, (Object)functionNamespace);
        this.cantor.objects().delete(functionNamespace, function);
    }

    private Collection<String> doList(String namespace) throws IOException {
        return this.cantor.objects().keys(this.getFunctionNamespace(namespace), 0, -1);
    }

    private Executor getExecutor(String functionName) {
        String extension = this.getExtension(functionName);
        for (Executor executor : this.executors) {
            if (!executor.getExtensions().contains(extension)) continue;
            return executor;
        }
        ArrayList<String> extensions = new ArrayList<String>();
        for (Executor executor : this.executors) {
            extensions.addAll(executor.getExtensions());
        }
        throw new IllegalArgumentException("executor for extension '" + extension + "' not found; supported extensions are: " + ((Object)extensions).toString());
    }

    private String getExtension(String name) {
        return name.substring(name.lastIndexOf(".") + 1);
    }

    private String getFunctionNamespace(String namespace) {
        return String.format("functions-%s", namespace);
    }
}

