/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.functions.executors;

import com.salesforce.cantor.functions.Context;
import com.salesforce.cantor.functions.Executor;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainExecutor
implements Executor {
    private static final Logger logger = LoggerFactory.getLogger(ChainExecutor.class);

    @Override
    public List<String> getExtensions() {
        return Arrays.asList("f", "chain");
    }

    @Override
    public void run(String function, byte[] body, Context context, Map<String, String> params) throws IOException {
        String functionChain = new String(body, StandardCharsets.UTF_8);
        logger.info("executing function chain: {}", (Object)functionChain);
        for (String part : functionChain.split("\\|")) {
            String qs = part.trim();
            String namespaceSlashFunction = qs.split("\\?")[0];
            if (!namespaceSlashFunction.contains("/")) {
                throw new RuntimeException("invalid namespace/function format: " + namespaceSlashFunction);
            }
            String functionNamespace = namespaceSlashFunction.split("/")[0];
            String functionName = namespaceSlashFunction.split("/")[1];
            Map functionParams = qs.contains("?") ? this.parseParams(qs.substring(qs.indexOf("?") + 1)) : Collections.emptyMap();
            HashMap<String, String> overrideParams = new HashMap<String, String>(params);
            overrideParams.putAll(functionParams);
            logger.info("executing function '{}' with parameters: '{}'", (Object)functionName, overrideParams);
            context.getFunctions().run(functionNamespace, functionName, context, overrideParams);
            logger.info("context: {}", context.keys());
        }
    }

    private Map<String, String> parseParams(String filterQueryString) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (String kv : filterQueryString.split("&")) {
            String[] keyValue = kv.split("=");
            if (keyValue.length == 1) {
                throw new RuntimeException("invalid key=value parameter format: " + kv);
            }
            params.put(keyValue[0], keyValue[1]);
        }
        return params;
    }
}

