/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.functions.executors;

import com.salesforce.cantor.functions.Context;
import com.salesforce.cantor.functions.Executor;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FreemarkerExecutor
implements Executor {
    private final Configuration configuration = new Configuration(Configuration.VERSION_2_3_21);

    @Override
    public List<String> getExtensions() {
        return Arrays.asList("ftl", "freemarker");
    }

    @Override
    public void run(String function, byte[] body, Context context, Map<String, String> params) {
        String templateBody = new String(body, StandardCharsets.UTF_8);
        this.process(function, templateBody, context, params);
    }

    public FreemarkerExecutor() {
        this.configuration.setClassForTemplateLoading(this.getClass(), "/");
    }

    private void process(String name, String source, Context context, Map<String, String> params) {
        try {
            String results = this.doProcess(name, source, context, params);
            if (context.get(".out") == null) {
                context.set(".out", results);
            }
        }
        catch (TemplateException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String doProcess(String name, String source, Context context, Map<String, String> params) throws IOException, TemplateException {
        Template template = new Template(name, source, this.configuration);
        StringWriter stringWriter = new StringWriter();
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("context", context);
        model.put("params", params);
        template.process(model, (Writer)stringWriter);
        return stringWriter.toString();
    }
}

