/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.functions.executors;

import com.salesforce.cantor.functions.Context;
import com.salesforce.cantor.functions.Executor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaExecutor
implements Executor {
    private static final Logger logger = LoggerFactory.getLogger(JavaExecutor.class);

    @Override
    public List<String> getExtensions() {
        return Collections.singletonList("java");
    }

    @Override
    public void run(String function, byte[] body, Context context, Map<String, String> params) throws IOException {
        String className = params.get(".class");
        if (className == null) {
            throw new RuntimeException("missing '.class' parameter");
        }
        String methodName = params.get(".method");
        if (methodName == null) {
            throw new RuntimeException("missing '.method' parameter");
        }
        Path tempPath = this.getBaseDirectory(UUID.randomUUID().toString());
        try {
            logger.info("executing java function: {} class: {} method: {}", new Object[]{function, className, methodName});
            String javaSource = new String(body, StandardCharsets.UTF_8);
            Path path = this.saveSource(tempPath, function, javaSource);
            this.compileSource(path);
            logger.info("class path is: {}", (Object)path);
            Object instance = this.getClassInstance(className, path);
            Method method = instance.getClass().getMethod(methodName, Context.class, Map.class);
            if (method == null) {
                throw new RuntimeException("method with signature " + className + "." + methodName + "(Context, Map) not found");
            }
            method.invoke(instance, context, params);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.deleteDirectory(tempPath.toFile());
        }
    }

    private void compileSource(Path javaFile) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int results = compiler.run(System.in, System.out, outputStream, javaFile.toFile().getAbsolutePath());
        if (results != 0) {
            throw new RuntimeException(new String(outputStream.toByteArray()));
        }
    }

    private Object getClassInstance(String className, Path javaClass) throws ReflectiveOperationException, MalformedURLException {
        URL classUrl = javaClass.getParent().toFile().toURI().toURL();
        URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{classUrl});
        return Class.forName(className, true, classLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private Path saveSource(Path path, String name, String source) throws IOException {
        logger.info("storing function: {} at: {}", (Object)name, (Object)path);
        Path sourcePath = path.resolve(name);
        Files.write(sourcePath, source.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return sourcePath;
    }

    private void deleteDirectory(File file) throws IOException {
        if (file.isDirectory()) {
            File[] list = file.listFiles();
            if (list == null) {
                return;
            }
            for (File f : list) {
                if (f == null || !f.isDirectory()) continue;
                this.deleteDirectory(f);
            }
        }
        if (!file.delete()) {
            throw new IOException("failed to delete: " + file.getAbsolutePath());
        }
    }

    private Path getBaseDirectory(String namespace) throws IOException {
        String tmpDir = System.getProperty("java.io.tmpdir");
        return Files.createDirectory(Paths.get(tmpDir, namespace), new FileAttribute[0]);
    }
}

