/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.functions.executors;

import com.salesforce.cantor.functions.Context;
import com.salesforce.cantor.functions.Executor;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptExecutor
implements Executor {
    private static final Logger logger = LoggerFactory.getLogger(ScriptExecutor.class);
    private final ScriptEngineManager manager = new ScriptEngineManager();
    private final Map<String, ScriptEngine> scriptEngines = new HashMap<String, ScriptEngine>();

    @Override
    public List<String> getExtensions() {
        ArrayList<String> extensions = new ArrayList<String>();
        for (ScriptEngineFactory factory : this.manager.getEngineFactories()) {
            extensions.addAll(factory.getExtensions());
        }
        return extensions;
    }

    @Override
    public void run(String function, byte[] body, Context context, Map<String, String> params) {
        String scriptBody = new String(body, StandardCharsets.UTF_8);
        SimpleScriptContext scriptContext = new SimpleScriptContext();
        scriptContext.setAttribute("context", context, 100);
        scriptContext.setAttribute("params", params, 100);
        StringWriter writer = new StringWriter();
        scriptContext.setWriter(writer);
        try {
            ScriptEngine engine = this.getEngine(this.getExtension(function));
            logger.info("script engine '{}' used for function '{}'", (Object)engine.getFactory().getEngineName(), (Object)function);
            engine.eval(scriptBody, (ScriptContext)scriptContext);
            if (params.get(".method") != null) {
                String methodName = params.get(".method");
                Invocable invocableEngine = (Invocable)((Object)engine);
                invocableEngine.invokeFunction(methodName, new Object[0]);
            }
        }
        catch (NoSuchMethodException | ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized ScriptEngine getEngine(String extension) {
        if (this.scriptEngines.containsKey(extension)) {
            return this.scriptEngines.get(extension);
        }
        ScriptEngine engine = this.manager.getEngineByExtension(extension);
        this.scriptEngines.put(extension, engine);
        return engine;
    }

    private String getExtension(String name) {
        return name.substring(name.lastIndexOf(".") + 1);
    }
}

