/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.grpc;

import com.google.protobuf.ByteString;
import com.salesforce.cantor.Events;
import com.salesforce.cantor.common.CommonUtils;
import com.salesforce.cantor.common.EventsPreconditions;
import com.salesforce.cantor.grpc.AbstractBaseGrpcClient;
import com.salesforce.cantor.grpc.events.AggregateRequest;
import com.salesforce.cantor.grpc.events.AggregateResponse;
import com.salesforce.cantor.grpc.events.CreateRequest;
import com.salesforce.cantor.grpc.events.DeleteRequest;
import com.salesforce.cantor.grpc.events.DeleteResponse;
import com.salesforce.cantor.grpc.events.DropRequest;
import com.salesforce.cantor.grpc.events.EventProto;
import com.salesforce.cantor.grpc.events.EventsServiceGrpc;
import com.salesforce.cantor.grpc.events.ExpireRequest;
import com.salesforce.cantor.grpc.events.GetRequest;
import com.salesforce.cantor.grpc.events.GetResponse;
import com.salesforce.cantor.grpc.events.MetadataRequest;
import com.salesforce.cantor.grpc.events.MetadataResponse;
import com.salesforce.cantor.grpc.events.NamespacesRequest;
import com.salesforce.cantor.grpc.events.StoreRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EventsOnGrpc
extends AbstractBaseGrpcClient<EventsServiceGrpc.EventsServiceBlockingStub>
implements Events {
    public EventsOnGrpc(String target) {
        super(EventsServiceGrpc::newBlockingStub, target);
    }

    public Collection<String> namespaces() throws IOException {
        return (Collection)this.call(() -> {
            NamespacesRequest request = NamespacesRequest.newBuilder().build();
            return ((EventsServiceGrpc.EventsServiceBlockingStub)this.getStub()).namespaces(request).getNamespacesList();
        });
    }

    public void create(String namespace) throws IOException {
        EventsPreconditions.checkCreate((String)namespace);
        this.call(() -> {
            CreateRequest request = CreateRequest.newBuilder().setNamespace(namespace).build();
            ((EventsServiceGrpc.EventsServiceBlockingStub)this.getStub()).create(request);
            return null;
        });
    }

    public void drop(String namespace) throws IOException {
        EventsPreconditions.checkDrop((String)namespace);
        this.call(() -> {
            DropRequest request = DropRequest.newBuilder().setNamespace(namespace).build();
            ((EventsServiceGrpc.EventsServiceBlockingStub)this.getStub()).drop(request);
            return null;
        });
    }

    public void store(String namespace, Collection<Events.Event> batch) throws IOException {
        EventsPreconditions.checkStore((String)namespace, batch);
        this.call(() -> {
            ArrayList<EventProto> eventBatch = new ArrayList<EventProto>();
            for (Events.Event event : batch) {
                eventBatch.add(EventProto.newBuilder().setTimestampMillis(event.getTimestampMillis()).putAllMetadata(event.getMetadata()).putAllDimensions(event.getDimensions()).setPayload(event.getPayload() != null ? ByteString.copyFrom((byte[])event.getPayload()) : ByteString.EMPTY).build());
            }
            StoreRequest request = StoreRequest.newBuilder().setNamespace(namespace).addAllBatch(eventBatch).build();
            ((EventsServiceGrpc.EventsServiceBlockingStub)this.getStub()).store(request);
            return null;
        });
    }

    public List<Events.Event> get(String namespace, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery, boolean includePayloads, boolean ascending, int limit) throws IOException {
        EventsPreconditions.checkGet((String)namespace, (long)startTimestampMillis, (long)endTimestampMillis, metadataQuery, dimensionsQuery);
        return this.call(() -> {
            GetRequest request = GetRequest.newBuilder().setNamespace(namespace).setStartTimestampMillis(startTimestampMillis).setEndTimestampMillis(endTimestampMillis).putAllMetadataQuery(CommonUtils.nullToEmpty((Map)metadataQuery)).putAllDimensionsQuery(CommonUtils.nullToEmpty((Map)dimensionsQuery)).setIncludePayloads(includePayloads).setAscending(ascending).setLimit(limit).build();
            ArrayList<Events.Event> results = new ArrayList<Events.Event>();
            GetResponse response = ((EventsServiceGrpc.EventsServiceBlockingStub)this.getStub()).get(request);
            List eventProtos = response.getResultsList();
            for (EventProto proto : eventProtos) {
                ByteString payloadByteString = proto.getPayload();
                results.add(new Events.Event(proto.getTimestampMillis(), proto.getMetadataMap(), proto.getDimensionsMap(), payloadByteString != null ? payloadByteString.toByteArray() : null));
            }
            return results;
        });
    }

    public int delete(String namespace, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery) throws IOException {
        EventsPreconditions.checkDelete((String)namespace, (long)startTimestampMillis, (long)endTimestampMillis, metadataQuery, dimensionsQuery);
        return this.call(() -> {
            DeleteRequest request = DeleteRequest.newBuilder().setNamespace(namespace).setStartTimestampMillis(startTimestampMillis).setEndTimestampMillis(endTimestampMillis).putAllMetadataQuery(CommonUtils.nullToEmpty((Map)metadataQuery)).putAllDimensionsQuery(CommonUtils.nullToEmpty((Map)dimensionsQuery)).build();
            DeleteResponse response = ((EventsServiceGrpc.EventsServiceBlockingStub)this.getStub()).delete(request);
            return response.getResults();
        });
    }

    public Map<Long, Double> aggregate(String namespace, String dimension, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery, int aggregateIntervalMillis, Events.AggregationFunction aggregationFunction) throws IOException {
        EventsPreconditions.checkAggregate((String)namespace, (String)dimension, (long)startTimestampMillis, (long)endTimestampMillis, metadataQuery, dimensionsQuery, (int)aggregateIntervalMillis, (Events.AggregationFunction)aggregationFunction);
        HashMap results = new HashMap();
        return this.call(() -> {
            AggregateRequest request = AggregateRequest.newBuilder().setNamespace(namespace).setDimension(dimension).setStartTimestampMillis(startTimestampMillis).setEndTimestampMillis(endTimestampMillis).putAllMetadataQuery(CommonUtils.nullToEmpty((Map)metadataQuery)).putAllDimensionsQuery(CommonUtils.nullToEmpty((Map)dimensionsQuery)).setAggregationIntervalMillis(aggregateIntervalMillis).setAggregationFunction(AggregateRequest.AggregationFunction.valueOf((String)aggregationFunction.name())).build();
            AggregateResponse aggregateResponse = ((EventsServiceGrpc.EventsServiceBlockingStub)this.getStub()).aggregate(request);
            block6: for (Map.Entry entry : aggregateResponse.getResultsMap().entrySet()) {
                long timestamp = (Long)entry.getKey();
                double value = (Double)entry.getValue();
                if (!results.containsKey(entry.getKey())) {
                    results.put(timestamp, value);
                    continue;
                }
                switch (aggregationFunction) {
                    case AVG: {
                        results.put(timestamp, (Double)results.get(timestamp) + value / 2.0);
                        continue block6;
                    }
                    case MAX: {
                        results.put(timestamp, Math.max((Double)results.get(timestamp), value));
                        continue block6;
                    }
                    case MIN: {
                        results.put(timestamp, Math.min((Double)results.get(timestamp), value));
                        continue block6;
                    }
                    case SUM: {
                        results.put(timestamp, (Double)results.get(timestamp) + value);
                        continue block6;
                    }
                }
                throw new IllegalStateException();
            }
            return results;
        });
    }

    public Set<String> metadata(String namespace, String metadataKey, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery) throws IOException {
        EventsPreconditions.checkMetadata((String)namespace, (String)metadataKey, (long)startTimestampMillis, (long)endTimestampMillis, metadataQuery, dimensionsQuery);
        return this.call(() -> {
            MetadataRequest request = MetadataRequest.newBuilder().setNamespace(namespace).setMetadataKey(metadataKey).setStartTimestampMillis(startTimestampMillis).setEndTimestampMillis(endTimestampMillis).putAllMetadataQuery(CommonUtils.nullToEmpty((Map)metadataQuery)).putAllDimensionsQuery(CommonUtils.nullToEmpty((Map)dimensionsQuery)).build();
            MetadataResponse metadataResponse = ((EventsServiceGrpc.EventsServiceBlockingStub)this.getStub()).metadata(request);
            return new HashSet(metadataResponse.getValuesList());
        });
    }

    public void expire(String namespace, long endTimestampMillis) throws IOException {
        EventsPreconditions.checkExpire((String)namespace, (long)endTimestampMillis);
        this.call(() -> {
            ExpireRequest request = ExpireRequest.newBuilder().setNamespace(namespace).setEndTimestampMillis(endTimestampMillis).build();
            ((EventsServiceGrpc.EventsServiceBlockingStub)this.getStub()).expire(request);
            return null;
        });
    }
}

