/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.grpc;

import com.salesforce.cantor.Sets;
import com.salesforce.cantor.common.SetsPreconditions;
import com.salesforce.cantor.grpc.AbstractBaseGrpcClient;
import com.salesforce.cantor.grpc.sets.AddBatchRequest;
import com.salesforce.cantor.grpc.sets.AddRequest;
import com.salesforce.cantor.grpc.sets.CreateRequest;
import com.salesforce.cantor.grpc.sets.DeleteBatchRequest;
import com.salesforce.cantor.grpc.sets.DeleteBetweenRequest;
import com.salesforce.cantor.grpc.sets.DeleteEntryRequest;
import com.salesforce.cantor.grpc.sets.DropRequest;
import com.salesforce.cantor.grpc.sets.GetRequest;
import com.salesforce.cantor.grpc.sets.IncRequest;
import com.salesforce.cantor.grpc.sets.IncResponse;
import com.salesforce.cantor.grpc.sets.IntersectRequest;
import com.salesforce.cantor.grpc.sets.KeysRequest;
import com.salesforce.cantor.grpc.sets.NamespacesRequest;
import com.salesforce.cantor.grpc.sets.PopRequest;
import com.salesforce.cantor.grpc.sets.SetsRequest;
import com.salesforce.cantor.grpc.sets.SetsServiceGrpc;
import com.salesforce.cantor.grpc.sets.SizeRequest;
import com.salesforce.cantor.grpc.sets.UnionRequest;
import com.salesforce.cantor.grpc.sets.WeightRequest;
import com.salesforce.cantor.grpc.sets.WeightResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class SetsOnGrpc
extends AbstractBaseGrpcClient<SetsServiceGrpc.SetsServiceBlockingStub>
implements Sets {
    public SetsOnGrpc(String target) {
        super(SetsServiceGrpc::newBlockingStub, target);
    }

    public Collection<String> namespaces() throws IOException {
        return (Collection)this.call(() -> {
            NamespacesRequest request = NamespacesRequest.newBuilder().build();
            return ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).namespaces(request).getNamespacesList();
        });
    }

    public void create(String namespace) throws IOException {
        SetsPreconditions.checkCreate((String)namespace);
        this.call(() -> {
            CreateRequest request = CreateRequest.newBuilder().setNamespace(namespace).build();
            ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).create(request);
            return null;
        });
    }

    public void drop(String namespace) throws IOException {
        SetsPreconditions.checkDrop((String)namespace);
        this.call(() -> {
            DropRequest request = DropRequest.newBuilder().setNamespace(namespace).build();
            ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).drop(request);
            return null;
        });
    }

    public Map<String, Long> get(String namespace, String set, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkGet((String)namespace, (String)set, (long)min, (long)max, (int)start, (int)count, (boolean)ascending);
        return this.call(() -> {
            GetRequest request = GetRequest.newBuilder().setNamespace(namespace).setSet(set).setMin(min).setMax(max).setStart(start).setCount(count).setAscending(ascending).build();
            return ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).get(request).getEntriesMap();
        });
    }

    public Map<String, Long> union(String namespace, Collection<String> sets, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkUnion((String)namespace, sets, (long)min, (long)max, (int)start, (int)count, (boolean)ascending);
        return this.call(() -> {
            UnionRequest request = UnionRequest.newBuilder().setNamespace(namespace).addAllSets((Iterable)sets).setMin(min).setMax(max).setStart(start).setCount(count).setAscending(ascending).build();
            return ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).union(request).getEntriesMap();
        });
    }

    public Map<String, Long> intersect(String namespace, Collection<String> sets, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkIntersect((String)namespace, sets, (long)min, (long)max, (int)start, (int)count, (boolean)ascending);
        return this.call(() -> {
            IntersectRequest request = IntersectRequest.newBuilder().setNamespace(namespace).addAllSets((Iterable)sets).setMin(min).setMax(max).setStart(start).setCount(count).setAscending(ascending).build();
            return ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).intersect(request).getEntriesMap();
        });
    }

    public Map<String, Long> pop(String namespace, String set, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkPop((String)namespace, (String)set, (long)min, (long)max, (int)start, (int)count, (boolean)ascending);
        return this.call(() -> {
            PopRequest request = PopRequest.newBuilder().setNamespace(namespace).setSet(set).setMin(min).setMax(max).setStart(start).setCount(count).setAscending(ascending).build();
            return ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).pop(request).getEntriesMap();
        });
    }

    public void add(String namespace, String set, String entry, long weight) throws IOException {
        SetsPreconditions.checkAdd((String)namespace, (String)set, (String)entry, (long)weight);
        this.call(() -> {
            AddRequest request = AddRequest.newBuilder().setNamespace(namespace).setSet(set).setEntry(entry).setWeight(weight).build();
            ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).add(request);
            return null;
        });
    }

    public void add(String namespace, String set, Map<String, Long> entries) throws IOException {
        SetsPreconditions.checkAdd((String)namespace, (String)set, entries);
        this.call(() -> {
            AddBatchRequest request = AddBatchRequest.newBuilder().setNamespace(namespace).setSet(set).putAllEntries(entries).build();
            ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).addBatch(request);
            return null;
        });
    }

    public void delete(String namespace, String set, long min, long max) throws IOException {
        SetsPreconditions.checkDelete((String)namespace, (String)set, (long)min, (long)max);
        this.call(() -> {
            DeleteBetweenRequest request = DeleteBetweenRequest.newBuilder().setNamespace(namespace).setSet(set).setMin(min).setMax(max).build();
            ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).deleteBetween(request);
            return null;
        });
    }

    public boolean delete(String namespace, String set, String entry) throws IOException {
        SetsPreconditions.checkDelete((String)namespace, (String)set, (String)entry);
        return this.call(() -> {
            DeleteEntryRequest request = DeleteEntryRequest.newBuilder().setNamespace(namespace).setSet(set).setEntry(entry).build();
            return ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).deleteEntry(request).getDeleted();
        });
    }

    public void delete(String namespace, String set, Collection<String> entries) throws IOException {
        SetsPreconditions.checkDelete((String)namespace, (String)set, entries);
        this.call(() -> {
            DeleteBatchRequest request = DeleteBatchRequest.newBuilder().setNamespace(namespace).setSet(set).addAllEntries((Iterable)entries).build();
            ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).deleteBatch(request);
            return null;
        });
    }

    public Collection<String> entries(String namespace, String set, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkKeys((String)namespace, (String)set, (long)min, (long)max, (int)start, (int)count, (boolean)ascending);
        return (Collection)this.call(() -> {
            KeysRequest request = KeysRequest.newBuilder().setNamespace(namespace).setSet(set).setMin(min).setMax(max).setStart(start).setCount(count).setAscending(ascending).build();
            return ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).keys(request).getKeysList();
        });
    }

    public Collection<String> sets(String namespace) throws IOException {
        SetsPreconditions.checkSets((String)namespace);
        return (Collection)this.call(() -> {
            SetsRequest request = SetsRequest.newBuilder().setNamespace(namespace).build();
            return ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).sets(request).getSetsList();
        });
    }

    public int size(String namespace, String set) throws IOException {
        SetsPreconditions.checkSize((String)namespace, (String)set);
        return this.call(() -> {
            SizeRequest request = SizeRequest.newBuilder().setNamespace(namespace).setSet(set).build();
            return ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).size(request).getSize();
        });
    }

    public Long weight(String namespace, String set, String entry) throws IOException {
        SetsPreconditions.checkWeight((String)namespace, (String)set, (String)entry);
        return this.call(() -> {
            WeightRequest request = WeightRequest.newBuilder().setNamespace(namespace).setSet(set).setEntry(entry).build();
            WeightResponse response = ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).weight(request);
            return response.getFound() ? Long.valueOf(response.getWeight()) : null;
        });
    }

    public long inc(String namespace, String set, String entry, long count) throws IOException {
        SetsPreconditions.checkInc((String)namespace, (String)set, (String)entry, (long)count);
        return this.call(() -> {
            IncRequest request = IncRequest.newBuilder().setNamespace(namespace).setSet(set).setEntry(entry).setCount(count).build();
            IncResponse response = ((SetsServiceGrpc.SetsServiceBlockingStub)this.getStub()).inc(request);
            return response.getResult();
        });
    }
}

