/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.h2;

import com.salesforce.cantor.Events;
import com.salesforce.cantor.h2.H2DataSourceProperties;
import com.salesforce.cantor.h2.H2DataSourceProvider;
import com.salesforce.cantor.h2.H2Utils;
import com.salesforce.cantor.jdbc.AbstractBaseEventsOnJdbc;
import com.salesforce.cantor.jdbc.JdbcUtils;
import java.io.IOException;
import java.util.Map;
import javax.sql.DataSource;

public class EventsOnH2
extends AbstractBaseEventsOnJdbc
implements Events {
    public EventsOnH2(String path) throws IOException {
        this(H2DataSourceProvider.getDatasource(new H2DataSourceProperties().setPath(path)));
    }

    public EventsOnH2(DataSource dataSource) throws IOException {
        super(dataSource);
    }

    protected String getCreateInternalDatabaseSql() {
        return H2Utils.getH2CreateDatabaseSql(this.getCantorInternalDatabaseName());
    }

    protected String getCreateDatabaseSql(String namespace) {
        return H2Utils.getH2CreateDatabaseSql(namespace);
    }

    protected String getDropDatabaseSql(String namespace) {
        return H2Utils.getH2DropDatabaseSql(namespace);
    }

    protected String getCreateChunkLookupTableSql(String namespace) {
        return String.format("CREATE TABLE IF NOT EXISTS %s ( `ID` INT NOT NULL AUTO_INCREMENT, %s VARCHAR(256), %s VARCHAR(256), %s VARCHAR(256), %s BIGINT, PRIMARY KEY (ID),  INDEX (%s), INDEX (%s), INDEX (%s), INDEX (%s) )", this.getTableFullName(namespace, this.getChunksLookupTableName()), JdbcUtils.quote((String)this.getTableNameColumnName()), JdbcUtils.quote((String)this.getKeyColumnName()), JdbcUtils.quote((String)this.getColumnColumnName()), JdbcUtils.quote((String)this.getStartTimestampMillisColumnName()), JdbcUtils.quote((String)this.getTableNameColumnName()), JdbcUtils.quote((String)this.getKeyColumnName()), JdbcUtils.quote((String)this.getColumnColumnName()), JdbcUtils.quote((String)this.getStartTimestampMillisColumnName()));
    }

    protected String getCreateChunkTableSql(String chunkTableName, String namespace, Map<String, String> metadata, Map<String, Double> dimensions) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("CREATE TABLE IF NOT EXISTS ").append(this.getTableFullName(namespace, chunkTableName)).append(" (").append(JdbcUtils.quote((String)this.getEventTimestampColumnName())).append(" BIGINT,");
        for (String metadataKey : this.getOrderedKeys(metadata)) {
            sqlBuilder.append(JdbcUtils.quote((String)this.getMetadataKeyColumnName(metadataKey))).append(" VARCHAR, ");
        }
        for (String dimensionKey : this.getOrderedKeys(dimensions)) {
            sqlBuilder.append(JdbcUtils.quote((String)this.getDimensionKeyColumnName(dimensionKey))).append(" DOUBLE, ");
        }
        sqlBuilder.append(JdbcUtils.quote((String)this.getPayloadColumnName())).append(" BLOB,");
        sqlBuilder.append("INDEX ").append("(").append(JdbcUtils.quote((String)this.getEventTimestampColumnName())).append("),");
        for (String metadataKey : this.getOrderedKeys(metadata)) {
            sqlBuilder.append("INDEX ").append("(").append(JdbcUtils.quote((String)this.getMetadataKeyColumnName(metadataKey))).append("),");
        }
        for (String dimensionKey : this.getOrderedKeys(dimensions)) {
            sqlBuilder.append("INDEX ").append("(").append(JdbcUtils.quote((String)this.getDimensionKeyColumnName(dimensionKey))).append("),");
        }
        sqlBuilder.delete(sqlBuilder.length() - 1, sqlBuilder.length());
        sqlBuilder.append(")");
        return sqlBuilder.toString();
    }

    protected String getRegexPattern(String originalPattern) {
        String finalPattern = originalPattern.replaceAll("\\*", "\\.\\*");
        if (!originalPattern.startsWith("*")) {
            finalPattern = "^" + finalPattern;
        }
        if (!originalPattern.endsWith("*")) {
            finalPattern = finalPattern + "$";
        }
        return finalPattern;
    }

    protected String getRegexQuery(String column) {
        return String.format(" REGEXP_LIKE (%s, ?) ", column);
    }

    protected String getNotRegexQuery(String column) {
        return String.format(" NOT REGEXP_LIKE (%s, ?) ", column);
    }
}

