/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.h2;

import com.salesforce.cantor.h2.H2DataSourceProperties;
import com.zaxxer.hikari.HikariDataSource;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H2DataSourceProvider {
    private static final Logger logger = LoggerFactory.getLogger(H2DataSourceProvider.class);
    private static final Map<String, DataSource> datasourceCache = new ConcurrentHashMap<String, DataSource>();

    public static synchronized DataSource getDatasource(H2DataSourceProperties builder) {
        String datasourceCacheKey = builder.getPath();
        if (!datasourceCache.containsKey(datasourceCacheKey)) {
            datasourceCache.put(datasourceCacheKey, H2DataSourceProvider.doGetDataSource(builder));
        }
        return datasourceCache.get(datasourceCacheKey);
    }

    private static DataSource doGetDataSource(H2DataSourceProperties datasourceProperties) {
        Path dbPath = Paths.get(String.format("%s/cantor", datasourceProperties.getPath()), new String[0]);
        String jdbcUrl = String.format("jdbc:h2:%s:%s;MODE=MYSQL;COMPRESS=" + String.valueOf(datasourceProperties.isCompressed()).toUpperCase() + ";LOCK_TIMEOUT=30000;TRACE_LEVEL_FILE=1;TRACE_MAX_FILE_SIZE=4;AUTOCOMMIT=TRUE;AUTO_SERVER=" + String.valueOf(datasourceProperties.isAutoServer()).toUpperCase() + ";LOCK_MODE=1;MAX_COMPACT_TIME=3000;", datasourceProperties.isInMemory() ? "mem" : "split", dbPath.toAbsolutePath().toString());
        logger.info("jdbc url for datasource is: {}", (Object)jdbcUrl);
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        HikariDataSource connectoinPoolDataSource = new HikariDataSource();
        connectoinPoolDataSource.setJdbcUrl(jdbcUrl);
        connectoinPoolDataSource.setUsername(datasourceProperties.getUsername());
        connectoinPoolDataSource.setPassword(datasourceProperties.getPassword());
        connectoinPoolDataSource.setMaximumPoolSize(datasourceProperties.getMaxPoolSize());
        connectoinPoolDataSource.setConnectionTimeout((long)datasourceProperties.getConnectionTimeoutMillis());
        return connectoinPoolDataSource;
    }
}

