/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.h2;

import com.salesforce.cantor.h2.H2DataSourceProperties;
import com.salesforce.cantor.h2.H2DataSourceProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class H2Helper {
    public static void dump(String path, boolean inMemory, String dumpFile) throws SQLException {
        H2DataSourceProperties dataSourceBuilder = new H2DataSourceProperties(){}.setPath(path).setInMemory(inMemory);
        Connection connection = H2DataSourceProvider.getDatasource(dataSourceBuilder).getConnection();
        String sql = String.format("SCRIPT TO '%s' COMPRESSION ZIP", dumpFile);
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.execute();
    }

    public static void load(String path, boolean inMemory, String dumpFile) throws SQLException {
        H2DataSourceProperties dataSourceBuilder = new H2DataSourceProperties(){}.setPath(path).setInMemory(inMemory);
        Connection connection = H2DataSourceProvider.getDatasource(dataSourceBuilder).getConnection();
        String sql = String.format("RUNSCRIPT FROM '%s' COMPRESSION ZIP", dumpFile);
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.execute();
    }

    public static void drop(String path, String database) throws SQLException {
        H2DataSourceProperties dataSourceBuilder = new H2DataSourceProperties(){}.setPath(path);
        Connection connection = H2DataSourceProvider.getDatasource(dataSourceBuilder).getConnection();
        String sql = String.format("DROP SCHEMA IF EXISTS `%s` CASCADE", database);
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        preparedStatement.execute();
    }
}

