/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.h2;

import com.salesforce.cantor.Sets;
import com.salesforce.cantor.h2.H2DataSourceProperties;
import com.salesforce.cantor.h2.H2DataSourceProvider;
import com.salesforce.cantor.h2.H2Utils;
import com.salesforce.cantor.jdbc.AbstractBaseSetsOnJdbc;
import com.salesforce.cantor.jdbc.JdbcUtils;
import java.io.IOException;
import javax.sql.DataSource;

public class SetsOnH2
extends AbstractBaseSetsOnJdbc
implements Sets {
    public SetsOnH2(String path) throws IOException {
        this(H2DataSourceProvider.getDatasource(new H2DataSourceProperties().setPath(path)));
    }

    public SetsOnH2(DataSource dataSource) throws IOException {
        super(dataSource);
    }

    protected String getCreateInternalDatabaseSql() {
        return H2Utils.getH2CreateDatabaseSql(this.getCantorInternalDatabaseName());
    }

    protected String getCreateDatabaseSql(String namespace) {
        return H2Utils.getH2CreateDatabaseSql(namespace);
    }

    protected String getDropDatabaseSql(String namespace) {
        return H2Utils.getH2DropDatabaseSql(namespace);
    }

    protected String getCreateSetsTableSql(String namespace) {
        return "CREATE TABLE IF NOT EXISTS " + this.getTableFullName(namespace, this.getSetsTableName()) + " (  " + JdbcUtils.quote((String)this.getSetKeyColumnName()) + " VARCHAR NOT NULL,  " + JdbcUtils.quote((String)this.getEntryColumnName()) + " VARCHAR NOT NULL,  " + JdbcUtils.quote((String)this.getWeightColumnName()) + " BIGINT,   PRIMARY KEY (" + JdbcUtils.quote((String)this.getSetKeyColumnName()) + ", " + JdbcUtils.quote((String)this.getEntryColumnName()) + "),   INDEX (" + JdbcUtils.quote((String)this.getSetKeyColumnName()) + "),   INDEX (" + JdbcUtils.quote((String)this.getWeightColumnName()) + ") ) ";
    }
}

