/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.http.jersey;

import com.salesforce.cantor.Cantor;
import com.salesforce.cantor.h2.CantorOnH2;
import com.salesforce.cantor.h2.H2DataSourceProperties;
import com.salesforce.cantor.h2.H2DataSourceProvider;
import com.salesforce.cantor.http.jersey.SwaggerJaxrsConfig;
import com.salesforce.cantor.http.resources.EventsResource;
import com.salesforce.cantor.http.resources.FunctionsResource;
import com.salesforce.cantor.http.resources.ObjectsResource;
import com.salesforce.cantor.http.resources.SetsResource;
import com.salesforce.cantor.misc.loggable.LoggableCantor;
import com.salesforce.cantor.mysql.CantorOnMysql;
import java.io.IOException;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedHttpServer {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedHttpServer.class);

    Server createServer(int port, String basePath) {
        SwaggerJaxrsConfig config = new SwaggerJaxrsConfig();
        final Cantor cantor = this.getCantorOnMysql();
        config.register(new AbstractBinder(){

            protected void configure() {
                this.bind(new EventsResource(cantor));
                this.bind(new ObjectsResource(cantor));
                this.bind(new SetsResource(cantor));
                this.bind(new FunctionsResource(cantor));
            }
        });
        Server server = new Server(port);
        ServletHolder jerseyServlet = new ServletHolder((Servlet)new ServletContainer((ResourceConfig)config));
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)server, "/");
        context.addServlet(jerseyServlet, basePath);
        context.setResourceBase("cantor-http-server/src/main/resources/static");
        context.addServlet(DefaultServlet.class, "/");
        return server;
    }

    private Cantor getCantorOnMysql() {
        try {
            CantorOnMysql cantorOnMysql = new CantorOnMysql("localhost", 3306, null, null);
            return new LoggableCantor((Cantor)cantorOnMysql);
        }
        catch (IOException e) {
            logger.error("failed to initialize cantor:", (Throwable)e);
            return null;
        }
    }

    private Cantor getCantorOnH2() {
        try {
            H2DataSourceProperties h2Properties = new H2DataSourceProperties().setPath("/tmp/cantor-server-tmp/").setInMemory(false).setCompressed(false).setUsername("cantor").setPassword("");
            CantorOnH2 cantorOnH2 = new CantorOnH2(H2DataSourceProvider.getDatasource((H2DataSourceProperties)h2Properties));
            return new LoggableCantor((Cantor)cantorOnH2);
        }
        catch (IOException e) {
            logger.error("failed to initialize cantor:", (Throwable)e);
            return null;
        }
    }
}

