/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.jdbc;

import java.sql.PreparedStatement;
import java.sql.SQLException;

public class JdbcUtils {
    public static String quote(String s) {
        return String.format("`%s`", s);
    }

    static void addParameters(PreparedStatement preparedStatement, Object ... parameters) throws SQLException {
        if (parameters == null) {
            return;
        }
        int index = 0;
        for (Object param : parameters) {
            ++index;
            if (param instanceof Integer) {
                preparedStatement.setInt(index, (Integer)param);
                continue;
            }
            if (param instanceof Long) {
                preparedStatement.setLong(index, (Long)param);
                continue;
            }
            if (param instanceof Boolean) {
                preparedStatement.setBoolean(index, (Boolean)param);
                continue;
            }
            if (param instanceof String) {
                preparedStatement.setString(index, (String)param);
                continue;
            }
            if (param instanceof Double) {
                preparedStatement.setDouble(index, (Double)param);
                continue;
            }
            if (param instanceof Float) {
                preparedStatement.setFloat(index, ((Float)param).floatValue());
                continue;
            }
            if (param instanceof byte[]) {
                preparedStatement.setBytes(index, (byte[])param);
                continue;
            }
            throw new IllegalStateException("invalid parameter type: " + param);
        }
    }

    static String getPlaceholders(int count) {
        if (count == 1) {
            return "?";
        }
        StringBuilder placeholders = new StringBuilder("?");
        for (int i = 1; i < count; ++i) {
            placeholders.append(",?");
        }
        return placeholders.toString();
    }
}

