/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.jdbc;

import com.salesforce.cantor.Events;
import com.salesforce.cantor.common.CommonUtils;
import com.salesforce.cantor.common.EventsPreconditions;
import com.salesforce.cantor.jdbc.AbstractBaseCantorOnJdbc;
import com.salesforce.cantor.jdbc.JdbcUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseEventsOnJdbc
extends AbstractBaseCantorOnJdbc
implements Events {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected AbstractBaseEventsOnJdbc(DataSource dataSource) {
        super(dataSource);
    }

    public Collection<String> namespaces() throws IOException {
        return this.getNamespaces();
    }

    public void create(String namespace) throws IOException {
        EventsPreconditions.checkCreate((String)namespace);
        this.createNamespace(namespace);
    }

    public void drop(String namespace) throws IOException {
        EventsPreconditions.checkDrop((String)namespace);
        this.dropNamespace(namespace);
    }

    public void store(String namespace, Collection<Events.Event> batch) throws IOException {
        EventsPreconditions.checkStore((String)namespace, batch);
        this.doStore(namespace, batch);
    }

    public List<Events.Event> get(String namespace, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery, boolean includePayloads, boolean ascending, int limit) throws IOException {
        EventsPreconditions.checkGet((String)namespace, (long)startTimestampMillis, (long)endTimestampMillis, metadataQuery, dimensionsQuery);
        return this.doGet(namespace, startTimestampMillis, endTimestampMillis, CommonUtils.nullToEmpty(metadataQuery), CommonUtils.nullToEmpty(dimensionsQuery), includePayloads, ascending, limit);
    }

    public Set<String> metadata(String namespace, String metadataKey, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery) throws IOException {
        EventsPreconditions.checkMetadata((String)namespace, (String)metadataKey, (long)startTimestampMillis, (long)endTimestampMillis, metadataQuery, dimensionsQuery);
        return this.doMetadata(namespace, metadataKey, startTimestampMillis, endTimestampMillis, CommonUtils.nullToEmpty(metadataQuery), CommonUtils.nullToEmpty(dimensionsQuery));
    }

    public void expire(String namespace, long endTimestampMillis) throws IOException {
        EventsPreconditions.checkExpire((String)namespace, (long)endTimestampMillis);
        this.doExpire(namespace, endTimestampMillis);
    }

    @Override
    protected String getNamespaceLookupTableName() {
        return "EVENTS-NAMESPACES";
    }

    @Override
    protected void createInternalTables(Connection connection, String namespace) throws IOException {
        this.logger.info("creating chunk lookup table for namespace: {}", (Object)namespace);
        String chunkLookupTableSql = this.getCreateChunkLookupTableSql(namespace);
        this.executeUpdate(connection, chunkLookupTableSql, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doValidations() throws IOException {
        this.logger.info("looking for mismatch between database and lookup tables");
        Connection connection = null;
        try {
            connection = this.getConnection();
            for (String namespace : this.getNamespaces()) {
                this.logger.info("verifying namespace '{}'", (Object)namespace);
                List<String> tablesInDatabase = this.getTablesInDatabase(connection, namespace);
                List<String> tablesInlookupTable = this.getChunkTableNames(namespace, 0L, Long.MAX_VALUE, Collections.emptyList(), Collections.emptyList());
                for (String chunkTable : tablesInlookupTable) {
                    if (tablesInDatabase.contains(chunkTable)) continue;
                    this.logger.warn("chunk table '{}' in namespace '{}' does not exist in database; removing it from lookup table", (Object)chunkTable, (Object)namespace);
                    this.removeChunkFromLookupTable(connection, namespace, chunkTable);
                }
                for (String databaseTable : tablesInDatabase) {
                    if (this.getChunksLookupTableName().equalsIgnoreCase(databaseTable) || !databaseTable.startsWith(this.getChunkTableNamePrefix()) || tablesInlookupTable.contains(databaseTable)) continue;
                    this.logger.warn("table '{}' in namespace '{}' exists in database but not in lookup table", (Object)databaseTable, (Object)namespace);
                    this.dropTable(connection, namespace, databaseTable);
                }
            }
        }
        finally {
            this.closeConnection(connection);
        }
    }

    protected abstract String getCreateChunkLookupTableSql(String var1);

    protected abstract String getCreateChunkTableSql(String var1, String var2, Map<String, String> var3, Map<String, Double> var4);

    private void createChunkTable(Connection connection, String namespace, Events.Event sampleEvent) throws IOException {
        String chunkTableName = this.getChunkTableName(sampleEvent.getTimestampMillis(), sampleEvent.getMetadata().keySet(), sampleEvent.getDimensions().keySet());
        this.logger.info("creating chunk table {}.{}", (Object)namespace, (Object)chunkTableName);
        String sql = this.getCreateChunkTableSql(chunkTableName, namespace, sampleEvent.getMetadata(), sampleEvent.getDimensions());
        this.executeUpdate(connection, sql, new Object[0]);
        this.addChunkToLookupTable(connection, namespace, chunkTableName, sampleEvent);
    }

    private void removeChunkFromLookupTable(Connection connection, String namespace, String chunkTableName) throws IOException {
        this.logger.info("removing chunk '{}' from lookup table for namespace '{}'", (Object)chunkTableName, (Object)namespace);
        String deleteChunkLookupSql = String.format("DELETE FROM %s WHERE %s = ?", this.getTableFullName(namespace, this.getChunksLookupTableName()), JdbcUtils.quote(this.getTableNameColumnName()));
        this.executeUpdate(connection, deleteChunkLookupSql, chunkTableName);
    }

    private void addChunkToLookupTable(Connection connection, String namespace, String chunkTableName, Events.Event event) throws IOException {
        this.logger.info("adding chunk '{}' to lookup table for namespace '{}'", (Object)chunkTableName, (Object)namespace);
        this.executeUpdate(connection, String.format("INSERT INTO %s SET %s = ?, %s = ?, %s = ? ON DUPLICATE KEY UPDATE %s = ?", this.getTableFullName(namespace, this.getChunksLookupTableName()), JdbcUtils.quote(this.getTableNameColumnName()), JdbcUtils.quote(this.getColumnColumnName()), JdbcUtils.quote(this.getStartTimestampMillisColumnName()), JdbcUtils.quote(this.getTableNameColumnName())), chunkTableName, "", this.getWindowForTimestamp(event.getTimestampMillis()), chunkTableName);
        String sql = String.format("INSERT INTO %s SET %s = ?, %s = ?, %s = ?, %s = ? ON DUPLICATE KEY UPDATE %s = ?", this.getTableFullName(namespace, this.getChunksLookupTableName()), JdbcUtils.quote(this.getTableNameColumnName()), JdbcUtils.quote(this.getKeyColumnName()), JdbcUtils.quote(this.getColumnColumnName()), JdbcUtils.quote(this.getStartTimestampMillisColumnName()), JdbcUtils.quote(this.getTableNameColumnName()));
        for (String metadataKey : event.getMetadata().keySet()) {
            this.executeUpdate(connection, sql, chunkTableName, metadataKey, this.getMetadataKeyColumnName(metadataKey), this.getWindowForTimestamp(event.getTimestampMillis()), chunkTableName);
        }
        for (String dimensionKey : event.getDimensions().keySet()) {
            this.executeUpdate(connection, sql, chunkTableName, dimensionKey, this.getDimensionKeyColumnName(dimensionKey), this.getWindowForTimestamp(event.getTimestampMillis()), chunkTableName);
        }
    }

    private List<String> getTablesInDatabase(Connection connection, String namespace) throws IOException {
        ArrayList<String> tables = new ArrayList<String>();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(this.getDatabaseNameForNamespace(namespace), null, "%", null);
            while (resultSet.next()) {
                tables.add(resultSet.getString(3));
            }
        }
        catch (SQLException e) {
            this.logger.warn("failed to fetch list of tables in database");
            throw new IOException(e);
        }
        return tables;
    }

    private Map<String, String> getColumnNameToKeyNameMap(String namespace, String chunkTableName) throws IOException {
        String sql = String.format("SELECT %s, %s FROM %s WHERE %s IS NOT NULL AND %s = ? ", JdbcUtils.quote(this.getColumnColumnName()), JdbcUtils.quote(this.getKeyColumnName()), this.getTableFullName(namespace, this.getChunksLookupTableName()), JdbcUtils.quote(this.getKeyColumnName()), JdbcUtils.quote(this.getTableNameColumnName()));
        HashMap<String, String> results = new HashMap<String, String>();
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setString(1, chunkTableName);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    results.put(resultSet.getString(1), resultSet.getString(2));
                }
            }
        }
        catch (SQLException e) {
            this.logger.warn("caught exception executing query sql '{}': {}", (Object)sql, (Object)e.getMessage());
            throw new IOException(e);
        }
        return results;
    }

    private void doExpire(String namespace, long endTimestampMillis) throws IOException {
        if (endTimestampMillis < this.getWindowSizeMillis()) {
            this.logger.info("expiring end timestamp is smaller than the window size; ignoring.");
            return;
        }
        long windowFloorEndTimestamp = this.getWindowForTimestamp(endTimestampMillis - this.getWindowSizeMillis() + 1L);
        List<String> chunkTables = this.getChunkTableNames(namespace, 0L, windowFloorEndTimestamp, Collections.emptyList(), Collections.emptyList());
        for (String chunkTable : chunkTables) {
            this.doExpireChunkTable(namespace, chunkTable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExpireChunkTable(String namespace, String chunkTable) throws IOException {
        this.logger.info("expiring chunk table {} from namespace {}", (Object)chunkTable, (Object)namespace);
        Connection connection = null;
        try {
            connection = this.openTransaction(this.getConnection());
            this.removeChunkFromLookupTable(connection, namespace, chunkTable);
            this.dropTable(connection, namespace, chunkTable);
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private void dropTable(Connection connection, String namespace, String chunkTable) throws IOException {
        this.executeUpdate(connection, this.getDropTableSql(namespace, chunkTable), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStore(String namespace, Collection<Events.Event> batch) throws IOException {
        Map<String, Collection<Object[]>> chunkTableToParameters = this.toChunkTableBatchParameters(batch);
        Map<String, String> chunkTableToInsertSqls = this.toChunkTableInsertSqls(namespace, batch);
        Map<String, Events.Event> chunkTableToCreateParameters = this.toChunkTableCreateParameters(batch);
        Connection connection = null;
        try {
            connection = this.openTransaction(this.getConnection());
            for (Map.Entry<String, Collection<Object[]>> entry : chunkTableToParameters.entrySet()) {
                String insertSql = chunkTableToInsertSqls.get(entry.getKey());
                try {
                    this.executeBatchUpdate(connection, insertSql, entry.getValue());
                }
                catch (IOException e) {
                    Events.Event sampleEvent = chunkTableToCreateParameters.get(entry.getKey());
                    this.createChunkTable(connection, namespace, sampleEvent);
                    this.executeBatchUpdate(connection, insertSql, entry.getValue());
                }
            }
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private Map<String, Events.Event> toChunkTableCreateParameters(Collection<Events.Event> batch) {
        HashMap<String, Events.Event> chunkTableCreateParameters = new HashMap<String, Events.Event>();
        for (Events.Event event : batch) {
            long timestampMillis = event.getTimestampMillis();
            Map metadata = event.getMetadata();
            Map dimensions = event.getDimensions();
            String chunkTableName = this.getChunkTableName(timestampMillis, metadata.keySet(), dimensions.keySet());
            if (chunkTableCreateParameters.containsKey(chunkTableName)) continue;
            chunkTableCreateParameters.put(chunkTableName, event);
        }
        return chunkTableCreateParameters;
    }

    private Map<String, String> toChunkTableInsertSqls(String namespace, Collection<Events.Event> batch) {
        HashMap<String, String> chunkTableInsertSqls = new HashMap<String, String>();
        for (Events.Event event : batch) {
            long timestampMillis = event.getTimestampMillis();
            Map metadata = event.getMetadata();
            Map dimensions = event.getDimensions();
            String chunkTableName = this.getChunkTableName(timestampMillis, metadata.keySet(), dimensions.keySet());
            if (chunkTableInsertSqls.containsKey(chunkTableName)) continue;
            chunkTableInsertSqls.put(chunkTableName, this.getChunkTableInsertSql(namespace, timestampMillis, metadata, dimensions));
        }
        return chunkTableInsertSqls;
    }

    private String getChunkTableInsertSql(String namespace, long timestampMillis, Map<String, String> metadata, Map<String, Double> dimensions) {
        String chunkTableName = this.getChunkTableName(timestampMillis, metadata.keySet(), dimensions.keySet());
        String insertSql = String.format("INSERT INTO %s SET %s = ? ", this.getTableFullName(namespace, chunkTableName), JdbcUtils.quote(this.getEventTimestampColumnName()));
        List<String> sortedMetadataKeys = this.getKeysOrdered(metadata);
        List<String> sortedDimensionKeys = this.getKeysOrdered(dimensions);
        StringBuilder builder = new StringBuilder(insertSql);
        for (String metadataKey : sortedMetadataKeys) {
            builder.append(",").append(JdbcUtils.quote(this.getMetadataKeyColumnName(metadataKey))).append(" = ?");
        }
        for (String dimensionKey : sortedDimensionKeys) {
            builder.append(",").append(JdbcUtils.quote(this.getDimensionKeyColumnName(dimensionKey))).append(" = ?");
        }
        builder.append(", ").append(JdbcUtils.quote(this.getPayloadColumnName())).append(" = ?");
        return builder.toString();
    }

    private Map<String, Collection<Object[]>> toChunkTableBatchParameters(Collection<Events.Event> batch) {
        HashMap<String, Collection<Object[]>> sqlPerBatch = new HashMap<String, Collection<Object[]>>();
        for (Events.Event event : batch) {
            long timestampMillis = event.getTimestampMillis();
            Map metadata = event.getMetadata();
            Map dimensions = event.getDimensions();
            byte[] payload = event.getPayload();
            String chunkTableName = this.getChunkTableName(timestampMillis, metadata.keySet(), dimensions.keySet());
            List<String> sortedMetadataKeys = this.getKeysOrdered(metadata);
            List<String> sortedDimensionKeys = this.getKeysOrdered(dimensions);
            Object[] parameters = new Object[1 + metadata.size() + dimensions.size() + 1];
            int index = 0;
            parameters[index++] = timestampMillis;
            for (String metadataKey : sortedMetadataKeys) {
                parameters[index++] = metadata.get(metadataKey);
            }
            for (String dimensionKey : sortedDimensionKeys) {
                parameters[index++] = dimensions.get(dimensionKey);
            }
            parameters[index] = payload != null ? payload : new byte[]{};
            if (!sqlPerBatch.containsKey(chunkTableName)) {
                sqlPerBatch.put(chunkTableName, new ArrayList());
            }
            ((Collection)sqlPerBatch.get(chunkTableName)).add(parameters);
        }
        return sqlPerBatch;
    }

    private List<Events.Event> doGet(String namespace, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery, boolean includePayloads, boolean ascending, int limit) throws IOException {
        List<String> chunkTables = this.getChunkTableNames(namespace, startTimestampMillis, endTimestampMillis, metadataQuery.keySet(), dimensionsQuery.keySet());
        ExecutorService executorService = Executors.newCachedThreadPool();
        CopyOnWriteArrayList<Events.Event> results = new CopyOnWriteArrayList<Events.Event>();
        for (String chunkTableName : chunkTables) {
            executorService.submit(() -> results.addAll(this.doGetOnChunkTable(namespace, chunkTableName, startTimestampMillis, endTimestampMillis, metadataQuery, dimensionsQuery, includePayloads, ascending, limit)));
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new IOException("events get operation timed out", e);
        }
        this.sortEventsByTimestamp(results, ascending);
        if (limit > 0) {
            return results.subList(0, Math.min(limit, results.size()));
        }
        return results;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<Events.Event> doGetOnChunkTable(String namespace, String chunkTableName, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery, boolean includePayloads, boolean ascending, int limit) throws IOException {
        Thread.currentThread().setName(String.format("get-chunk-%s.%s", namespace, chunkTableName));
        String sqlFormat = "SELECT %s %s %s %s %s FROM %s WHERE %s BETWEEN ? AND ? ";
        Map<String, String> keyHashToName = this.getColumnNameToKeyNameMap(namespace, chunkTableName);
        StringBuilder sqlBuilder = new StringBuilder(String.format("SELECT %s %s %s %s %s FROM %s WHERE %s BETWEEN ? AND ? ", JdbcUtils.quote(this.getEventTimestampColumnName()), includePayloads ? "," : "", includePayloads ? JdbcUtils.quote(this.getPayloadColumnName()) : "", !keyHashToName.isEmpty() ? "," : "", keyHashToName.keySet().stream().map(JdbcUtils::quote).collect(Collectors.joining(",")), this.getTableFullName(namespace, chunkTableName), JdbcUtils.quote(this.getEventTimestampColumnName())));
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(startTimestampMillis);
        parameters.add(endTimestampMillis);
        sqlBuilder.append(this.getMetadataQuerySql(metadataQuery, parameters));
        sqlBuilder.append(this.getDimensionsQuerySql(dimensionsQuery, parameters));
        sqlBuilder.append(" ORDER BY ").append(this.getEventTimestampColumnName()).append(ascending ? " ASC " : " DESC ");
        if (limit > 0) {
            sqlBuilder.append(" LIMIT ? ");
            parameters.add(limit);
        }
        String sql = sqlBuilder.toString();
        ArrayList<Events.Event> results = new ArrayList<Events.Event>();
        try (Connection connection = this.getConnection();){
            try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
                JdbcUtils.addParameters(preparedStatement, parameters.toArray());
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    while (resultSet.next()) {
                        HashMap<String, String> metadata = new HashMap<String, String>();
                        HashMap<String, Double> dimensions = new HashMap<String, Double>();
                        long timestampMillis = resultSet.getLong(1);
                        byte[] payload = includePayloads ? resultSet.getBytes(2) : null;
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        for (int c = 2 + (includePayloads ? 1 : 0); c <= resultSet.getMetaData().getColumnCount(); ++c) {
                            String columnName = resultSetMetaData.getColumnName(c);
                            if (columnName.equalsIgnoreCase(this.getPayloadColumnName())) continue;
                            if (columnName.startsWith(this.getMetadataKeyColumnNamePrefix())) {
                                metadata.put(keyHashToName.get(columnName), resultSet.getString(c));
                                continue;
                            }
                            if (columnName.startsWith(this.getDimensionKeyColumnNamePrefix())) {
                                dimensions.put(keyHashToName.get(columnName), resultSet.getDouble(c));
                                continue;
                            }
                            throw new IllegalStateException("could not detect column '" + columnName + "'");
                        }
                        results.add(new Events.Event(timestampMillis, metadata, dimensions, payload));
                    }
                }
            }
            ArrayList<Events.Event> arrayList = results;
            return arrayList;
        }
        catch (SQLException e) {
            this.logger.warn("caught exception executing query sql '{}': {}; ignoring.", (Object)sql, (Object)e.getMessage());
            throw new IOException(e);
        }
    }

    private int doDelete(String namespace, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery) throws IOException {
        List<String> chunkTables = this.getChunkTableNames(namespace, startTimestampMillis, endTimestampMillis, metadataQuery.keySet(), dimensionsQuery.keySet());
        int results = 0;
        for (String chunkTableName : chunkTables) {
            results += this.doDeleteOnChunkTable(namespace, chunkTableName, startTimestampMillis, endTimestampMillis, metadataQuery, dimensionsQuery);
        }
        return results;
    }

    private int doDeleteOnChunkTable(String namespace, String chunkTableName, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery) throws IOException {
        String sqlFormat = "DELETE FROM %s WHERE %s BETWEEN ? AND ?";
        StringBuilder sqlBuilder = new StringBuilder(String.format("DELETE FROM %s WHERE %s BETWEEN ? AND ?", this.getTableFullName(namespace, chunkTableName), JdbcUtils.quote(this.getEventTimestampColumnName())));
        ArrayList<Object> parameters = new ArrayList<Object>();
        parameters.add(startTimestampMillis);
        parameters.add(endTimestampMillis);
        sqlBuilder.append(this.getMetadataQuerySql(metadataQuery, parameters));
        sqlBuilder.append(this.getDimensionsQuerySql(dimensionsQuery, parameters));
        String sql = sqlBuilder.toString();
        return this.executeUpdate(sql, parameters.toArray());
    }

    private Set<String> doMetadata(String namespace, String metadataKey, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery) throws IOException {
        String sqlFormat = "SELECT DISTINCT %s AS METADATA_VALUE FROM %s WHERE %s BETWEEN ? AND ?";
        HashSet<String> metadataKeys = new HashSet<String>(metadataQuery.keySet());
        metadataKeys.add(metadataKey);
        List<String> chunkTables = this.getChunkTableNames(namespace, startTimestampMillis, endTimestampMillis, metadataKeys, dimensionsQuery.keySet());
        ExecutorService executorService = Executors.newCachedThreadPool();
        ConcurrentSkipListSet<String> results = new ConcurrentSkipListSet<String>();
        for (String chunkTableName : chunkTables) {
            StringBuilder sqlBuilder = new StringBuilder(String.format("SELECT DISTINCT %s AS METADATA_VALUE FROM %s WHERE %s BETWEEN ? AND ?", JdbcUtils.quote(this.getMetadataKeyColumnName(metadataKey)), this.getTableFullName(namespace, chunkTableName), JdbcUtils.quote(this.getEventTimestampColumnName())));
            ArrayList<Object> parameters = new ArrayList<Object>();
            parameters.add(startTimestampMillis);
            parameters.add(endTimestampMillis);
            sqlBuilder.append(this.getMetadataQuerySql(metadataQuery, parameters));
            sqlBuilder.append(this.getDimensionsQuerySql(dimensionsQuery, parameters));
            String sql = sqlBuilder.toString();
            executorService.submit(() -> {
                try (Connection connection = this.getConnection();
                     PreparedStatement preparedStatement = connection.prepareStatement(sql);){
                    JdbcUtils.addParameters(preparedStatement, parameters.toArray());
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        while (resultSet.next()) {
                            results.add(resultSet.getString(1));
                        }
                    }
                }
                catch (IOException | SQLException e) {
                    this.logger.warn("caught exception executing query sql '{}': {}", (Object)sql, (Object)e.getMessage());
                }
            });
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new IOException("events get operation timed out", e);
        }
        return results;
    }

    private String getMetadataQuerySql(Map<String, String> metadataQuery, List<Object> parameters) {
        if (metadataQuery.isEmpty()) {
            return " AND 1 ";
        }
        StringBuilder sql = new StringBuilder();
        for (Map.Entry<String, String> entry : metadataQuery.entrySet()) {
            String column = JdbcUtils.quote(this.getMetadataKeyColumnName(entry.getKey()));
            String parameter = entry.getValue();
            if (parameter.startsWith("~")) {
                sql.append(" AND ").append(this.getRegexQuery(column));
                parameters.add(this.getRegexPattern(parameter.substring(1)));
                continue;
            }
            if (parameter.startsWith("!~")) {
                sql.append(" AND ").append(this.getNotRegexQuery(column));
                parameters.add(this.getRegexPattern(parameter.substring(2)));
                continue;
            }
            if (parameter.startsWith("=")) {
                sql.append(" AND ").append(column).append(" = ? ");
                parameters.add(parameter.substring(1));
                continue;
            }
            if (parameter.startsWith("!=")) {
                sql.append(" AND ").append(column).append(" != ? ");
                parameters.add(parameter.substring(2));
                continue;
            }
            sql.append(" AND ").append(column).append(" = ? ");
            parameters.add(parameter);
        }
        return sql.toString();
    }

    protected abstract String getRegexPattern(String var1);

    protected abstract String getRegexQuery(String var1);

    protected abstract String getNotRegexQuery(String var1);

    private String getDimensionsQuerySql(Map<String, String> dimensionsQuery, List<Object> parameters) {
        if (dimensionsQuery.isEmpty()) {
            return " AND 1 ";
        }
        StringBuilder sql = new StringBuilder();
        for (Map.Entry<String, String> entry : dimensionsQuery.entrySet()) {
            String column = JdbcUtils.quote(this.getDimensionKeyColumnName(entry.getKey()));
            String query = entry.getValue();
            if (query.contains("..")) {
                sql.append(" AND ? BETWEEN ? AND ? ");
                parameters.add(Double.valueOf(query.substring(0, query.indexOf(".."))));
                parameters.add(Double.valueOf(query.substring(query.indexOf("..") + 2)));
                continue;
            }
            if (query.startsWith(">=")) {
                sql.append(" AND ").append(column).append(" >= ? ");
                parameters.add(Double.valueOf(query.substring(2)));
                continue;
            }
            if (query.startsWith("<=")) {
                sql.append(" AND ").append(column).append(" <= ? ");
                parameters.add(Double.valueOf(query.substring(2)));
                continue;
            }
            if (query.startsWith(">")) {
                sql.append(" AND ").append(column).append(" > ? ");
                parameters.add(Double.valueOf(query.substring(1)));
                continue;
            }
            if (query.startsWith("<")) {
                sql.append(" AND ").append(column).append(" < ? ");
                parameters.add(Double.valueOf(query.substring(1)));
                continue;
            }
            if (query.startsWith("!=")) {
                sql.append(" AND ").append(column).append(" != ? ");
                parameters.add(Double.valueOf(query.substring(2)));
                continue;
            }
            if (query.startsWith("=")) {
                sql.append(" AND ").append(column).append(" = ? ");
                parameters.add(Double.valueOf(query.substring(1)));
                continue;
            }
            sql.append(" AND ").append(column).append(" = ? ");
            parameters.add(Double.valueOf(query));
        }
        return sql.toString();
    }

    private void sortEventsByTimestamp(List<Events.Event> events, boolean ascending) {
        events.sort((event1, event2) -> {
            if (event1.getTimestampMillis() < event2.getTimestampMillis()) {
                return ascending ? -1 : 1;
            }
            if (event1.getTimestampMillis() > event2.getTimestampMillis()) {
                return ascending ? 1 : -1;
            }
            return 0;
        });
    }

    private List<String> getChunkTableNames(String namespace, long startTimestampMillis, long endTimestampMillis, Collection<String> metadataKeys, Collection<String> dimensionKeys) throws IOException {
        StringBuilder sqlFormatBuilder = new StringBuilder();
        Object[] parameters = new Object[2 + metadataKeys.size() + dimensionKeys.size()];
        sqlFormatBuilder.append("SELECT DISTINCT ").append(JdbcUtils.quote(this.getTableNameColumnName())).append(" FROM ").append(this.getTableFullName(namespace, this.getChunksLookupTableName())).append(" WHERE (").append(JdbcUtils.quote(this.getStartTimestampMillisColumnName())).append(" BETWEEN ? AND ?)");
        int index = 0;
        long startWindow = this.getWindowForTimestamp(startTimestampMillis) - this.getWindowSizeMillis();
        parameters[index++] = startWindow >= 0L ? startWindow : 0L;
        long endTimestampWindow = Long.MAX_VALUE - this.getWindowForTimestamp(endTimestampMillis) > this.getWindowSizeMillis() ? this.getWindowForTimestamp(endTimestampMillis) + this.getWindowSizeMillis() : Long.MAX_VALUE;
        parameters[index++] = endTimestampWindow;
        String tableNameInSeparator = " AND " + JdbcUtils.quote(this.getTableNameColumnName()) + " IN (";
        StringJoiner tableNameSelectJoiner = new StringJoiner(tableNameInSeparator);
        StringBuilder innerSelectBuilder = new StringBuilder();
        for (String metadataKey : metadataKeys) {
            innerSelectBuilder.setLength(0);
            innerSelectBuilder.append("SELECT ").append(JdbcUtils.quote(this.getTableNameColumnName())).append(" FROM ").append(this.getTableFullName(namespace, this.getChunksLookupTableName())).append(" WHERE ").append(JdbcUtils.quote(this.getColumnColumnName())).append(" = ?");
            tableNameSelectJoiner.add(innerSelectBuilder.toString());
            parameters[index++] = this.getMetadataKeyColumnName(metadataKey);
        }
        for (String dimensionKey : dimensionKeys) {
            innerSelectBuilder.setLength(0);
            innerSelectBuilder.append("SELECT ").append(JdbcUtils.quote(this.getTableNameColumnName())).append(" FROM ").append(this.getTableFullName(namespace, this.getChunksLookupTableName())).append(" WHERE ").append(JdbcUtils.quote(this.getColumnColumnName())).append(" = ?");
            tableNameSelectJoiner.add(innerSelectBuilder.toString());
            parameters[index++] = this.getDimensionKeyColumnName(dimensionKey);
        }
        if (!metadataKeys.isEmpty() || !dimensionKeys.isEmpty()) {
            sqlFormatBuilder.append(" AND (").append(JdbcUtils.quote(this.getTableNameColumnName())).append(" IN (").append(tableNameSelectJoiner.toString());
            for (int i = 0; i < metadataKeys.size() + dimensionKeys.size(); ++i) {
                sqlFormatBuilder.append(")");
            }
            sqlFormatBuilder.append(")");
        }
        ArrayList<String> tables = new ArrayList<String>();
        String sql = sqlFormatBuilder.toString();
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            JdbcUtils.addParameters(preparedStatement, parameters);
            this.logger.debug("executing chunk table sql query [[{}]] with parameters (({}))", (Object)sql, (Object)parameters);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    tables.add(resultSet.getString(1));
                }
            }
        }
        catch (SQLException e) {
            this.logger.warn("caught exception executing query sql '{}': {}", (Object)sql, (Object)e.getMessage());
            throw new IOException(e);
        }
        return tables;
    }

    private long getWindowForTimestamp(long timestampMillis) {
        return timestampMillis / this.getWindowSizeMillis() * this.getWindowSizeMillis();
    }

    private long getWindowSizeMillis() {
        return TimeUnit.DAYS.toMillis(1L);
    }

    protected List<String> getOrderedKeys(Map<String, ?> map) {
        return this.getOrdered(map.keySet());
    }

    private List<String> getOrdered(Collection<String> collection) {
        ArrayList<String> keys = new ArrayList<String>(collection);
        Collections.sort(keys);
        return keys;
    }

    private List<String> getKeysOrdered(Map<String, ?> map) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        return keys;
    }

    private String getChunkTableName(long timestampMillis, Collection<String> metadataKeys, Collection<String> dimensionKeys) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return String.format("%s%s_%s", this.getChunkTableNamePrefix(), dateFormat.format(new Date(this.getWindowForTimestamp(timestampMillis))), this.getKeysHash(metadataKeys, dimensionKeys));
    }

    private String getKeysHash(Collection<String> metadataKeys, Collection<String> dimensionKeys) {
        String orderedMetadataKeysCsv = String.join((CharSequence)",", this.getOrdered(metadataKeys));
        String orderedDimensionKeysCsv = String.join((CharSequence)",", this.getOrdered(dimensionKeys));
        return Math.abs(orderedMetadataKeysCsv.hashCode()) + "_" + Math.abs(orderedDimensionKeysCsv.hashCode());
    }

    protected String getEventTimestampColumnName() {
        return "TIMESTAMP_MILLIS";
    }

    protected String getChunksLookupTableName() {
        return "CANTOR-EVENTS-CHUNKS-LOOKUP";
    }

    protected String getChunkTableNamePrefix() {
        return "CANTOR-EVENTS-CHUNK-";
    }

    protected String getTableNameColumnName() {
        return "TABLE_NAME";
    }

    protected String getKeyColumnName() {
        return "KEY";
    }

    protected String getColumnColumnName() {
        return "COLUMN";
    }

    protected String getStartTimestampMillisColumnName() {
        return "START_TIMESTAMP_MILLIS";
    }

    protected String getPayloadColumnName() {
        return "PAYLOAD";
    }

    protected String getDimensionKeyColumnNamePrefix() {
        return "D_";
    }

    protected String getMetadataKeyColumnNamePrefix() {
        return "M_";
    }

    protected String getDimensionKeyColumnName(String dimensionKey) {
        String cleanKey = dimensionKey.replaceAll("[^A-Za-z0-9_\\-]", "").toUpperCase();
        return this.getDimensionKeyColumnNamePrefix() + cleanKey.substring(0, Math.min(32, cleanKey.length())) + "_" + Math.abs(dimensionKey.hashCode());
    }

    protected String getMetadataKeyColumnName(String metadataKey) {
        String cleanKey = metadataKey.replaceAll("[^A-Za-z0-9_\\-]", "").toUpperCase();
        return this.getMetadataKeyColumnNamePrefix() + cleanKey.substring(0, Math.min(32, cleanKey.length())) + "_" + Math.abs(metadataKey.hashCode());
    }
}

