/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.jdbc;

import com.salesforce.cantor.Sets;
import com.salesforce.cantor.common.SetsPreconditions;
import com.salesforce.cantor.jdbc.AbstractBaseCantorOnJdbc;
import com.salesforce.cantor.jdbc.JdbcUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseSetsOnJdbc
extends AbstractBaseCantorOnJdbc
implements Sets {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected AbstractBaseSetsOnJdbc(DataSource dataSource) {
        super(dataSource);
    }

    public void create(String namespace) throws IOException {
        SetsPreconditions.checkCreate((String)namespace);
        this.createNamespace(namespace);
    }

    public void drop(String namespace) throws IOException {
        SetsPreconditions.checkDrop((String)namespace);
        this.dropNamespace(namespace);
    }

    public int size(String namespace, String set) throws IOException {
        SetsPreconditions.checkSize((String)namespace, (String)set);
        return this.doSize(namespace, set);
    }

    public Collection<String> entries(String namespace, String set, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkEntries((String)namespace, (String)set, (long)min, (long)max, (int)start, (int)count, (boolean)ascending);
        return this.doEntries(namespace, set, min, max, start, count, this.getOrderByString(ascending));
    }

    public Collection<String> sets(String namespace) throws IOException {
        SetsPreconditions.checkSets((String)namespace);
        return this.doSets(namespace);
    }

    public Map<String, Long> get(String namespace, String set, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkGet((String)namespace, (String)set, (long)min, (long)max, (int)start, (int)count, (boolean)ascending);
        return this.doGet(namespace, set, min, max, start, count, this.getOrderByString(ascending));
    }

    public Map<String, Long> union(String namespace, Collection<String> sets, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkUnion((String)namespace, sets, (long)min, (long)max, (int)start, (int)count, (boolean)ascending);
        return this.doUnion(namespace, sets, min, max, start, count, this.getOrderByString(ascending));
    }

    public Map<String, Long> intersect(String namespace, Collection<String> sets, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkIntersect((String)namespace, sets, (long)min, (long)max, (int)start, (int)count, (boolean)ascending);
        return this.doIntersect(namespace, sets, min, max, start, count, this.getOrderByString(ascending));
    }

    public Map<String, Long> pop(String namespace, String key, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkPop((String)namespace, (String)key, (long)min, (long)max, (int)start, (int)count, (boolean)ascending);
        return this.doPop(namespace, key, min, max, start, count, this.getOrderByString(ascending));
    }

    public void delete(String namespace, String key, long min, long max) throws IOException {
        SetsPreconditions.checkDelete((String)namespace, (String)key, (long)min, (long)max);
        this.doDelete(namespace, key, min, max);
    }

    public boolean delete(String namespace, String key, String entry) throws IOException {
        SetsPreconditions.checkDelete((String)namespace, (String)key, (String)entry);
        return this.doDelete(namespace, key, entry);
    }

    public void delete(String namespace, String key, Collection<String> entries) throws IOException {
        SetsPreconditions.checkDelete((String)namespace, (String)key, entries);
        this.doDelete(namespace, key, entries);
    }

    public void add(String namespace, String key, String entry, long weight) throws IOException {
        SetsPreconditions.checkAdd((String)namespace, (String)key, (String)entry, (long)weight);
        this.doAdd(namespace, key, entry, weight);
    }

    public void add(String namespace, String key, Map<String, Long> entries) throws IOException {
        SetsPreconditions.checkAdd((String)namespace, (String)key, entries);
        this.doAdd(namespace, key, entries);
    }

    public Long weight(String namespace, String key, String entry) throws IOException {
        SetsPreconditions.checkWeight((String)namespace, (String)key, (String)entry);
        return this.doWeight(namespace, key, entry);
    }

    public long inc(String namespace, String key, String entry, long count) throws IOException {
        SetsPreconditions.checkInc((String)namespace, (String)key, (String)entry, (long)count);
        return this.doInc(namespace, key, entry, count);
    }

    @Override
    protected String getNamespaceLookupTableName() {
        return "SETS-NAMESPACES";
    }

    @Override
    protected void createInternalTables(Connection connection, String namespace) throws IOException {
        this.logger.info("creating sets table for namespace '{}' if not exists", (Object)namespace);
        this.executeUpdate(connection, this.getCreateSetsTableSql(namespace), new Object[0]);
    }

    @Override
    protected void doValidations() throws IOException {
        this.logger.info("looking for mismatch between database and sets lookup tables");
    }

    /*
     * Exception decompiling
     */
    private int doSize(String namespace, String set) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, Long> doGet(String namespace, String set, long min, long max, int start, int count, String orderby) throws IOException {
        LinkedHashMap<String, Long> linkedHashMap;
        block22: {
            String sql = String.format("SELECT %s, %s FROM %s WHERE %s.%s = ? AND %s.%s BETWEEN ? AND ? %s %s", JdbcUtils.quote(this.getEntryColumnName()), JdbcUtils.quote(this.getWeightColumnName()), this.getTableFullName(namespace, this.getSetsTableName()), JdbcUtils.quote(this.getSetsTableName()), JdbcUtils.quote(this.getSetKeyColumnName()), JdbcUtils.quote(this.getSetsTableName()), JdbcUtils.quote(this.getWeightColumnName()), orderby, this.getLimitString(start, count));
            LinkedHashMap<String, Long> items = new LinkedHashMap<String, Long>();
            Connection connection = this.getConnection();
            try {
                try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
                    preparedStatement.setString(1, set);
                    preparedStatement.setLong(2, min);
                    preparedStatement.setLong(3, max);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        while (resultSet.next()) {
                            String key = resultSet.getString(1);
                            Long weight = resultSet.getLong(2);
                            if (key == null || key.isEmpty()) continue;
                            items.put(key, weight);
                        }
                    }
                }
                linkedHashMap = items;
                if (connection == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.logger.warn("exception on sets.get()", (Throwable)e);
                    throw new IOException(e);
                }
            }
            connection.close();
        }
        return linkedHashMap;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<String, Long> doUnion(String namespace, Collection<String> sets, long min, long max, int start, int count, String orderby) throws IOException {
        String partialSql = String.format("SELECT %s, %s FROM %s WHERE %s = ? AND %s BETWEEN ? AND ?", JdbcUtils.quote(this.getEntryColumnName()), JdbcUtils.quote(this.getWeightColumnName()), this.getTableFullName(namespace, this.getSetsTableName()), JdbcUtils.quote(this.getSetKeyColumnName()), JdbcUtils.quote(this.getWeightColumnName()));
        String sql = String.format("%s %s %s", String.join((CharSequence)" UNION ", Collections.nCopies(sets.size(), partialSql)), orderby, this.getLimitString(start, count));
        LinkedHashMap<String, Long> items = new LinkedHashMap<String, Long>();
        try (Connection connection = this.getConnection();){
            LinkedHashMap<String, Long> linkedHashMap;
            block23: {
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                try {
                    int index = 1;
                    for (String set : sets) {
                        preparedStatement.setString(index++, set);
                        preparedStatement.setLong(index++, min);
                        preparedStatement.setLong(index++, max);
                    }
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        while (resultSet.next()) {
                            String key = resultSet.getString(1);
                            Long weight = resultSet.getLong(2);
                            if (key == null || key.isEmpty()) continue;
                            items.put(key, weight);
                        }
                    }
                    linkedHashMap = items;
                    if (preparedStatement == null) break block23;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return linkedHashMap;
        }
        catch (SQLException e) {
            this.logger.warn("exception on sets.union()", (Throwable)e);
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<String, Long> doIntersect(String namespace, Collection<String> sets, long min, long max, int start, int count, String orderby) throws IOException {
        int index = 0;
        Object[] parameters = new Object[sets.size() + 2];
        parameters[index++] = min;
        parameters[index++] = max;
        StringJoiner setsJoiner = new StringJoiner(" OR ");
        String clause = this.getSetKeyColumnName() + " = ?";
        for (String set : sets) {
            parameters[index++] = set;
            setsJoiner.add(clause);
        }
        String sql = String.format("SELECT %s, %s FROM %s WHERE %s BETWEEN ? AND ? AND %s %s %s", JdbcUtils.quote(this.getEntryColumnName()), JdbcUtils.quote(this.getWeightColumnName()), this.getTableFullName(namespace, this.getSetsTableName()), JdbcUtils.quote(this.getWeightColumnName()), setsJoiner.toString(), orderby, this.getLimitString(start, count));
        LinkedHashMap<String, Long> items = new LinkedHashMap<String, Long>();
        try (Connection connection = this.getConnection();){
            LinkedHashMap<String, Long> linkedHashMap;
            block23: {
                this.logger.debug("executing sql query: {}", (Object)sql);
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                try {
                    JdbcUtils.addParameters(preparedStatement, parameters);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        while (resultSet.next()) {
                            String key = resultSet.getString(1);
                            Long weight = resultSet.getLong(2);
                            if (key == null || key.isEmpty()) continue;
                            items.put(key, weight);
                        }
                    }
                    linkedHashMap = items;
                    if (preparedStatement == null) break block23;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return linkedHashMap;
        }
        catch (SQLException e) {
            this.logger.warn("exception on sets.intersect()", (Throwable)e);
            throw new IOException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private Map<String, Long> doPop(String namespace, String set, long min, long max, int start, int count, String orderby) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 24[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<String> doEntries(String namespace, String set, long min, long max, int start, int count, String orderby) throws IOException {
        String sql = String.format("SELECT %s FROM %s WHERE %s.%s = ? AND %s.%s BETWEEN ? AND ? %s %s", JdbcUtils.quote(this.getEntryColumnName()), this.getTableFullName(namespace, this.getSetsTableName()), JdbcUtils.quote(this.getSetsTableName()), JdbcUtils.quote(this.getSetKeyColumnName()), JdbcUtils.quote(this.getSetsTableName()), JdbcUtils.quote(this.getWeightColumnName()), orderby, this.getLimitString(start, count));
        LinkedList<String> entries = new LinkedList<String>();
        try (Connection connection = this.getConnection();){
            LinkedList<String> linkedList;
            block22: {
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                try {
                    preparedStatement.setString(1, set);
                    preparedStatement.setLong(2, min);
                    preparedStatement.setLong(3, max);
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        while (resultSet.next()) {
                            String key = resultSet.getString(1);
                            if (key == null || key.isEmpty()) continue;
                            entries.add(key);
                        }
                    }
                    linkedList = entries;
                    if (preparedStatement == null) break block22;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return linkedList;
        }
        catch (SQLException e) {
            this.logger.warn("exception on sets.entries()", (Throwable)e);
            throw new IOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<String> doSets(String namespace) throws IOException {
        String sql = String.format("SELECT DISTINCT %s FROM %s", JdbcUtils.quote(this.getSetKeyColumnName()), this.getTableFullName(namespace, this.getSetsTableName()));
        LinkedList<String> sets = new LinkedList<String>();
        try (Connection connection = this.getConnection();){
            LinkedList<String> linkedList;
            block22: {
                PreparedStatement preparedStatement = connection.prepareStatement(sql);
                try {
                    try (ResultSet resultSet = preparedStatement.executeQuery();){
                        while (resultSet.next()) {
                            String set = resultSet.getString(1);
                            if (set == null || set.isEmpty()) continue;
                            sets.add(set);
                        }
                    }
                    linkedList = sets;
                    if (preparedStatement == null) break block22;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return linkedList;
        }
        catch (SQLException e) {
            this.logger.warn("exception on sets.sets()", (Throwable)e);
            throw new IOException(e);
        }
    }

    private void doDelete(String namespace, String key, long min, long max) throws IOException {
        String sql = String.format("DELETE FROM %s WHERE %s = ? AND %s BETWEEN ? AND ? ", this.getTableFullName(namespace, this.getSetsTableName()), JdbcUtils.quote(this.getSetKeyColumnName()), JdbcUtils.quote(this.getWeightColumnName()));
        this.executeUpdate(sql, key, min, max);
    }

    private boolean doDelete(String namespace, String set, String entry) throws IOException {
        String sql = String.format("DELETE FROM %s WHERE %s = ? AND %s = ? ", this.getTableFullName(namespace, this.getSetsTableName()), JdbcUtils.quote(this.getSetKeyColumnName()), JdbcUtils.quote(this.getEntryColumnName()));
        return this.executeUpdate(sql, set, entry) == 1;
    }

    private void doDelete(String namespace, String set, Collection<String> entries) throws IOException {
        String sql = String.format("DELETE FROM %s WHERE %s = ? AND %s IN (%s) ", this.getTableFullName(namespace, this.getSetsTableName()), JdbcUtils.quote(this.getSetKeyColumnName()), JdbcUtils.quote(this.getEntryColumnName()), JdbcUtils.getPlaceholders(entries.size()));
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setString(1, set);
            int placeholderIndex = 2;
            for (String entry : entries) {
                preparedStatement.setString(placeholderIndex, entry);
                ++placeholderIndex;
            }
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.warn("exception on sets.delete()", (Throwable)e);
            throw new IOException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private Long doWeight(String namespace, String set, String entry) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long doInc(String namespace, String set, String entry, long count) throws IOException {
        boolean exists;
        boolean bl = exists = this.doWeight(namespace, set, entry) != null;
        if (!exists) {
            this.doAdd(namespace, set, entry, 0L);
        }
        String updateSql = String.format("UPDATE %s SET %s = %s + ? WHERE %s = ? AND %s = ? ", this.getTableFullName(namespace, this.getSetsTableName()), JdbcUtils.quote(this.getWeightColumnName()), JdbcUtils.quote(this.getWeightColumnName()), JdbcUtils.quote(this.getSetKeyColumnName()), JdbcUtils.quote(this.getEntryColumnName()));
        String selectSql = String.format("SELECT %s FROM %s WHERE %s = ? AND %s = ? ", JdbcUtils.quote(this.getWeightColumnName()), this.getTableFullName(namespace, this.getSetsTableName()), JdbcUtils.quote(this.getSetKeyColumnName()), JdbcUtils.quote(this.getEntryColumnName()));
        Connection connection = null;
        try {
            connection = this.openTransaction(this.getConnection());
            this.executeUpdate(connection, updateSql, count, set, entry);
            try {
                PreparedStatement preparedStatement = connection.prepareStatement(selectSql);
                try {
                    block18: {
                        long l;
                        block19: {
                            preparedStatement.setString(1, set);
                            preparedStatement.setString(2, entry);
                            ResultSet resultSet = preparedStatement.executeQuery();
                            if (!resultSet.next()) break block18;
                            l = resultSet.getLong(1);
                            if (resultSet == null) break block19;
                            {
                                catch (Throwable throwable) {
                                    if (resultSet == null) throw throwable;
                                    try {
                                        resultSet.close();
                                        throw throwable;
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    throw throwable;
                                }
                            }
                            resultSet.close();
                        }
                        if (preparedStatement == null) return l;
                        preparedStatement.close();
                        return l;
                    }
                    throw new IOException("cannot find entry for sets.inc()");
                }
                catch (Throwable throwable) {
                    if (preparedStatement == null) throw throwable;
                    try {
                        preparedStatement.close();
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                this.logger.warn("exception on sets.inc()", (Throwable)e);
                throw new IOException(e);
            }
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private void doAdd(String namespace, String set, String entry, long weight) throws IOException {
        String sql = String.format("INSERT INTO %s SET %s = ?, %s = ?, %s = ? ON DUPLICATE KEY UPDATE %s= ? ", this.getTableFullName(namespace, this.getSetsTableName()), JdbcUtils.quote(this.getSetKeyColumnName()), JdbcUtils.quote(this.getEntryColumnName()), JdbcUtils.quote(this.getWeightColumnName()), JdbcUtils.quote(this.getWeightColumnName()));
        this.executeUpdate(sql, set, entry, weight, weight);
    }

    private void doAdd(String namespace, String set, Map<String, Long> entries) throws IOException {
        String sql = String.format("INSERT INTO %s SET %s = ?, %s = ?, %s = ? ON DUPLICATE KEY UPDATE %s= ? ", this.getTableFullName(namespace, this.getSetsTableName()), JdbcUtils.quote(this.getSetKeyColumnName()), JdbcUtils.quote(this.getEntryColumnName()), JdbcUtils.quote(this.getWeightColumnName()), JdbcUtils.quote(this.getWeightColumnName()));
        try (Connection connection = this.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            for (Map.Entry<String, Long> entry : entries.entrySet()) {
                preparedStatement.clearParameters();
                preparedStatement.setString(1, set);
                preparedStatement.setString(2, entry.getKey());
                preparedStatement.setLong(3, entry.getValue());
                preparedStatement.setLong(4, entry.getValue());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
        catch (SQLException e) {
            this.logger.warn("exception on sets.add()", (Throwable)e);
            throw new IOException(e);
        }
    }

    protected abstract String getCreateSetsTableSql(String var1);

    private String getOrderByString(boolean ascending) {
        String order = ascending ? " ASC " : " DESC ";
        return " ORDER BY " + this.getWeightColumnName() + " " + order + " ";
    }

    private String getLimitString(int start, int count) {
        if (start == 0 && count == -1) {
            return " ";
        }
        return " LIMIT " + start + "," + count;
    }

    protected String getSetsTableName() {
        return "CANTOR-SETS";
    }

    protected String getEntryColumnName() {
        return "ENTRY";
    }

    protected String getSetKeyColumnName() {
        return "SET-KEY";
    }

    protected String getWeightColumnName() {
        return "WEIGHT";
    }
}

