/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseMetricCollectingCantor {
    private static final Logger logger = LoggerFactory.getLogger(BaseMetricCollectingCantor.class);
    private final MetricRegistry metrics;
    private final Object delegate;

    BaseMetricCollectingCantor(MetricRegistry metrics, Object delegate) {
        this.metrics = metrics;
        this.delegate = delegate;
    }

    <R> R metrics(Callable<R> callable, String methodName, String namespace, Function<R, Integer> resultToHistogramValue) throws IOException {
        R result = this.metrics(callable, methodName, namespace);
        try {
            Integer value = resultToHistogramValue.apply(result);
            if (value != null) {
                this.metrics.histogram(this.getHistogramName(namespace, methodName)).update(value.intValue());
            }
        }
        catch (Exception e) {
            logger.warn("exception transforming result to histogram value: ", (Throwable)e);
        }
        return result;
    }

    <R> R metrics(Callable<R> callable, String methodName, String namespace) throws IOException {
        try {
            return (R)this.metrics.timer(this.getTimerName(namespace, methodName)).time(callable);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    void metrics(IORunnable runnable, String methodName, String namespace) throws IOException {
        try (Timer.Context ignored = this.metrics.timer(this.getTimerName(namespace, methodName)).time();){
            runnable.run();
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    Integer size(Collection<?> collection) {
        return collection != null ? collection.size() : 0;
    }

    private String getTimerName(String namespace, String method) {
        return MetricRegistry.name(this.delegate.getClass(), (String[])new String[]{namespace, method, "calls"});
    }

    private String getHistogramName(String namespace, String method) {
        return MetricRegistry.name(this.delegate.getClass(), (String[])new String[]{namespace, method, "response-size"});
    }

    static interface IORunnable {
        public void run() throws IOException;
    }
}

