/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.mysql;

import com.salesforce.cantor.mysql.MysqlDataSourceProperties;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlDataSourceProvider {
    private static final Logger logger = LoggerFactory.getLogger(MysqlDataSourceProvider.class);

    public static synchronized DataSource getDatasource(MysqlDataSourceProperties builder) {
        return MysqlDataSourceProvider.doGetDataSource(builder.getHostname(), builder.getPort(), builder.getUsername(), builder.getPassword());
    }

    private static DataSource doGetDataSource(String hostname, int port, String username, String password) {
        String jdbcUrl = "jdbc:mysql://" + hostname + ":" + port + "/";
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        HikariDataSource connectoinPoolDataSource = new HikariDataSource();
        connectoinPoolDataSource.setJdbcUrl(jdbcUrl);
        connectoinPoolDataSource.setUsername(username);
        if (password != null) {
            connectoinPoolDataSource.setPassword(password);
        }
        connectoinPoolDataSource.setConnectionTimeout(30000L);
        connectoinPoolDataSource.addDataSourceProperty("useUnicode", (Object)true);
        connectoinPoolDataSource.addDataSourceProperty("useSSL", (Object)false);
        connectoinPoolDataSource.addDataSourceProperty("allowPublicKeyRetrieval", (Object)true);
        connectoinPoolDataSource.addDataSourceProperty("serverTimezone", (Object)"UTC");
        connectoinPoolDataSource.addDataSourceProperty("useJDBCCompliantTimezoneShift", (Object)true);
        connectoinPoolDataSource.addDataSourceProperty("useLegacyDatetimeCode", (Object)false);
        connectoinPoolDataSource.addDataSourceProperty("cachePrepStmts", (Object)true);
        connectoinPoolDataSource.addDataSourceProperty("prepStmtCacheSize", (Object)512);
        connectoinPoolDataSource.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)2048);
        connectoinPoolDataSource.addDataSourceProperty("useServerPrepStmts", (Object)true);
        connectoinPoolDataSource.addDataSourceProperty("useLocalSessionState", (Object)true);
        connectoinPoolDataSource.addDataSourceProperty("rewriteBatchedStatements", (Object)true);
        connectoinPoolDataSource.addDataSourceProperty("cacheResultSetMetadata", (Object)true);
        connectoinPoolDataSource.addDataSourceProperty("metadataCacheSize", (Object)512);
        connectoinPoolDataSource.addDataSourceProperty("cacheServerConfiguration", (Object)true);
        connectoinPoolDataSource.addDataSourceProperty("elideSetAutoCommits", (Object)true);
        connectoinPoolDataSource.addDataSourceProperty("continueBatchOnError", (Object)false);
        connectoinPoolDataSource.addDataSourceProperty("maintainTimeStats", (Object)false);
        connectoinPoolDataSource.addDataSourceProperty("maxRows", (Object)100000);
        connectoinPoolDataSource.setMaximumPoolSize(64);
        logger.info("jdbc url for datasource is: {} data source properties are: {}", (Object)jdbcUrl, (Object)connectoinPoolDataSource.getDataSourceProperties());
        return connectoinPoolDataSource;
    }
}

