/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.s3;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.HeadBucketRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.util.StringInputStream;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.salesforce.cantor.Namespaceable;
import com.salesforce.cantor.common.CommonPreconditions;
import com.salesforce.cantor.s3.S3Utils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseS3Namespaceable
implements Namespaceable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBaseS3Namespaceable.class);
    protected final AmazonS3 s3Client;
    protected final String bucketName;
    private final String namespaceLookupKey;
    private final LoadingCache<String, Optional<String>> namespaceCache;

    public AbstractBaseS3Namespaceable(AmazonS3 s3Client, String bucketName, String type) throws IOException {
        CommonPreconditions.checkArgument((s3Client != null ? 1 : 0) != 0, (String)"null s3 client");
        CommonPreconditions.checkString((String)bucketName, (String)"null/empty bucket name");
        this.s3Client = s3Client;
        this.bucketName = bucketName;
        this.namespaceLookupKey = S3Utils.getCleanKeyForNamespace(String.format("all-namespaces-%s", type));
        try {
            this.s3Client.headBucket(new HeadBucketRequest(this.bucketName));
        }
        catch (SdkClientException e) {
            logger.warn("exception validating s3 client and bucket:", (Throwable)e);
            throw new IOException("exception validating s3 client and bucket", e);
        }
        this.namespaceCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Optional<String>>(){
            final Map<String, String> cachedNamespaces = new HashMap<String, String>();

            public Optional<String> load(String namespace) throws IOException {
                if (this.cachedNamespaces.containsKey(namespace)) {
                    return Optional.of(this.cachedNamespaces.get(namespace));
                }
                AbstractBaseS3Namespaceable.this.refreshNamespaces(this.cachedNamespaces);
                return Optional.ofNullable(this.cachedNamespaces.get(namespace));
            }
        });
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        executor.scheduleAtFixedRate(this::refreshCache, 0L, 30L, TimeUnit.SECONDS);
    }

    public Collection<String> namespaces() throws IOException {
        try {
            return this.doGetNamespaces();
        }
        catch (AmazonS3Exception e) {
            logger.warn("exception getting namespaces", (Throwable)e);
            throw new IOException("exception getting namespaces", e);
        }
    }

    public void create(String namespace) throws IOException {
        CommonPreconditions.checkCreate((String)namespace);
        try {
            this.doCreate(namespace);
        }
        catch (AmazonS3Exception e) {
            this.namespaceCache.invalidate((Object)namespace);
            logger.warn("exception creating namespace: " + namespace, (Throwable)e);
            throw new IOException("exception creating namespace: " + namespace, e);
        }
    }

    public void drop(String namespace) throws IOException {
        CommonPreconditions.checkDrop((String)namespace);
        try {
            this.doDrop(namespace);
        }
        catch (AmazonS3Exception e) {
            logger.warn("exception dropping namespace: " + namespace, (Throwable)e);
            throw new IOException("exception dropping namespace: " + namespace, e);
        }
    }

    protected abstract String getObjectKeyPrefix(String var1);

    protected void checkNamespace(String namespace) throws IOException {
        CommonPreconditions.checkNamespace((String)namespace);
        Optional namespaceKey = (Optional)this.namespaceCache.getUnchecked((Object)namespace);
        if (!namespaceKey.isPresent()) {
            throw new IOException(String.format("namespace '%s' does not exist", namespace));
        }
    }

    /*
     * Exception decompiling
     */
    private Collection<String> doGetNamespaces() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doCreate(String namespace) throws IOException {
        String newNamespace;
        logger.info("creating namespace '{}' and adding to '{}.{}'", new Object[]{namespace, this.bucketName, this.namespaceLookupKey});
        this.namespaceCache.put((Object)namespace, Optional.ofNullable(S3Utils.getCleanKeyForNamespace(namespace)));
        if (!S3Utils.doesObjectExist(this.s3Client, this.bucketName, this.namespaceLookupKey)) {
            StringInputStream csvForNamespaces = new StringInputStream("namespace,key\n" + namespace + "," + S3Utils.getCleanKeyForNamespace(namespace));
            S3Utils.putObject(this.s3Client, this.bucketName, this.namespaceLookupKey, (InputStream)csvForNamespaces, new ObjectMetadata());
            return;
        }
        byte[] namespacesCsv = S3Utils.getObjectBytes(this.s3Client, this.bucketName, this.namespaceLookupKey);
        String namespaces = new String(namespacesCsv);
        if (namespaces.contains(newNamespace = "\n" + namespace + "," + S3Utils.getCleanKeyForNamespace(namespace))) {
            return;
        }
        namespaces = namespaces + newNamespace;
        ByteArrayInputStream updatedNamespaceList = new ByteArrayInputStream(namespaces.getBytes(StandardCharsets.UTF_8));
        S3Utils.putObject(this.s3Client, this.bucketName, this.namespaceLookupKey, updatedNamespaceList, new ObjectMetadata());
    }

    private void doDrop(String namespace) throws IOException {
        logger.info("dropping namespace '{}'", (Object)namespace);
        String objectKeyPrefix = this.getObjectKeyPrefix(namespace);
        logger.debug("deleting all objects with prefix '{}.{}'", (Object)this.bucketName, (Object)objectKeyPrefix);
        S3Utils.deleteObjects(this.s3Client, this.bucketName, objectKeyPrefix);
        logger.debug("deleting namespace record from namespaces object '{}.{}'", (Object)this.bucketName, (Object)this.namespaceLookupKey);
        String remainingNamespacesQuery = String.format("select * from s3object s where NOT s.namespace = '%s'", namespace);
        String namespacesCsv = S3Utils.S3Select.queryObjectCsv(this.s3Client, this.bucketName, this.namespaceLookupKey, remainingNamespacesQuery);
        try (ByteArrayOutputStream csvForNamespaces = new ByteArrayOutputStream();){
            csvForNamespaces.write("namespace,key".getBytes(StandardCharsets.UTF_8));
            for (String entry : namespacesCsv.split("\n")) {
                String line = "\n" + entry;
                csvForNamespaces.write(line.getBytes(StandardCharsets.UTF_8));
            }
            try (ByteArrayInputStream updatedNamespaces = new ByteArrayInputStream(csvForNamespaces.toByteArray());){
                S3Utils.putObject(this.s3Client, this.bucketName, this.namespaceLookupKey, updatedNamespaces, new ObjectMetadata());
            }
        }
        this.namespaceCache.invalidate((Object)namespace);
    }

    private void refreshCache() {
        for (String key : this.namespaceCache.asMap().keySet()) {
            this.namespaceCache.refresh((Object)key);
        }
    }

    private void refreshNamespaces(Map<String, String> cachedNamespaces) throws IOException {
        cachedNamespaces.clear();
        try (InputStream namespacesCsv = S3Utils.getObjectStream(this.s3Client, this.bucketName, this.namespaceLookupKey);){
            if (namespacesCsv == null) {
                return;
            }
            try (BufferedReader namespaceReader = new BufferedReader(new InputStreamReader(namespacesCsv));){
                Iterator namespaceCsv = namespaceReader.lines().skip(1L).iterator();
                while (namespaceCsv.hasNext()) {
                    String entry = (String)namespaceCsv.next();
                    String[] entries = entry.split(",");
                    if (entries.length != 2) {
                        throw new IOException("Invalid entry in lookup table: " + entry);
                    }
                    cachedNamespaces.put(entries[0], entries[1]);
                }
            }
        }
    }

    protected static String trim(String namespace) {
        String cleanName = namespace.replaceAll("[^A-Za-z0-9_\\-/]", "").toLowerCase();
        return String.format("%s-%s", cleanName.substring(0, Math.min(64, cleanName.length())), Math.abs(namespace.hashCode()));
    }

    private static /* synthetic */ String lambda$doGetNamespaces$0(String namespaceCsv) {
        return namespaceCsv.split(",")[0];
    }
}

