/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor;

import com.salesforce.cantor.Namespaceable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public interface Objects
extends Namespaceable {
    public void store(String var1, String var2, byte[] var3) throws IOException;

    default public void store(String namespace, Map<String, byte[]> batch) throws IOException {
        if (namespace == null || namespace.length() == 0) {
            throw new IllegalArgumentException("null/empty namespace");
        }
        if (batch == null) {
            throw new IllegalArgumentException("null batch");
        }
        for (Map.Entry<String, byte[]> object : batch.entrySet()) {
            this.store(namespace, object.getKey(), object.getValue());
        }
    }

    public byte[] get(String var1, String var2) throws IOException;

    default public Map<String, byte[]> get(String namespace, Collection<String> keys) throws IOException {
        if (namespace == null || namespace.length() == 0) {
            throw new IllegalArgumentException("null/empty namespace");
        }
        if (keys == null) {
            throw new IllegalArgumentException("null keys");
        }
        HashMap<String, byte[]> results = new HashMap<String, byte[]>();
        for (String key : keys) {
            results.put(key, this.get(namespace, key));
        }
        return results;
    }

    public boolean delete(String var1, String var2) throws IOException;

    default public void delete(String namespace, Collection<String> keys) throws IOException {
        if (namespace == null || namespace.length() == 0) {
            throw new IllegalArgumentException("null/empty namespace");
        }
        if (keys == null) {
            throw new IllegalArgumentException("null keys");
        }
        for (String key : keys) {
            this.delete(namespace, key);
        }
    }

    public Collection<String> keys(String var1, int var2, int var3) throws IOException;

    public int size(String var1) throws IOException;
}

