/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.common;

import com.salesforce.cantor.Events;
import com.salesforce.cantor.common.CommonPreconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class EventsPreconditions
extends CommonPreconditions {
    public static void checkStore(String namespace, Collection<Events.Event> batch) {
        EventsPreconditions.checkNamespace(namespace);
        EventsPreconditions.checkArgument(batch.size() <= 10000, "batch larger than 10K events");
        for (Events.Event event : batch) {
            EventsPreconditions.checkStore(event.getTimestampMillis(), event.getMetadata(), event.getDimensions());
        }
    }

    public static void checkGet(String namespace, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery) {
        EventsPreconditions.checkNamespace(namespace);
        EventsPreconditions.checkTimestamps(startTimestampMillis, endTimestampMillis);
        EventsPreconditions.checkMetadataQuery(metadataQuery);
        EventsPreconditions.checkDimensionsQuery(dimensionsQuery);
    }

    public static void checkMetadata(String namespace, String metadataKey, long startTimestampMillis, long endTimestampMillis, Map<String, String> metadataQuery, Map<String, String> dimensionsQuery) {
        EventsPreconditions.checkNamespace(namespace);
        EventsPreconditions.checkString(metadataKey);
        EventsPreconditions.checkTimestamps(startTimestampMillis, endTimestampMillis);
        EventsPreconditions.checkMetadataQuery(metadataQuery);
        EventsPreconditions.checkDimensionsQuery(dimensionsQuery);
    }

    public static void checkExpire(String namespace, long endTimestampMillis) {
        EventsPreconditions.checkNamespace(namespace);
        EventsPreconditions.checkArgument(endTimestampMillis >= 0L, "invalid end timestamp");
    }

    static void checkTimestamps(long startTimestampMillis, long endTimestampMillis) {
        EventsPreconditions.checkArgument(startTimestampMillis >= 0L, "invalid start timestamp");
        EventsPreconditions.checkArgument(endTimestampMillis >= startTimestampMillis, "end timestamp cannot be before start timestamp");
    }

    static void checkMetadata(Map<String, String> metadata) {
        if (metadata == null || metadata.isEmpty()) {
            return;
        }
        EventsPreconditions.checkArgument(metadata.keySet().size() <= 100, "metadata contains more than 100 keys");
        HashSet<String> uniqueKeys = new HashSet<String>();
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            String key = entry.getKey();
            EventsPreconditions.checkString(entry.getValue(), "metadata '" + key + "' has null/empty value");
            uniqueKeys.add(key.toUpperCase());
        }
        EventsPreconditions.checkArgument(uniqueKeys.size() == metadata.size(), "metadata keys must be unique ignoring case");
    }

    static void checkDimensions(Map<String, Double> dimensions) {
        if (dimensions == null || dimensions.isEmpty()) {
            return;
        }
        EventsPreconditions.checkArgument(dimensions.keySet().size() <= 400, "dimensions contains more than 400 keys");
        HashSet<String> uniqueKeys = new HashSet<String>();
        for (Map.Entry<String, Double> entry : dimensions.entrySet()) {
            String key = entry.getKey();
            Double value = entry.getValue();
            EventsPreconditions.checkArgument(value != null, "dimension '" + key + "' has null value");
            EventsPreconditions.checkArgument(!Double.isNaN(value) && !Double.isInfinite(value), "dimension '" + key + "' is not a valid number");
            uniqueKeys.add(key.toUpperCase());
        }
        EventsPreconditions.checkArgument(uniqueKeys.size() == dimensions.size(), "dimension keys must be unique ignoring case");
    }

    static void checkMetadataQuery(Map<String, String> metadataQuery) {
        if (metadataQuery == null || metadataQuery.isEmpty()) {
            return;
        }
        HashSet<String> uniqueKeys = new HashSet<String>();
        for (Map.Entry<String, String> entry : metadataQuery.entrySet()) {
            String key = entry.getKey();
            EventsPreconditions.checkString(entry.getValue(), "metadata query '" + key + "' has null/empty value");
            uniqueKeys.add(key.toUpperCase());
        }
        EventsPreconditions.checkArgument(uniqueKeys.size() == metadataQuery.size(), "metadata keys must be unique ignoring case");
    }

    static void checkDimensionsQuery(Map<String, String> dimensionsQuery) {
        if (dimensionsQuery == null || dimensionsQuery.isEmpty()) {
            return;
        }
        HashSet<String> uniqueKeys = new HashSet<String>();
        for (Map.Entry<String, String> entry : dimensionsQuery.entrySet()) {
            EventsPreconditions.checkArgument(entry.getValue() != null, "dimension '" + entry.getKey() + "' has null value");
            uniqueKeys.add(entry.getKey().toUpperCase());
        }
        EventsPreconditions.checkArgument(uniqueKeys.size() == dimensionsQuery.size(), "dimension keys must be unique ignoring case");
    }

    private static void checkStore(long timestampMillis, Map<String, String> metadata, Map<String, Double> dimensions) {
        EventsPreconditions.checkArgument(timestampMillis >= 0L, "invalid timestamp");
        EventsPreconditions.checkMetadata(metadata);
        EventsPreconditions.checkDimensions(dimensions);
    }
}

