/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.common;

import com.salesforce.cantor.common.CommonPreconditions;
import java.util.Collection;
import java.util.Map;

public class ObjectsPreconditions
extends CommonPreconditions {
    public static void checkStore(String namespace, String key, byte[] bytes) {
        ObjectsPreconditions.checkNamespace(namespace);
        ObjectsPreconditions.checkString(key);
        ObjectsPreconditions.checkArgument(bytes != null, "null value");
    }

    public static void checkStore(String namespace, Map<String, byte[]> batch) {
        ObjectsPreconditions.checkNamespace(namespace);
        ObjectsPreconditions.checkArgument(batch != null, "null batch");
    }

    public static void checkGet(String namespace, int start, int count) {
        ObjectsPreconditions.checkNamespace(namespace);
        ObjectsPreconditions.checkArgument(start >= 0, "invalid start");
        ObjectsPreconditions.checkArgument(count >= 0 || count == -1 && start == 0, "invalid count");
    }

    public static void checkKeys(String namespace, int start, int count) {
        ObjectsPreconditions.checkNamespace(namespace);
        ObjectsPreconditions.checkArgument(start >= 0, "invalid start");
        ObjectsPreconditions.checkArgument(count >= 0 || count == -1 && start == 0, "invalid count");
    }

    public static void checkGet(String namespace, String key) {
        ObjectsPreconditions.checkNamespace(namespace);
        ObjectsPreconditions.checkString(key);
    }

    public static void checkGet(String namespace, Collection<String> keys) {
        ObjectsPreconditions.checkNamespace(namespace);
        ObjectsPreconditions.checkArgument(keys != null, "null entries");
    }

    public static void checkDelete(String namespace, String key) {
        ObjectsPreconditions.checkNamespace(namespace);
        ObjectsPreconditions.checkString(key);
    }

    public static void checkSize(String namespace) {
        ObjectsPreconditions.checkNamespace(namespace);
    }

    public static void checkDelete(String namespace, Collection<String> keys) {
        ObjectsPreconditions.checkNamespace(namespace);
        ObjectsPreconditions.checkArgument(keys != null, "null entries");
    }
}

