/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.grpc;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.salesforce.cantor.common.CommonPreconditions;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractBaseGrpcClient<StubType extends AbstractStub<StubType>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final StubType stub;

    AbstractBaseGrpcClient(Function<Channel, StubType> stubConstructor, String target) {
        CommonPreconditions.checkString(target, "null/empty target");
        this.stub = this.makeStubs(stubConstructor, target);
    }

    StubType getStub() {
        return this.stub;
    }

    <R> R call(Callable<R> callable) throws IOException {
        try {
            return callable.call();
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus() != null && e.getStatus().getCause() != null) {
                throw new IOException(e.getStatus().getCause());
            }
            throw new IOException(e);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private StubType makeStubs(Function<Channel, StubType> stubConstructor, String target) {
        this.logger.info("creating stub of {} for target '{}'", (Object)stubConstructor.getClass(), (Object)target);
        ManagedChannel channel = ((ManagedChannelBuilder)((ManagedChannelBuilder)((ManagedChannelBuilder)ManagedChannelBuilder.forTarget(target).usePlaintext()).maxInboundMessageSize(0x2000000)).executor(Executors.newFixedThreadPool(16, new ThreadFactoryBuilder().setNameFormat("cantor-client-channel-%d").build()))).build();
        return (StubType)((AbstractStub)stubConstructor.apply(channel));
    }
}

