/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.h2;

import com.salesforce.cantor.Objects;
import com.salesforce.cantor.h2.H2DataSourceProperties;
import com.salesforce.cantor.h2.H2DataSourceProvider;
import com.salesforce.cantor.h2.H2Utils;
import com.salesforce.cantor.jdbc.AbstractBaseObjectsOnJdbc;
import com.salesforce.cantor.jdbc.JdbcUtils;
import java.io.IOException;
import javax.sql.DataSource;

public class ObjectsOnH2
extends AbstractBaseObjectsOnJdbc
implements Objects {
    public ObjectsOnH2(String path) throws IOException {
        this(H2DataSourceProvider.getDatasource(new H2DataSourceProperties().setPath(path)));
    }

    public ObjectsOnH2(DataSource dataSource) throws IOException {
        super(dataSource);
    }

    @Override
    protected String getCreateInternalDatabaseSql() {
        return H2Utils.getH2CreateDatabaseSql(this.getCantorInternalDatabaseName());
    }

    @Override
    protected String getCreateDatabaseSql(String database) {
        return H2Utils.getH2CreateDatabaseSql(database);
    }

    @Override
    protected String getDropDatabaseSql(String database) {
        return H2Utils.getH2DropDatabaseSql(database);
    }

    @Override
    protected String getCreateObjectsTableSql(String namespace) {
        return "CREATE TABLE IF NOT EXISTS " + this.getTableFullName(namespace, this.getObjectsTableName()) + "(  " + JdbcUtils.quote(this.getKeyColumnName()) + " VARCHAR NOT NULL,  " + JdbcUtils.quote(this.getValueColumnName()) + " BINARY NOT NULL,   PRIMARY KEY (" + JdbcUtils.quote(this.getKeyColumnName()) + ") ) ";
    }
}

