/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.misc.async;

import com.salesforce.cantor.Sets;
import com.salesforce.cantor.common.SetsPreconditions;
import com.salesforce.cantor.misc.async.AbstractBaseAsyncNamespaceable;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class AsyncSets
extends AbstractBaseAsyncNamespaceable<Sets>
implements Sets {
    public AsyncSets(Sets delegate, ExecutorService executorService) {
        super(delegate, executorService);
    }

    @Override
    public Collection<String> namespaces() throws IOException {
        return this.submitCall(((Sets)this.getDelegate())::namespaces);
    }

    @Override
    public void create(String namespace) throws IOException {
        SetsPreconditions.checkCreate(namespace);
        this.submitCall(() -> {
            ((Sets)this.getDelegate()).create(namespace);
            return null;
        });
    }

    @Override
    public void drop(String namespace) throws IOException {
        SetsPreconditions.checkDrop(namespace);
        this.submitCall(() -> {
            ((Sets)this.getDelegate()).drop(namespace);
            return null;
        });
    }

    @Override
    public void add(String namespace, String set, String entry, long weight) throws IOException {
        SetsPreconditions.checkAdd(namespace, set, entry, weight);
        this.submitCall(() -> {
            ((Sets)this.getDelegate()).add(namespace, set, entry, weight);
            return null;
        });
    }

    @Override
    public void add(String namespace, String set, Map<String, Long> entries) throws IOException {
        SetsPreconditions.checkAdd(namespace, set, entries);
        this.submitCall(() -> {
            ((Sets)this.getDelegate()).add(namespace, set, entries);
            return null;
        });
    }

    @Override
    public Collection<String> entries(String namespace, String set, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkEntries(namespace, set, min, max, start, count, ascending);
        return this.submitCall(() -> ((Sets)this.getDelegate()).entries(namespace, set, min, max, start, count, ascending));
    }

    @Override
    public Map<String, Long> get(String namespace, String set, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkGet(namespace, set, min, max, start, count, ascending);
        return this.submitCall(() -> ((Sets)this.getDelegate()).get(namespace, set, min, max, start, count, ascending));
    }

    @Override
    public void delete(String namespace, String set, long min, long max) throws IOException {
        SetsPreconditions.checkDelete(namespace, set, min, max);
        this.submitCall(() -> {
            ((Sets)this.getDelegate()).delete(namespace, set, min, max);
            return null;
        });
    }

    @Override
    public final boolean delete(String namespace, String set, String entry) throws IOException {
        SetsPreconditions.checkDelete(namespace, set, entry);
        return this.submitCall(() -> ((Sets)this.getDelegate()).delete(namespace, set, entry));
    }

    @Override
    public void delete(String namespace, String set, Collection<String> entries) throws IOException {
        SetsPreconditions.checkDelete(namespace, set, entries);
        this.submitCall(() -> {
            ((Sets)this.getDelegate()).delete(namespace, set, entries);
            return null;
        });
    }

    @Override
    public Map<String, Long> union(String namespace, Collection<String> sets, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkUnion(namespace, sets, min, max, start, count, ascending);
        return this.submitCall(() -> ((Sets)this.getDelegate()).union(namespace, sets, min, max, start, count, ascending));
    }

    @Override
    public Map<String, Long> intersect(String namespace, Collection<String> sets, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkIntersect(namespace, sets, min, max, start, count, ascending);
        return this.submitCall(() -> ((Sets)this.getDelegate()).intersect(namespace, sets, min, max, start, count, ascending));
    }

    @Override
    public Map<String, Long> pop(String namespace, String set, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkPop(namespace, set, min, max, start, count, ascending);
        return this.submitCall(() -> ((Sets)this.getDelegate()).pop(namespace, set, min, max, start, count, ascending));
    }

    @Override
    public Collection<String> sets(String namespace) throws IOException {
        SetsPreconditions.checkSets(namespace);
        return this.submitCall(() -> ((Sets)this.getDelegate()).sets(namespace));
    }

    @Override
    public final int size(String namespace, String set) throws IOException {
        SetsPreconditions.checkSize(namespace, set);
        return this.submitCall(() -> ((Sets)this.getDelegate()).size(namespace, set));
    }

    @Override
    public Long weight(String namespace, String set, String entry) throws IOException {
        SetsPreconditions.checkWeight(namespace, set, entry);
        return this.submitCall(() -> ((Sets)this.getDelegate()).weight(namespace, set, entry));
    }

    @Override
    public long inc(String namespace, String set, String entry, long count) throws IOException {
        SetsPreconditions.checkInc(namespace, set, entry, count);
        return this.submitCall(() -> ((Sets)this.getDelegate()).inc(namespace, set, entry, count));
    }
}

