/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.misc.loggable;

import com.salesforce.cantor.Sets;
import com.salesforce.cantor.common.SetsPreconditions;
import com.salesforce.cantor.misc.loggable.AbstractBaseLoggableNamespaceable;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class LoggableSets
extends AbstractBaseLoggableNamespaceable<Sets>
implements Sets {
    public LoggableSets(Sets delegate) {
        super(delegate);
    }

    @Override
    public void add(String namespace, String set, String entry, long weight) throws IOException {
        SetsPreconditions.checkAdd(namespace, set, entry, weight);
        this.logCall(() -> {
            ((Sets)this.getDelegate()).add(namespace, set, entry, weight);
            return null;
        }, "add", namespace, set, entry, weight);
    }

    @Override
    public void add(String namespace, String set, Map<String, Long> entries) throws IOException {
        SetsPreconditions.checkAdd(namespace, set, entries);
        this.logCall(() -> {
            ((Sets)this.getDelegate()).add(namespace, set, entries);
            return null;
        }, "add", namespace, set, entries);
    }

    @Override
    public Collection<String> entries(String namespace, String set, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkEntries(namespace, set, min, max, start, count, ascending);
        return this.logCall(() -> ((Sets)this.getDelegate()).entries(namespace, set, min, max, start, count, ascending), "entries", namespace, set, min, max, start, count, ascending);
    }

    @Override
    public Map<String, Long> get(String namespace, String set, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkGet(namespace, set, min, max, start, count, ascending);
        return this.logCall(() -> ((Sets)this.getDelegate()).get(namespace, set, min, max, start, count, ascending), "get", namespace, set, min, max, start, count, ascending);
    }

    @Override
    public void delete(String namespace, String set, long min, long max) throws IOException {
        SetsPreconditions.checkDelete(namespace, set, min, max);
        this.logCall(() -> {
            ((Sets)this.getDelegate()).delete(namespace, set, min, max);
            return null;
        }, "delete", namespace, set, min, max);
    }

    @Override
    public final boolean delete(String namespace, String set, String entry) throws IOException {
        SetsPreconditions.checkDelete(namespace, set, entry);
        return this.logCall(() -> ((Sets)this.getDelegate()).delete(namespace, set, entry), "delete", namespace, set, entry);
    }

    @Override
    public void delete(String namespace, String set, Collection<String> entries) throws IOException {
        SetsPreconditions.checkDelete(namespace, set, entries);
        this.logCall(() -> {
            ((Sets)this.getDelegate()).delete(namespace, set, entries);
            return null;
        }, "delete", namespace, set, entries);
    }

    @Override
    public Map<String, Long> union(String namespace, Collection<String> sets, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkUnion(namespace, sets, min, max, start, count, ascending);
        return this.logCall(() -> ((Sets)this.getDelegate()).union(namespace, sets, min, max, start, count, ascending), "union", namespace, sets, min, max, start, count);
    }

    @Override
    public Map<String, Long> intersect(String namespace, Collection<String> sets, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkIntersect(namespace, sets, min, max, start, count, ascending);
        return this.logCall(() -> ((Sets)this.getDelegate()).intersect(namespace, sets, min, max, start, count, ascending), "intersect", namespace, sets, min, max, start, count, ascending);
    }

    @Override
    public Map<String, Long> pop(String namespace, String set, long min, long max, int start, int count, boolean ascending) throws IOException {
        SetsPreconditions.checkPop(namespace, set, min, max, start, count, ascending);
        return this.logCall(() -> ((Sets)this.getDelegate()).pop(namespace, set, min, max, start, count, ascending), "pop", namespace, set, min, max, start, count, ascending);
    }

    @Override
    public Collection<String> sets(String namespace) throws IOException {
        SetsPreconditions.checkSets(namespace);
        return this.logCall(() -> ((Sets)this.getDelegate()).sets(namespace), "sets", namespace, new Object[0]);
    }

    @Override
    public final int size(String namespace, String set) throws IOException {
        SetsPreconditions.checkSize(namespace, set);
        return this.logCall(() -> ((Sets)this.getDelegate()).size(namespace, set), "size", namespace, set);
    }

    @Override
    public Long weight(String namespace, String set, String entry) throws IOException {
        SetsPreconditions.checkWeight(namespace, set, entry);
        return this.logCall(() -> ((Sets)this.getDelegate()).weight(namespace, set, entry), "weight", namespace, set, entry);
    }

    @Override
    public long inc(String namespace, String set, String entry, long count) throws IOException {
        SetsPreconditions.checkInc(namespace, set, entry, count);
        return this.logCall(() -> ((Sets)this.getDelegate()).inc(namespace, set, entry, count), "inc", namespace, set, entry, count);
    }
}

