/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.misc.sharded;

import com.salesforce.cantor.Namespaceable;
import com.salesforce.cantor.common.CommonPreconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractBaseShardedNamespaceable<T extends Namespaceable>
implements Namespaceable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final T[] delegates;
    private final AtomicReference<Map<String, List<T>>> namespaceLookupTable = new AtomicReference();

    public AbstractBaseShardedNamespaceable(T[] delegates) {
        CommonPreconditions.checkArgument(delegates != null && delegates.length > 0, "null/empty delegates");
        this.delegates = delegates;
    }

    @Override
    public final Collection<String> namespaces() throws IOException {
        return this.doNamespaces();
    }

    protected T getShardForCreate(String namespace) throws IOException {
        this.reloadLookupIfNeeded(namespace);
        if (this.namespaceLookupTable.get().containsKey(namespace)) {
            return this.getShard(namespace);
        }
        int minNamespaceCount = this.delegates[0].namespaces().size();
        T smallestShard = this.delegates[0];
        for (int i = 1; i < this.delegates.length; ++i) {
            int namespaceCount = this.delegates[i].namespaces().size();
            if (namespaceCount >= minNamespaceCount) continue;
            minNamespaceCount = namespaceCount;
            smallestShard = this.delegates[i];
        }
        return smallestShard;
    }

    protected T getShard(String namespace) throws IOException {
        this.reloadLookupIfNeeded(namespace);
        List<T> shards = this.namespaceLookupTable.get().get(namespace);
        if (shards == null) {
            throw new IOException("shard not found for namespace " + namespace);
        }
        if (shards.size() > 1) {
            this.logger.warn("more than one shard found for namespace '{}'", (Object)namespace);
        }
        return (T)((Namespaceable)shards.get(0));
    }

    protected void reloadLookupIfNeeded(String namespace) throws IOException {
        if (this.namespaceLookupTable.get() == null || !this.namespaceLookupTable.get().containsKey(namespace)) {
            this.loadNamespaceLookupTable();
        }
    }

    protected void loadNamespaceLookupTable() throws IOException {
        HashMap namespaceToDelegates = new HashMap();
        for (T delegate : this.delegates) {
            for (String namespace : delegate.namespaces()) {
                namespaceToDelegates.putIfAbsent(namespace, new ArrayList());
                ((List)namespaceToDelegates.get(namespace)).add(delegate);
            }
        }
        this.namespaceLookupTable.set(namespaceToDelegates);
    }

    private Collection<String> doNamespaces() throws IOException {
        HashSet<String> results = new HashSet<String>();
        for (T delegate : this.delegates) {
            results.addAll(delegate.namespaces());
        }
        return results;
    }
}

