/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.misc.sharded;

import com.salesforce.cantor.Namespaceable;
import com.salesforce.cantor.Objects;
import com.salesforce.cantor.common.ObjectsPreconditions;
import com.salesforce.cantor.misc.sharded.AbstractBaseShardedNamespaceable;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public class ShardedObjects
extends AbstractBaseShardedNamespaceable<Objects>
implements Objects {
    public ShardedObjects(Objects ... delegates) {
        super((Namespaceable[])delegates);
    }

    @Override
    public void create(String namespace) throws IOException {
        ObjectsPreconditions.checkCreate(namespace);
        ((Objects)this.getShardForCreate(namespace)).create(namespace);
        this.loadNamespaceLookupTable();
    }

    @Override
    public void drop(String namespace) throws IOException {
        ObjectsPreconditions.checkDrop(namespace);
        ((Objects)this.getShard(namespace)).drop(namespace);
        this.loadNamespaceLookupTable();
    }

    @Override
    public void store(String namespace, String key, byte[] bytes) throws IOException {
        ObjectsPreconditions.checkStore(namespace, key, bytes);
        ((Objects)this.getShard(namespace)).store(namespace, key, bytes);
    }

    @Override
    public void store(String namespace, Map<String, byte[]> batch) throws IOException {
        ObjectsPreconditions.checkStore(namespace, batch);
        ((Objects)this.getShard(namespace)).store(namespace, batch);
    }

    @Override
    public byte[] get(String namespace, String key) throws IOException {
        ObjectsPreconditions.checkGet(namespace, key);
        return ((Objects)this.getShard(namespace)).get(namespace, key);
    }

    @Override
    public Map<String, byte[]> get(String namespace, Collection<String> keys) throws IOException {
        ObjectsPreconditions.checkGet(namespace, keys);
        return ((Objects)this.getShard(namespace)).get(namespace, keys);
    }

    @Override
    public boolean delete(String namespace, String key) throws IOException {
        ObjectsPreconditions.checkDelete(namespace, key);
        return ((Objects)this.getShard(namespace)).delete(namespace, key);
    }

    @Override
    public void delete(String namespace, Collection<String> keys) throws IOException {
        ObjectsPreconditions.checkDelete(namespace, keys);
        ((Objects)this.getShard(namespace)).delete(namespace, keys);
    }

    @Override
    public Collection<String> keys(String namespace, int start, int count) throws IOException {
        ObjectsPreconditions.checkKeys(namespace, start, count);
        return ((Objects)this.getShard(namespace)).keys(namespace, start, count);
    }

    @Override
    public int size(String namespace) throws IOException {
        ObjectsPreconditions.checkSize(namespace);
        return ((Objects)this.getShard(namespace)).size(namespace);
    }
}

