/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.server.grpc;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.salesforce.cantor.Cantor;
import com.salesforce.cantor.grpc.EventsGrpcService;
import com.salesforce.cantor.grpc.ObjectsGrpcService;
import com.salesforce.cantor.grpc.SetsGrpcService;
import com.salesforce.cantor.server.CantorEnvironment;
import com.salesforce.cantor.server.utils.CantorFactory;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcServer {
    private static final Logger logger = LoggerFactory.getLogger(GrpcServer.class);
    private final Server server;

    public GrpcServer(CantorEnvironment cantorEnvironment) throws IOException {
        CantorFactory cantorProvider = new CantorFactory(cantorEnvironment);
        int port = cantorEnvironment.getConfigAsInteger("grpc.port", -1);
        logger.info("creating new grpc server listening on port '{}' with storage type: '{}'", (Object)port, (Object)cantorEnvironment.getStorageType());
        Cantor cantor = cantorProvider.getCantor();
        this.server = ((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)((ServerBuilder)ServerBuilder.forPort(port).maxInboundMessageSize(0x4000000)).addService(new ObjectsGrpcService(cantor))).addService(new SetsGrpcService(cantor))).addService(new EventsGrpcService(cantor))).executor(Executors.newFixedThreadPool(64, new ThreadFactoryBuilder().setNameFormat("cantor-grpc-worker-%d").build()))).build();
        this.addShutdownHook();
    }

    public CompletableFuture<?> start() {
        return CompletableFuture.runAsync(() -> {
            try {
                Thread.currentThread().setName("cantor-grpc-server");
                logger.info("starting grpc server...");
                this.server.start();
                this.blockUntilShutdown();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void shutdown() {
        this.server.shutdown();
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
    }

    private void stop() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    private void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }
}

