/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.common;

import com.salesforce.cantor.Cantor;
import com.salesforce.cantor.Events;
import com.salesforce.cantor.Namespaceable;
import com.salesforce.cantor.Objects;
import com.salesforce.cantor.Sets;
import com.salesforce.cantor.common.CommonPreconditions;
import com.salesforce.cantor.common.EventsProvider;
import com.salesforce.cantor.common.NamespaceableProvider;
import com.salesforce.cantor.common.ObjectsProvider;
import com.salesforce.cantor.common.SetsProvider;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CantorFactory {
    private static final Logger logger = LoggerFactory.getLogger(CantorFactory.class);
    private static Cantor instance;

    public static Cantor get() throws IOException {
        if (instance == null) {
            CantorFactory.init();
        }
        return instance;
    }

    private static synchronized void init() throws IOException {
        if (instance != null) {
            return;
        }
        logger.info("initializing cantor factory");
        HashMap<String, Objects> objects = new HashMap<String, Objects>();
        HashMap<String, Sets> sets = new HashMap<String, Sets>();
        HashMap<String, Events> events = new HashMap<String, Events>();
        CantorFactory.load(objects, ObjectsProvider.class);
        CantorFactory.load(sets, SetsProvider.class);
        CantorFactory.load(events, EventsProvider.class);
        logger.info("cantor factory loaded '{}' objects, '{}' sets, and '{}' events providers", objects.size(), sets.size(), events.size());
        instance = new CantorProxy(objects, sets, events);
    }

    private static <T extends Namespaceable, R extends NamespaceableProvider<T>> void load(Map<String, T> map, Class<R> provider) throws IOException {
        for (NamespaceableProvider p : ServiceLoader.load(provider)) {
            Object instance = p.getInstance();
            String scope = p.getScope();
            logger.info("provider found with name: '{}' instance-class: '{}'", (Object)p.getScope(), (Object)instance.getClass().getName());
            if (map.containsKey(scope)) {
                logger.error("provider for scope '{}' is already loaded", (Object)p.getScope());
                throw new IllegalStateException("duplicate service provider name");
            }
            map.put(scope, instance);
        }
    }

    static class EventsProxy
    extends NamespaceableProxy<Events> {
        EventsProxy(Map<String, Events> delegates) {
            super(delegates);
        }
    }

    static class SetsProxy
    extends NamespaceableProxy<Sets> {
        SetsProxy(Map<String, Sets> delegates) {
            super(delegates);
        }
    }

    static class ObjectsProxy
    extends NamespaceableProxy<Objects> {
        ObjectsProxy(Map<String, Objects> delegates) {
            super(delegates);
        }
    }

    static abstract class NamespaceableProxy<T extends Namespaceable>
    implements InvocationHandler {
        private static final String scopeDelimiter = ".";
        private final Map<String, T> delegates;

        NamespaceableProxy(Map<String, T> delegates) {
            this.delegates = delegates;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("namespaces")) {
                return this.doNamespaces();
            }
            if (args == null || args.length == 0) {
                throw new IllegalArgumentException("method '" + method.getName() + "' is not recognized by proxy object");
            }
            String scopedNamespace = (String)args[0];
            if (!scopedNamespace.contains(scopeDelimiter) || scopedNamespace.startsWith(scopeDelimiter)) {
                return method.invoke(this.delegates.get(""), args);
            }
            String scope = scopedNamespace.substring(0, scopedNamespace.indexOf(scopeDelimiter));
            String namespace = scopedNamespace.substring(scopedNamespace.indexOf(scopeDelimiter) + 1);
            CommonPreconditions.checkArgument(this.delegates.containsKey(scope), "invalid scope: " + scope);
            if (args.length == 1) {
                return method.invoke(this.delegates.get(scope), namespace);
            }
            Object[] newArgs = new Object[args.length];
            newArgs[0] = namespace;
            System.arraycopy(args, 1, newArgs, 1, args.length - 1);
            return method.invoke(this.delegates.get(scope), newArgs);
        }

        private Object doNamespaces() throws IOException {
            ArrayList<String> results = new ArrayList<String>();
            for (Map.Entry<String, T> entry : this.delegates.entrySet()) {
                Collection<String> namespaces = ((Namespaceable)entry.getValue()).namespaces();
                for (String namespace : namespaces) {
                    String scope = entry.getKey();
                    if ("".equals(scope)) {
                        results.add(namespace);
                        continue;
                    }
                    results.add(String.format("%s.%s", scope, namespace));
                }
            }
            return results;
        }
    }

    static class CantorProxy
    implements Cantor {
        private final Objects objects;
        private final Sets sets;
        private final Events events;

        CantorProxy(Map<String, Objects> objectsDelegates, Map<String, Sets> setsDelegates, Map<String, Events> eventsDelegates) {
            this.objects = (Objects)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Objects.class}, (InvocationHandler)new ObjectsProxy(objectsDelegates));
            this.sets = (Sets)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Sets.class}, (InvocationHandler)new SetsProxy(setsDelegates));
            this.events = (Events)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Events.class}, (InvocationHandler)new EventsProxy(eventsDelegates));
        }

        @Override
        public Objects objects() {
            return this.objects;
        }

        @Override
        public Sets sets() {
            return this.sets;
        }

        @Override
        public Events events() {
            return this.events;
        }
    }
}

