/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.grpc;

import com.google.protobuf.Message;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcUtils {
    private static final Logger logger = LoggerFactory.getLogger(GrpcUtils.class);

    GrpcUtils() {
    }

    static void sendError(StreamObserver<?> observer, Throwable throwable) {
        logger.warn("exception caught handling request: ", throwable);
        observer.onError(new StatusRuntimeException(Status.INTERNAL.withCause(throwable).withDescription(throwable.getMessage())));
    }

    static void sendCancelledError(StreamObserver<?> observer, Throwable cancellationCause) {
        logger.warn("request is cancelled by client: ", cancellationCause);
        observer.onError(Status.CANCELLED.withDescription("request is cancelled by client").asRuntimeException());
    }

    static <T extends Message> void sendResponse(StreamObserver<T> observer, T t) {
        observer.onNext(t);
        observer.onCompleted();
    }
}

