/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.cantor.grpc;

import com.google.protobuf.ByteString;
import com.salesforce.cantor.Cantor;
import com.salesforce.cantor.Objects;
import com.salesforce.cantor.common.CommonPreconditions;
import com.salesforce.cantor.grpc.GrpcUtils;
import com.salesforce.cantor.grpc.objects.CreateRequest;
import com.salesforce.cantor.grpc.objects.DeleteRequest;
import com.salesforce.cantor.grpc.objects.DeleteResponse;
import com.salesforce.cantor.grpc.objects.DropRequest;
import com.salesforce.cantor.grpc.objects.GetRequest;
import com.salesforce.cantor.grpc.objects.GetResponse;
import com.salesforce.cantor.grpc.objects.KeysRequest;
import com.salesforce.cantor.grpc.objects.KeysResponse;
import com.salesforce.cantor.grpc.objects.NamespacesRequest;
import com.salesforce.cantor.grpc.objects.NamespacesResponse;
import com.salesforce.cantor.grpc.objects.ObjectsServiceGrpc;
import com.salesforce.cantor.grpc.objects.SizeRequest;
import com.salesforce.cantor.grpc.objects.SizeResponse;
import com.salesforce.cantor.grpc.objects.StoreRequest;
import com.salesforce.cantor.grpc.objects.VoidResponse;
import io.grpc.Context;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.Collection;

public class ObjectsGrpcService
extends ObjectsServiceGrpc.ObjectsServiceImplBase {
    private final Cantor cantor;

    public ObjectsGrpcService(Cantor cantor) {
        CommonPreconditions.checkArgument(cantor != null, "null cantor");
        this.cantor = cantor;
    }

    @Override
    public void namespaces(NamespacesRequest request, StreamObserver<NamespacesResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            NamespacesResponse response = NamespacesResponse.newBuilder().addAllNamespaces(this.getObjects().namespaces()).build();
            GrpcUtils.sendResponse(responseObserver, response);
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void create(CreateRequest request, StreamObserver<VoidResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            this.getObjects().create(request.getNamespace());
            GrpcUtils.sendResponse(responseObserver, VoidResponse.getDefaultInstance());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void drop(DropRequest request, StreamObserver<VoidResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            this.getObjects().drop(request.getNamespace());
            GrpcUtils.sendResponse(responseObserver, VoidResponse.getDefaultInstance());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void keys(KeysRequest request, StreamObserver<KeysResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            KeysResponse.Builder resultsBuilder = KeysResponse.newBuilder();
            Collection<String> results = this.getObjects().keys(request.getNamespace(), request.getStart(), request.getCount());
            if (results != null) {
                resultsBuilder.addAllKeys(results);
            }
            GrpcUtils.sendResponse(responseObserver, resultsBuilder.build());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void get(GetRequest request, StreamObserver<GetResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            GetResponse.Builder resultsBuilder = GetResponse.newBuilder();
            byte[] value = this.getObjects().get(request.getNamespace(), request.getKey());
            if (value != null) {
                resultsBuilder.setValue(ByteString.copyFrom(value));
            }
            GrpcUtils.sendResponse(responseObserver, resultsBuilder.build());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void store(StoreRequest request, StreamObserver<VoidResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            this.getObjects().store(request.getNamespace(), request.getKey(), request.getValue().toByteArray());
            GrpcUtils.sendResponse(responseObserver, VoidResponse.getDefaultInstance());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void delete(DeleteRequest request, StreamObserver<DeleteResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            boolean result = this.getObjects().delete(request.getNamespace(), request.getKey());
            GrpcUtils.sendResponse(responseObserver, DeleteResponse.newBuilder().setResult(result).build());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    @Override
    public void size(SizeRequest request, StreamObserver<SizeResponse> responseObserver) {
        if (Context.current().isCancelled()) {
            GrpcUtils.sendCancelledError(responseObserver, Context.current().cancellationCause());
            return;
        }
        try {
            int size = this.getObjects().size(request.getNamespace());
            GrpcUtils.sendResponse(responseObserver, SizeResponse.newBuilder().setSize(size).build());
        }
        catch (IOException e) {
            GrpcUtils.sendError(responseObserver, e);
        }
    }

    protected Objects getObjects() {
        return this.cantor.objects();
    }
}

